/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.collect.ImmutableSet;
import com.google.common.graph.AbstractNetworkTest;
import com.google.common.testing.EqualsTester;
import com.google.common.truth.Truth;
import java.util.Collection;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractUndirectedNetworkTest
extends AbstractNetworkTest {
    @After
    public void validateUndirectedEdges() {
        for (Integer node : this.graph.nodes()) {
            new EqualsTester().addEqualityGroup(new Object[]{this.graph.inEdges((Object)node), this.graph.outEdges((Object)node), this.graph.incidentEdges((Object)node)}).testEquals();
            new EqualsTester().addEqualityGroup(new Object[]{this.graph.predecessors((Object)node), this.graph.successors((Object)node), this.graph.adjacentNodes((Object)node)}).testEquals();
            for (Integer adjacentNode : this.graph.adjacentNodes((Object)node)) {
                Truth.assertThat((Iterable)this.graph.edgesConnecting((Object)node, (Object)adjacentNode)).containsExactlyElementsIn((Iterable)this.graph.edgesConnecting((Object)adjacentNode, (Object)node));
            }
        }
    }

    @Test
    public void edgesConnecting_oneEdge() {
        this.addEdge("1-2", N1, N2);
        Truth.assertThat((Iterable)this.graph.edgesConnecting((Object)N1, (Object)N2)).containsExactly(new Object[]{"1-2"});
        Truth.assertThat((Iterable)this.graph.edgesConnecting((Object)N2, (Object)N1)).containsExactly(new Object[]{"1-2"});
    }

    @Test
    public void inEdges_oneEdge() {
        this.addEdge("1-2", N1, N2);
        Truth.assertThat((Iterable)this.graph.inEdges((Object)N2)).containsExactly(new Object[]{"1-2"});
        Truth.assertThat((Iterable)this.graph.inEdges((Object)N1)).containsExactly(new Object[]{"1-2"});
    }

    @Test
    public void outEdges_oneEdge() {
        this.addEdge("1-2", N1, N2);
        Truth.assertThat((Iterable)this.graph.outEdges((Object)N2)).containsExactly(new Object[]{"1-2"});
        Truth.assertThat((Iterable)this.graph.outEdges((Object)N1)).containsExactly(new Object[]{"1-2"});
    }

    @Test
    public void predecessors_oneEdge() {
        this.addEdge("1-2", N1, N2);
        Truth.assertThat((Iterable)this.graph.predecessors((Object)N2)).containsExactly(new Object[]{N1});
        Truth.assertThat((Iterable)this.graph.predecessors((Object)N1)).containsExactly(new Object[]{N2});
    }

    @Test
    public void successors_oneEdge() {
        this.addEdge("1-2", N1, N2);
        Truth.assertThat((Iterable)this.graph.successors((Object)N1)).containsExactly(new Object[]{N2});
        Truth.assertThat((Iterable)this.graph.successors((Object)N2)).containsExactly(new Object[]{N1});
    }

    @Test
    public void inDegree_oneEdge() {
        this.addEdge("1-2", N1, N2);
        Assert.assertEquals((long)1L, (long)this.graph.inDegree((Object)N2));
        Assert.assertEquals((long)1L, (long)this.graph.inDegree((Object)N1));
    }

    @Test
    public void outDegree_oneEdge() {
        this.addEdge("1-2", N1, N2);
        Assert.assertEquals((long)1L, (long)this.graph.outDegree((Object)N1));
        Assert.assertEquals((long)1L, (long)this.graph.outDegree((Object)N2));
    }

    @Test
    public void addEdge_existingNodes() {
        this.addNode(N1);
        this.addNode(N2);
        Assert.assertTrue((boolean)this.addEdge("1-2", N1, N2));
        Truth.assertThat((Iterable)this.graph.edges()).contains((Object)"1-2");
        Truth.assertThat((Iterable)this.graph.edgesConnecting((Object)N1, (Object)N2)).containsExactly(new Object[]{"1-2"});
        Truth.assertThat((Iterable)this.graph.edgesConnecting((Object)N2, (Object)N1)).containsExactly(new Object[]{"1-2"});
    }

    @Test
    public void addEdge_existingEdgeBetweenSameNodes() {
        this.addEdge("1-2", N1, N2);
        ImmutableSet edges = ImmutableSet.copyOf((Collection)this.graph.edges());
        Assert.assertFalse((boolean)this.addEdge("1-2", N1, N2));
        Truth.assertThat((Iterable)this.graph.edges()).containsExactlyElementsIn((Iterable)edges);
        Assert.assertFalse((boolean)this.addEdge("1-2", N2, N1));
        Truth.assertThat((Iterable)this.graph.edges()).containsExactlyElementsIn((Iterable)edges);
    }

    @Test
    public void addEdge_existingEdgeBetweenDifferentNodes() {
        this.addEdge("1-2", N1, N2);
        try {
            this.addEdge("1-2", N4, N5);
            Assert.fail((String)"Reusing an existing edge to connect different nodes succeeded");
        }
        catch (IllegalArgumentException e) {
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"it can't be reused to connect");
        }
    }

    @Test
    public void addEdge_parallelEdge() {
        this.addEdge("1-2", N1, N2);
        try {
            this.addEdge("edgeNotInGraph", N1, N2);
            Assert.fail((String)"Should not be allowed to add a parallel edge.");
        }
        catch (IllegalArgumentException e) {
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"connected by a different edge");
        }
        try {
            this.addEdge("edgeNotInGraph", N2, N1);
            Assert.fail((String)"Should not be allowed to add a parallel edge.");
        }
        catch (IllegalArgumentException e) {
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"connected by a different edge");
        }
    }

    @Test
    public void removeEdge_existingEdge() {
        this.addEdge("1-2", N1, N2);
        Assert.assertTrue((boolean)this.graph.removeEdge((Object)"1-2"));
        Truth.assertThat((Iterable)this.graph.edges()).doesNotContain((Object)"1-2");
        Truth.assertThat((Iterable)this.graph.edgesConnecting((Object)N1, (Object)N2)).isEmpty();
        Truth.assertThat((Iterable)this.graph.edgesConnecting((Object)N2, (Object)N1)).isEmpty();
    }
}

