/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.graph.ConfigurableSimpleUndirectedGraphTest;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import com.google.common.truth.Truth;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ConfigurableUndirectedGraphTest
extends ConfigurableSimpleUndirectedGraphTest {
    @Override
    public MutableGraph<Integer> createGraph() {
        return GraphBuilder.undirected().build();
    }

    @Test
    public void adjacentNodes_selfLoop() {
        this.addEdge(N1, N1);
        this.addEdge(N1, N2);
        Truth.assertThat((Iterable)this.graph.adjacentNodes((Object)N1)).containsExactly(new Object[]{N1, N2});
    }

    @Test
    public void predecessors_selfLoop() {
        this.addEdge(N1, N1);
        Truth.assertThat((Iterable)this.graph.predecessors((Object)N1)).containsExactly(new Object[]{N1});
        this.addEdge(N1, N2);
        Truth.assertThat((Iterable)this.graph.predecessors((Object)N1)).containsExactly(new Object[]{N1, N2});
    }

    @Test
    public void successors_selfLoop() {
        this.addEdge(N1, N1);
        Truth.assertThat((Iterable)this.graph.successors((Object)N1)).containsExactly(new Object[]{N1});
        this.addEdge(N2, N1);
        Truth.assertThat((Iterable)this.graph.successors((Object)N1)).containsExactly(new Object[]{N1, N2});
    }

    @Test
    public void degree_selfLoop() {
        this.addEdge(N1, N1);
        Assert.assertEquals((long)1L, (long)this.graph.degree((Object)N1));
        this.addEdge(N1, N2);
        Assert.assertEquals((long)2L, (long)this.graph.degree((Object)N1));
    }

    @Test
    public void inDegree_selfLoop() {
        this.addEdge(N1, N1);
        Assert.assertEquals((long)1L, (long)this.graph.inDegree((Object)N1));
        this.addEdge(N1, N2);
        Assert.assertEquals((long)2L, (long)this.graph.inDegree((Object)N1));
    }

    @Test
    public void outDegree_selfLoop() {
        this.addEdge(N1, N1);
        Assert.assertEquals((long)1L, (long)this.graph.outDegree((Object)N1));
        this.addEdge(N2, N1);
        Assert.assertEquals((long)2L, (long)this.graph.outDegree((Object)N1));
    }

    @Override
    @Test
    public void addEdge_selfLoop() {
        Assert.assertTrue((boolean)this.addEdge(N1, N1));
        Truth.assertThat((Iterable)this.graph.adjacentNodes((Object)N1)).containsExactly(new Object[]{N1});
    }

    @Test
    public void addEdge_existingSelfLoopEdgeBetweenSameNodes() {
        this.addEdge(N1, N1);
        Assert.assertFalse((boolean)this.addEdge(N1, N1));
    }

    @Test
    public void removeNode_existingNodeWithSelfLoopEdge() {
        this.addNode(N1);
        this.addEdge(N1, N1);
        Assert.assertTrue((boolean)this.graph.removeNode((Object)N1));
        Truth.assertThat((Iterable)this.graph.nodes()).isEmpty();
    }

    @Test
    public void removeEdge_existingSelfLoopEdge() {
        this.addEdge(N1, N1);
        Assert.assertTrue((boolean)this.graph.removeEdge((Object)N1, (Object)N1));
        Truth.assertThat((Iterable)this.graph.nodes()).containsExactly(new Object[]{N1});
        Truth.assertThat((Iterable)this.graph.adjacentNodes((Object)N1)).isEmpty();
    }
}

