/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.graph.ConfigurableUndirectedNetworkTest;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.NetworkBuilder;
import com.google.common.truth.Truth;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ConfigurableUndirectedMultiNetworkTest
extends ConfigurableUndirectedNetworkTest {
    @Override
    public MutableNetwork<Integer, String> createGraph() {
        return NetworkBuilder.undirected().allowsParallelEdges(true).build();
    }

    @Test
    public void edgesConnecting_parallelEdges() {
        Assert.assertTrue((boolean)this.addEdge("1-2", N1, N2));
        Assert.assertTrue((boolean)this.addEdge("1-2a", N1, N2));
        Assert.assertTrue((boolean)this.addEdge("2-1", N2, N1));
        Truth.assertThat((Iterable)this.graph.edgesConnecting((Object)N1, (Object)N2)).containsExactly(new Object[]{"1-2", "1-2a", "2-1"});
        Truth.assertThat((Iterable)this.graph.edgesConnecting((Object)N2, (Object)N1)).containsExactly(new Object[]{"1-2", "1-2a", "2-1"});
    }

    @Test
    public void edgesConnecting_parallelSelfLoopEdges() {
        Assert.assertTrue((boolean)this.addEdge("1-1", N1, N1));
        Assert.assertTrue((boolean)this.addEdge("1-1a", N1, N1));
        Truth.assertThat((Iterable)this.graph.edgesConnecting((Object)N1, (Object)N1)).containsExactly(new Object[]{"1-1", "1-1a"});
    }

    @Override
    @Test
    public void addEdge_parallelEdge() {
        Assert.assertTrue((boolean)this.addEdge("1-2", N1, N2));
        Assert.assertTrue((boolean)this.addEdge("1-2a", N1, N2));
        Assert.assertTrue((boolean)this.addEdge("2-1", N2, N1));
        Truth.assertThat((Iterable)this.graph.edgesConnecting((Object)N1, (Object)N2)).containsExactly(new Object[]{"1-2", "1-2a", "2-1"});
    }

    @Override
    @Test
    public void addEdge_parallelSelfLoopEdge() {
        Assert.assertTrue((boolean)this.addEdge("1-1", N1, N1));
        Assert.assertTrue((boolean)this.addEdge("1-1a", N1, N1));
        Truth.assertThat((Iterable)this.graph.edgesConnecting((Object)N1, (Object)N1)).containsExactly(new Object[]{"1-1", "1-1a"});
    }

    @Test
    public void removeEdge_parallelEdge() {
        this.addEdge("1-2", N1, N2);
        this.addEdge("1-2a", N1, N2);
        this.addEdge("2-1", N2, N1);
        Assert.assertTrue((boolean)this.graph.removeEdge((Object)"1-2a"));
        Truth.assertThat((Iterable)this.graph.edgesConnecting((Object)N1, (Object)N2)).containsExactly(new Object[]{"1-2", "2-1"});
    }

    @Test
    public void removeEdge_parallelSelfLoopEdge() {
        this.addEdge("1-1", N1, N1);
        this.addEdge("1-1a", N1, N1);
        this.addEdge("1-2", N1, N2);
        Assert.assertTrue((boolean)this.graph.removeEdge((Object)"1-1a"));
        Truth.assertThat((Iterable)this.graph.edgesConnecting((Object)N1, (Object)N1)).containsExactly(new Object[]{"1-1"});
        Truth.assertThat((Iterable)this.graph.edgesConnecting((Object)N1, (Object)N2)).containsExactly(new Object[]{"1-2"});
        Assert.assertTrue((boolean)this.graph.removeEdge((Object)"1-1"));
        Truth.assertThat((Iterable)this.graph.edgesConnecting((Object)N1, (Object)N1)).isEmpty();
        Truth.assertThat((Iterable)this.graph.edgesConnecting((Object)N1, (Object)N2)).containsExactly(new Object[]{"1-2"});
    }
}

