/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.graph.AndroidIncompatible;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import com.google.common.testing.EqualsTester;
import java.util.Arrays;
import java.util.Collection;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@AndroidIncompatible
public final class GraphEqualsTest {
    private static final Integer N1 = 1;
    private static final Integer N2 = 2;
    private static final Integer N3 = 3;
    private final GraphType graphType;
    private final MutableGraph<Integer> graph;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({GraphType.UNDIRECTED}, {GraphType.DIRECTED});
    }

    public GraphEqualsTest(GraphType graphType) {
        this.graphType = graphType;
        this.graph = GraphEqualsTest.createGraph(graphType);
    }

    private static MutableGraph<Integer> createGraph(GraphType graphType) {
        switch (graphType) {
            case UNDIRECTED: {
                return GraphBuilder.undirected().build();
            }
            case DIRECTED: {
                return GraphBuilder.directed().build();
            }
        }
        throw new IllegalStateException("Unexpected graph type: " + (Object)((Object)graphType));
    }

    private static GraphType oppositeType(GraphType graphType) {
        switch (graphType) {
            case UNDIRECTED: {
                return GraphType.DIRECTED;
            }
            case DIRECTED: {
                return GraphType.UNDIRECTED;
            }
        }
        throw new IllegalStateException("Unexpected graph type: " + (Object)((Object)graphType));
    }

    @Test
    public void equals_nodeSetsDiffer() {
        this.graph.addNode((Object)N1);
        MutableGraph<Integer> g2 = GraphEqualsTest.createGraph(this.graphType);
        g2.addNode((Object)N2);
        new EqualsTester().addEqualityGroup(new Object[]{this.graph}).addEqualityGroup(new Object[]{g2}).testEquals();
    }

    @Test
    public void equals_directedVsUndirected() {
        this.graph.addEdge((Object)N1, (Object)N2);
        MutableGraph<Integer> g2 = GraphEqualsTest.createGraph(GraphEqualsTest.oppositeType(this.graphType));
        g2.addEdge((Object)N1, (Object)N2);
        new EqualsTester().addEqualityGroup(new Object[]{this.graph}).addEqualityGroup(new Object[]{g2}).testEquals();
    }

    @Test
    public void equals_selfLoop_directedVsUndirected() {
        this.graph.addEdge((Object)N1, (Object)N1);
        MutableGraph<Integer> g2 = GraphEqualsTest.createGraph(GraphEqualsTest.oppositeType(this.graphType));
        g2.addEdge((Object)N1, (Object)N1);
        new EqualsTester().addEqualityGroup(new Object[]{this.graph, g2}).testEquals();
    }

    @Test
    public void equals_propertiesDiffer() {
        this.graph.addEdge((Object)N1, (Object)N2);
        MutableGraph g2 = GraphBuilder.from(this.graph).allowsSelfLoops(!this.graph.allowsSelfLoops()).build();
        g2.addEdge((Object)N1, (Object)N2);
        new EqualsTester().addEqualityGroup(new Object[]{this.graph, g2}).testEquals();
    }

    @Test
    public void equals_edgeAddOrdersDiffer() {
        GraphBuilder builder = GraphBuilder.from(this.graph);
        MutableGraph g1 = builder.build();
        MutableGraph g2 = builder.build();
        g1.addEdge((Object)N1, (Object)N2);
        g1.addEdge((Object)N3, (Object)N1);
        g2.addEdge((Object)N3, (Object)N1);
        g2.addEdge((Object)N1, (Object)N2);
        new EqualsTester().addEqualityGroup(new Object[]{g1, g2}).testEquals();
    }

    @Test
    public void equals_edgeDirectionsDiffer() {
        this.graph.addEdge((Object)N1, (Object)N2);
        MutableGraph<Integer> g2 = GraphEqualsTest.createGraph(this.graphType);
        g2.addEdge((Object)N2, (Object)N1);
        switch (this.graphType) {
            case UNDIRECTED: {
                new EqualsTester().addEqualityGroup(new Object[]{this.graph, g2}).testEquals();
                break;
            }
            case DIRECTED: {
                new EqualsTester().addEqualityGroup(new Object[]{this.graph}).addEqualityGroup(new Object[]{g2}).testEquals();
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected graph type: " + (Object)((Object)this.graphType));
            }
        }
    }

    static enum GraphType {
        UNDIRECTED,
        DIRECTED,
        HYPER;

    }
}

