/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.collect.ImmutableSet;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphProperties;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.NetworkBuilder;
import com.google.common.truth.Truth;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class GraphPropertiesTest {
    private static final Integer N1 = 1;
    private static final Integer N2 = 2;
    private static final Integer N3 = 3;
    private static final String E11 = "1-1";
    private static final String E12 = "1-2";
    private static final String E12_A = "1-2a";
    private static final String E13 = "1-3";
    private static final String E21 = "2-1";
    private static final String E23 = "2-3";
    private static final String E31 = "3-1";

    @Test
    public void isCyclic_emptyGraph() {
        MutableNetwork directedGraph = NetworkBuilder.directed().build();
        Truth.assertThat((Boolean)GraphProperties.isCyclic((Graph)directedGraph)).isFalse();
    }

    @Test
    public void isCyclic_isolatedNodes() {
        MutableNetwork directedGraph = NetworkBuilder.directed().build();
        directedGraph.addNode((Object)N1);
        Truth.assertThat((Boolean)GraphProperties.isCyclic((Graph)directedGraph)).isFalse();
        directedGraph.addNode((Object)N2);
        Truth.assertThat((Boolean)GraphProperties.isCyclic((Graph)directedGraph)).isFalse();
    }

    @Test
    public void isCyclic_oneEdge() {
        MutableNetwork directedGraph = NetworkBuilder.directed().build();
        directedGraph.addEdge((Object)E12, (Object)N1, (Object)N2);
        Truth.assertThat((Boolean)GraphProperties.isCyclic((Graph)directedGraph)).isFalse();
    }

    @Test
    public void isCyclic_selfLoopEdge() {
        MutableNetwork directedGraph = NetworkBuilder.directed().build();
        directedGraph.addEdge((Object)E11, (Object)N1, (Object)N1);
        Truth.assertThat((Boolean)GraphProperties.isCyclic((Graph)directedGraph)).isTrue();
    }

    @Test
    public void isCyclic_twoParallelEdges() {
        MutableNetwork directedGraph = NetworkBuilder.directed().allowsParallelEdges(true).build();
        directedGraph.addEdge((Object)E12, (Object)N1, (Object)N2);
        directedGraph.addEdge((Object)E12_A, (Object)N1, (Object)N2);
        Truth.assertThat((Boolean)GraphProperties.isCyclic((Graph)directedGraph)).isFalse();
    }

    @Test
    public void isCyclic_twoAcyclicEdges() {
        MutableNetwork directedGraph = NetworkBuilder.directed().build();
        directedGraph.addEdge((Object)E12, (Object)N1, (Object)N2);
        directedGraph.addEdge((Object)E13, (Object)N1, (Object)N3);
        Truth.assertThat((Boolean)GraphProperties.isCyclic((Graph)directedGraph)).isFalse();
    }

    @Test
    public void isCyclic_twoCyclicEdges() {
        MutableNetwork directedGraph = NetworkBuilder.directed().build();
        directedGraph.addEdge((Object)E12, (Object)N1, (Object)N2);
        directedGraph.addEdge((Object)E21, (Object)N2, (Object)N1);
        Truth.assertThat((Boolean)GraphProperties.isCyclic((Graph)directedGraph)).isTrue();
    }

    @Test
    public void isCyclic_threeAcyclicEdges() {
        MutableNetwork directedGraph = NetworkBuilder.directed().build();
        directedGraph.addEdge((Object)E12, (Object)N1, (Object)N2);
        directedGraph.addEdge((Object)E23, (Object)N2, (Object)N3);
        directedGraph.addEdge((Object)E13, (Object)N1, (Object)N3);
        Truth.assertThat((Boolean)GraphProperties.isCyclic((Graph)directedGraph)).isFalse();
    }

    @Test
    public void isCyclic_threeCyclicEdges() {
        MutableNetwork directedGraph = NetworkBuilder.directed().build();
        directedGraph.addEdge((Object)E12, (Object)N1, (Object)N2);
        directedGraph.addEdge((Object)E23, (Object)N2, (Object)N3);
        directedGraph.addEdge((Object)E31, (Object)N3, (Object)N1);
        Truth.assertThat((Boolean)GraphProperties.isCyclic((Graph)directedGraph)).isTrue();
    }

    @Test
    public void isCyclic_disconnectedCyclicGraph() {
        MutableNetwork directedGraph = NetworkBuilder.directed().build();
        directedGraph.addEdge((Object)E12, (Object)N1, (Object)N2);
        directedGraph.addEdge((Object)E21, (Object)N2, (Object)N1);
        directedGraph.addNode((Object)N3);
        Truth.assertThat((Boolean)GraphProperties.isCyclic((Graph)directedGraph)).isTrue();
    }

    @Test
    public void isCyclic_cyclicMultigraph() {
        MutableNetwork directedGraph = NetworkBuilder.directed().allowsParallelEdges(true).build();
        directedGraph.addEdge((Object)E12, (Object)N1, (Object)N2);
        directedGraph.addEdge((Object)E12_A, (Object)N1, (Object)N2);
        directedGraph.addEdge((Object)E23, (Object)N2, (Object)N3);
        directedGraph.addEdge((Object)E31, (Object)N3, (Object)N1);
        Truth.assertThat((Boolean)GraphProperties.isCyclic((Graph)directedGraph)).isTrue();
    }

    @Test
    public void isCyclic_multipleCycles() {
        MutableNetwork directedGraph = NetworkBuilder.directed().allowsParallelEdges(true).build();
        directedGraph.addEdge((Object)E12, (Object)N1, (Object)N2);
        directedGraph.addEdge((Object)E21, (Object)N2, (Object)N1);
        directedGraph.addEdge((Object)E23, (Object)N2, (Object)N3);
        directedGraph.addEdge((Object)E31, (Object)N3, (Object)N1);
        Truth.assertThat((Boolean)GraphProperties.isCyclic((Graph)directedGraph)).isTrue();
    }

    @Test
    public void roots_emptyGraph() {
        MutableNetwork directedGraph = NetworkBuilder.directed().build();
        Truth.assertThat((Iterable)GraphProperties.roots((Graph)directedGraph)).isEmpty();
    }

    @Test
    public void roots_trivialGraph() {
        MutableNetwork directedGraph = NetworkBuilder.directed().build();
        directedGraph.addNode((Object)N1);
        Truth.assertThat((Iterable)GraphProperties.roots((Graph)directedGraph)).isEqualTo((Object)ImmutableSet.of((Object)N1));
    }

    @Test
    public void roots_nodeWithSelfLoop() {
        MutableNetwork directedGraph = NetworkBuilder.directed().build();
        directedGraph.addNode((Object)N1);
        directedGraph.addEdge((Object)E11, (Object)N1, (Object)N1);
        Truth.assertThat((Iterable)GraphProperties.roots((Graph)directedGraph)).isEmpty();
    }

    @Test
    public void roots_nodeWithChildren() {
        MutableNetwork directedGraph = NetworkBuilder.directed().build();
        directedGraph.addEdge((Object)E12, (Object)N1, (Object)N2);
        directedGraph.addEdge((Object)E13, (Object)N1, (Object)N3);
        Truth.assertThat((Iterable)GraphProperties.roots((Graph)directedGraph)).isEqualTo((Object)ImmutableSet.of((Object)N1));
    }

    @Test
    public void roots_cycle() {
        MutableNetwork directedGraph = NetworkBuilder.directed().build();
        directedGraph.addEdge((Object)E12, (Object)N1, (Object)N2);
        directedGraph.addEdge((Object)E21, (Object)N2, (Object)N1);
        Truth.assertThat((Iterable)GraphProperties.roots((Graph)directedGraph)).isEmpty();
    }

    @Test
    public void roots_multipleRoots() {
        MutableNetwork directedGraph = NetworkBuilder.directed().build();
        directedGraph.addNode((Object)N1);
        directedGraph.addNode((Object)N2);
        Truth.assertThat((Iterable)GraphProperties.roots((Graph)directedGraph)).isEqualTo((Object)ImmutableSet.of((Object)N1, (Object)N2));
    }
}

