/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.graph.ImmutableNetwork;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.Network;
import com.google.common.graph.NetworkBuilder;
import com.google.common.truth.Truth;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ImmutableNetworkTest {
    @Test
    public void copyOfImmutableNetwork_optimized() {
        ImmutableNetwork graph1 = ImmutableNetwork.copyOf((Network)NetworkBuilder.directed().build());
        ImmutableNetwork graph2 = ImmutableNetwork.copyOf((Network)graph1);
        Truth.assertThat((Object)graph2).isSameAs((Object)graph1);
    }

    @Test
    public void edgesConnecting_directed() {
        MutableNetwork mutableGraph = NetworkBuilder.directed().build();
        mutableGraph.addEdge((Object)"AA", (Object)"A", (Object)"A");
        mutableGraph.addEdge((Object)"AB", (Object)"A", (Object)"B");
        ImmutableNetwork graph = ImmutableNetwork.copyOf((Network)mutableGraph);
        Truth.assertThat((Iterable)graph.edgesConnecting((Object)"A", (Object)"A")).containsExactly(new Object[]{"AA"});
        Truth.assertThat((Iterable)graph.edgesConnecting((Object)"A", (Object)"B")).containsExactly(new Object[]{"AB"});
        Truth.assertThat((Iterable)graph.edgesConnecting((Object)"B", (Object)"A")).isEmpty();
    }

    @Test
    public void edgesConnecting_undirected() {
        MutableNetwork mutableGraph = NetworkBuilder.undirected().build();
        mutableGraph.addEdge((Object)"AA", (Object)"A", (Object)"A");
        mutableGraph.addEdge((Object)"AB", (Object)"A", (Object)"B");
        ImmutableNetwork graph = ImmutableNetwork.copyOf((Network)mutableGraph);
        Truth.assertThat((Iterable)graph.edgesConnecting((Object)"A", (Object)"A")).containsExactly(new Object[]{"AA"});
        Truth.assertThat((Iterable)graph.edgesConnecting((Object)"A", (Object)"B")).containsExactly(new Object[]{"AB"});
        Truth.assertThat((Iterable)graph.edgesConnecting((Object)"B", (Object)"A")).containsExactly(new Object[]{"AB"});
    }
}

