/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.graph.AndroidIncompatible;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.NetworkBuilder;
import com.google.common.testing.EqualsTester;
import java.util.Arrays;
import java.util.Collection;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@AndroidIncompatible
public final class NetworkEqualsTest {
    private static final Integer N1 = 1;
    private static final Integer N2 = 2;
    private static final Integer N3 = 3;
    private static final String E11 = "1-1";
    private static final String E12 = "1-2";
    private static final String E12_A = "1-2a";
    private static final String E13 = "1-3";
    private final GraphType graphType;
    private final MutableNetwork<Integer, String> graph;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({GraphType.UNDIRECTED}, {GraphType.DIRECTED});
    }

    public NetworkEqualsTest(GraphType graphType) {
        this.graphType = graphType;
        this.graph = NetworkEqualsTest.createGraph(graphType);
    }

    private static MutableNetwork<Integer, String> createGraph(GraphType graphType) {
        switch (graphType) {
            case UNDIRECTED: {
                return NetworkBuilder.undirected().build();
            }
            case DIRECTED: {
                return NetworkBuilder.directed().build();
            }
        }
        throw new IllegalStateException("Unexpected graph type: " + (Object)((Object)graphType));
    }

    private static GraphType oppositeType(GraphType graphType) {
        switch (graphType) {
            case UNDIRECTED: {
                return GraphType.DIRECTED;
            }
            case DIRECTED: {
                return GraphType.UNDIRECTED;
            }
        }
        throw new IllegalStateException("Unexpected graph type: " + (Object)((Object)graphType));
    }

    @Test
    public void equals_nodeSetsDiffer() {
        this.graph.addNode((Object)N1);
        MutableNetwork<Integer, String> g2 = NetworkEqualsTest.createGraph(this.graphType);
        g2.addNode((Object)N2);
        new EqualsTester().addEqualityGroup(new Object[]{this.graph}).addEqualityGroup(new Object[]{g2}).testEquals();
    }

    @Test
    public void equals_edgeSetsDiffer() {
        this.graph.addEdge((Object)E12, (Object)N1, (Object)N2);
        MutableNetwork<Integer, String> g2 = NetworkEqualsTest.createGraph(this.graphType);
        g2.addEdge((Object)E13, (Object)N1, (Object)N2);
        new EqualsTester().addEqualityGroup(new Object[]{this.graph}).addEqualityGroup(new Object[]{g2}).testEquals();
    }

    @Test
    public void equals_directedVsUndirected() {
        this.graph.addEdge((Object)E12, (Object)N1, (Object)N2);
        MutableNetwork<Integer, String> g2 = NetworkEqualsTest.createGraph(NetworkEqualsTest.oppositeType(this.graphType));
        g2.addEdge((Object)E12, (Object)N1, (Object)N2);
        new EqualsTester().addEqualityGroup(new Object[]{this.graph}).addEqualityGroup(new Object[]{g2}).testEquals();
    }

    @Test
    public void equals_selfLoop_directedVsUndirected() {
        this.graph.addEdge((Object)E11, (Object)N1, (Object)N1);
        MutableNetwork<Integer, String> g2 = NetworkEqualsTest.createGraph(NetworkEqualsTest.oppositeType(this.graphType));
        g2.addEdge((Object)E11, (Object)N1, (Object)N1);
        new EqualsTester().addEqualityGroup(new Object[]{this.graph, g2}).testEquals();
    }

    @Test
    public void equals_connectionsDiffer() {
        this.graph.addEdge((Object)E12, (Object)N1, (Object)N2);
        this.graph.addEdge((Object)E13, (Object)N1, (Object)N3);
        MutableNetwork<Integer, String> g2 = NetworkEqualsTest.createGraph(this.graphType);
        g2.addEdge((Object)E13, (Object)N1, (Object)N2);
        g2.addEdge((Object)E12, (Object)N1, (Object)N3);
        new EqualsTester().addEqualityGroup(new Object[]{this.graph}).addEqualityGroup(new Object[]{g2}).testEquals();
    }

    @Test
    public void equals_propertiesDiffer() {
        this.graph.addEdge((Object)E12, (Object)N1, (Object)N2);
        MutableNetwork g2 = NetworkBuilder.from(this.graph).allowsParallelEdges(!this.graph.allowsParallelEdges()).allowsSelfLoops(!this.graph.allowsSelfLoops()).build();
        g2.addEdge((Object)E12, (Object)N1, (Object)N2);
        new EqualsTester().addEqualityGroup(new Object[]{this.graph, g2}).testEquals();
    }

    @Test
    public void equals_edgeAddOrdersDiffer() {
        NetworkBuilder builder = NetworkBuilder.from(this.graph).allowsParallelEdges(true);
        MutableNetwork g1 = builder.build();
        MutableNetwork g2 = builder.build();
        g1.addEdge((Object)E12, (Object)N1, (Object)N2);
        g1.addEdge((Object)E12_A, (Object)N1, (Object)N2);
        g2.addEdge((Object)E12_A, (Object)N1, (Object)N2);
        g2.addEdge((Object)E12, (Object)N1, (Object)N2);
        new EqualsTester().addEqualityGroup(new Object[]{g1, g2}).testEquals();
    }

    @Test
    public void equals_edgeDirectionsDiffer() {
        this.graph.addEdge((Object)E12, (Object)N1, (Object)N2);
        MutableNetwork<Integer, String> g2 = NetworkEqualsTest.createGraph(this.graphType);
        g2.addEdge((Object)E12, (Object)N2, (Object)N1);
        switch (this.graphType) {
            case UNDIRECTED: {
                new EqualsTester().addEqualityGroup(new Object[]{this.graph, g2}).testEquals();
                break;
            }
            case DIRECTED: {
                new EqualsTester().addEqualityGroup(new Object[]{this.graph}).addEqualityGroup(new Object[]{g2}).testEquals();
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected graph type: " + (Object)((Object)this.graphType));
            }
        }
    }

    static enum GraphType {
        UNDIRECTED,
        DIRECTED,
        HYPER;

    }
}

