/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.ImmutableGraph;
import com.google.common.graph.ImmutableNetwork;
import com.google.common.graph.Network;
import com.google.common.graph.NetworkBuilder;
import com.google.common.graph.testing.TestGraphBuilder;
import com.google.common.graph.testing.TestNetworkBuilder;
import com.google.common.testing.AbstractPackageSanityTests;
import com.google.common.truth.Truth;
import junit.framework.AssertionFailedError;

public class PackageSanityTests
extends AbstractPackageSanityTests {
    private static final GraphBuilder<?> GRAPH_BUILDER_A = GraphBuilder.directed().expectedNodeCount(10);
    private static final GraphBuilder<?> GRAPH_BUILDER_B = GraphBuilder.directed().allowsSelfLoops(false).expectedNodeCount(16);
    private static final ImmutableGraph<String> IMMUTABLE_GRAPH_A = TestGraphBuilder.init((GraphBuilder)GraphBuilder.directed()).addNode((Object)"A").toImmutableGraph();
    private static final ImmutableGraph<String> IMMUTABLE_GRAPH_B = TestGraphBuilder.init((GraphBuilder)GraphBuilder.directed()).addNode((Object)"B").toImmutableGraph();
    private static final NetworkBuilder<?, ?> NETWORK_BUILDER_A = NetworkBuilder.directed().allowsParallelEdges(true).expectedNodeCount(10);
    private static final NetworkBuilder<?, ?> NETWORK_BUILDER_B = NetworkBuilder.directed().allowsSelfLoops(false).expectedNodeCount(16);
    private static final ImmutableNetwork<String, String> IMMUTABLE_NETWORK_A = TestNetworkBuilder.init((NetworkBuilder)NetworkBuilder.directed()).addNode((Object)"A").toImmutableNetwork();
    private static final ImmutableNetwork<String, String> IMMUTABLE_NETWORK_B = TestNetworkBuilder.init((NetworkBuilder)NetworkBuilder.directed()).addNode((Object)"B").toImmutableNetwork();

    public PackageSanityTests() {
        this.setDistinctValues(GraphBuilder.class, GRAPH_BUILDER_A, GRAPH_BUILDER_B);
        this.setDistinctValues(Graph.class, IMMUTABLE_GRAPH_A, IMMUTABLE_GRAPH_B);
        this.setDistinctValues(NetworkBuilder.class, NETWORK_BUILDER_A, NETWORK_BUILDER_B);
        this.setDistinctValues(Network.class, IMMUTABLE_NETWORK_A, IMMUTABLE_NETWORK_B);
    }

    public void testNulls() throws Exception {
        try {
            super.testNulls();
            throw new Error("Should have thrown AssertionFailedError");
        }
        catch (AssertionFailedError e) {
            Truth.assertThat((String)e.getCause().getMessage()).contains((CharSequence)"not an element of this graph");
            return;
        }
    }
}

