/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Supplier;
import com.google.common.hash.ChecksumHashFunction;
import com.google.common.hash.HashTestUtils;
import com.google.common.hash.Hashing;
import java.util.zip.Checksum;
import junit.framework.TestCase;

public class ChecksumHashFunctionTest
extends TestCase {
    public void testCrc32_equalsChecksumValue() throws Exception {
        ChecksumHashFunctionTest.assertChecksum((Supplier<Checksum>)Hashing.ChecksumType.CRC_32, "");
        ChecksumHashFunctionTest.assertChecksum((Supplier<Checksum>)Hashing.ChecksumType.CRC_32, "Z");
        ChecksumHashFunctionTest.assertChecksum((Supplier<Checksum>)Hashing.ChecksumType.CRC_32, "foobar");
    }

    public void testAdler32_equalsChecksumValue() throws Exception {
        ChecksumHashFunctionTest.assertChecksum((Supplier<Checksum>)Hashing.ChecksumType.ADLER_32, "");
        ChecksumHashFunctionTest.assertChecksum((Supplier<Checksum>)Hashing.ChecksumType.ADLER_32, "Z");
        ChecksumHashFunctionTest.assertChecksum((Supplier<Checksum>)Hashing.ChecksumType.ADLER_32, "foobar");
    }

    public void testCrc32_knownValues() throws Exception {
        ChecksumHashFunctionTest.assertHash32(478544099, (Supplier<Checksum>)Hashing.ChecksumType.CRC_32, "hell");
        ChecksumHashFunctionTest.assertHash32(907060870, (Supplier<Checksum>)Hashing.ChecksumType.CRC_32, "hello");
        ChecksumHashFunctionTest.assertHash32(-310248970, (Supplier<Checksum>)Hashing.ChecksumType.CRC_32, "hello ");
        ChecksumHashFunctionTest.assertHash32(1213259202, (Supplier<Checksum>)Hashing.ChecksumType.CRC_32, "hello w");
        ChecksumHashFunctionTest.assertHash32(2049794053, (Supplier<Checksum>)Hashing.ChecksumType.CRC_32, "hello wo");
        ChecksumHashFunctionTest.assertHash32(471410290, (Supplier<Checksum>)Hashing.ChecksumType.CRC_32, "hello wor");
        ChecksumHashFunctionTest.assertHash32(1095738169, (Supplier<Checksum>)Hashing.ChecksumType.CRC_32, "The quick brown fox jumps over the lazy dog");
        ChecksumHashFunctionTest.assertHash32(1140897212, (Supplier<Checksum>)Hashing.ChecksumType.CRC_32, "The quick brown fox jumps over the lazy cog");
    }

    public void testAdler32_knownValues() throws Exception {
        ChecksumHashFunctionTest.assertHash32(68616614, (Supplier<Checksum>)Hashing.ChecksumType.ADLER_32, "hell");
        ChecksumHashFunctionTest.assertHash32(103547413, (Supplier<Checksum>)Hashing.ChecksumType.ADLER_32, "hello");
        ChecksumHashFunctionTest.assertHash32(140575285, (Supplier<Checksum>)Hashing.ChecksumType.ADLER_32, "hello ");
        ChecksumHashFunctionTest.assertHash32(185402028, (Supplier<Checksum>)Hashing.ChecksumType.ADLER_32, "hello w");
        ChecksumHashFunctionTest.assertHash32(237503259, (Supplier<Checksum>)Hashing.ChecksumType.ADLER_32, "hello wo");
        ChecksumHashFunctionTest.assertHash32(297075597, (Supplier<Checksum>)Hashing.ChecksumType.ADLER_32, "hello wor");
        ChecksumHashFunctionTest.assertHash32(1541148634, (Supplier<Checksum>)Hashing.ChecksumType.ADLER_32, "The quick brown fox jumps over the lazy dog");
        ChecksumHashFunctionTest.assertHash32(1540952025, (Supplier<Checksum>)Hashing.ChecksumType.ADLER_32, "The quick brown fox jumps over the lazy cog");
    }

    private static void assertChecksum(Supplier<Checksum> supplier, String input) {
        byte[] bytes = HashTestUtils.ascii(input);
        Checksum checksum = (Checksum)supplier.get();
        checksum.update(bytes, 0, bytes.length);
        long value = checksum.getValue();
        String toString = "name";
        ChecksumHashFunction func = new ChecksumHashFunction(supplier, 32, toString);
        ChecksumHashFunctionTest.assertEquals((String)toString, (String)func.toString());
        ChecksumHashFunctionTest.assertEquals((long)value, (long)func.hashBytes(bytes).padToLong());
    }

    private static void assertHash32(int expected, Supplier<Checksum> supplier, String input) {
        byte[] bytes = HashTestUtils.ascii(input);
        String toString = "name";
        ChecksumHashFunction func = new ChecksumHashFunction(supplier, 32, toString);
        ChecksumHashFunctionTest.assertEquals((int)expected, (int)func.hashBytes(bytes).asInt());
        ChecksumHashFunctionTest.assertEquals((String)toString, (String)func.toString());
    }
}

