/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Charsets;
import com.google.common.hash.Crc32cHashFunction;
import com.google.common.hash.Hashing;
import java.util.Arrays;
import junit.framework.TestCase;

public class Crc32cHashFunctionTest
extends TestCase {
    private static final int CRC32C_GENERATOR = 517762881;
    private static final int CRC32C_GENERATOR_FLIPPED = Integer.reverse(517762881);

    public void testZeros() {
        byte[] zeros = new byte[32];
        Arrays.fill(zeros, (byte)0);
        Crc32cHashFunctionTest.assertCrc(-1970194774, zeros);
    }

    public void testFull() {
        byte[] fulls = new byte[32];
        Arrays.fill(fulls, (byte)-1);
        Crc32cHashFunctionTest.assertCrc(1655221059, fulls);
    }

    public void testAscending() {
        byte[] ascending = new byte[32];
        for (int i = 0; i < 32; ++i) {
            ascending[i] = (byte)i;
        }
        Crc32cHashFunctionTest.assertCrc(1188919630, ascending);
    }

    public void testDescending() {
        byte[] descending = new byte[32];
        for (int i = 0; i < 32; ++i) {
            descending[i] = (byte)(31 - i);
        }
        Crc32cHashFunctionTest.assertCrc(289397596, descending);
    }

    public void testScsiReadCommad() {
        byte[] scsiReadCommand = new byte[]{1, -64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 20, 0, 0, 0, 24, 40, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0};
        Crc32cHashFunctionTest.assertCrc(-644466090, scsiReadCommand);
    }

    public void testSomeOtherKnownValues() {
        Crc32cHashFunctionTest.assertCrc(576848900, "The quick brown fox jumps over the lazy dog".getBytes(Charsets.UTF_8));
        Crc32cHashFunctionTest.assertCrc(-486108541, "123456789".getBytes(Charsets.UTF_8));
        Crc32cHashFunctionTest.assertCrc(-203696898, "1234567890".getBytes(Charsets.UTF_8));
        Crc32cHashFunctionTest.assertCrc(-1075238269, "23456789".getBytes(Charsets.UTF_8));
    }

    private static void assertCrc(int expectedCrc, byte[] data) {
        int actualCrc = Hashing.crc32c().hashBytes(data).asInt();
        Crc32cHashFunctionTest.assertEquals((int)expectedCrc, (int)actualCrc);
    }

    public void testCrc32cLookupTable() {
        int[] expected = new int[256];
        for (int i = 0; i < expected.length; ++i) {
            int crc = i;
            for (int j = 7; j >= 0; --j) {
                int mask = -(crc & 1);
                crc = crc >>> 1 ^ CRC32C_GENERATOR_FLIPPED & mask;
            }
            expected[i] = crc;
        }
        int[] actual = Crc32cHashFunction.Crc32cHasher.CRC_TABLE;
        Crc32cHashFunctionTest.assertTrue((String)("Expected: \n" + Arrays.toString(expected) + "\nActual:\n" + Arrays.toString(actual)), (boolean)Arrays.equals(expected, actual));
    }
}

