/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.caliper.BeforeExperiment;
import com.google.caliper.Benchmark;
import com.google.caliper.Param;
import com.google.common.math.IntMath;
import com.google.common.math.MathBenchmarking;
import java.math.RoundingMode;

public class IntMathRoundingBenchmark {
    private static final int[] positive = new int[65536];
    private static final int[] nonzero = new int[65536];
    private static final int[] ints = new int[65536];
    @Param(value={"DOWN", "UP", "FLOOR", "CEILING", "HALF_EVEN", "HALF_UP", "HALF_DOWN"})
    RoundingMode mode;

    @BeforeExperiment
    void setUp() {
        for (int i = 0; i < 65536; ++i) {
            IntMathRoundingBenchmark.positive[i] = MathBenchmarking.randomPositiveBigInteger(30).intValue();
            IntMathRoundingBenchmark.nonzero[i] = MathBenchmarking.randomNonZeroBigInteger(30).intValue();
            IntMathRoundingBenchmark.ints[i] = MathBenchmarking.RANDOM_SOURCE.nextInt();
        }
    }

    @Benchmark
    int log2(int reps) {
        int tmp = 0;
        for (int i = 0; i < reps; ++i) {
            int j = i & 0xFFFF;
            tmp += IntMath.log2((int)positive[j], (RoundingMode)this.mode);
        }
        return tmp;
    }

    @Benchmark
    int log10(int reps) {
        int tmp = 0;
        for (int i = 0; i < reps; ++i) {
            int j = i & 0xFFFF;
            tmp += IntMath.log10((int)positive[j], (RoundingMode)this.mode);
        }
        return tmp;
    }

    @Benchmark
    int sqrt(int reps) {
        int tmp = 0;
        for (int i = 0; i < reps; ++i) {
            int j = i & 0xFFFF;
            tmp += IntMath.sqrt((int)positive[j], (RoundingMode)this.mode);
        }
        return tmp;
    }

    @Benchmark
    int divide(int reps) {
        int tmp = 0;
        for (int i = 0; i < reps; ++i) {
            int j = i & 0xFFFF;
            tmp += IntMath.divide((int)ints[j], (int)nonzero[j], (RoundingMode)this.mode);
        }
        return tmp;
    }
}

