/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.common.collect.ImmutableList;
import com.google.common.math.LinearTransformation;
import com.google.common.math.PairedStats;
import com.google.common.math.StatsTesting;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.SerializableTester;
import com.google.common.truth.DoubleSubject;
import com.google.common.truth.Truth;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import junit.framework.TestCase;

public class PairedStatsTest
extends TestCase {
    public void testCount() {
        Truth.assertThat((Long)StatsTesting.EMPTY_PAIRED_STATS.count()).isEqualTo((Object)0);
        Truth.assertThat((Long)StatsTesting.ONE_VALUE_PAIRED_STATS.count()).isEqualTo((Object)1);
        Truth.assertThat((Long)StatsTesting.TWO_VALUES_PAIRED_STATS.count()).isEqualTo((Object)2);
        Truth.assertThat((Long)StatsTesting.MANY_VALUES_PAIRED_STATS.count()).isEqualTo((Object)5);
    }

    public void testXStats() {
        StatsTesting.assertStatsApproxEqual(StatsTesting.EMPTY_STATS_ITERABLE, StatsTesting.EMPTY_PAIRED_STATS.xStats());
        StatsTesting.assertStatsApproxEqual(StatsTesting.ONE_VALUE_STATS, StatsTesting.ONE_VALUE_PAIRED_STATS.xStats());
        StatsTesting.assertStatsApproxEqual(StatsTesting.TWO_VALUES_STATS, StatsTesting.TWO_VALUES_PAIRED_STATS.xStats());
        StatsTesting.assertStatsApproxEqual(StatsTesting.MANY_VALUES_STATS_ITERABLE, StatsTesting.MANY_VALUES_PAIRED_STATS.xStats());
    }

    public void testYStats() {
        StatsTesting.assertStatsApproxEqual(StatsTesting.EMPTY_STATS_ITERABLE, StatsTesting.EMPTY_PAIRED_STATS.yStats());
        StatsTesting.assertStatsApproxEqual(StatsTesting.OTHER_ONE_VALUE_STATS, StatsTesting.ONE_VALUE_PAIRED_STATS.yStats());
        StatsTesting.assertStatsApproxEqual(StatsTesting.OTHER_TWO_VALUES_STATS, StatsTesting.TWO_VALUES_PAIRED_STATS.yStats());
        StatsTesting.assertStatsApproxEqual(StatsTesting.OTHER_MANY_VALUES_STATS, StatsTesting.MANY_VALUES_PAIRED_STATS.yStats());
    }

    public void testPopulationCovariance() {
        try {
            StatsTesting.EMPTY_PAIRED_STATS.populationCovariance();
            PairedStatsTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Truth.assertThat((Double)StatsTesting.ONE_VALUE_PAIRED_STATS.populationCovariance()).isWithin(0.0).of(0.0);
        Truth.assertThat((Double)this.createSingleStats(Double.POSITIVE_INFINITY, 1.23).populationCovariance()).isNaN();
        Truth.assertThat((Double)this.createSingleStats(Double.NEGATIVE_INFINITY, 1.23).populationCovariance()).isNaN();
        Truth.assertThat((Double)this.createSingleStats(Double.NaN, 1.23).populationCovariance()).isNaN();
        Truth.assertThat((Double)StatsTesting.TWO_VALUES_PAIRED_STATS.populationCovariance()).isWithin(1.0E-10).of(15767.447040000001);
        for (StatsTesting.ManyValues values : StatsTesting.ALL_MANY_VALUES) {
            PairedStats stats = StatsTesting.createPairedStatsOf(values.asIterable(), StatsTesting.OTHER_MANY_VALUES);
            double populationCovariance = stats.populationCovariance();
            if (values.hasAnyNonFinite()) {
                ((DoubleSubject)Truth.assertThat((Double)populationCovariance).named("population covariance of " + values)).isNaN();
                continue;
            }
            ((DoubleSubject)Truth.assertThat((Double)populationCovariance).named("population covariance of " + values)).isWithin(1.0E-10).of(-16749.253212878997);
        }
        Truth.assertThat((Double)StatsTesting.HORIZONTAL_VALUES_PAIRED_STATS.populationCovariance()).isWithin(1.0E-10).of(0.0);
        Truth.assertThat((Double)StatsTesting.VERTICAL_VALUES_PAIRED_STATS.populationCovariance()).isWithin(1.0E-10).of(0.0);
        Truth.assertThat((Double)StatsTesting.CONSTANT_VALUES_PAIRED_STATS.populationCovariance()).isWithin(1.0E-10).of(0.0);
    }

    public void testSampleCovariance() {
        try {
            StatsTesting.EMPTY_PAIRED_STATS.sampleCovariance();
            PairedStatsTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            StatsTesting.ONE_VALUE_PAIRED_STATS.sampleCovariance();
            PairedStatsTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Truth.assertThat((Double)StatsTesting.TWO_VALUES_PAIRED_STATS.sampleCovariance()).isWithin(1.0E-10).of(31534.894080000002);
        Truth.assertThat((Double)StatsTesting.MANY_VALUES_PAIRED_STATS.sampleCovariance()).isWithin(1.0E-10).of(-20936.56651609875);
        Truth.assertThat((Double)StatsTesting.HORIZONTAL_VALUES_PAIRED_STATS.sampleCovariance()).isWithin(1.0E-10).of(0.0);
        Truth.assertThat((Double)StatsTesting.VERTICAL_VALUES_PAIRED_STATS.sampleCovariance()).isWithin(1.0E-10).of(0.0);
        Truth.assertThat((Double)StatsTesting.CONSTANT_VALUES_PAIRED_STATS.sampleCovariance()).isWithin(1.0E-10).of(0.0);
    }

    public void testPearsonsCorrelationCoefficient() {
        try {
            StatsTesting.EMPTY_PAIRED_STATS.pearsonsCorrelationCoefficient();
            PairedStatsTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            StatsTesting.ONE_VALUE_PAIRED_STATS.pearsonsCorrelationCoefficient();
            PairedStatsTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.createSingleStats(Double.POSITIVE_INFINITY, 1.23).pearsonsCorrelationCoefficient();
            PairedStatsTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Truth.assertThat((Double)StatsTesting.TWO_VALUES_PAIRED_STATS.pearsonsCorrelationCoefficient()).isWithin(1.0E-10).of(StatsTesting.TWO_VALUES_PAIRED_STATS.populationCovariance() / (StatsTesting.TWO_VALUES_PAIRED_STATS.xStats().populationStandardDeviation() * StatsTesting.TWO_VALUES_PAIRED_STATS.yStats().populationStandardDeviation()));
        for (StatsTesting.ManyValues values : StatsTesting.ALL_MANY_VALUES) {
            PairedStats stats = StatsTesting.createPairedStatsOf(StatsTesting.MANY_VALUES, values.asIterable());
            double pearsonsCorrelationCoefficient = stats.pearsonsCorrelationCoefficient();
            if (values.hasAnyNonFinite()) {
                ((DoubleSubject)Truth.assertThat((Double)pearsonsCorrelationCoefficient).named("Pearson's correlation coefficient of " + values)).isNaN();
                continue;
            }
            ((DoubleSubject)Truth.assertThat((Double)pearsonsCorrelationCoefficient).named("Pearson's correlation coefficient of " + values)).isWithin(1.0E-10).of(stats.populationCovariance() / (stats.xStats().populationStandardDeviation() * stats.yStats().populationStandardDeviation()));
        }
        try {
            StatsTesting.HORIZONTAL_VALUES_PAIRED_STATS.pearsonsCorrelationCoefficient();
            PairedStatsTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            StatsTesting.VERTICAL_VALUES_PAIRED_STATS.pearsonsCorrelationCoefficient();
            PairedStatsTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            StatsTesting.CONSTANT_VALUES_PAIRED_STATS.pearsonsCorrelationCoefficient();
            PairedStatsTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testLeastSquaresFit() {
        try {
            StatsTesting.EMPTY_PAIRED_STATS.leastSquaresFit();
            PairedStatsTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            StatsTesting.ONE_VALUE_PAIRED_STATS.leastSquaresFit();
            PairedStatsTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.createSingleStats(Double.POSITIVE_INFINITY, 1.23).leastSquaresFit();
            PairedStatsTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        StatsTesting.assertDiagonalLinearTransformation(StatsTesting.TWO_VALUES_PAIRED_STATS.leastSquaresFit(), StatsTesting.TWO_VALUES_PAIRED_STATS.xStats().mean(), StatsTesting.TWO_VALUES_PAIRED_STATS.yStats().mean(), StatsTesting.TWO_VALUES_PAIRED_STATS.xStats().populationVariance(), StatsTesting.TWO_VALUES_PAIRED_STATS.populationCovariance());
        for (StatsTesting.ManyValues values : StatsTesting.ALL_MANY_VALUES) {
            PairedStats stats = StatsTesting.createPairedStatsOf(values.asIterable(), StatsTesting.OTHER_MANY_VALUES);
            LinearTransformation fit = stats.leastSquaresFit();
            if (values.hasAnyNonFinite()) {
                StatsTesting.assertLinearTransformationNaN(fit);
                continue;
            }
            StatsTesting.assertDiagonalLinearTransformation(fit, stats.xStats().mean(), stats.yStats().mean(), stats.xStats().populationVariance(), stats.populationCovariance());
        }
        StatsTesting.assertHorizontalLinearTransformation(StatsTesting.HORIZONTAL_VALUES_PAIRED_STATS.leastSquaresFit(), StatsTesting.HORIZONTAL_VALUES_PAIRED_STATS.yStats().mean());
        StatsTesting.assertVerticalLinearTransformation(StatsTesting.VERTICAL_VALUES_PAIRED_STATS.leastSquaresFit(), StatsTesting.VERTICAL_VALUES_PAIRED_STATS.xStats().mean());
        try {
            StatsTesting.CONSTANT_VALUES_PAIRED_STATS.leastSquaresFit();
            PairedStatsTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testEqualsAndHashCode() {
        new EqualsTester().addEqualityGroup(new Object[]{StatsTesting.MANY_VALUES_PAIRED_STATS, StatsTesting.DUPLICATE_MANY_VALUES_PAIRED_STATS, SerializableTester.reserialize((Object)StatsTesting.MANY_VALUES_PAIRED_STATS)}).addEqualityGroup(new Object[]{new PairedStats(StatsTesting.MANY_VALUES_STATS_ITERABLE, StatsTesting.OTHER_MANY_VALUES_STATS, 1.23), new PairedStats(StatsTesting.MANY_VALUES_STATS_VARARGS, StatsTesting.OTHER_MANY_VALUES_STATS, 1.23)}).addEqualityGroup(new Object[]{new PairedStats(StatsTesting.OTHER_MANY_VALUES_STATS, StatsTesting.MANY_VALUES_STATS_ITERABLE, 1.23)}).addEqualityGroup(new Object[]{new PairedStats(StatsTesting.MANY_VALUES_STATS_ITERABLE, StatsTesting.MANY_VALUES_STATS_ITERABLE, 1.23)}).addEqualityGroup(new Object[]{new PairedStats(StatsTesting.TWO_VALUES_STATS, StatsTesting.MANY_VALUES_STATS_ITERABLE, 1.23)}).addEqualityGroup(new Object[]{new PairedStats(StatsTesting.MANY_VALUES_STATS_ITERABLE, StatsTesting.ONE_VALUE_STATS, 1.23)}).addEqualityGroup(new Object[]{new PairedStats(StatsTesting.MANY_VALUES_STATS_ITERABLE, StatsTesting.MANY_VALUES_STATS_ITERABLE, 1.234)}).testEquals();
    }

    public void testSerializable() {
        SerializableTester.reserializeAndAssert((Object)StatsTesting.MANY_VALUES_PAIRED_STATS);
    }

    public void testToString() {
        Truth.assertThat((String)StatsTesting.EMPTY_PAIRED_STATS.toString()).isEqualTo((Object)"PairedStats{xStats=Stats{count=0}, yStats=Stats{count=0}}");
        Truth.assertThat((String)StatsTesting.MANY_VALUES_PAIRED_STATS.toString()).isEqualTo((Object)("PairedStats{xStats=" + StatsTesting.MANY_VALUES_PAIRED_STATS.xStats() + ", yStats=" + StatsTesting.MANY_VALUES_PAIRED_STATS.yStats() + ", populationCovariance=" + StatsTesting.MANY_VALUES_PAIRED_STATS.populationCovariance() + "}"));
    }

    private PairedStats createSingleStats(double x, double y) {
        return StatsTesting.createPairedStatsOf((List<Double>)ImmutableList.of((Object)x), (List<Double>)ImmutableList.of((Object)y));
    }

    public void testToByteArrayAndFromByteArrayRoundTrip() {
        for (PairedStats pairedStats : StatsTesting.ALL_PAIRED_STATS) {
            byte[] pairedStatsByteArray = pairedStats.toByteArray();
            Truth.assertThat((Object)PairedStats.fromByteArray((byte[])pairedStatsByteArray)).isEqualTo((Object)pairedStats);
        }
    }

    public void testFromByteArray_withNullInputThrowsNullPointerException() {
        try {
            PairedStats.fromByteArray(null);
            PairedStatsTest.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testFromByteArray_withEmptyArrayInputThrowsIllegalArgumentException() {
        try {
            PairedStats.fromByteArray((byte[])new byte[0]);
            PairedStatsTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testFromByteArray_withTooLongArrayInputThrowsIllegalArgumentException() {
        byte[] buffer = StatsTesting.MANY_VALUES_PAIRED_STATS.toByteArray();
        byte[] tooLongByteArray = ByteBuffer.allocate(buffer.length + 2).order(ByteOrder.LITTLE_ENDIAN).put(buffer).putChar('.').array();
        try {
            PairedStats.fromByteArray((byte[])tooLongByteArray);
            PairedStatsTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testFromByteArrayWithTooShortArrayInputThrowsIllegalArgumentException() {
        byte[] buffer = StatsTesting.MANY_VALUES_PAIRED_STATS.toByteArray();
        byte[] tooShortByteArray = ByteBuffer.allocate(buffer.length - 1).order(ByteOrder.LITTLE_ENDIAN).put(buffer, 0, buffer.length - 1).array();
        try {
            PairedStats.fromByteArray((byte[])tooShortByteArray);
            PairedStatsTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

