/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.common.collect.ImmutableList;
import com.google.common.math.Stats;
import com.google.common.math.StatsAccumulator;
import com.google.common.math.StatsTesting;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Longs;
import com.google.common.truth.DoubleSubject;
import com.google.common.truth.Truth;
import java.util.Iterator;
import junit.framework.TestCase;

public class StatsAccumulatorTest
extends TestCase {
    private StatsAccumulator emptyAccumulator;
    private StatsAccumulator emptyAccumulatorByAddAllEmptyIterable;
    private StatsAccumulator emptyAccumulatorByAddAllEmptyStats;
    private StatsAccumulator oneValueAccumulator;
    private StatsAccumulator oneValueAccumulatorByAddAllEmptyStats;
    private StatsAccumulator twoValuesAccumulator;
    private StatsAccumulator twoValuesAccumulatorByAddAllStats;
    private StatsAccumulator manyValuesAccumulatorByAddAllIterable;
    private StatsAccumulator manyValuesAccumulatorByAddAllIterator;
    private StatsAccumulator manyValuesAccumulatorByAddAllVarargs;
    private StatsAccumulator manyValuesAccumulatorByRepeatedAdd;
    private StatsAccumulator manyValuesAccumulatorByAddAndAddAll;
    private StatsAccumulator manyValuesAccumulatorByAddAllStats;
    private StatsAccumulator integerManyValuesAccumulatorByAddAllIterable;
    private StatsAccumulator longManyValuesAccumulatorByAddAllIterator;
    private StatsAccumulator longManyValuesAccumulatorByAddAllVarargs;

    protected void setUp() throws Exception {
        super.setUp();
        this.emptyAccumulator = new StatsAccumulator();
        this.emptyAccumulatorByAddAllEmptyIterable = new StatsAccumulator();
        this.emptyAccumulatorByAddAllEmptyIterable.addAll((Iterable)ImmutableList.of());
        this.emptyAccumulatorByAddAllEmptyStats = new StatsAccumulator();
        this.emptyAccumulatorByAddAllEmptyStats.addAll(Stats.of((int[])new int[0]));
        this.oneValueAccumulator = new StatsAccumulator();
        this.oneValueAccumulator.add(12.34);
        this.oneValueAccumulatorByAddAllEmptyStats = new StatsAccumulator();
        this.oneValueAccumulatorByAddAllEmptyStats.add(12.34);
        this.oneValueAccumulatorByAddAllEmptyStats.addAll(Stats.of((int[])new int[0]));
        this.twoValuesAccumulator = new StatsAccumulator();
        this.twoValuesAccumulator.addAll(StatsTesting.TWO_VALUES);
        this.twoValuesAccumulatorByAddAllStats = new StatsAccumulator();
        this.twoValuesAccumulatorByAddAllStats.addAll(Stats.of((double[])new double[]{12.34}));
        this.twoValuesAccumulatorByAddAllStats.addAll(Stats.of((double[])new double[]{-56.78}));
        this.manyValuesAccumulatorByAddAllIterable = new StatsAccumulator();
        this.manyValuesAccumulatorByAddAllIterable.addAll(StatsTesting.MANY_VALUES);
        this.manyValuesAccumulatorByAddAllIterator = new StatsAccumulator();
        this.manyValuesAccumulatorByAddAllIterator.addAll((Iterator)StatsTesting.MANY_VALUES.iterator());
        this.manyValuesAccumulatorByAddAllVarargs = new StatsAccumulator();
        this.manyValuesAccumulatorByAddAllVarargs.addAll(Doubles.toArray(StatsTesting.MANY_VALUES));
        this.manyValuesAccumulatorByRepeatedAdd = new StatsAccumulator();
        Iterator i$ = StatsTesting.MANY_VALUES.iterator();
        while (i$.hasNext()) {
            double value = (Double)i$.next();
            this.manyValuesAccumulatorByRepeatedAdd.add(value);
        }
        this.manyValuesAccumulatorByAddAndAddAll = new StatsAccumulator();
        this.manyValuesAccumulatorByAddAndAddAll.add(((Double)StatsTesting.MANY_VALUES.get(0)).doubleValue());
        this.manyValuesAccumulatorByAddAndAddAll.addAll((Iterable)StatsTesting.MANY_VALUES.subList(1, StatsTesting.MANY_VALUES.size()));
        this.manyValuesAccumulatorByAddAllStats = new StatsAccumulator();
        this.manyValuesAccumulatorByAddAllStats.addAll(Stats.of((Iterable)StatsTesting.MANY_VALUES.subList(0, StatsTesting.MANY_VALUES.size() / 2)));
        this.manyValuesAccumulatorByAddAllStats.addAll(Stats.of((Iterable)StatsTesting.MANY_VALUES.subList(StatsTesting.MANY_VALUES.size() / 2, StatsTesting.MANY_VALUES.size())));
        this.integerManyValuesAccumulatorByAddAllIterable = new StatsAccumulator();
        this.integerManyValuesAccumulatorByAddAllIterable.addAll(StatsTesting.INTEGER_MANY_VALUES);
        this.longManyValuesAccumulatorByAddAllIterator = new StatsAccumulator();
        this.longManyValuesAccumulatorByAddAllIterator.addAll((Iterator)StatsTesting.LONG_MANY_VALUES.iterator());
        this.longManyValuesAccumulatorByAddAllVarargs = new StatsAccumulator();
        this.longManyValuesAccumulatorByAddAllVarargs.addAll(Longs.toArray(StatsTesting.LONG_MANY_VALUES));
    }

    public void testCount() {
        Truth.assertThat((Long)this.emptyAccumulator.count()).isEqualTo((Object)0);
        Truth.assertThat((Long)this.emptyAccumulatorByAddAllEmptyIterable.count()).isEqualTo((Object)0);
        Truth.assertThat((Long)this.emptyAccumulatorByAddAllEmptyStats.count()).isEqualTo((Object)0);
        Truth.assertThat((Long)this.oneValueAccumulator.count()).isEqualTo((Object)1);
        Truth.assertThat((Long)this.oneValueAccumulatorByAddAllEmptyStats.count()).isEqualTo((Object)1);
        Truth.assertThat((Long)this.twoValuesAccumulator.count()).isEqualTo((Object)2);
        Truth.assertThat((Long)this.twoValuesAccumulatorByAddAllStats.count()).isEqualTo((Object)2);
        Truth.assertThat((Long)this.manyValuesAccumulatorByAddAllIterable.count()).isEqualTo((Object)5);
        Truth.assertThat((Long)this.manyValuesAccumulatorByAddAllIterator.count()).isEqualTo((Object)5);
        Truth.assertThat((Long)this.manyValuesAccumulatorByAddAllVarargs.count()).isEqualTo((Object)5);
        Truth.assertThat((Long)this.manyValuesAccumulatorByRepeatedAdd.count()).isEqualTo((Object)5);
        Truth.assertThat((Long)this.manyValuesAccumulatorByAddAndAddAll.count()).isEqualTo((Object)5);
        Truth.assertThat((Long)this.manyValuesAccumulatorByAddAllStats.count()).isEqualTo((Object)5);
        Truth.assertThat((Long)this.integerManyValuesAccumulatorByAddAllIterable.count()).isEqualTo((Object)5);
        Truth.assertThat((Long)this.longManyValuesAccumulatorByAddAllIterator.count()).isEqualTo((Object)5);
        Truth.assertThat((Long)this.longManyValuesAccumulatorByAddAllVarargs.count()).isEqualTo((Object)5);
    }

    public void testCountOverflow_doesNotThrow() {
        StatsAccumulator accumulator = new StatsAccumulator();
        accumulator.add(12.34);
        for (int power = 1; power < 63; ++power) {
            accumulator.addAll(accumulator.snapshot());
        }
        accumulator.addAll(accumulator.snapshot());
        Truth.assertThat((Long)accumulator.count()).isLessThan((Comparable)Long.valueOf(0L));
    }

    public void testMean() {
        try {
            this.emptyAccumulator.mean();
            StatsAccumulatorTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.emptyAccumulatorByAddAllEmptyIterable.mean();
            StatsAccumulatorTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.emptyAccumulatorByAddAllEmptyStats.mean();
            StatsAccumulatorTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Truth.assertThat((Double)this.oneValueAccumulator.mean()).isWithin(1.0E-10).of(12.34);
        Truth.assertThat((Double)this.oneValueAccumulatorByAddAllEmptyStats.mean()).isWithin(1.0E-10).of(12.34);
        Truth.assertThat((Double)this.twoValuesAccumulator.mean()).isWithin(1.0E-10).of(-22.22);
        Truth.assertThat((Double)this.twoValuesAccumulatorByAddAllStats.mean()).isWithin(1.0E-10).of(-22.22);
        Truth.assertThat((Double)this.manyValuesAccumulatorByAddAllIterable.mean()).isWithin(1.0E-10).of(108.66899999999998);
        Truth.assertThat((Double)this.manyValuesAccumulatorByAddAllIterator.mean()).isWithin(1.0E-10).of(108.66899999999998);
        Truth.assertThat((Double)this.manyValuesAccumulatorByAddAllVarargs.mean()).isWithin(1.0E-10).of(108.66899999999998);
        Truth.assertThat((Double)this.manyValuesAccumulatorByRepeatedAdd.mean()).isWithin(1.0E-10).of(108.66899999999998);
        Truth.assertThat((Double)this.manyValuesAccumulatorByAddAndAddAll.mean()).isWithin(1.0E-10).of(108.66899999999998);
        Truth.assertThat((Double)this.manyValuesAccumulatorByAddAllStats.mean()).isWithin(1.0E-10).of(108.66899999999998);
        for (StatsTesting.ManyValues values : StatsTesting.ALL_MANY_VALUES) {
            StatsAccumulator accumulator = new StatsAccumulator();
            StatsAccumulator accumulatorByAddAllStats = new StatsAccumulator();
            accumulator.addAll(values.asIterable());
            Iterator i$ = values.asIterable().iterator();
            while (i$.hasNext()) {
                double value = (Double)i$.next();
                accumulatorByAddAllStats.addAll(Stats.of((double[])new double[]{value}));
            }
            double mean = accumulator.mean();
            double meanByAddAllStats = accumulatorByAddAllStats.mean();
            if (values.hasAnyNaN()) {
                ((DoubleSubject)Truth.assertThat((Double)mean).named("mean of " + values)).isNaN();
                ((DoubleSubject)Truth.assertThat((Double)meanByAddAllStats).named("mean by addAll(Stats) of " + values)).isNaN();
                continue;
            }
            if (values.hasAnyPositiveInfinity() && values.hasAnyNegativeInfinity()) {
                ((DoubleSubject)Truth.assertThat((Double)mean).named("mean of " + values)).isNaN();
                ((DoubleSubject)Truth.assertThat((Double)meanByAddAllStats).named("mean by addAll(Stats) of " + values)).isNaN();
                continue;
            }
            if (values.hasAnyPositiveInfinity()) {
                ((DoubleSubject)Truth.assertThat((Double)mean).named("mean of " + values)).isPositiveInfinity();
                ((DoubleSubject)Truth.assertThat((Double)meanByAddAllStats).named("mean by addAll(Stats) of " + values)).isPositiveInfinity();
                continue;
            }
            if (values.hasAnyNegativeInfinity()) {
                ((DoubleSubject)Truth.assertThat((Double)mean).named("mean of " + values)).isNegativeInfinity();
                ((DoubleSubject)Truth.assertThat((Double)meanByAddAllStats).named("mean by addAll(Stats) of " + values)).isNegativeInfinity();
                continue;
            }
            ((DoubleSubject)Truth.assertThat((Double)mean).named("mean of " + values)).isWithin(1.0E-10).of(108.66899999999998);
            ((DoubleSubject)Truth.assertThat((Double)meanByAddAllStats).named("mean by addAll(Stats) of " + values)).isWithin(1.0E-10).of(108.66899999999998);
        }
        Truth.assertThat((Double)this.integerManyValuesAccumulatorByAddAllIterable.mean()).isWithin(1.0E-10).of(110886.6);
        Truth.assertThat((Double)this.longManyValuesAccumulatorByAddAllIterator.mean()).isWithin(1.0E-10).of(1.1088886666E9);
        Truth.assertThat((Double)this.longManyValuesAccumulatorByAddAllVarargs.mean()).isWithin(1.0E-10).of(1.1088886666E9);
    }

    public void testSum() {
        Truth.assertThat((Double)this.emptyAccumulator.sum()).isWithin(0.0).of(0.0);
        Truth.assertThat((Double)this.emptyAccumulatorByAddAllEmptyIterable.sum()).isWithin(0.0).of(0.0);
        Truth.assertThat((Double)this.emptyAccumulatorByAddAllEmptyStats.sum()).isWithin(0.0).of(0.0);
        Truth.assertThat((Double)this.oneValueAccumulator.sum()).isWithin(1.0E-10).of(12.34);
        Truth.assertThat((Double)this.oneValueAccumulatorByAddAllEmptyStats.sum()).isWithin(1.0E-10).of(12.34);
        Truth.assertThat((Double)this.twoValuesAccumulator.sum()).isWithin(1.0E-10).of(-44.44);
        Truth.assertThat((Double)this.twoValuesAccumulatorByAddAllStats.sum()).isWithin(1.0E-10).of(-44.44);
        Truth.assertThat((Double)this.manyValuesAccumulatorByAddAllIterable.sum()).isWithin(1.0E-10).of(543.3449999999999);
        Truth.assertThat((Double)this.manyValuesAccumulatorByAddAllIterator.sum()).isWithin(1.0E-10).of(543.3449999999999);
        Truth.assertThat((Double)this.manyValuesAccumulatorByAddAllVarargs.sum()).isWithin(1.0E-10).of(543.3449999999999);
        Truth.assertThat((Double)this.manyValuesAccumulatorByRepeatedAdd.sum()).isWithin(1.0E-10).of(543.3449999999999);
        Truth.assertThat((Double)this.manyValuesAccumulatorByAddAndAddAll.sum()).isWithin(1.0E-10).of(543.3449999999999);
        Truth.assertThat((Double)this.manyValuesAccumulatorByAddAllStats.sum()).isWithin(1.0E-10).of(543.3449999999999);
        Truth.assertThat((Double)this.integerManyValuesAccumulatorByAddAllIterable.sum()).isWithin(1.0E-10).of(554433.0);
        Truth.assertThat((Double)this.longManyValuesAccumulatorByAddAllIterator.sum()).isWithin(1.0E-10).of(5.544443333E9);
        Truth.assertThat((Double)this.longManyValuesAccumulatorByAddAllVarargs.sum()).isWithin(1.0E-10).of(5.544443333E9);
    }

    public void testPopulationVariance() {
        try {
            this.emptyAccumulator.populationVariance();
            StatsAccumulatorTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.emptyAccumulatorByAddAllEmptyIterable.populationVariance();
            StatsAccumulatorTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.emptyAccumulatorByAddAllEmptyStats.populationVariance();
            StatsAccumulatorTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Truth.assertThat((Double)this.oneValueAccumulator.populationVariance()).isWithin(0.0).of(0.0);
        Truth.assertThat((Double)this.oneValueAccumulatorByAddAllEmptyStats.populationVariance()).isWithin(0.0).of(0.0);
        Truth.assertThat((Double)this.twoValuesAccumulator.populationVariance()).isWithin(1.0E-10).of(1194.3936);
        Truth.assertThat((Double)this.twoValuesAccumulatorByAddAllStats.populationVariance()).isWithin(1.0E-10).of(1194.3936);
        Truth.assertThat((Double)this.manyValuesAccumulatorByAddAllIterable.populationVariance()).isWithin(1.0E-10).of(50537.690544);
        Truth.assertThat((Double)this.manyValuesAccumulatorByAddAllIterator.populationVariance()).isWithin(1.0E-10).of(50537.690544);
        Truth.assertThat((Double)this.manyValuesAccumulatorByAddAllVarargs.populationVariance()).isWithin(1.0E-10).of(50537.690544);
        Truth.assertThat((Double)this.manyValuesAccumulatorByRepeatedAdd.populationVariance()).isWithin(1.0E-10).of(50537.690544);
        Truth.assertThat((Double)this.manyValuesAccumulatorByAddAndAddAll.populationVariance()).isWithin(1.0E-10).of(50537.690544);
        Truth.assertThat((Double)this.manyValuesAccumulatorByAddAllStats.populationVariance()).isWithin(1.0E-10).of(50537.690544);
        for (StatsTesting.ManyValues values : StatsTesting.ALL_MANY_VALUES) {
            StatsAccumulator accumulator = new StatsAccumulator();
            StatsAccumulator accumulatorByAddAllStats = new StatsAccumulator();
            accumulator.addAll((Iterator)values.asIterable().iterator());
            Iterator i$ = values.asIterable().iterator();
            while (i$.hasNext()) {
                double value = (Double)i$.next();
                accumulatorByAddAllStats.addAll(Stats.of((double[])new double[]{value}));
            }
            double populationVariance = accumulator.populationVariance();
            double populationVarianceByAddAllStats = accumulatorByAddAllStats.populationVariance();
            if (values.hasAnyNonFinite()) {
                ((DoubleSubject)Truth.assertThat((Double)populationVariance).named("population variance of " + values)).isNaN();
                ((DoubleSubject)Truth.assertThat((Double)populationVarianceByAddAllStats).named("population variance by addAll(Stats) of " + values)).isNaN();
                continue;
            }
            ((DoubleSubject)Truth.assertThat((Double)populationVariance).named("population variance of " + values)).isWithin(1.0E-10).of(50537.690544);
            ((DoubleSubject)Truth.assertThat((Double)populationVarianceByAddAllStats).named("population variance by addAll(Stats) of " + values)).isWithin(1.0E-10).of(50537.690544);
        }
        Truth.assertThat((Double)this.integerManyValuesAccumulatorByAddAllIterable.populationVariance()).isWithin(1.0E-10).of(4.943860527144E10);
        Truth.assertThat((Double)this.longManyValuesAccumulatorByAddAllIterator.populationVariance()).isWithin(1.0E-10).of(4.943822713963851E18);
        Truth.assertThat((Double)this.longManyValuesAccumulatorByAddAllVarargs.populationVariance()).isWithin(1.0E-10).of(4.943822713963851E18);
    }

    public void testPopulationStandardDeviation() {
        try {
            this.emptyAccumulator.populationStandardDeviation();
            StatsAccumulatorTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.emptyAccumulatorByAddAllEmptyIterable.populationStandardDeviation();
            StatsAccumulatorTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.emptyAccumulatorByAddAllEmptyStats.populationStandardDeviation();
            StatsAccumulatorTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Truth.assertThat((Double)this.oneValueAccumulator.populationStandardDeviation()).isWithin(0.0).of(0.0);
        Truth.assertThat((Double)this.oneValueAccumulatorByAddAllEmptyStats.populationStandardDeviation()).isWithin(0.0).of(0.0);
        Truth.assertThat((Double)this.twoValuesAccumulator.populationStandardDeviation()).isWithin(1.0E-10).of(Math.sqrt(1194.3936));
        Truth.assertThat((Double)this.twoValuesAccumulatorByAddAllStats.populationStandardDeviation()).isWithin(1.0E-10).of(Math.sqrt(1194.3936));
        Truth.assertThat((Double)this.manyValuesAccumulatorByAddAllIterable.populationStandardDeviation()).isWithin(1.0E-10).of(Math.sqrt(50537.690544));
        Truth.assertThat((Double)this.manyValuesAccumulatorByAddAllIterator.populationStandardDeviation()).isWithin(1.0E-10).of(Math.sqrt(50537.690544));
        Truth.assertThat((Double)this.manyValuesAccumulatorByAddAllVarargs.populationStandardDeviation()).isWithin(1.0E-10).of(Math.sqrt(50537.690544));
        Truth.assertThat((Double)this.manyValuesAccumulatorByRepeatedAdd.populationStandardDeviation()).isWithin(1.0E-10).of(Math.sqrt(50537.690544));
        Truth.assertThat((Double)this.manyValuesAccumulatorByAddAndAddAll.populationStandardDeviation()).isWithin(1.0E-10).of(Math.sqrt(50537.690544));
        Truth.assertThat((Double)this.manyValuesAccumulatorByAddAllStats.populationStandardDeviation()).isWithin(1.0E-10).of(Math.sqrt(50537.690544));
        Truth.assertThat((Double)this.integerManyValuesAccumulatorByAddAllIterable.populationStandardDeviation()).isWithin(1.0E-10).of(Math.sqrt(4.943860527144E10));
        Truth.assertThat((Double)this.longManyValuesAccumulatorByAddAllIterator.populationStandardDeviation()).isWithin(1.0E-10).of(Math.sqrt(4.943822713963851E18));
        Truth.assertThat((Double)this.longManyValuesAccumulatorByAddAllVarargs.populationStandardDeviation()).isWithin(1.0E-10).of(Math.sqrt(4.943822713963851E18));
    }

    public void testSampleVariance() {
        try {
            this.emptyAccumulator.sampleVariance();
            StatsAccumulatorTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.emptyAccumulatorByAddAllEmptyIterable.sampleVariance();
            StatsAccumulatorTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.emptyAccumulatorByAddAllEmptyStats.sampleVariance();
            StatsAccumulatorTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.oneValueAccumulator.sampleVariance();
            StatsAccumulatorTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.oneValueAccumulatorByAddAllEmptyStats.sampleVariance();
            StatsAccumulatorTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Truth.assertThat((Double)this.twoValuesAccumulator.sampleVariance()).isWithin(1.0E-10).of(2388.7872);
        Truth.assertThat((Double)this.twoValuesAccumulatorByAddAllStats.sampleVariance()).isWithin(1.0E-10).of(2388.7872);
        Truth.assertThat((Double)this.manyValuesAccumulatorByAddAllIterable.sampleVariance()).isWithin(1.0E-10).of(63172.11317999999);
        Truth.assertThat((Double)this.manyValuesAccumulatorByAddAllIterator.sampleVariance()).isWithin(1.0E-10).of(63172.11317999999);
        Truth.assertThat((Double)this.manyValuesAccumulatorByAddAllVarargs.sampleVariance()).isWithin(1.0E-10).of(63172.11317999999);
        Truth.assertThat((Double)this.manyValuesAccumulatorByRepeatedAdd.sampleVariance()).isWithin(1.0E-10).of(63172.11317999999);
        Truth.assertThat((Double)this.manyValuesAccumulatorByAddAndAddAll.sampleVariance()).isWithin(1.0E-10).of(63172.11317999999);
        Truth.assertThat((Double)this.manyValuesAccumulatorByAddAllStats.sampleVariance()).isWithin(1.0E-10).of(63172.11317999999);
        Truth.assertThat((Double)this.integerManyValuesAccumulatorByAddAllIterable.sampleVariance()).isWithin(1.0E-10).of(6.17982565893E10);
        Truth.assertThat((Double)this.longManyValuesAccumulatorByAddAllIterator.sampleVariance()).isWithin(1.0E-10).of(6.179778392454814E18);
        Truth.assertThat((Double)this.longManyValuesAccumulatorByAddAllVarargs.sampleVariance()).isWithin(1.0E-10).of(6.179778392454814E18);
    }

    public void testSampleStandardDeviation() {
        try {
            this.emptyAccumulator.sampleStandardDeviation();
            StatsAccumulatorTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.emptyAccumulatorByAddAllEmptyIterable.sampleStandardDeviation();
            StatsAccumulatorTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.emptyAccumulatorByAddAllEmptyStats.sampleStandardDeviation();
            StatsAccumulatorTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.oneValueAccumulator.sampleStandardDeviation();
            StatsAccumulatorTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.oneValueAccumulatorByAddAllEmptyStats.sampleStandardDeviation();
            StatsAccumulatorTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Truth.assertThat((Double)this.twoValuesAccumulator.sampleStandardDeviation()).isWithin(1.0E-10).of(Math.sqrt(2388.7872));
        Truth.assertThat((Double)this.twoValuesAccumulatorByAddAllStats.sampleStandardDeviation()).isWithin(1.0E-10).of(Math.sqrt(2388.7872));
        Truth.assertThat((Double)this.manyValuesAccumulatorByAddAllIterable.sampleStandardDeviation()).isWithin(1.0E-10).of(Math.sqrt(63172.11317999999));
        Truth.assertThat((Double)this.manyValuesAccumulatorByAddAllIterator.sampleStandardDeviation()).isWithin(1.0E-10).of(Math.sqrt(63172.11317999999));
        Truth.assertThat((Double)this.manyValuesAccumulatorByAddAllVarargs.sampleStandardDeviation()).isWithin(1.0E-10).of(Math.sqrt(63172.11317999999));
        Truth.assertThat((Double)this.manyValuesAccumulatorByRepeatedAdd.sampleStandardDeviation()).isWithin(1.0E-10).of(Math.sqrt(63172.11317999999));
        Truth.assertThat((Double)this.manyValuesAccumulatorByAddAndAddAll.sampleStandardDeviation()).isWithin(1.0E-10).of(Math.sqrt(63172.11317999999));
        Truth.assertThat((Double)this.manyValuesAccumulatorByAddAllStats.sampleStandardDeviation()).isWithin(1.0E-10).of(Math.sqrt(63172.11317999999));
        Truth.assertThat((Double)this.integerManyValuesAccumulatorByAddAllIterable.sampleStandardDeviation()).isWithin(1.0E-10).of(Math.sqrt(6.17982565893E10));
        Truth.assertThat((Double)this.longManyValuesAccumulatorByAddAllIterator.sampleStandardDeviation()).isWithin(1.0E-10).of(Math.sqrt(6.179778392454814E18));
        Truth.assertThat((Double)this.longManyValuesAccumulatorByAddAllVarargs.sampleStandardDeviation()).isWithin(1.0E-10).of(Math.sqrt(6.179778392454814E18));
    }

    public void testMax() {
        try {
            this.emptyAccumulator.max();
            StatsAccumulatorTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.emptyAccumulatorByAddAllEmptyIterable.max();
            StatsAccumulatorTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.emptyAccumulatorByAddAllEmptyStats.max();
            StatsAccumulatorTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Truth.assertThat((Double)this.oneValueAccumulator.max()).isWithin(1.0E-10).of(12.34);
        Truth.assertThat((Double)this.oneValueAccumulatorByAddAllEmptyStats.max()).isWithin(1.0E-10).of(12.34);
        Truth.assertThat((Double)this.twoValuesAccumulator.max()).isWithin(1.0E-10).of(12.34);
        Truth.assertThat((Double)this.twoValuesAccumulatorByAddAllStats.max()).isWithin(1.0E-10).of(12.34);
        Truth.assertThat((Double)this.manyValuesAccumulatorByAddAllIterable.max()).isWithin(1.0E-10).of(555.555);
        Truth.assertThat((Double)this.manyValuesAccumulatorByAddAllIterator.max()).isWithin(1.0E-10).of(555.555);
        Truth.assertThat((Double)this.manyValuesAccumulatorByAddAllVarargs.max()).isWithin(1.0E-10).of(555.555);
        Truth.assertThat((Double)this.manyValuesAccumulatorByRepeatedAdd.max()).isWithin(1.0E-10).of(555.555);
        Truth.assertThat((Double)this.manyValuesAccumulatorByAddAndAddAll.max()).isWithin(1.0E-10).of(555.555);
        Truth.assertThat((Double)this.manyValuesAccumulatorByAddAllStats.max()).isWithin(1.0E-10).of(555.555);
        for (StatsTesting.ManyValues values : StatsTesting.ALL_MANY_VALUES) {
            StatsAccumulator accumulator = new StatsAccumulator();
            StatsAccumulator accumulatorByAddAllStats = new StatsAccumulator();
            accumulator.addAll(values.asArray());
            Iterator i$ = values.asIterable().iterator();
            while (i$.hasNext()) {
                double value = (Double)i$.next();
                accumulatorByAddAllStats.addAll(Stats.of((double[])new double[]{value}));
            }
            double max = accumulator.max();
            double maxByAddAllStats = accumulatorByAddAllStats.max();
            if (values.hasAnyNaN()) {
                ((DoubleSubject)Truth.assertThat((Double)max).named("max of " + values)).isNaN();
                ((DoubleSubject)Truth.assertThat((Double)maxByAddAllStats).named("max by addAll(Stats) of " + values)).isNaN();
                continue;
            }
            if (values.hasAnyPositiveInfinity()) {
                ((DoubleSubject)Truth.assertThat((Double)max).named("max of " + values)).isPositiveInfinity();
                ((DoubleSubject)Truth.assertThat((Double)maxByAddAllStats).named("max by addAll(Stats) of " + values)).isPositiveInfinity();
                continue;
            }
            ((DoubleSubject)Truth.assertThat((Double)max).named("max of " + values)).isWithin(1.0E-10).of(555.555);
            ((DoubleSubject)Truth.assertThat((Double)maxByAddAllStats).named("max by addAll(Stats) of " + values)).isWithin(1.0E-10).of(555.555);
        }
        Truth.assertThat((Double)this.integerManyValuesAccumulatorByAddAllIterable.max()).isWithin(1.0E-10).of(555555.0);
        Truth.assertThat((Double)this.longManyValuesAccumulatorByAddAllIterator.max()).isWithin(1.0E-10).of(5.555555555E9);
        Truth.assertThat((Double)this.longManyValuesAccumulatorByAddAllVarargs.max()).isWithin(1.0E-10).of(5.555555555E9);
    }

    public void testMin() {
        try {
            this.emptyAccumulator.min();
            StatsAccumulatorTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.emptyAccumulatorByAddAllEmptyIterable.min();
            StatsAccumulatorTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.emptyAccumulatorByAddAllEmptyStats.min();
            StatsAccumulatorTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Truth.assertThat((Double)this.oneValueAccumulator.min()).isWithin(1.0E-10).of(12.34);
        Truth.assertThat((Double)this.oneValueAccumulatorByAddAllEmptyStats.min()).isWithin(1.0E-10).of(12.34);
        Truth.assertThat((Double)this.twoValuesAccumulator.min()).isWithin(1.0E-10).of(-56.78);
        Truth.assertThat((Double)this.twoValuesAccumulatorByAddAllStats.min()).isWithin(1.0E-10).of(-56.78);
        Truth.assertThat((Double)this.manyValuesAccumulatorByAddAllIterable.min()).isWithin(1.0E-10).of(-44.44);
        Truth.assertThat((Double)this.manyValuesAccumulatorByAddAllIterator.min()).isWithin(1.0E-10).of(-44.44);
        Truth.assertThat((Double)this.manyValuesAccumulatorByAddAllVarargs.min()).isWithin(1.0E-10).of(-44.44);
        Truth.assertThat((Double)this.manyValuesAccumulatorByRepeatedAdd.min()).isWithin(1.0E-10).of(-44.44);
        Truth.assertThat((Double)this.manyValuesAccumulatorByAddAndAddAll.min()).isWithin(1.0E-10).of(-44.44);
        Truth.assertThat((Double)this.manyValuesAccumulatorByAddAllStats.min()).isWithin(1.0E-10).of(-44.44);
        for (StatsTesting.ManyValues values : StatsTesting.ALL_MANY_VALUES) {
            StatsAccumulator accumulator = new StatsAccumulator();
            StatsAccumulator accumulatorByAddAllStats = new StatsAccumulator();
            Iterator i$ = values.asIterable().iterator();
            while (i$.hasNext()) {
                double value = (Double)i$.next();
                accumulator.add(value);
                accumulatorByAddAllStats.addAll(Stats.of((double[])new double[]{value}));
            }
            double min = accumulator.min();
            double minByAddAllStats = accumulatorByAddAllStats.min();
            if (values.hasAnyNaN()) {
                ((DoubleSubject)Truth.assertThat((Double)min).named("min of " + values)).isNaN();
                ((DoubleSubject)Truth.assertThat((Double)minByAddAllStats).named("min by addAll(Stats) of " + values)).isNaN();
                continue;
            }
            if (values.hasAnyNegativeInfinity()) {
                ((DoubleSubject)Truth.assertThat((Double)min).named("min of " + values)).isNegativeInfinity();
                ((DoubleSubject)Truth.assertThat((Double)minByAddAllStats).named("min by addAll(Stats) of " + values)).isNegativeInfinity();
                continue;
            }
            ((DoubleSubject)Truth.assertThat((Double)min).named("min of " + values)).isWithin(1.0E-10).of(-44.44);
            ((DoubleSubject)Truth.assertThat((Double)minByAddAllStats).named("min by addAll(Stats) of " + values)).isWithin(1.0E-10).of(-44.44);
        }
        Truth.assertThat((Double)this.integerManyValuesAccumulatorByAddAllIterable.min()).isWithin(1.0E-10).of(-4444.0);
        Truth.assertThat((Double)this.longManyValuesAccumulatorByAddAllIterator.min()).isWithin(1.0E-10).of(-4.4444444E7);
        Truth.assertThat((Double)this.longManyValuesAccumulatorByAddAllVarargs.min()).isWithin(1.0E-10).of(-4.4444444E7);
    }
}

