/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.common.collect.ImmutableList;
import com.google.common.math.Stats;
import com.google.common.math.StatsAccumulator;
import com.google.common.math.StatsTesting;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.SerializableTester;
import com.google.common.truth.DoubleSubject;
import com.google.common.truth.Truth;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Iterator;
import junit.framework.TestCase;

public class StatsTest
extends TestCase {
    public void testCount() {
        Truth.assertThat((Long)StatsTesting.EMPTY_STATS_VARARGS.count()).isEqualTo((Object)0);
        Truth.assertThat((Long)StatsTesting.EMPTY_STATS_ITERABLE.count()).isEqualTo((Object)0);
        Truth.assertThat((Long)StatsTesting.ONE_VALUE_STATS.count()).isEqualTo((Object)1);
        Truth.assertThat((Long)StatsTesting.TWO_VALUES_STATS.count()).isEqualTo((Object)2);
        Truth.assertThat((Long)StatsTesting.MANY_VALUES_STATS_VARARGS.count()).isEqualTo((Object)5);
        Truth.assertThat((Long)StatsTesting.MANY_VALUES_STATS_ITERABLE.count()).isEqualTo((Object)5);
        Truth.assertThat((Long)StatsTesting.MANY_VALUES_STATS_ITERATOR.count()).isEqualTo((Object)5);
        Truth.assertThat((Long)StatsTesting.MANY_VALUES_STATS_SNAPSHOT.count()).isEqualTo((Object)5);
        Truth.assertThat((Long)StatsTesting.INTEGER_MANY_VALUES_STATS_VARARGS.count()).isEqualTo((Object)5);
        Truth.assertThat((Long)StatsTesting.INTEGER_MANY_VALUES_STATS_ITERABLE.count()).isEqualTo((Object)5);
        Truth.assertThat((Long)StatsTesting.LONG_MANY_VALUES_STATS_ITERATOR.count()).isEqualTo((Object)5);
        Truth.assertThat((Long)StatsTesting.LONG_MANY_VALUES_STATS_SNAPSHOT.count()).isEqualTo((Object)5);
    }

    public void testMean() {
        try {
            StatsTesting.EMPTY_STATS_VARARGS.mean();
            StatsTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            StatsTesting.EMPTY_STATS_ITERABLE.mean();
            StatsTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Truth.assertThat((Double)StatsTesting.ONE_VALUE_STATS.mean()).isWithin(1.0E-10).of(12.34);
        Truth.assertThat((Double)Stats.of((double[])new double[]{Double.POSITIVE_INFINITY}).mean()).isPositiveInfinity();
        Truth.assertThat((Double)Stats.of((double[])new double[]{Double.NEGATIVE_INFINITY}).mean()).isNegativeInfinity();
        Truth.assertThat((Double)Stats.of((double[])new double[]{Double.NaN}).mean()).isNaN();
        Truth.assertThat((Double)StatsTesting.TWO_VALUES_STATS.mean()).isWithin(1.0E-10).of(-22.22);
        for (StatsTesting.ManyValues values : StatsTesting.ALL_MANY_VALUES) {
            double mean = Stats.of((double[])values.asArray()).mean();
            if (values.hasAnyNaN()) {
                ((DoubleSubject)Truth.assertThat((Double)mean).named("mean of " + values)).isNaN();
                continue;
            }
            if (values.hasAnyPositiveInfinity() && values.hasAnyNegativeInfinity()) {
                ((DoubleSubject)Truth.assertThat((Double)mean).named("mean of " + values)).isNaN();
                continue;
            }
            if (values.hasAnyPositiveInfinity()) {
                ((DoubleSubject)Truth.assertThat((Double)mean).named("mean of " + values)).isPositiveInfinity();
                continue;
            }
            if (values.hasAnyNegativeInfinity()) {
                ((DoubleSubject)Truth.assertThat((Double)mean).named("mean of " + values)).isNegativeInfinity();
                continue;
            }
            ((DoubleSubject)Truth.assertThat((Double)mean).named("mean of " + values)).isWithin(1.0E-10).of(108.66899999999998);
        }
        Truth.assertThat((Double)StatsTesting.MANY_VALUES_STATS_ITERABLE.mean()).isWithin(1.0E-10).of(108.66899999999998);
        Truth.assertThat((Double)StatsTesting.MANY_VALUES_STATS_ITERATOR.mean()).isWithin(1.0E-10).of(108.66899999999998);
        Truth.assertThat((Double)StatsTesting.MANY_VALUES_STATS_SNAPSHOT.mean()).isWithin(1.0E-10).of(108.66899999999998);
        Truth.assertThat((Double)StatsTesting.LARGE_VALUES_STATS.mean()).isWithin(1.7976931348623157E298).of(1.3482698511467367E308);
        Truth.assertThat((Double)StatsTesting.INTEGER_MANY_VALUES_STATS_VARARGS.mean()).isWithin(1.0E-10).of(110886.6);
        Truth.assertThat((Double)StatsTesting.INTEGER_MANY_VALUES_STATS_ITERABLE.mean()).isWithin(1.0E-10).of(110886.6);
        Truth.assertThat((Double)StatsTesting.LARGE_INTEGER_VALUES_STATS.mean()).isWithin(0.2147483647).of(StatsTesting.LARGE_INTEGER_VALUES_MEAN);
        Truth.assertThat((Double)StatsTesting.LONG_MANY_VALUES_STATS_ITERATOR.mean()).isWithin(1.0E-10).of(1.1088886666E9);
        Truth.assertThat((Double)StatsTesting.LONG_MANY_VALUES_STATS_SNAPSHOT.mean()).isWithin(1.0E-10).of(1.1088886666E9);
        Truth.assertThat((Double)StatsTesting.LARGE_LONG_VALUES_STATS.mean()).isWithin(9.223372036854776E8).of(StatsTesting.LARGE_LONG_VALUES_MEAN);
    }

    public void testSum() {
        Truth.assertThat((Double)StatsTesting.EMPTY_STATS_VARARGS.sum()).isEqualTo(Double.valueOf(0.0));
        Truth.assertThat((Double)StatsTesting.EMPTY_STATS_ITERABLE.sum()).isEqualTo(Double.valueOf(0.0));
        Truth.assertThat((Double)StatsTesting.ONE_VALUE_STATS.sum()).isWithin(1.0E-10).of(12.34);
        Truth.assertThat((Double)StatsTesting.TWO_VALUES_STATS.sum()).isWithin(1.0E-10).of(-44.44);
        Truth.assertThat((Double)StatsTesting.MANY_VALUES_STATS_VARARGS.sum()).isWithin(1.0E-10).of(543.3449999999999);
        Truth.assertThat((Double)StatsTesting.MANY_VALUES_STATS_ITERABLE.sum()).isWithin(1.0E-10).of(543.3449999999999);
        Truth.assertThat((Double)StatsTesting.MANY_VALUES_STATS_ITERATOR.sum()).isWithin(1.0E-10).of(543.3449999999999);
        Truth.assertThat((Double)StatsTesting.MANY_VALUES_STATS_SNAPSHOT.sum()).isWithin(1.0E-10).of(543.3449999999999);
        Truth.assertThat((Double)StatsTesting.INTEGER_MANY_VALUES_STATS_VARARGS.sum()).isWithin(1.0E-10).of(554433.0);
        Truth.assertThat((Double)StatsTesting.INTEGER_MANY_VALUES_STATS_ITERABLE.sum()).isWithin(1.0E-10).of(554433.0);
        Truth.assertThat((Double)StatsTesting.LONG_MANY_VALUES_STATS_ITERATOR.sum()).isWithin(1.0E-10).of(5.544443333E9);
        Truth.assertThat((Double)StatsTesting.LONG_MANY_VALUES_STATS_SNAPSHOT.sum()).isWithin(1.0E-10).of(5.544443333E9);
    }

    public void testPopulationVariance() {
        try {
            StatsTesting.EMPTY_STATS_VARARGS.populationVariance();
            StatsTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            StatsTesting.EMPTY_STATS_ITERABLE.populationVariance();
            StatsTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Truth.assertThat((Double)StatsTesting.ONE_VALUE_STATS.populationVariance()).isWithin(0.0).of(0.0);
        Truth.assertThat((Double)Stats.of((double[])new double[]{Double.POSITIVE_INFINITY}).populationVariance()).isNaN();
        Truth.assertThat((Double)Stats.of((double[])new double[]{Double.NEGATIVE_INFINITY}).populationVariance()).isNaN();
        Truth.assertThat((Double)Stats.of((double[])new double[]{Double.NaN}).populationVariance()).isNaN();
        Truth.assertThat((Double)StatsTesting.TWO_VALUES_STATS.populationVariance()).isWithin(1.0E-10).of(1194.3936);
        Truth.assertThat((Double)StatsTesting.MANY_VALUES_STATS_VARARGS.populationVariance()).isWithin(1.0E-10).of(50537.690544);
        for (StatsTesting.ManyValues values : StatsTesting.ALL_MANY_VALUES) {
            double populationVariance = Stats.of(values.asIterable()).populationVariance();
            if (values.hasAnyNonFinite()) {
                ((DoubleSubject)Truth.assertThat((Double)populationVariance).named("population variance of " + values)).isNaN();
                continue;
            }
            ((DoubleSubject)Truth.assertThat((Double)populationVariance).named("population variance of " + values)).isWithin(1.0E-10).of(50537.690544);
        }
        Truth.assertThat((Double)StatsTesting.MANY_VALUES_STATS_ITERATOR.populationVariance()).isWithin(1.0E-10).of(50537.690544);
        Truth.assertThat((Double)StatsTesting.MANY_VALUES_STATS_SNAPSHOT.populationVariance()).isWithin(1.0E-10).of(50537.690544);
        Truth.assertThat((Double)StatsTesting.INTEGER_MANY_VALUES_STATS_VARARGS.populationVariance()).isWithin(1.0E-10).of(4.943860527144E10);
        Truth.assertThat((Double)StatsTesting.INTEGER_MANY_VALUES_STATS_ITERABLE.populationVariance()).isWithin(1.0E-10).of(4.943860527144E10);
        Truth.assertThat((Double)StatsTesting.LARGE_INTEGER_VALUES_STATS.populationVariance()).isWithin(4.6116860141324204E8).of(StatsTesting.LARGE_INTEGER_VALUES_POPULATION_VARIANCE);
        Truth.assertThat((Double)StatsTesting.LONG_MANY_VALUES_STATS_ITERATOR.populationVariance()).isWithin(1.0E-10).of(4.943822713963851E18);
        Truth.assertThat((Double)StatsTesting.LONG_MANY_VALUES_STATS_SNAPSHOT.populationVariance()).isWithin(1.0E-10).of(4.943822713963851E18);
        Truth.assertThat((Double)StatsTesting.LARGE_LONG_VALUES_STATS.populationVariance()).isWithin(8.507059173023462E27).of(StatsTesting.LARGE_LONG_VALUES_POPULATION_VARIANCE);
    }

    public void testPopulationStandardDeviation() {
        try {
            StatsTesting.EMPTY_STATS_VARARGS.populationStandardDeviation();
            StatsTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            StatsTesting.EMPTY_STATS_ITERABLE.populationStandardDeviation();
            StatsTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Truth.assertThat((Double)StatsTesting.ONE_VALUE_STATS.populationStandardDeviation()).isWithin(0.0).of(0.0);
        Truth.assertThat((Double)StatsTesting.TWO_VALUES_STATS.populationStandardDeviation()).isWithin(1.0E-10).of(Math.sqrt(1194.3936));
        Truth.assertThat((Double)StatsTesting.MANY_VALUES_STATS_VARARGS.populationStandardDeviation()).isWithin(1.0E-10).of(Math.sqrt(50537.690544));
        Truth.assertThat((Double)StatsTesting.MANY_VALUES_STATS_ITERABLE.populationStandardDeviation()).isWithin(1.0E-10).of(Math.sqrt(50537.690544));
        Truth.assertThat((Double)StatsTesting.MANY_VALUES_STATS_ITERATOR.populationStandardDeviation()).isWithin(1.0E-10).of(Math.sqrt(50537.690544));
        Truth.assertThat((Double)StatsTesting.MANY_VALUES_STATS_SNAPSHOT.populationStandardDeviation()).isWithin(1.0E-10).of(Math.sqrt(50537.690544));
        Truth.assertThat((Double)StatsTesting.INTEGER_MANY_VALUES_STATS_VARARGS.populationStandardDeviation()).isWithin(1.0E-10).of(Math.sqrt(4.943860527144E10));
        Truth.assertThat((Double)StatsTesting.INTEGER_MANY_VALUES_STATS_ITERABLE.populationStandardDeviation()).isWithin(1.0E-10).of(Math.sqrt(4.943860527144E10));
        Truth.assertThat((Double)StatsTesting.LONG_MANY_VALUES_STATS_ITERATOR.populationStandardDeviation()).isWithin(1.0E-10).of(Math.sqrt(4.943822713963851E18));
        Truth.assertThat((Double)StatsTesting.LONG_MANY_VALUES_STATS_SNAPSHOT.populationStandardDeviation()).isWithin(1.0E-10).of(Math.sqrt(4.943822713963851E18));
    }

    public void testSampleVariance() {
        try {
            StatsTesting.EMPTY_STATS_VARARGS.sampleVariance();
            StatsTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            StatsTesting.EMPTY_STATS_ITERABLE.sampleVariance();
            StatsTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            StatsTesting.ONE_VALUE_STATS.sampleVariance();
            StatsTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Truth.assertThat((Double)StatsTesting.TWO_VALUES_STATS.sampleVariance()).isWithin(1.0E-10).of(2388.7872);
        Truth.assertThat((Double)StatsTesting.MANY_VALUES_STATS_VARARGS.sampleVariance()).isWithin(1.0E-10).of(63172.11317999999);
        Truth.assertThat((Double)StatsTesting.MANY_VALUES_STATS_ITERABLE.sampleVariance()).isWithin(1.0E-10).of(63172.11317999999);
        Truth.assertThat((Double)StatsTesting.MANY_VALUES_STATS_ITERATOR.sampleVariance()).isWithin(1.0E-10).of(63172.11317999999);
        Truth.assertThat((Double)StatsTesting.MANY_VALUES_STATS_SNAPSHOT.sampleVariance()).isWithin(1.0E-10).of(63172.11317999999);
        Truth.assertThat((Double)StatsTesting.INTEGER_MANY_VALUES_STATS_VARARGS.sampleVariance()).isWithin(1.0E-10).of(6.17982565893E10);
        Truth.assertThat((Double)StatsTesting.INTEGER_MANY_VALUES_STATS_ITERABLE.sampleVariance()).isWithin(1.0E-10).of(6.17982565893E10);
        Truth.assertThat((Double)StatsTesting.LONG_MANY_VALUES_STATS_ITERATOR.sampleVariance()).isWithin(1.0E-10).of(6.179778392454814E18);
        Truth.assertThat((Double)StatsTesting.LONG_MANY_VALUES_STATS_SNAPSHOT.sampleVariance()).isWithin(1.0E-10).of(6.179778392454814E18);
    }

    public void testSampleStandardDeviation() {
        try {
            StatsTesting.EMPTY_STATS_VARARGS.sampleStandardDeviation();
            StatsTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            StatsTesting.EMPTY_STATS_ITERABLE.sampleStandardDeviation();
            StatsTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            StatsTesting.ONE_VALUE_STATS.sampleStandardDeviation();
            StatsTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Truth.assertThat((Double)StatsTesting.TWO_VALUES_STATS.sampleStandardDeviation()).isWithin(1.0E-10).of(Math.sqrt(2388.7872));
        Truth.assertThat((Double)StatsTesting.MANY_VALUES_STATS_VARARGS.sampleStandardDeviation()).isWithin(1.0E-10).of(Math.sqrt(63172.11317999999));
        Truth.assertThat((Double)StatsTesting.MANY_VALUES_STATS_ITERABLE.sampleStandardDeviation()).isWithin(1.0E-10).of(Math.sqrt(63172.11317999999));
        Truth.assertThat((Double)StatsTesting.MANY_VALUES_STATS_ITERATOR.sampleStandardDeviation()).isWithin(1.0E-10).of(Math.sqrt(63172.11317999999));
        Truth.assertThat((Double)StatsTesting.MANY_VALUES_STATS_SNAPSHOT.sampleStandardDeviation()).isWithin(1.0E-10).of(Math.sqrt(63172.11317999999));
        Truth.assertThat((Double)StatsTesting.INTEGER_MANY_VALUES_STATS_VARARGS.sampleStandardDeviation()).isWithin(1.0E-10).of(Math.sqrt(6.17982565893E10));
        Truth.assertThat((Double)StatsTesting.INTEGER_MANY_VALUES_STATS_ITERABLE.sampleStandardDeviation()).isWithin(1.0E-10).of(Math.sqrt(6.17982565893E10));
        Truth.assertThat((Double)StatsTesting.LONG_MANY_VALUES_STATS_ITERATOR.sampleStandardDeviation()).isWithin(1.0E-10).of(Math.sqrt(6.179778392454814E18));
        Truth.assertThat((Double)StatsTesting.LONG_MANY_VALUES_STATS_SNAPSHOT.sampleStandardDeviation()).isWithin(1.0E-10).of(Math.sqrt(6.179778392454814E18));
    }

    public void testMax() {
        try {
            StatsTesting.EMPTY_STATS_VARARGS.max();
            StatsTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            StatsTesting.EMPTY_STATS_ITERABLE.max();
            StatsTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Truth.assertThat((Double)StatsTesting.ONE_VALUE_STATS.max()).isWithin(1.0E-10).of(12.34);
        Truth.assertThat((Double)Stats.of((double[])new double[]{Double.POSITIVE_INFINITY}).max()).isPositiveInfinity();
        Truth.assertThat((Double)Stats.of((double[])new double[]{Double.NEGATIVE_INFINITY}).max()).isNegativeInfinity();
        Truth.assertThat((Double)Stats.of((double[])new double[]{Double.NaN}).max()).isNaN();
        Truth.assertThat((Double)StatsTesting.TWO_VALUES_STATS.max()).isWithin(1.0E-10).of(12.34);
        Truth.assertThat((Double)StatsTesting.MANY_VALUES_STATS_VARARGS.max()).isWithin(1.0E-10).of(555.555);
        Truth.assertThat((Double)StatsTesting.MANY_VALUES_STATS_ITERABLE.max()).isWithin(1.0E-10).of(555.555);
        for (StatsTesting.ManyValues values : StatsTesting.ALL_MANY_VALUES) {
            double max = Stats.of((Iterator)values.asIterable().iterator()).max();
            if (values.hasAnyNaN()) {
                ((DoubleSubject)Truth.assertThat((Double)max).named("max of " + values)).isNaN();
                continue;
            }
            if (values.hasAnyPositiveInfinity()) {
                ((DoubleSubject)Truth.assertThat((Double)max).named("max of " + values)).isPositiveInfinity();
                continue;
            }
            ((DoubleSubject)Truth.assertThat((Double)max).named("max of " + values)).isWithin(1.0E-10).of(555.555);
        }
        Truth.assertThat((Double)StatsTesting.MANY_VALUES_STATS_SNAPSHOT.max()).isWithin(1.0E-10).of(555.555);
        Truth.assertThat((Double)StatsTesting.INTEGER_MANY_VALUES_STATS_VARARGS.max()).isWithin(1.0E-10).of(555555.0);
        Truth.assertThat((Double)StatsTesting.INTEGER_MANY_VALUES_STATS_ITERABLE.max()).isWithin(1.0E-10).of(555555.0);
        Truth.assertThat((Double)StatsTesting.LONG_MANY_VALUES_STATS_ITERATOR.max()).isWithin(1.0E-10).of(5.555555555E9);
        Truth.assertThat((Double)StatsTesting.LONG_MANY_VALUES_STATS_SNAPSHOT.max()).isWithin(1.0E-10).of(5.555555555E9);
    }

    public void testMin() {
        try {
            StatsTesting.EMPTY_STATS_VARARGS.min();
            StatsTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            StatsTesting.EMPTY_STATS_ITERABLE.min();
            StatsTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Truth.assertThat((Double)StatsTesting.ONE_VALUE_STATS.min()).isWithin(1.0E-10).of(12.34);
        Truth.assertThat((Double)Stats.of((double[])new double[]{Double.POSITIVE_INFINITY}).min()).isPositiveInfinity();
        Truth.assertThat((Double)Stats.of((double[])new double[]{Double.NEGATIVE_INFINITY}).min()).isNegativeInfinity();
        Truth.assertThat((Double)Stats.of((double[])new double[]{Double.NaN}).min()).isNaN();
        Truth.assertThat((Double)StatsTesting.TWO_VALUES_STATS.min()).isWithin(1.0E-10).of(-56.78);
        Truth.assertThat((Double)StatsTesting.MANY_VALUES_STATS_VARARGS.min()).isWithin(1.0E-10).of(-44.44);
        Truth.assertThat((Double)StatsTesting.MANY_VALUES_STATS_ITERABLE.min()).isWithin(1.0E-10).of(-44.44);
        Truth.assertThat((Double)StatsTesting.MANY_VALUES_STATS_ITERATOR.min()).isWithin(1.0E-10).of(-44.44);
        for (StatsTesting.ManyValues values : StatsTesting.ALL_MANY_VALUES) {
            StatsAccumulator accumulator = new StatsAccumulator();
            accumulator.addAll(values.asIterable());
            double min = accumulator.snapshot().min();
            if (values.hasAnyNaN()) {
                ((DoubleSubject)Truth.assertThat((Double)min).named("min of " + values)).isNaN();
                continue;
            }
            if (values.hasAnyNegativeInfinity()) {
                ((DoubleSubject)Truth.assertThat((Double)min).named("min of " + values)).isNegativeInfinity();
                continue;
            }
            ((DoubleSubject)Truth.assertThat((Double)min).named("min of " + values)).isWithin(1.0E-10).of(-44.44);
        }
        Truth.assertThat((Double)StatsTesting.INTEGER_MANY_VALUES_STATS_VARARGS.min()).isWithin(1.0E-10).of(-4444.0);
        Truth.assertThat((Double)StatsTesting.INTEGER_MANY_VALUES_STATS_ITERABLE.min()).isWithin(1.0E-10).of(-4444.0);
        Truth.assertThat((Double)StatsTesting.LONG_MANY_VALUES_STATS_ITERATOR.min()).isWithin(1.0E-10).of(-4.4444444E7);
        Truth.assertThat((Double)StatsTesting.LONG_MANY_VALUES_STATS_SNAPSHOT.min()).isWithin(1.0E-10).of(-4.4444444E7);
    }

    public void testEqualsAndHashCode() {
        new EqualsTester().addEqualityGroup(new Object[]{Stats.of((double[])new double[]{1.0, 1.0, 5.0, 5.0}), Stats.of((double[])new double[]{1.0, 1.0, 5.0, 5.0}), Stats.of((Iterable)ImmutableList.of((Object)1.0, (Object)1.0, (Object)5.0, (Object)5.0)), Stats.of((Iterator)ImmutableList.of((Object)1.0, (Object)1.0, (Object)5.0, (Object)5.0).iterator()), SerializableTester.reserialize((Object)Stats.of((double[])new double[]{1.0, 1.0, 5.0, 5.0}))}).addEqualityGroup(new Object[]{Stats.of((double[])new double[]{1.0, 5.0})}).addEqualityGroup(new Object[]{Stats.of((double[])new double[]{1.0, 5.0, 1.0, 6.0})}).addEqualityGroup(new Object[]{Stats.of((double[])new double[]{2.0, 6.0, 2.0, 6.0})}).addEqualityGroup(new Object[]{new Stats(5L, -5.5, 55.5, -5.55, 5.55), new Stats(5L, -5.5, 55.5, -5.55, 5.55)}).addEqualityGroup(new Object[]{new Stats(6L, -5.5, 55.5, -5.55, 5.55)}).addEqualityGroup(new Object[]{new Stats(5L, -5.6, 55.5, -5.55, 5.55)}).addEqualityGroup(new Object[]{new Stats(5L, -5.5, 55.6, -5.55, 5.55)}).addEqualityGroup(new Object[]{new Stats(5L, -5.5, 55.5, -5.56, 5.55)}).addEqualityGroup(new Object[]{new Stats(5L, -5.5, 55.5, -5.55, 5.56)}).testEquals();
    }

    public void testSerializable() {
        SerializableTester.reserializeAndAssert((Object)StatsTesting.MANY_VALUES_STATS_ITERABLE);
    }

    public void testToString() {
        Truth.assertThat((String)StatsTesting.EMPTY_STATS_VARARGS.toString()).isEqualTo((Object)"Stats{count=0}");
        Truth.assertThat((String)StatsTesting.MANY_VALUES_STATS_ITERABLE.toString()).isEqualTo((Object)("Stats{count=" + StatsTesting.MANY_VALUES_STATS_ITERABLE.count() + ", mean=" + StatsTesting.MANY_VALUES_STATS_ITERABLE.mean() + ", populationStandardDeviation=" + StatsTesting.MANY_VALUES_STATS_ITERABLE.populationStandardDeviation() + ", min=" + StatsTesting.MANY_VALUES_STATS_ITERABLE.min() + ", max=" + StatsTesting.MANY_VALUES_STATS_ITERABLE.max() + "}"));
    }

    public void testMeanOf() {
        try {
            Stats.meanOf((int[])new int[0]);
            StatsTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            Stats.meanOf((Iterable)ImmutableList.of());
            StatsTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Truth.assertThat((Double)Stats.meanOf((double[])new double[]{12.34})).isWithin(1.0E-10).of(12.34);
        Truth.assertThat((Double)Stats.meanOf((double[])new double[]{Double.POSITIVE_INFINITY})).isPositiveInfinity();
        Truth.assertThat((Double)Stats.meanOf((double[])new double[]{Double.NEGATIVE_INFINITY})).isNegativeInfinity();
        Truth.assertThat((Double)Stats.meanOf((double[])new double[]{Double.NaN})).isNaN();
        Truth.assertThat((Double)Stats.meanOf(StatsTesting.TWO_VALUES)).isWithin(1.0E-10).of(-22.22);
        for (StatsTesting.ManyValues values : StatsTesting.ALL_MANY_VALUES) {
            double mean = Stats.meanOf((double[])values.asArray());
            if (values.hasAnyNaN()) {
                ((DoubleSubject)Truth.assertThat((Double)mean).named("mean of " + values)).isNaN();
                continue;
            }
            if (values.hasAnyPositiveInfinity() && values.hasAnyNegativeInfinity()) {
                ((DoubleSubject)Truth.assertThat((Double)mean).named("mean of " + values)).isNaN();
                continue;
            }
            if (values.hasAnyPositiveInfinity()) {
                ((DoubleSubject)Truth.assertThat((Double)mean).named("mean of " + values)).isPositiveInfinity();
                continue;
            }
            if (values.hasAnyNegativeInfinity()) {
                ((DoubleSubject)Truth.assertThat((Double)mean).named("mean of " + values)).isNegativeInfinity();
                continue;
            }
            ((DoubleSubject)Truth.assertThat((Double)mean).named("mean of " + values)).isWithin(1.0E-10).of(108.66899999999998);
        }
        Truth.assertThat((Double)Stats.meanOf(StatsTesting.MANY_VALUES)).isWithin(1.0E-10).of(108.66899999999998);
        Truth.assertThat((Double)Stats.meanOf((Iterator)StatsTesting.MANY_VALUES.iterator())).isWithin(1.0E-10).of(108.66899999999998);
        Truth.assertThat((Double)Stats.meanOf(StatsTesting.INTEGER_MANY_VALUES)).isWithin(1.0E-10).of(110886.6);
        Truth.assertThat((Double)Stats.meanOf((int[])Ints.toArray(StatsTesting.INTEGER_MANY_VALUES))).isWithin(1.0E-10).of(110886.6);
        Truth.assertThat((Double)Stats.meanOf(StatsTesting.LONG_MANY_VALUES)).isWithin(1.0E-10).of(1.1088886666E9);
        Truth.assertThat((Double)Stats.meanOf((long[])Longs.toArray(StatsTesting.LONG_MANY_VALUES))).isWithin(1.0E-10).of(1.1088886666E9);
    }

    public void testToByteArrayAndFromByteArrayRoundTrip() {
        for (Stats stats : StatsTesting.ALL_STATS) {
            byte[] statsByteArray = stats.toByteArray();
            Truth.assertThat((Object)Stats.fromByteArray((byte[])statsByteArray)).isEqualTo((Object)stats);
        }
    }

    public void testFromByteArray_withNullInputThrowsNullPointerException() {
        try {
            Stats.fromByteArray(null);
            StatsTest.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testFromByteArray_withEmptyArrayInputThrowsIllegalArgumentException() {
        try {
            Stats.fromByteArray((byte[])new byte[0]);
            StatsTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testFromByteArray_withTooLongArrayInputThrowsIllegalArgumentException() {
        byte[] buffer = StatsTesting.MANY_VALUES_STATS_VARARGS.toByteArray();
        byte[] tooLongByteArray = ByteBuffer.allocate(buffer.length + 2).order(ByteOrder.LITTLE_ENDIAN).put(buffer).putChar('.').array();
        try {
            Stats.fromByteArray((byte[])tooLongByteArray);
            StatsTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testFromByteArrayWithTooShortArrayInputThrowsIllegalArgumentException() {
        byte[] buffer = StatsTesting.MANY_VALUES_STATS_VARARGS.toByteArray();
        byte[] tooShortByteArray = ByteBuffer.allocate(buffer.length - 1).order(ByteOrder.LITTLE_ENDIAN).put(buffer, 0, 39).array();
        try {
            Stats.fromByteArray((byte[])tooShortByteArray);
            StatsTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

