/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.math.LinearTransformation;
import com.google.common.math.PairedStats;
import com.google.common.math.PairedStatsAccumulator;
import com.google.common.math.Stats;
import com.google.common.math.StatsAccumulator;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Ints;
import com.google.common.truth.Truth;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.junit.Assert;

class StatsTesting {
    static final double ALLOWED_ERROR = 1.0E-10;
    static final double ONE_VALUE = 12.34;
    static final double OTHER_ONE_VALUE = -56.78;
    static final ImmutableList<Double> TWO_VALUES = ImmutableList.of((Object)12.34, (Object)-56.78);
    static final double TWO_VALUES_MEAN = -22.22;
    static final double TWO_VALUES_SUM_OF_SQUARES_OF_DELTAS = 2388.7872;
    static final double TWO_VALUES_MAX = 12.34;
    static final double TWO_VALUES_MIN = -56.78;
    static final ImmutableList<Double> OTHER_TWO_VALUES = ImmutableList.of((Object)123.456, (Object)-789.012);
    static final double OTHER_TWO_VALUES_MEAN = -332.77799999999996;
    static final double TWO_VALUES_SUM_OF_PRODUCTS_OF_DELTAS = 31534.894080000002;
    static final Iterable<ManyValues> ALL_MANY_VALUES = ManyValues.access$000();
    static final ImmutableList<Double> MANY_VALUES = ImmutableList.of((Object)1.1, (Object)-44.44, (Object)33.33, (Object)555.555, (Object)-2.2);
    static final int MANY_VALUES_COUNT = 5;
    static final double MANY_VALUES_MEAN = 108.66899999999998;
    static final double MANY_VALUES_SUM_OF_SQUARES_OF_DELTAS = 252688.45271999997;
    static final double MANY_VALUES_MAX = 555.555;
    static final double MANY_VALUES_MIN = -44.44;
    static final double[] LARGE_VALUES = new double[]{Double.MAX_VALUE, 8.988465674311579E307};
    static final double LARGE_VALUES_MEAN = 1.3482698511467367E308;
    static final ImmutableList<Double> OTHER_MANY_VALUES = ImmutableList.of((Object)1.11, (Object)-2.22, (Object)33.3333, (Object)-44.4444, (Object)555.555555);
    static final int OTHER_MANY_VALUES_COUNT = 5;
    static final double OTHER_MANY_VALUES_MEAN = 108.666891;
    static final double MANY_VALUES_SUM_OF_PRODUCTS_OF_DELTAS = -83746.266064395;
    static final ImmutableList<Integer> INTEGER_MANY_VALUES = ImmutableList.of((Object)11, (Object)-22, (Object)3333, (Object)-4444, (Object)555555);
    static final int INTEGER_MANY_VALUES_COUNT = 5;
    static final double INTEGER_MANY_VALUES_MEAN = 110886.6;
    static final double INTEGER_MANY_VALUES_SUM_OF_SQUARES_OF_DELTAS = 2.471930263572E11;
    static final double INTEGER_MANY_VALUES_MAX = 555555.0;
    static final double INTEGER_MANY_VALUES_MIN = -4444.0;
    static final int[] LARGE_INTEGER_VALUES = new int[]{Integer.MAX_VALUE, 0x3FFFFFFF};
    static final double LARGE_INTEGER_VALUES_MEAN = BigInteger.valueOf(Integer.MAX_VALUE).multiply(BigInteger.valueOf(3L)).divide(BigInteger.valueOf(4L)).doubleValue();
    static final double LARGE_INTEGER_VALUES_POPULATION_VARIANCE = BigInteger.valueOf(Integer.MAX_VALUE).multiply(BigInteger.valueOf(Integer.MAX_VALUE)).divide(BigInteger.valueOf(16L)).doubleValue();
    static final ImmutableList<Long> LONG_MANY_VALUES = ImmutableList.of((Object)1111L, (Object)-2222L, (Object)33333333L, (Object)-44444444L, (Object)5555555555L);
    static final int LONG_MANY_VALUES_COUNT = 5;
    static final double LONG_MANY_VALUES_MEAN = 1.1088886666E9;
    static final double LONG_MANY_VALUES_SUM_OF_SQUARES_OF_DELTAS = 2.4719113569819255E19;
    static final double LONG_MANY_VALUES_MAX = 5.555555555E9;
    static final double LONG_MANY_VALUES_MIN = -4.4444444E7;
    static final long[] LARGE_LONG_VALUES = new long[]{Long.MAX_VALUE, 0x3FFFFFFFFFFFFFFFL};
    static final double LARGE_LONG_VALUES_MEAN = BigInteger.valueOf(Long.MAX_VALUE).multiply(BigInteger.valueOf(3L)).divide(BigInteger.valueOf(4L)).doubleValue();
    static final double LARGE_LONG_VALUES_POPULATION_VARIANCE = BigInteger.valueOf(Long.MAX_VALUE).multiply(BigInteger.valueOf(Long.MAX_VALUE)).divide(BigInteger.valueOf(16L)).doubleValue();
    static final Stats EMPTY_STATS_VARARGS = Stats.of((int[])new int[0]);
    static final Stats EMPTY_STATS_ITERABLE = Stats.of((Iterable)ImmutableList.of());
    static final Stats ONE_VALUE_STATS = Stats.of((double[])new double[]{12.34});
    static final Stats OTHER_ONE_VALUE_STATS = Stats.of((double[])new double[]{-56.78});
    static final Stats TWO_VALUES_STATS = Stats.of(TWO_VALUES);
    static final Stats OTHER_TWO_VALUES_STATS = Stats.of(OTHER_TWO_VALUES);
    static final Stats MANY_VALUES_STATS_VARARGS = Stats.of((double[])new double[]{1.1, -44.44, 33.33, 555.555, -2.2});
    static final Stats MANY_VALUES_STATS_ITERABLE = Stats.of(MANY_VALUES);
    static final Stats MANY_VALUES_STATS_ITERATOR = Stats.of((Iterator)MANY_VALUES.iterator());
    static final Stats MANY_VALUES_STATS_SNAPSHOT;
    static final Stats LARGE_VALUES_STATS;
    static final Stats OTHER_MANY_VALUES_STATS;
    static final Stats INTEGER_MANY_VALUES_STATS_VARARGS;
    static final Stats INTEGER_MANY_VALUES_STATS_ITERABLE;
    static final Stats LARGE_INTEGER_VALUES_STATS;
    static final Stats LONG_MANY_VALUES_STATS_ITERATOR;
    static final Stats LONG_MANY_VALUES_STATS_SNAPSHOT;
    static final Stats LARGE_LONG_VALUES_STATS;
    static final List<Stats> ALL_STATS;
    static final PairedStats EMPTY_PAIRED_STATS;
    static final PairedStats ONE_VALUE_PAIRED_STATS;
    static final PairedStats TWO_VALUES_PAIRED_STATS;
    static final PairedStats MANY_VALUES_PAIRED_STATS;
    static final PairedStats DUPLICATE_MANY_VALUES_PAIRED_STATS;
    static final PairedStats HORIZONTAL_VALUES_PAIRED_STATS;
    static final PairedStats VERTICAL_VALUES_PAIRED_STATS;
    static final PairedStats CONSTANT_VALUES_PAIRED_STATS;
    static final List<PairedStats> ALL_PAIRED_STATS;

    static void assertStatsApproxEqual(Stats expectedStats, Stats actualStats) {
        Truth.assertThat((Long)actualStats.count()).isEqualTo((Object)expectedStats.count());
        if (expectedStats.count() == 0L) {
            try {
                actualStats.mean();
                Assert.fail((String)"Expected IllegalStateException");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            try {
                actualStats.populationVariance();
                Assert.fail((String)"Expected IllegalStateException");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            try {
                actualStats.min();
                Assert.fail((String)"Expected IllegalStateException");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            try {
                actualStats.max();
                Assert.fail((String)"Expected IllegalStateException");
            }
            catch (IllegalStateException illegalStateException) {}
        } else if (expectedStats.count() == 1L) {
            Truth.assertThat((Double)actualStats.mean()).isWithin(1.0E-10).of(expectedStats.mean());
            Truth.assertThat((Double)actualStats.populationVariance()).isWithin(0.0).of(0.0);
            Truth.assertThat((Double)actualStats.min()).isWithin(1.0E-10).of(expectedStats.min());
            Truth.assertThat((Double)actualStats.max()).isWithin(1.0E-10).of(expectedStats.max());
        } else {
            Truth.assertThat((Double)actualStats.mean()).isWithin(1.0E-10).of(expectedStats.mean());
            Truth.assertThat((Double)actualStats.populationVariance()).isWithin(1.0E-10).of(expectedStats.populationVariance());
            Truth.assertThat((Double)actualStats.min()).isWithin(1.0E-10).of(expectedStats.min());
            Truth.assertThat((Double)actualStats.max()).isWithin(1.0E-10).of(expectedStats.max());
        }
    }

    static void assertDiagonalLinearTransformation(LinearTransformation transformation, double x1, double y1, double xDelta, double yDelta) {
        Preconditions.checkArgument((xDelta != 0.0 ? 1 : 0) != 0);
        Preconditions.checkArgument((yDelta != 0.0 ? 1 : 0) != 0);
        Truth.assertThat((Boolean)transformation.isHorizontal()).isFalse();
        Truth.assertThat((Boolean)transformation.isVertical()).isFalse();
        Truth.assertThat((Boolean)transformation.inverse().isHorizontal()).isFalse();
        Truth.assertThat((Boolean)transformation.inverse().isVertical()).isFalse();
        Truth.assertThat((Double)transformation.transform(x1)).isWithin(1.0E-10).of(y1);
        Truth.assertThat((Double)transformation.transform(x1 + xDelta)).isWithin(1.0E-10).of(y1 + yDelta);
        Truth.assertThat((Double)transformation.inverse().transform(y1)).isWithin(1.0E-10).of(x1);
        Truth.assertThat((Double)transformation.inverse().transform(y1 + yDelta)).isWithin(1.0E-10).of(x1 + xDelta);
        Truth.assertThat((Double)transformation.slope()).isWithin(1.0E-10).of(yDelta / xDelta);
        Truth.assertThat((Double)transformation.inverse().slope()).isWithin(1.0E-10).of(xDelta / yDelta);
        Truth.assertThat((Object)transformation.inverse()).isSameAs((Object)transformation.inverse());
        Truth.assertThat((Object)transformation.inverse().inverse()).isSameAs((Object)transformation);
    }

    static void assertHorizontalLinearTransformation(LinearTransformation transformation, double y) {
        Truth.assertThat((Boolean)transformation.isHorizontal()).isTrue();
        Truth.assertThat((Boolean)transformation.isVertical()).isFalse();
        Truth.assertThat((Boolean)transformation.inverse().isHorizontal()).isFalse();
        Truth.assertThat((Boolean)transformation.inverse().isVertical()).isTrue();
        Truth.assertThat((Double)transformation.transform(-1.0)).isWithin(1.0E-10).of(y);
        Truth.assertThat((Double)transformation.transform(1.0)).isWithin(1.0E-10).of(y);
        try {
            transformation.inverse().transform(0.0);
            Assert.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Truth.assertThat((Double)transformation.slope()).isWithin(1.0E-10).of(0.0);
        try {
            transformation.inverse().slope();
            Assert.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Truth.assertThat((Object)transformation.inverse()).isSameAs((Object)transformation.inverse());
        Truth.assertThat((Object)transformation.inverse().inverse()).isSameAs((Object)transformation);
    }

    static void assertVerticalLinearTransformation(LinearTransformation transformation, double x) {
        Truth.assertThat((Boolean)transformation.isHorizontal()).isFalse();
        Truth.assertThat((Boolean)transformation.isVertical()).isTrue();
        Truth.assertThat((Boolean)transformation.inverse().isHorizontal()).isTrue();
        Truth.assertThat((Boolean)transformation.inverse().isVertical()).isFalse();
        try {
            transformation.transform(0.0);
            Assert.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Truth.assertThat((Double)transformation.inverse().transform(-1.0)).isWithin(1.0E-10).of(x);
        Truth.assertThat((Double)transformation.inverse().transform(1.0)).isWithin(1.0E-10).of(x);
        try {
            transformation.slope();
            Assert.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Truth.assertThat((Double)transformation.inverse().slope()).isWithin(1.0E-10).of(0.0);
        Truth.assertThat((Object)transformation.inverse()).isSameAs((Object)transformation.inverse());
        Truth.assertThat((Object)transformation.inverse().inverse()).isSameAs((Object)transformation);
    }

    static void assertLinearTransformationNaN(LinearTransformation transformation) {
        Truth.assertThat((Boolean)transformation.isHorizontal()).isFalse();
        Truth.assertThat((Boolean)transformation.isVertical()).isFalse();
        Truth.assertThat((Double)transformation.slope()).isNaN();
        Truth.assertThat((Double)transformation.transform(0.0)).isNaN();
        Truth.assertThat((Object)transformation.inverse()).isSameAs((Object)transformation);
    }

    static PairedStats createPairedStatsOf(List<Double> xValues, List<Double> yValues) {
        return StatsTesting.createFilledPairedStatsAccumulator(xValues, yValues).snapshot();
    }

    static PairedStatsAccumulator createFilledPairedStatsAccumulator(List<Double> xValues, List<Double> yValues) {
        Preconditions.checkArgument((xValues.size() == yValues.size() ? 1 : 0) != 0);
        PairedStatsAccumulator accumulator = new PairedStatsAccumulator();
        for (int index = 0; index < xValues.size(); ++index) {
            accumulator.add(xValues.get(index).doubleValue(), yValues.get(index).doubleValue());
        }
        return accumulator;
    }

    static PairedStatsAccumulator createPartitionedFilledPairedStatsAccumulator(List<Double> xValues, List<Double> yValues, int partitionSize) {
        Preconditions.checkArgument((xValues.size() == yValues.size() ? 1 : 0) != 0);
        Preconditions.checkArgument((partitionSize > 0 ? 1 : 0) != 0);
        PairedStatsAccumulator accumulator = new PairedStatsAccumulator();
        List xPartitions = Lists.partition(xValues, (int)partitionSize);
        List yPartitions = Lists.partition(yValues, (int)partitionSize);
        for (int index = 0; index < xPartitions.size(); ++index) {
            accumulator.addAll(StatsTesting.createPairedStatsOf((List)xPartitions.get(index), (List)yPartitions.get(index)));
        }
        return accumulator;
    }

    private StatsTesting() {
    }

    static {
        LARGE_VALUES_STATS = Stats.of((double[])LARGE_VALUES);
        OTHER_MANY_VALUES_STATS = Stats.of(OTHER_MANY_VALUES);
        INTEGER_MANY_VALUES_STATS_VARARGS = Stats.of((int[])Ints.toArray(INTEGER_MANY_VALUES));
        INTEGER_MANY_VALUES_STATS_ITERABLE = Stats.of(INTEGER_MANY_VALUES);
        LARGE_INTEGER_VALUES_STATS = Stats.of((int[])LARGE_INTEGER_VALUES);
        LONG_MANY_VALUES_STATS_ITERATOR = Stats.of((Iterator)LONG_MANY_VALUES.iterator());
        LARGE_LONG_VALUES_STATS = Stats.of((long[])LARGE_LONG_VALUES);
        StatsAccumulator accumulator = new StatsAccumulator();
        accumulator.addAll(MANY_VALUES);
        MANY_VALUES_STATS_SNAPSHOT = accumulator.snapshot();
        accumulator.add(999.999);
        accumulator = new StatsAccumulator();
        accumulator.addAll(LONG_MANY_VALUES);
        LONG_MANY_VALUES_STATS_SNAPSHOT = accumulator.snapshot();
        ALL_STATS = ImmutableList.of((Object)EMPTY_STATS_VARARGS, (Object)EMPTY_STATS_ITERABLE, (Object)ONE_VALUE_STATS, (Object)OTHER_ONE_VALUE_STATS, (Object)TWO_VALUES_STATS, (Object)OTHER_TWO_VALUES_STATS, (Object)MANY_VALUES_STATS_VARARGS, (Object)MANY_VALUES_STATS_ITERABLE, (Object)MANY_VALUES_STATS_ITERATOR, (Object)MANY_VALUES_STATS_SNAPSHOT, (Object)LARGE_VALUES_STATS, (Object)OTHER_MANY_VALUES_STATS, (Object[])new Stats[]{INTEGER_MANY_VALUES_STATS_VARARGS, INTEGER_MANY_VALUES_STATS_ITERABLE, LARGE_INTEGER_VALUES_STATS, LONG_MANY_VALUES_STATS_ITERATOR, LONG_MANY_VALUES_STATS_SNAPSHOT, LARGE_LONG_VALUES_STATS});
        EMPTY_PAIRED_STATS = StatsTesting.createPairedStatsOf((List<Double>)ImmutableList.of(), (List<Double>)ImmutableList.of());
        ONE_VALUE_PAIRED_STATS = StatsTesting.createPairedStatsOf((List<Double>)ImmutableList.of((Object)12.34), (List<Double>)ImmutableList.of((Object)-56.78));
        TWO_VALUES_PAIRED_STATS = StatsTesting.createPairedStatsOf(TWO_VALUES, OTHER_TWO_VALUES);
        DUPLICATE_MANY_VALUES_PAIRED_STATS = StatsTesting.createPairedStatsOf(MANY_VALUES, OTHER_MANY_VALUES);
        accumulator = StatsTesting.createFilledPairedStatsAccumulator(MANY_VALUES, OTHER_MANY_VALUES);
        MANY_VALUES_PAIRED_STATS = accumulator.snapshot();
        accumulator.add(99.99, 9999.9999);
        accumulator = new PairedStatsAccumulator();
        Iterator i$ = MANY_VALUES.iterator();
        while (i$.hasNext()) {
            double x = (Double)i$.next();
            accumulator.add(x, -56.78);
        }
        HORIZONTAL_VALUES_PAIRED_STATS = accumulator.snapshot();
        accumulator = new PairedStatsAccumulator();
        i$ = OTHER_MANY_VALUES.iterator();
        while (i$.hasNext()) {
            double y = (Double)i$.next();
            accumulator.add(12.34, y);
        }
        VERTICAL_VALUES_PAIRED_STATS = accumulator.snapshot();
        accumulator = new PairedStatsAccumulator();
        for (int i = 0; i < 5; ++i) {
            accumulator.add(12.34, -56.78);
        }
        CONSTANT_VALUES_PAIRED_STATS = accumulator.snapshot();
        ALL_PAIRED_STATS = ImmutableList.of((Object)EMPTY_PAIRED_STATS, (Object)ONE_VALUE_PAIRED_STATS, (Object)TWO_VALUES_PAIRED_STATS, (Object)MANY_VALUES_PAIRED_STATS, (Object)DUPLICATE_MANY_VALUES_PAIRED_STATS, (Object)HORIZONTAL_VALUES_PAIRED_STATS, (Object)VERTICAL_VALUES_PAIRED_STATS, (Object)CONSTANT_VALUES_PAIRED_STATS);
    }

    static class ManyValues {
        private final ImmutableList<Double> values;

        ManyValues(double[] values) {
            this.values = ImmutableList.copyOf((Collection)Doubles.asList((double[])values));
        }

        ImmutableList<Double> asIterable() {
            return this.values;
        }

        double[] asArray() {
            return Doubles.toArray(this.values);
        }

        boolean hasAnyPositiveInfinity() {
            return Iterables.any(this.values, (Predicate)Predicates.equalTo((Object)Double.POSITIVE_INFINITY));
        }

        boolean hasAnyNegativeInfinity() {
            return Iterables.any(this.values, (Predicate)Predicates.equalTo((Object)Double.NEGATIVE_INFINITY));
        }

        boolean hasAnyNaN() {
            return Iterables.any(this.values, (Predicate)Predicates.equalTo((Object)Double.NaN));
        }

        boolean hasAnyNonFinite() {
            return this.hasAnyPositiveInfinity() || this.hasAnyNegativeInfinity() || this.hasAnyNaN();
        }

        public String toString() {
            return this.values.toString();
        }

        private static ImmutableList<ManyValues> createAll() {
            ImmutableList.Builder builder = ImmutableList.builder();
            double[] values = new double[5];
            Iterator i$ = ImmutableList.of((Object)1.1, (Object)Double.POSITIVE_INFINITY, (Object)Double.NEGATIVE_INFINITY, (Object)Double.NaN).iterator();
            while (i$.hasNext()) {
                double first;
                values[0] = first = ((Double)i$.next()).doubleValue();
                values[1] = -44.44;
                Iterator i$2 = ImmutableList.of((Object)33.33, (Object)Double.POSITIVE_INFINITY, (Object)Double.NEGATIVE_INFINITY, (Object)Double.NaN).iterator();
                while (i$2.hasNext()) {
                    double third;
                    values[2] = third = ((Double)i$2.next()).doubleValue();
                    values[3] = 555.555;
                    Iterator i$3 = ImmutableList.of((Object)-2.2, (Object)Double.POSITIVE_INFINITY, (Object)Double.NEGATIVE_INFINITY, (Object)Double.NaN).iterator();
                    while (i$3.hasNext()) {
                        double fifth;
                        values[4] = fifth = ((Double)i$3.next()).doubleValue();
                        builder.add((Object)new ManyValues(values));
                    }
                }
            }
            return builder.build();
        }

        static /* synthetic */ ImmutableList access$000() {
            return ManyValues.createAll();
        }
    }
}

