/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.net;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.escape.UnicodeEscaper;
import com.google.common.escape.testing.EscaperAsserts;
import com.google.common.net.PercentEscaper;
import com.google.common.truth.Truth;
import junit.framework.TestCase;

@GwtCompatible
public class PercentEscaperTest
extends TestCase {
    public void testSimpleEscaper() {
        PercentEscaper e = new PercentEscaper("", false);
        for (char c = '\u0000'; c < '\u0080'; c = (char)(c + 1)) {
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                EscaperAsserts.assertUnescaped((UnicodeEscaper)e, (int)c);
                continue;
            }
            EscaperAsserts.assertEscaping((UnicodeEscaper)e, (String)this.escapeAscii(c), (int)c);
        }
        EscaperAsserts.assertEscaping((UnicodeEscaper)e, (String)"%00", (int)0);
        EscaperAsserts.assertEscaping((UnicodeEscaper)e, (String)"%7F", (int)127);
        EscaperAsserts.assertEscaping((UnicodeEscaper)e, (String)"%C2%80", (int)128);
        EscaperAsserts.assertEscaping((UnicodeEscaper)e, (String)"%DF%BF", (int)2047);
        EscaperAsserts.assertEscaping((UnicodeEscaper)e, (String)"%E0%A0%80", (int)2048);
        EscaperAsserts.assertEscaping((UnicodeEscaper)e, (String)"%EF%BF%BF", (int)65535);
        EscaperAsserts.assertUnicodeEscaping((UnicodeEscaper)e, (String)"%F0%90%80%80", (char)'\ud800', (char)'\udc00');
        EscaperAsserts.assertUnicodeEscaping((UnicodeEscaper)e, (String)"%F4%8F%BF%BF", (char)'\udbff', (char)'\udfff');
        PercentEscaperTest.assertEquals((String)"", (String)e.escape(""));
        PercentEscaperTest.assertEquals((String)"safestring", (String)e.escape("safestring"));
        PercentEscaperTest.assertEquals((String)"embedded%00null", (String)e.escape("embedded\u0000null"));
        PercentEscaperTest.assertEquals((String)"max%EF%BF%BFchar", (String)e.escape("max\uffffchar"));
    }

    public void testPlusForSpace() {
        PercentEscaper basicEscaper = new PercentEscaper("", false);
        PercentEscaper plusForSpaceEscaper = new PercentEscaper("", true);
        PercentEscaper spaceEscaper = new PercentEscaper(" ", false);
        PercentEscaperTest.assertEquals((String)"string%20with%20spaces", (String)basicEscaper.escape("string with spaces"));
        PercentEscaperTest.assertEquals((String)"string+with+spaces", (String)plusForSpaceEscaper.escape("string with spaces"));
        PercentEscaperTest.assertEquals((String)"string with spaces", (String)spaceEscaper.escape("string with spaces"));
    }

    public void testCustomEscaper() {
        PercentEscaper e = new PercentEscaper("+*/-", false);
        for (char c = '\u0000'; c < '\u0080'; c = (char)((char)(c + 1))) {
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || "+*/-".indexOf(c) >= 0) {
                EscaperAsserts.assertUnescaped((UnicodeEscaper)e, (int)c);
                continue;
            }
            EscaperAsserts.assertEscaping((UnicodeEscaper)e, (String)this.escapeAscii(c), (int)c);
        }
    }

    public void testCustomEscaper_withpercent() {
        PercentEscaper e = new PercentEscaper("%", false);
        PercentEscaperTest.assertEquals((String)"foo%7Cbar", (String)e.escape("foo|bar"));
        PercentEscaperTest.assertEquals((String)"foo%7Cbar", (String)e.escape("foo%7Cbar"));
    }

    public void testBadArguments_null() {
        try {
            new PercentEscaper(null, false);
            PercentEscaperTest.fail((String)"Expected null pointer exception for null parameter");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testBadArguments_badchars() {
        String msg = "Alphanumeric characters are always 'safe' and should not be explicitly specified";
        try {
            new PercentEscaper("-+#abc.!", false);
            PercentEscaperTest.fail((String)msg);
        }
        catch (IllegalArgumentException expected) {
            Truth.assertThat((Throwable)expected).hasMessage(msg);
        }
    }

    public void testBadArguments_plusforspace() {
        try {
            new PercentEscaper(" ", false);
        }
        catch (IllegalArgumentException e) {
            PercentEscaperTest.fail((String)"Space can be a 'safe' character if plusForSpace is false");
        }
        String msg = "plusForSpace cannot be specified when space is a 'safe' character";
        try {
            new PercentEscaper(" ", true);
            PercentEscaperTest.fail((String)msg);
        }
        catch (IllegalArgumentException expected) {
            Truth.assertThat((Throwable)expected).hasMessage(msg);
        }
    }

    private String escapeAscii(char c) {
        Preconditions.checkArgument((c < '\u0080' ? 1 : 0) != 0);
        String hex = "0123456789ABCDEF";
        return "%" + hex.charAt(c >> 4 & 0xF) + hex.charAt(c & 0xF);
    }
}

