/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.collect.testing.Helpers;
import com.google.common.primitives.Ints;
import com.google.common.primitives.UnsignedBytes;
import com.google.common.testing.NullPointerTester;
import com.google.common.testing.SerializableTester;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import junit.framework.TestCase;

public class UnsignedBytesTest
extends TestCase {
    private static final byte LEAST = 0;
    private static final byte GREATEST = -1;
    private static final byte[] VALUES = new byte[]{0, 127, -128, -127, -1};

    public void testToInt() {
        UnsignedBytesTest.assertEquals((int)0, (int)UnsignedBytes.toInt((byte)0));
        UnsignedBytesTest.assertEquals((int)1, (int)UnsignedBytes.toInt((byte)1));
        UnsignedBytesTest.assertEquals((int)127, (int)UnsignedBytes.toInt((byte)127));
        UnsignedBytesTest.assertEquals((int)128, (int)UnsignedBytes.toInt((byte)-128));
        UnsignedBytesTest.assertEquals((int)129, (int)UnsignedBytes.toInt((byte)-127));
        UnsignedBytesTest.assertEquals((int)255, (int)UnsignedBytes.toInt((byte)-1));
    }

    public void testCheckedCast() {
        for (byte value : VALUES) {
            UnsignedBytesTest.assertEquals((byte)value, (byte)UnsignedBytes.checkedCast((long)UnsignedBytes.toInt((byte)value)));
        }
        UnsignedBytesTest.assertCastFails(256L);
        UnsignedBytesTest.assertCastFails(-1L);
        UnsignedBytesTest.assertCastFails(Long.MAX_VALUE);
        UnsignedBytesTest.assertCastFails(Long.MIN_VALUE);
    }

    public void testSaturatedCast() {
        for (byte value : VALUES) {
            UnsignedBytesTest.assertEquals((byte)value, (byte)UnsignedBytes.saturatedCast((long)UnsignedBytes.toInt((byte)value)));
        }
        UnsignedBytesTest.assertEquals((byte)-1, (byte)UnsignedBytes.saturatedCast((long)256L));
        UnsignedBytesTest.assertEquals((byte)0, (byte)UnsignedBytes.saturatedCast((long)-1L));
        UnsignedBytesTest.assertEquals((byte)-1, (byte)UnsignedBytes.saturatedCast((long)Long.MAX_VALUE));
        UnsignedBytesTest.assertEquals((byte)0, (byte)UnsignedBytes.saturatedCast((long)Long.MIN_VALUE));
    }

    private static void assertCastFails(long value) {
        try {
            UnsignedBytes.checkedCast((long)value);
            UnsignedBytesTest.fail((String)("Cast to byte should have failed: " + value));
        }
        catch (IllegalArgumentException ex) {
            UnsignedBytesTest.assertTrue((String)(value + " not found in exception text: " + ex.getMessage()), (boolean)ex.getMessage().contains(String.valueOf(value)));
        }
    }

    public void testCompare() {
        for (int i = 0; i < VALUES.length; ++i) {
            for (int j = 0; j < VALUES.length; ++j) {
                byte x = VALUES[i];
                byte y = VALUES[j];
                UnsignedBytesTest.assertEquals((String)(x + ", " + y), (Object)Float.valueOf(Math.signum(UnsignedBytes.compare((byte)x, (byte)y))), (Object)Float.valueOf(Math.signum(Ints.compare((int)i, (int)j))));
            }
        }
    }

    public void testMax_noArgs() {
        try {
            UnsignedBytes.max((byte[])new byte[0]);
            UnsignedBytesTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testMax() {
        UnsignedBytesTest.assertEquals((byte)0, (byte)UnsignedBytes.max((byte[])new byte[]{0}));
        UnsignedBytesTest.assertEquals((byte)-1, (byte)UnsignedBytes.max((byte[])new byte[]{-1}));
        UnsignedBytesTest.assertEquals((byte)-1, (byte)UnsignedBytes.max((byte[])new byte[]{0, -128, -1, 127, 1}));
    }

    public void testMin_noArgs() {
        try {
            UnsignedBytes.min((byte[])new byte[0]);
            UnsignedBytesTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testMin() {
        UnsignedBytesTest.assertEquals((byte)0, (byte)UnsignedBytes.min((byte[])new byte[]{0}));
        UnsignedBytesTest.assertEquals((byte)-1, (byte)UnsignedBytes.min((byte[])new byte[]{-1}));
        UnsignedBytesTest.assertEquals((byte)0, (byte)UnsignedBytes.min((byte[])new byte[]{0, -128, -1, 127, 1}));
        UnsignedBytesTest.assertEquals((byte)0, (byte)UnsignedBytes.min((byte[])new byte[]{-1, 127, 1, -128, 0}));
    }

    private static void assertParseFails(String value) {
        try {
            UnsignedBytes.parseUnsignedByte((String)value);
            UnsignedBytesTest.fail();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void testParseUnsignedByte() {
        for (int i = 0; i <= 255; ++i) {
            UnsignedBytesTest.assertEquals((byte)((byte)i), (byte)UnsignedBytes.parseUnsignedByte((String)Integer.toString(i)));
        }
        UnsignedBytesTest.assertParseFails("1000");
        UnsignedBytesTest.assertParseFails("-1");
        UnsignedBytesTest.assertParseFails("-128");
        UnsignedBytesTest.assertParseFails("256");
    }

    public void testMaxValue() {
        UnsignedBytesTest.assertTrue((UnsignedBytes.compare((byte)-1, (byte)0) > 0 ? 1 : 0) != 0);
    }

    private static void assertParseFails(String value, int radix) {
        try {
            UnsignedBytes.parseUnsignedByte((String)value, (int)radix);
            UnsignedBytesTest.fail();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void testParseUnsignedByteWithRadix() throws NumberFormatException {
        for (int radix = 2; radix <= 36; ++radix) {
            for (int i = 0; i <= 255; ++i) {
                UnsignedBytesTest.assertEquals((byte)((byte)i), (byte)UnsignedBytes.parseUnsignedByte((String)Integer.toString(i, radix), (int)radix));
            }
            UnsignedBytesTest.assertParseFails(Integer.toString(1000, radix), radix);
            UnsignedBytesTest.assertParseFails(Integer.toString(-1, radix), radix);
            UnsignedBytesTest.assertParseFails(Integer.toString(-128, radix), radix);
            UnsignedBytesTest.assertParseFails(Integer.toString(256, radix), radix);
        }
    }

    public void testParseUnsignedByteThrowsExceptionForInvalidRadix() {
        try {
            UnsignedBytes.parseUnsignedByte((String)"0", (int)1);
            UnsignedBytesTest.fail();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            UnsignedBytes.parseUnsignedByte((String)"0", (int)37);
            UnsignedBytesTest.fail();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            UnsignedBytes.parseUnsignedByte((String)"0", (int)-1);
            UnsignedBytesTest.fail();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void testToString() {
        for (int i = 0; i <= 255; ++i) {
            UnsignedBytesTest.assertEquals((String)Integer.toString(i), (String)UnsignedBytes.toString((byte)((byte)i)));
        }
    }

    public void testToStringWithRadix() {
        for (int radix = 2; radix <= 36; ++radix) {
            for (int i = 0; i <= 255; ++i) {
                UnsignedBytesTest.assertEquals((String)Integer.toString(i, radix), (String)UnsignedBytes.toString((byte)((byte)i), (int)radix));
            }
        }
    }

    public void testJoin() {
        UnsignedBytesTest.assertEquals((String)"", (String)UnsignedBytes.join((String)",", (byte[])new byte[0]));
        UnsignedBytesTest.assertEquals((String)"1", (String)UnsignedBytes.join((String)",", (byte[])new byte[]{1}));
        UnsignedBytesTest.assertEquals((String)"1,2", (String)UnsignedBytes.join((String)",", (byte[])new byte[]{1, 2}));
        UnsignedBytesTest.assertEquals((String)"123", (String)UnsignedBytes.join((String)"", (byte[])new byte[]{1, 2, 3}));
        UnsignedBytesTest.assertEquals((String)"128,255", (String)UnsignedBytes.join((String)",", (byte[])new byte[]{-128, -1}));
    }

    public void testLexicographicalComparatorDefaultChoice() {
        Comparator defaultComparator = UnsignedBytes.lexicographicalComparator();
        UnsignedBytes.LexicographicalComparatorHolder.UnsafeComparator unsafeComparator = UnsignedBytes.LexicographicalComparatorHolder.UnsafeComparator.INSTANCE;
        UnsignedBytesTest.assertSame((Object)defaultComparator, (Object)unsafeComparator);
    }

    public void testLexicographicalComparator() {
        List ordered = Arrays.asList(new byte[0], {0}, {0, 0}, {0, 1}, {1}, {1, 0}, {-1, -2}, {-1, -1}, {-1, -1, -1});
        Comparator comparator = UnsignedBytes.lexicographicalComparator();
        Helpers.testComparator((Comparator)comparator, ordered);
        UnsignedBytesTest.assertSame((Object)comparator, (Object)SerializableTester.reserialize((Object)comparator));
        Comparator javaImpl = UnsignedBytes.lexicographicalComparatorJavaImpl();
        Helpers.testComparator((Comparator)javaImpl, ordered);
        UnsignedBytesTest.assertSame((Object)javaImpl, (Object)SerializableTester.reserialize((Object)javaImpl));
    }

    public void testLexicographicalComparatorLongInputs() {
        for (Comparator comparator : Arrays.asList(UnsignedBytes.lexicographicalComparator(), UnsignedBytes.lexicographicalComparatorJavaImpl())) {
            for (int i = 0; i < 32; ++i) {
                byte[] left = new byte[32];
                byte[] right = new byte[32];
                UnsignedBytesTest.assertTrue((comparator.compare(left, right) == 0 ? 1 : 0) != 0);
                left[i] = 1;
                UnsignedBytesTest.assertTrue((comparator.compare(left, right) > 0 ? 1 : 0) != 0);
                UnsignedBytesTest.assertTrue((comparator.compare(right, left) < 0 ? 1 : 0) != 0);
            }
        }
    }

    public void testNulls() {
        new NullPointerTester().testAllPublicStaticMethods(UnsignedBytes.class);
    }
}

