/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.AggregateFutureState;
import com.google.common.util.concurrent.FuturesTest;
import com.google.common.util.concurrent.SettableFuture;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URLClassLoader;
import java.util.Set;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class AggregateFutureStateFallbackAtomicHelperTest
extends TestCase {
    private static final ClassLoader NO_ATOMIC_FIELD_UPDATER = AggregateFutureStateFallbackAtomicHelperTest.getClassLoader((Set<String>)ImmutableSet.of((Object)AtomicIntegerFieldUpdater.class.getName(), (Object)AtomicReferenceFieldUpdater.class.getName()));

    public static TestSuite suite() {
        TestSuite suite = new TestSuite(AggregateFutureStateFallbackAtomicHelperTest.class.getName());
        for (Method method : FuturesTest.class.getDeclaredMethods()) {
            if (!Modifier.isPublic(method.getModifiers()) || !method.getName().startsWith("test")) continue;
            suite.addTest(TestSuite.createTest(AggregateFutureStateFallbackAtomicHelperTest.class, (String)method.getName()));
        }
        return suite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTest() throws Exception {
        this.checkHelperVersion(((Object)((Object)this)).getClass().getClassLoader(), "SafeAtomicHelper");
        this.checkHelperVersion(NO_ATOMIC_FIELD_UPDATER, "SynchronizedAtomicHelper");
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(NO_ATOMIC_FIELD_UPDATER);
        try {
            this.runTestMethod(NO_ATOMIC_FIELD_UPDATER);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    private void runTestMethod(ClassLoader classLoader) throws Exception {
        Class<?> test = classLoader.loadClass(FuturesTest.class.getName());
        Object testInstance = test.newInstance();
        test.getMethod("setUp", new Class[0]).invoke(testInstance, new Object[0]);
        test.getMethod(this.getName(), new Class[0]).invoke(testInstance, new Object[0]);
        test.getMethod("tearDown", new Class[0]).invoke(testInstance, new Object[0]);
    }

    private void checkHelperVersion(ClassLoader classLoader, String expectedHelperClassName) throws Exception {
        Class<?> abstractFutureClass = classLoader.loadClass(AggregateFutureState.class.getName());
        Field helperField = abstractFutureClass.getDeclaredField("ATOMIC_HELPER");
        helperField.setAccessible(true);
        AggregateFutureStateFallbackAtomicHelperTest.assertEquals((String)expectedHelperClassName, (String)helperField.get(null).getClass().getSimpleName());
    }

    private static ClassLoader getClassLoader(final Set<String> blacklist) {
        final String concurrentPackage = SettableFuture.class.getPackage().getName();
        ClassLoader classLoader = AggregateFutureStateFallbackAtomicHelperTest.class.getClassLoader();
        return new URLClassLoader(((URLClassLoader)classLoader).getURLs(), classLoader){

            @Override
            public Class<?> loadClass(String name) throws ClassNotFoundException {
                if (blacklist.contains(name)) {
                    throw new ClassNotFoundException("I'm sorry Dave, I'm afraid I can't do that.");
                }
                if (name.startsWith(concurrentPackage)) {
                    Class<?> c = this.findLoadedClass(name);
                    if (c == null) {
                        return super.findClass(name);
                    }
                    return c;
                }
                return super.loadClass(name);
            }
        };
    }
}

