/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.util.concurrent.AsyncCallable;
import com.google.common.util.concurrent.Callables;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.security.Permission;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import junit.framework.Assert;
import junit.framework.TestCase;

@GwtCompatible(emulated=true)
public class CallablesTest
extends TestCase {
    public void testReturning() throws Exception {
        CallablesTest.assertNull(Callables.returning(null).call());
        Object value = new Object();
        Callable callable = Callables.returning((Object)value);
        CallablesTest.assertSame((Object)value, callable.call());
        CallablesTest.assertSame((Object)value, callable.call());
    }

    @GwtIncompatible
    public void testAsAsyncCallable() throws Exception {
        String expected = "MyCallableString";
        Callable<String> callable = new Callable<String>(){

            @Override
            public String call() throws Exception {
                return "MyCallableString";
            }
        };
        AsyncCallable asyncCallable = Callables.asAsyncCallable((Callable)callable, (ListeningExecutorService)MoreExecutors.newDirectExecutorService());
        ListenableFuture future = asyncCallable.call();
        CallablesTest.assertSame((Object)"MyCallableString", (Object)future.get());
    }

    @GwtIncompatible
    public void testAsAsyncCallable_exception() throws Exception {
        final IllegalArgumentException expected = new IllegalArgumentException();
        Callable<String> callable = new Callable<String>(){

            @Override
            public String call() throws Exception {
                throw expected;
            }
        };
        AsyncCallable asyncCallable = Callables.asAsyncCallable((Callable)callable, (ListeningExecutorService)MoreExecutors.newDirectExecutorService());
        ListenableFuture future = asyncCallable.call();
        try {
            future.get();
            CallablesTest.fail((String)"Expected exception to be thrown");
        }
        catch (ExecutionException e) {
            CallablesTest.assertSame((Object)expected, (Object)e.getCause());
        }
    }

    @GwtIncompatible
    public void testRenaming() throws Exception {
        String oldName = Thread.currentThread().getName();
        final Supplier newName = Suppliers.ofInstance((Object)"MyCrazyThreadName");
        Callable<Void> callable = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Assert.assertEquals((String)Thread.currentThread().getName(), (String)((String)newName.get()));
                return null;
            }
        };
        Callables.threadRenaming((Callable)callable, (Supplier)newName).call();
        CallablesTest.assertEquals((String)oldName, (String)Thread.currentThread().getName());
    }

    @GwtIncompatible
    public void testRenaming_exceptionalReturn() throws Exception {
        class MyException
        extends Exception {
            MyException() {
            }
        }
        String oldName = Thread.currentThread().getName();
        final Supplier newName = Suppliers.ofInstance((Object)"MyCrazyThreadName");
        Callable<Void> callable = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Assert.assertEquals((String)Thread.currentThread().getName(), (String)((String)newName.get()));
                throw new MyException();
            }
        };
        try {
            Callables.threadRenaming((Callable)callable, (Supplier)newName).call();
            CallablesTest.fail();
        }
        catch (MyException myException) {
            // empty catch block
        }
        CallablesTest.assertEquals((String)oldName, (String)Thread.currentThread().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GwtIncompatible
    public void testRenaming_noPermissions() throws Exception {
        System.setSecurityManager(new SecurityManager(){

            @Override
            public void checkAccess(Thread t) {
                throw new SecurityException();
            }

            @Override
            public void checkPermission(Permission perm) {
            }
        });
        try {
            final String oldName = Thread.currentThread().getName();
            Supplier newName = Suppliers.ofInstance((Object)"MyCrazyThreadName");
            Callable<Void> callable = new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    Assert.assertEquals((String)Thread.currentThread().getName(), (String)oldName);
                    return null;
                }
            };
            Callables.threadRenaming((Callable)callable, (Supplier)newName).call();
            CallablesTest.assertEquals((String)oldName, (String)Thread.currentThread().getName());
        }
        finally {
            System.setSecurityManager(null);
        }
    }
}

