/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.testing.GcFinalization;
import com.google.common.truth.Truth;
import com.google.common.util.concurrent.ExecutionError;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.FuturesGetCheckedInputs;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.lang.ref.WeakReference;
import java.net.URLClassLoader;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import junit.framework.TestCase;

public class FuturesGetCheckedTest
extends TestCase {
    public void testGetCheckedUntimed_success() throws FuturesGetCheckedInputs.TwoArgConstructorException {
        FuturesGetCheckedTest.assertEquals((String)"foo", (String)((String)Futures.getChecked((Future)Futures.immediateFuture((Object)"foo"), FuturesGetCheckedInputs.TwoArgConstructorException.class)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetCheckedUntimed_interrupted() {
        SettableFuture future = SettableFuture.create();
        Thread.currentThread().interrupt();
        try {
            Futures.getChecked((Future)future, FuturesGetCheckedInputs.TwoArgConstructorException.class);
            FuturesGetCheckedTest.fail();
        }
        catch (FuturesGetCheckedInputs.TwoArgConstructorException expected) {
            Truth.assertThat((Throwable)expected.getCause()).isInstanceOf(InterruptedException.class);
            FuturesGetCheckedTest.assertTrue((boolean)Thread.currentThread().isInterrupted());
        }
        finally {
            Thread.interrupted();
        }
    }

    public void testGetCheckedUntimed_cancelled() throws FuturesGetCheckedInputs.TwoArgConstructorException {
        SettableFuture future = SettableFuture.create();
        future.cancel(true);
        try {
            Futures.getChecked((Future)future, FuturesGetCheckedInputs.TwoArgConstructorException.class);
            FuturesGetCheckedTest.fail();
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
    }

    public void testGetCheckedUntimed_ExecutionExceptionChecked() {
        try {
            Futures.getChecked(FuturesGetCheckedInputs.FAILED_FUTURE_CHECKED_EXCEPTION, FuturesGetCheckedInputs.TwoArgConstructorException.class);
            FuturesGetCheckedTest.fail();
        }
        catch (FuturesGetCheckedInputs.TwoArgConstructorException expected) {
            FuturesGetCheckedTest.assertEquals((Object)FuturesGetCheckedInputs.CHECKED_EXCEPTION, (Object)expected.getCause());
        }
    }

    public void testGetCheckedUntimed_ExecutionExceptionUnchecked() throws FuturesGetCheckedInputs.TwoArgConstructorException {
        try {
            Futures.getChecked(FuturesGetCheckedInputs.FAILED_FUTURE_UNCHECKED_EXCEPTION, FuturesGetCheckedInputs.TwoArgConstructorException.class);
            FuturesGetCheckedTest.fail();
        }
        catch (UncheckedExecutionException expected) {
            FuturesGetCheckedTest.assertEquals((Object)FuturesGetCheckedInputs.UNCHECKED_EXCEPTION, (Object)expected.getCause());
        }
    }

    public void testGetCheckedUntimed_ExecutionExceptionError() throws FuturesGetCheckedInputs.TwoArgConstructorException {
        try {
            Futures.getChecked(FuturesGetCheckedInputs.FAILED_FUTURE_ERROR, FuturesGetCheckedInputs.TwoArgConstructorException.class);
            FuturesGetCheckedTest.fail();
        }
        catch (ExecutionError expected) {
            FuturesGetCheckedTest.assertEquals((Object)FuturesGetCheckedInputs.ERROR, (Object)expected.getCause());
        }
    }

    public void testGetCheckedUntimed_ExecutionExceptionOtherThrowable() {
        try {
            Futures.getChecked(FuturesGetCheckedInputs.FAILED_FUTURE_OTHER_THROWABLE, FuturesGetCheckedInputs.TwoArgConstructorException.class);
            FuturesGetCheckedTest.fail();
        }
        catch (FuturesGetCheckedInputs.TwoArgConstructorException expected) {
            FuturesGetCheckedTest.assertEquals((Object)FuturesGetCheckedInputs.OTHER_THROWABLE, (Object)expected.getCause());
        }
    }

    public void testGetCheckedUntimed_RuntimeException() throws FuturesGetCheckedInputs.TwoArgConstructorException {
        try {
            Futures.getChecked(FuturesGetCheckedInputs.RUNTIME_EXCEPTION_FUTURE, FuturesGetCheckedInputs.TwoArgConstructorException.class);
            FuturesGetCheckedTest.fail();
        }
        catch (RuntimeException expected) {
            FuturesGetCheckedTest.assertEquals((Object)FuturesGetCheckedInputs.RUNTIME_EXCEPTION, (Object)expected);
        }
    }

    public void testGetCheckedUntimed_Error() throws FuturesGetCheckedInputs.TwoArgConstructorException {
        try {
            Futures.getChecked(FuturesGetCheckedInputs.ERROR_FUTURE, FuturesGetCheckedInputs.TwoArgConstructorException.class);
        }
        catch (Error expected) {
            FuturesGetCheckedTest.assertEquals((Object)FuturesGetCheckedInputs.ERROR, (Object)expected);
            return;
        }
        FuturesGetCheckedTest.fail();
    }

    public void testGetCheckedUntimed_badExceptionConstructor_failsEvenForSuccessfulInput() throws Exception {
        try {
            Futures.getChecked((Future)Futures.immediateFuture((Object)"x"), FuturesGetCheckedInputs.ExceptionWithBadConstructor.class);
            FuturesGetCheckedTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetCheckedUntimed_badExceptionConstructor_wrapsOriginalChecked() throws Exception {
        try {
            Futures.getChecked(FuturesGetCheckedInputs.FAILED_FUTURE_CHECKED_EXCEPTION, FuturesGetCheckedInputs.ExceptionWithBadConstructor.class);
            FuturesGetCheckedTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetCheckedUntimed_withGoodAndBadExceptionConstructor() throws Exception {
        try {
            Futures.getChecked(FuturesGetCheckedInputs.FAILED_FUTURE_CHECKED_EXCEPTION, FuturesGetCheckedInputs.ExceptionWithGoodAndBadConstructor.class);
            FuturesGetCheckedTest.fail();
        }
        catch (FuturesGetCheckedInputs.ExceptionWithGoodAndBadConstructor expected) {
            FuturesGetCheckedTest.assertSame((Object)FuturesGetCheckedInputs.CHECKED_EXCEPTION, (Object)expected.getCause());
        }
    }

    public void testGetCheckedTimed_success() throws FuturesGetCheckedInputs.TwoArgConstructorException {
        FuturesGetCheckedTest.assertEquals((String)"foo", (String)((String)Futures.getChecked((Future)Futures.immediateFuture((Object)"foo"), FuturesGetCheckedInputs.TwoArgConstructorException.class, (long)0L, (TimeUnit)TimeUnit.SECONDS)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetCheckedTimed_interrupted() {
        SettableFuture future = SettableFuture.create();
        Thread.currentThread().interrupt();
        try {
            Futures.getChecked((Future)future, FuturesGetCheckedInputs.TwoArgConstructorException.class, (long)0L, (TimeUnit)TimeUnit.SECONDS);
            FuturesGetCheckedTest.fail();
        }
        catch (FuturesGetCheckedInputs.TwoArgConstructorException expected) {
            Truth.assertThat((Throwable)expected.getCause()).isInstanceOf(InterruptedException.class);
            FuturesGetCheckedTest.assertTrue((boolean)Thread.currentThread().isInterrupted());
        }
        finally {
            Thread.interrupted();
        }
    }

    public void testGetCheckedTimed_cancelled() throws FuturesGetCheckedInputs.TwoArgConstructorException {
        SettableFuture future = SettableFuture.create();
        future.cancel(true);
        try {
            Futures.getChecked((Future)future, FuturesGetCheckedInputs.TwoArgConstructorException.class, (long)0L, (TimeUnit)TimeUnit.SECONDS);
            FuturesGetCheckedTest.fail();
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
    }

    public void testGetCheckedTimed_ExecutionExceptionChecked() {
        try {
            Futures.getChecked(FuturesGetCheckedInputs.FAILED_FUTURE_CHECKED_EXCEPTION, FuturesGetCheckedInputs.TwoArgConstructorException.class, (long)0L, (TimeUnit)TimeUnit.SECONDS);
            FuturesGetCheckedTest.fail();
        }
        catch (FuturesGetCheckedInputs.TwoArgConstructorException expected) {
            FuturesGetCheckedTest.assertEquals((Object)FuturesGetCheckedInputs.CHECKED_EXCEPTION, (Object)expected.getCause());
        }
    }

    public void testGetCheckedTimed_ExecutionExceptionUnchecked() throws FuturesGetCheckedInputs.TwoArgConstructorException {
        try {
            Futures.getChecked(FuturesGetCheckedInputs.FAILED_FUTURE_UNCHECKED_EXCEPTION, FuturesGetCheckedInputs.TwoArgConstructorException.class, (long)0L, (TimeUnit)TimeUnit.SECONDS);
            FuturesGetCheckedTest.fail();
        }
        catch (UncheckedExecutionException expected) {
            FuturesGetCheckedTest.assertEquals((Object)FuturesGetCheckedInputs.UNCHECKED_EXCEPTION, (Object)expected.getCause());
        }
    }

    public void testGetCheckedTimed_ExecutionExceptionError() throws FuturesGetCheckedInputs.TwoArgConstructorException {
        try {
            Futures.getChecked(FuturesGetCheckedInputs.FAILED_FUTURE_ERROR, FuturesGetCheckedInputs.TwoArgConstructorException.class, (long)0L, (TimeUnit)TimeUnit.SECONDS);
            FuturesGetCheckedTest.fail();
        }
        catch (ExecutionError expected) {
            FuturesGetCheckedTest.assertEquals((Object)FuturesGetCheckedInputs.ERROR, (Object)expected.getCause());
        }
    }

    public void testGetCheckedTimed_ExecutionExceptionOtherThrowable() {
        try {
            Futures.getChecked(FuturesGetCheckedInputs.FAILED_FUTURE_OTHER_THROWABLE, FuturesGetCheckedInputs.TwoArgConstructorException.class, (long)0L, (TimeUnit)TimeUnit.SECONDS);
            FuturesGetCheckedTest.fail();
        }
        catch (FuturesGetCheckedInputs.TwoArgConstructorException expected) {
            FuturesGetCheckedTest.assertEquals((Object)FuturesGetCheckedInputs.OTHER_THROWABLE, (Object)expected.getCause());
        }
    }

    public void testGetCheckedTimed_RuntimeException() throws FuturesGetCheckedInputs.TwoArgConstructorException {
        try {
            Futures.getChecked(FuturesGetCheckedInputs.RUNTIME_EXCEPTION_FUTURE, FuturesGetCheckedInputs.TwoArgConstructorException.class, (long)0L, (TimeUnit)TimeUnit.SECONDS);
            FuturesGetCheckedTest.fail();
        }
        catch (RuntimeException expected) {
            FuturesGetCheckedTest.assertEquals((Object)FuturesGetCheckedInputs.RUNTIME_EXCEPTION, (Object)expected);
        }
    }

    public void testGetCheckedTimed_Error() throws FuturesGetCheckedInputs.TwoArgConstructorException {
        try {
            Futures.getChecked(FuturesGetCheckedInputs.ERROR_FUTURE, FuturesGetCheckedInputs.TwoArgConstructorException.class, (long)0L, (TimeUnit)TimeUnit.SECONDS);
        }
        catch (Error expected) {
            FuturesGetCheckedTest.assertEquals((Object)FuturesGetCheckedInputs.ERROR, (Object)expected);
            return;
        }
        FuturesGetCheckedTest.fail();
    }

    public void testGetCheckedTimed_TimeoutException() {
        SettableFuture future = SettableFuture.create();
        try {
            Futures.getChecked((Future)future, FuturesGetCheckedInputs.TwoArgConstructorException.class, (long)0L, (TimeUnit)TimeUnit.SECONDS);
            FuturesGetCheckedTest.fail();
        }
        catch (FuturesGetCheckedInputs.TwoArgConstructorException expected) {
            Truth.assertThat((Throwable)expected.getCause()).isInstanceOf(TimeoutException.class);
        }
    }

    public void testGetCheckedTimed_badExceptionConstructor_failsEvenForSuccessfulInput() throws Exception {
        try {
            Futures.getChecked((Future)Futures.immediateFuture((Object)"x"), FuturesGetCheckedInputs.ExceptionWithBadConstructor.class, (long)1L, (TimeUnit)TimeUnit.SECONDS);
            FuturesGetCheckedTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetCheckedTimed_badExceptionConstructor_wrapsOriginalChecked() throws Exception {
        try {
            Futures.getChecked(FuturesGetCheckedInputs.FAILED_FUTURE_CHECKED_EXCEPTION, FuturesGetCheckedInputs.ExceptionWithBadConstructor.class, (long)1L, (TimeUnit)TimeUnit.SECONDS);
            FuturesGetCheckedTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetCheckedTimed_withGoodAndBadExceptionConstructor() throws Exception {
        try {
            Futures.getChecked(FuturesGetCheckedInputs.FAILED_FUTURE_CHECKED_EXCEPTION, FuturesGetCheckedInputs.ExceptionWithGoodAndBadConstructor.class, (long)1L, (TimeUnit)TimeUnit.SECONDS);
            FuturesGetCheckedTest.fail();
        }
        catch (FuturesGetCheckedInputs.ExceptionWithGoodAndBadConstructor expected) {
            FuturesGetCheckedTest.assertSame((Object)FuturesGetCheckedInputs.CHECKED_EXCEPTION, (Object)expected.getCause());
        }
    }

    public void testGetCheckedUntimed_exceptionClassIsRuntimeException() {
        try {
            Futures.getChecked(FuturesGetCheckedInputs.FAILED_FUTURE_CHECKED_EXCEPTION, FuturesGetCheckedInputs.TwoArgConstructorRuntimeException.class);
            FuturesGetCheckedTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetCheckedUntimed_exceptionClassSomePrivateConstructors() {
        try {
            Futures.getChecked(FuturesGetCheckedInputs.FAILED_FUTURE_CHECKED_EXCEPTION, FuturesGetCheckedInputs.ExceptionWithSomePrivateConstructors.class);
            FuturesGetCheckedTest.fail();
        }
        catch (FuturesGetCheckedInputs.ExceptionWithSomePrivateConstructors exceptionWithSomePrivateConstructors) {
            // empty catch block
        }
    }

    public void testGetCheckedUntimed_exceptionClassNoPublicConstructor() throws FuturesGetCheckedInputs.ExceptionWithPrivateConstructor {
        try {
            Futures.getChecked(FuturesGetCheckedInputs.FAILED_FUTURE_CHECKED_EXCEPTION, FuturesGetCheckedInputs.ExceptionWithPrivateConstructor.class);
            FuturesGetCheckedTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetCheckedUntimed_exceptionClassPublicConstructorWrongType() throws FuturesGetCheckedInputs.ExceptionWithWrongTypesConstructor {
        try {
            Futures.getChecked(FuturesGetCheckedInputs.FAILED_FUTURE_CHECKED_EXCEPTION, FuturesGetCheckedInputs.ExceptionWithWrongTypesConstructor.class);
            FuturesGetCheckedTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetCheckedUntimed_exceptionClassPrefersStringConstructor() {
        try {
            Futures.getChecked(FuturesGetCheckedInputs.FAILED_FUTURE_CHECKED_EXCEPTION, FuturesGetCheckedInputs.ExceptionWithManyConstructors.class);
            FuturesGetCheckedTest.fail();
        }
        catch (FuturesGetCheckedInputs.ExceptionWithManyConstructors expected) {
            FuturesGetCheckedTest.assertTrue((boolean)expected.usedExpectedConstructor);
        }
    }

    public void testGetCheckedUntimed_exceptionClassUsedInitCause() {
        try {
            Futures.getChecked(FuturesGetCheckedInputs.FAILED_FUTURE_CHECKED_EXCEPTION, FuturesGetCheckedInputs.ExceptionWithoutThrowableConstructor.class);
            FuturesGetCheckedTest.fail();
        }
        catch (FuturesGetCheckedInputs.ExceptionWithoutThrowableConstructor expected) {
            Truth.assertThat((String)expected.getMessage()).contains((CharSequence)"mymessage");
            FuturesGetCheckedTest.assertEquals((Object)FuturesGetCheckedInputs.CHECKED_EXCEPTION, (Object)expected.getCause());
        }
    }

    public void testGetChecked_classUnloading() throws Exception {
        WeakReference<?> classUsedByGetChecked = this.doTestClassUnloading();
        GcFinalization.awaitClear(classUsedByGetChecked);
    }

    private WeakReference<?> doTestClassUnloading() throws Exception {
        URLClassLoader myLoader = (URLClassLoader)((Object)((Object)this)).getClass().getClassLoader();
        URLClassLoader shadowLoader = new URLClassLoader(myLoader.getURLs(), null);
        Class<?> shadowClass = Class.forName(WillBeUnloadedException.class.getName(), false, shadowLoader);
        FuturesGetCheckedTest.assertNotSame(shadowClass, WillBeUnloadedException.class);
        Futures.getChecked((Future)Futures.immediateFuture((Object)"foo"), shadowClass);
        return new WeakReference<URLClassLoader>(shadowLoader);
    }

    public static final class WillBeUnloadedException
    extends Exception {
    }
}

