/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtCompatible;
import com.google.common.truth.Truth;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.SettableFuture;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import junit.framework.TestCase;

@GwtCompatible
public class FuturesGetDoneTest
extends TestCase {
    public void testSuccessful() throws ExecutionException {
        Truth.assertThat((String)((String)Futures.getDone((Future)Futures.immediateFuture((Object)"a")))).isEqualTo((Object)"a");
    }

    public void testSuccessfulNull() throws ExecutionException {
        Truth.assertThat((String)((String)Futures.getDone((Future)Futures.immediateFuture((Object)null)))).isEqualTo(null);
    }

    public void testFailed() {
        Exception failureCause = new Exception();
        try {
            Futures.getDone((Future)Futures.immediateFailedFuture((Throwable)failureCause));
            FuturesGetDoneTest.fail();
        }
        catch (ExecutionException expected) {
            Truth.assertThat((Throwable)expected.getCause()).isEqualTo((Object)failureCause);
        }
    }

    public void testCancelled() throws ExecutionException {
        try {
            Futures.getDone((Future)Futures.immediateCancelledFuture());
            FuturesGetDoneTest.fail();
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
    }

    public void testPending() throws ExecutionException {
        try {
            Futures.getDone((Future)SettableFuture.create());
            FuturesGetDoneTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

