/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Monitor;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

@CanIgnoreReturnValue
public class MonitorBasedPriorityBlockingQueue<E>
extends AbstractQueue<E>
implements BlockingQueue<E> {
    private static final long serialVersionUID = 5595510919245408276L;
    final PriorityQueue<E> q;
    final Monitor monitor = new Monitor(true);
    private final Monitor.Guard notEmpty = new Monitor.Guard(this.monitor){

        public boolean isSatisfied() {
            return !MonitorBasedPriorityBlockingQueue.this.q.isEmpty();
        }
    };

    public MonitorBasedPriorityBlockingQueue() {
        this.q = new PriorityQueue();
    }

    public MonitorBasedPriorityBlockingQueue(int initialCapacity) {
        this.q = new PriorityQueue(initialCapacity, null);
    }

    public MonitorBasedPriorityBlockingQueue(int initialCapacity, @Nullable Comparator<? super E> comparator) {
        this.q = new PriorityQueue<E>(initialCapacity, comparator);
    }

    public MonitorBasedPriorityBlockingQueue(Collection<? extends E> c) {
        this.q = new PriorityQueue<E>(c);
    }

    @Override
    public boolean add(E e) {
        return this.offer(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e) {
        Monitor monitor = this.monitor;
        monitor.enter();
        try {
            boolean ok = this.q.offer(e);
            if (!ok) {
                throw new AssertionError();
            }
            boolean bl = true;
            return bl;
        }
        finally {
            monitor.leave();
        }
    }

    @Override
    public void put(E e) {
        this.offer(e);
    }

    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) {
        Preconditions.checkNotNull((Object)((Object)unit));
        return this.offer(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll() {
        Monitor monitor = this.monitor;
        monitor.enter();
        try {
            E e = this.q.poll();
            return e;
        }
        finally {
            monitor.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E take() throws InterruptedException {
        Monitor monitor = this.monitor;
        monitor.enterWhen(this.notEmpty);
        try {
            E e = this.q.poll();
            return e;
        }
        finally {
            monitor.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        Monitor monitor = this.monitor;
        if (monitor.enterWhen(this.notEmpty, timeout, unit)) {
            try {
                E e = this.q.poll();
                return e;
            }
            finally {
                monitor.leave();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E peek() {
        Monitor monitor = this.monitor;
        monitor.enter();
        try {
            E e = this.q.peek();
            return e;
        }
        finally {
            monitor.leave();
        }
    }

    public Comparator<? super E> comparator() {
        return this.q.comparator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Monitor monitor = this.monitor;
        monitor.enter();
        try {
            int n = this.q.size();
            return n;
        }
        finally {
            monitor.leave();
        }
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(@Nullable Object o) {
        Monitor monitor = this.monitor;
        monitor.enter();
        try {
            boolean bl = this.q.remove(o);
            return bl;
        }
        finally {
            monitor.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(@Nullable Object o) {
        Monitor monitor = this.monitor;
        monitor.enter();
        try {
            boolean bl = this.q.contains(o);
            return bl;
        }
        finally {
            monitor.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        Monitor monitor = this.monitor;
        monitor.enter();
        try {
            Object[] objectArray = this.q.toArray();
            return objectArray;
        }
        finally {
            monitor.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        Monitor monitor = this.monitor;
        monitor.enter();
        try {
            String string = this.q.toString();
            return string;
        }
        finally {
            monitor.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> c) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        Monitor monitor = this.monitor;
        monitor.enter();
        try {
            E e;
            int n = 0;
            while ((e = this.q.poll()) != null) {
                c.add(e);
                ++n;
            }
            int n2 = n;
            return n2;
        }
        finally {
            monitor.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        if (maxElements <= 0) {
            return 0;
        }
        Monitor monitor = this.monitor;
        monitor.enter();
        try {
            E e;
            int n;
            for (n = 0; n < maxElements && (e = this.q.poll()) != null; ++n) {
                c.add(e);
            }
            int n2 = n;
            return n2;
        }
        finally {
            monitor.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Monitor monitor = this.monitor;
        monitor.enter();
        try {
            this.q.clear();
        }
        finally {
            monitor.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] a) {
        Monitor monitor = this.monitor;
        monitor.enter();
        try {
            T[] TArray = this.q.toArray(a);
            return TArray;
        }
        finally {
            monitor.leave();
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr(this.toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream s) throws IOException {
        this.monitor.enter();
        try {
            s.defaultWriteObject();
        }
        finally {
            this.monitor.leave();
        }
    }

    private class Itr
    implements Iterator<E> {
        final Object[] array;
        int cursor;
        int lastRet = -1;

        Itr(Object[] array) {
            this.array = array;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.array.length;
        }

        @Override
        public E next() {
            if (this.cursor >= this.array.length) {
                throw new NoSuchElementException();
            }
            this.lastRet = this.cursor;
            Object e = this.array[this.cursor++];
            return e;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            Object x = this.array[this.lastRet];
            this.lastRet = -1;
            MonitorBasedPriorityBlockingQueue.this.monitor.enter();
            try {
                Iterator it = MonitorBasedPriorityBlockingQueue.this.q.iterator();
                while (it.hasNext()) {
                    if (it.next() != x) continue;
                    it.remove();
                    return;
                }
            }
            finally {
                MonitorBasedPriorityBlockingQueue.this.monitor.leave();
            }
        }
    }
}

