/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.caliper.BeforeExperiment;
import com.google.caliper.Benchmark;
import com.google.caliper.Param;
import com.google.caliper.api.VmOptions;
import com.google.common.util.concurrent.AbstractFutureBenchmarks;
import java.util.ArrayList;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@VmOptions(value={"-Xms8g", "-Xmx8g"})
public class SingleThreadAbstractFutureBenchmark {
    @Param
    AbstractFutureBenchmarks.Impl impl;
    private final Exception exception = new Exception();
    private AbstractFutureBenchmarks.Facade<?> notDoneFuture;

    @BeforeExperiment
    void setUp() throws Exception {
        this.notDoneFuture = this.impl.newFacade();
    }

    @Benchmark
    public long timeComplete_Normal(int reps) throws Exception {
        int i;
        long r = 0L;
        ArrayList<AbstractFutureBenchmarks.Facade<Integer>> list = new ArrayList<AbstractFutureBenchmarks.Facade<Integer>>(reps);
        for (i = 0; i < reps; ++i) {
            AbstractFutureBenchmarks.Facade<Integer> localFuture = this.impl.newFacade();
            list.add(localFuture);
            localFuture.set(i);
        }
        for (i = 0; i < reps; ++i) {
            r += (long)((Integer)((AbstractFutureBenchmarks.Facade)list.get(i)).get()).intValue();
        }
        return r;
    }

    @Benchmark
    public long timeComplete_Failure(int reps) throws Exception {
        int i;
        long r = 0L;
        ArrayList list = new ArrayList(reps);
        for (i = 0; i < reps; ++i) {
            AbstractFutureBenchmarks.Facade localFuture = this.impl.newFacade();
            list.add(localFuture);
            localFuture.setException(this.exception);
        }
        for (i = 0; i < reps; ++i) {
            AbstractFutureBenchmarks.Facade facade = (AbstractFutureBenchmarks.Facade)list.get(i);
            try {
                facade.get();
                ++r;
                continue;
            }
            catch (ExecutionException e) {
                r += 2L;
            }
        }
        return r;
    }

    @Benchmark
    public long timeComplete_Cancel(int reps) throws Exception {
        int i;
        long r = 0L;
        ArrayList list = new ArrayList(reps);
        for (i = 0; i < reps; ++i) {
            AbstractFutureBenchmarks.Facade localFuture = this.impl.newFacade();
            list.add(localFuture);
            localFuture.cancel(false);
        }
        for (i = 0; i < reps; ++i) {
            AbstractFutureBenchmarks.Facade facade = (AbstractFutureBenchmarks.Facade)list.get(i);
            try {
                facade.get();
                ++r;
                continue;
            }
            catch (CancellationException e) {
                r += 2L;
            }
        }
        return r;
    }

    @Benchmark
    public long timeGetWith0Timeout(long reps) throws Exception {
        AbstractFutureBenchmarks.Facade<?> f = this.notDoneFuture;
        long r = 0L;
        int i = 0;
        while ((long)i < reps) {
            try {
                f.get(0L, TimeUnit.SECONDS);
                ++r;
            }
            catch (TimeoutException e) {
                r += 2L;
            }
            ++i;
        }
        return r;
    }

    @Benchmark
    public long timeGetWithSmallTimeout(long reps) throws Exception {
        AbstractFutureBenchmarks.Facade<?> f = this.notDoneFuture;
        long r = 0L;
        int i = 0;
        while ((long)i < reps) {
            try {
                f.get(500L, TimeUnit.NANOSECONDS);
                ++r;
            }
            catch (TimeoutException e) {
                r += 2L;
            }
            ++i;
        }
        return r;
    }
}

