/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.util.concurrent.GeneratedMonitorTest;
import com.google.common.util.concurrent.Monitor;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import junit.framework.TestCase;

public class SupplementalMonitorTest
extends TestCase {
    public void testLeaveWithoutEnterThrowsIMSE() {
        Monitor monitor = new Monitor();
        try {
            monitor.leave();
            SupplementalMonitorTest.fail((String)"expected IllegalMonitorStateException");
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            // empty catch block
        }
    }

    public void testGetWaitQueueLengthWithWrongMonitorThrowsIMSE() {
        Monitor monitor1 = new Monitor();
        Monitor monitor2 = new Monitor();
        GeneratedMonitorTest.FlagGuard guard = new GeneratedMonitorTest.FlagGuard(monitor2);
        try {
            monitor1.getWaitQueueLength((Monitor.Guard)guard);
            SupplementalMonitorTest.fail((String)"expected IllegalMonitorStateException");
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            // empty catch block
        }
    }

    public void testHasWaitersWithWrongMonitorThrowsIMSE() {
        Monitor monitor1 = new Monitor();
        Monitor monitor2 = new Monitor();
        GeneratedMonitorTest.FlagGuard guard = new GeneratedMonitorTest.FlagGuard(monitor2);
        try {
            monitor1.hasWaiters((Monitor.Guard)guard);
            SupplementalMonitorTest.fail((String)"expected IllegalMonitorStateException");
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            // empty catch block
        }
    }

    public void testNullMonitorInGuardConstructorThrowsNPE() {
        try {
            new GeneratedMonitorTest.FlagGuard(null);
            SupplementalMonitorTest.fail((String)"expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testIsFair() {
        SupplementalMonitorTest.assertTrue((boolean)new Monitor(true).isFair());
        SupplementalMonitorTest.assertFalse((boolean)new Monitor(false).isFair());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOccupiedMethods() {
        Monitor monitor = new Monitor();
        SupplementalMonitorTest.verifyOccupiedMethodsInCurrentThread(monitor, false, false, 0);
        SupplementalMonitorTest.verifyOccupiedMethodsInAnotherThread(monitor, false, false, 0);
        monitor.enter();
        try {
            SupplementalMonitorTest.verifyOccupiedMethodsInCurrentThread(monitor, true, true, 1);
            SupplementalMonitorTest.verifyOccupiedMethodsInAnotherThread(monitor, true, false, 0);
            monitor.enter();
            try {
                SupplementalMonitorTest.verifyOccupiedMethodsInCurrentThread(monitor, true, true, 2);
                SupplementalMonitorTest.verifyOccupiedMethodsInAnotherThread(monitor, true, false, 0);
            }
            finally {
                monitor.leave();
            }
            SupplementalMonitorTest.verifyOccupiedMethodsInCurrentThread(monitor, true, true, 1);
            SupplementalMonitorTest.verifyOccupiedMethodsInAnotherThread(monitor, true, false, 0);
        }
        finally {
            monitor.leave();
        }
        SupplementalMonitorTest.verifyOccupiedMethodsInCurrentThread(monitor, false, false, 0);
        SupplementalMonitorTest.verifyOccupiedMethodsInAnotherThread(monitor, false, false, 0);
    }

    private static void verifyOccupiedMethodsInCurrentThread(Monitor monitor, boolean expectedIsOccupied, boolean expectedIsOccupiedByCurrentThread, int expectedOccupiedDepth) {
        SupplementalMonitorTest.assertEquals((boolean)expectedIsOccupied, (boolean)monitor.isOccupied());
        SupplementalMonitorTest.assertEquals((boolean)expectedIsOccupiedByCurrentThread, (boolean)monitor.isOccupiedByCurrentThread());
        SupplementalMonitorTest.assertEquals((int)expectedOccupiedDepth, (int)monitor.getOccupiedDepth());
    }

    private static void verifyOccupiedMethodsInAnotherThread(final Monitor monitor, boolean expectedIsOccupied, boolean expectedIsOccupiedByCurrentThread, int expectedOccupiedDepth) {
        final AtomicBoolean actualIsOccupied = new AtomicBoolean();
        final AtomicBoolean actualIsOccupiedByCurrentThread = new AtomicBoolean();
        final AtomicInteger actualOccupiedDepth = new AtomicInteger();
        final AtomicReference thrown = new AtomicReference();
        Uninterruptibles.joinUninterruptibly((Thread)GeneratedMonitorTest.startThread(new Runnable(){

            @Override
            public void run() {
                try {
                    actualIsOccupied.set(monitor.isOccupied());
                    actualIsOccupiedByCurrentThread.set(monitor.isOccupiedByCurrentThread());
                    actualOccupiedDepth.set(monitor.getOccupiedDepth());
                }
                catch (Throwable t) {
                    thrown.set(t);
                }
            }
        }));
        SupplementalMonitorTest.assertNull(thrown.get());
        SupplementalMonitorTest.assertEquals((boolean)expectedIsOccupied, (boolean)actualIsOccupied.get());
        SupplementalMonitorTest.assertEquals((boolean)expectedIsOccupiedByCurrentThread, (boolean)actualIsOccupiedByCurrentThread.get());
        SupplementalMonitorTest.assertEquals((int)expectedOccupiedDepth, (int)actualOccupiedDepth.get());
    }
}

