/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@GwtCompatible
final class UncheckedThrowingFuture<V>
implements ListenableFuture<V> {
    private final Error error;
    private final RuntimeException runtime;

    public static <V> ListenableFuture<V> throwingError(Error error) {
        return new UncheckedThrowingFuture<V>(error);
    }

    public static <V> ListenableFuture<V> throwingRuntimeException(RuntimeException e) {
        return new UncheckedThrowingFuture<V>(e);
    }

    private UncheckedThrowingFuture(Error error) {
        this.error = (Error)Preconditions.checkNotNull((Object)error);
        this.runtime = null;
    }

    public UncheckedThrowingFuture(RuntimeException e) {
        this.runtime = (RuntimeException)Preconditions.checkNotNull((Object)e);
        this.error = null;
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    public boolean isCancelled() {
        return false;
    }

    public boolean isDone() {
        return true;
    }

    public V get() {
        this.throwOnGet();
        throw new AssertionError((Object)"Unreachable");
    }

    public V get(long timeout, TimeUnit unit) {
        Preconditions.checkNotNull((Object)((Object)unit));
        this.throwOnGet();
        throw new AssertionError();
    }

    public void addListener(Runnable listener, Executor executor) {
        Preconditions.checkNotNull((Object)listener);
        executor.execute(listener);
    }

    private void throwOnGet() {
        if (this.error != null) {
            throw this.error;
        }
        throw this.runtime;
    }
}

