/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.AbstractBaseIterator;
import com.google.common.testing.GcFinalization;
import java.lang.ref.WeakReference;
import java.util.NoSuchElementException;
import junit.framework.Assert;
import junit.framework.TestCase;

@GwtCompatible(emulated=true)
public class AbstractBaseIteratorTest
extends TestCase {
    public void testDefaultBehaviorOfNextAndHasNext() {
        AbstractBaseIterator<Integer> iter = new AbstractBaseIterator<Integer>(){
            private int rep;

            public Integer computeNext() {
                switch (this.rep++) {
                    case 0: {
                        return 0;
                    }
                    case 1: {
                        return 1;
                    }
                    case 2: {
                        return (Integer)this.endOfData();
                    }
                }
                Assert.fail((String)"Should not have been invoked again");
                return null;
            }
        };
        AbstractBaseIteratorTest.assertTrue((boolean)iter.hasNext());
        AbstractBaseIteratorTest.assertEquals((int)0, (int)((Integer)iter.next()));
        AbstractBaseIteratorTest.assertTrue((boolean)iter.hasNext());
        AbstractBaseIteratorTest.assertTrue((boolean)iter.hasNext());
        AbstractBaseIteratorTest.assertTrue((boolean)iter.hasNext());
        AbstractBaseIteratorTest.assertEquals((int)1, (int)((Integer)iter.next()));
        AbstractBaseIteratorTest.assertFalse((boolean)iter.hasNext());
        AbstractBaseIteratorTest.assertFalse((boolean)iter.hasNext());
        try {
            iter.next();
            AbstractBaseIteratorTest.fail((String)"no exception thrown");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testSneakyThrow() throws Exception {
        AbstractBaseIterator<Integer> iter;
        block4: {
            iter = new AbstractBaseIterator<Integer>(){
                boolean haveBeenCalled;

                public Integer computeNext() {
                    if (this.haveBeenCalled) {
                        Assert.fail((String)"Should not have been called again");
                    } else {
                        this.haveBeenCalled = true;
                        AbstractBaseIteratorTest.sneakyThrow(new SomeCheckedException());
                    }
                    return null;
                }
            };
            try {
                iter.hasNext();
                AbstractBaseIteratorTest.fail((String)"No exception thrown");
            }
            catch (Exception e) {
                if (e instanceof SomeCheckedException) break block4;
                throw e;
            }
        }
        try {
            iter.hasNext();
            AbstractBaseIteratorTest.fail((String)"No exception thrown");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testException() {
        final SomeUncheckedException exception = new SomeUncheckedException();
        AbstractBaseIterator<Integer> iter = new AbstractBaseIterator<Integer>(){

            public Integer computeNext() {
                throw exception;
            }
        };
        try {
            iter.hasNext();
            AbstractBaseIteratorTest.fail((String)"No exception thrown");
        }
        catch (SomeUncheckedException e) {
            AbstractBaseIteratorTest.assertSame((Object)exception, (Object)e);
        }
    }

    public void testExceptionAfterEndOfData() {
        AbstractBaseIterator<Integer> iter = new AbstractBaseIterator<Integer>(){

            public Integer computeNext() {
                this.endOfData();
                throw new SomeUncheckedException();
            }
        };
        try {
            iter.hasNext();
            AbstractBaseIteratorTest.fail((String)"No exception thrown");
        }
        catch (SomeUncheckedException someUncheckedException) {
            // empty catch block
        }
    }

    public void testCantRemove() {
        AbstractBaseIterator<Integer> iter = new AbstractBaseIterator<Integer>(){
            boolean haveBeenCalled;

            public Integer computeNext() {
                if (this.haveBeenCalled) {
                    this.endOfData();
                }
                this.haveBeenCalled = true;
                return 0;
            }
        };
        AbstractBaseIteratorTest.assertEquals((int)0, (int)((Integer)iter.next()));
        try {
            iter.remove();
            AbstractBaseIteratorTest.fail((String)"No exception thrown");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @GwtIncompatible
    public void testFreesNextReference() {
        AbstractBaseIterator<Object> itr = new AbstractBaseIterator<Object>(){

            public Object computeNext() {
                return new Object();
            }
        };
        WeakReference ref = new WeakReference(itr.next());
        GcFinalization.awaitClear(ref);
    }

    public void testReentrantHasNext() {
        AbstractBaseIterator<Integer> iter = new AbstractBaseIterator<Integer>(){

            protected Integer computeNext() {
                boolean unused = this.hasNext();
                return null;
            }
        };
        try {
            iter.hasNext();
            AbstractBaseIteratorTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private static void sneakyThrow(Throwable t) {
        class SneakyThrower<T extends Throwable> {
            SneakyThrower() {
            }

            void throwIt(Throwable t) throws T {
                throw t;
            }
        }
        new SneakyThrower().throwIt(t);
    }

    private static class SomeUncheckedException
    extends RuntimeException {
        private SomeUncheckedException() {
        }
    }

    private static class SomeCheckedException
    extends Exception {
        private SomeCheckedException() {
        }
    }
}

