/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.testing.NullPointerTester;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;

@GwtCompatible(emulated=true)
public class JoinerTest
extends TestCase {
    private static final Joiner J = Joiner.on((String)"-");
    private static final Iterable<Integer> ITERABLE_ = Arrays.asList(new Integer[0]);
    private static final Iterable<Integer> ITERABLE_1 = Arrays.asList(1);
    private static final Iterable<Integer> ITERABLE_12 = Arrays.asList(1, 2);
    private static final Iterable<Integer> ITERABLE_123 = Arrays.asList(1, 2, 3);
    private static final Iterable<Integer> ITERABLE_NULL = Arrays.asList(new Integer[]{null});
    private static final Iterable<Integer> ITERABLE_NULL_NULL = Arrays.asList(null, null);
    private static final Iterable<Integer> ITERABLE_NULL_1 = Arrays.asList(null, 1);
    private static final Iterable<Integer> ITERABLE_1_NULL = Arrays.asList(1, null);
    private static final Iterable<Integer> ITERABLE_1_NULL_2 = Arrays.asList(1, null, 2);
    private static final Iterable<Integer> ITERABLE_FOUR_NULLS = Arrays.asList(null, null, null, null);
    private static final Appendable NASTY_APPENDABLE = new Appendable(){

        @Override
        public Appendable append(CharSequence csq) throws IOException {
            throw new IOException();
        }

        @Override
        public Appendable append(CharSequence csq, int start, int end) throws IOException {
            throw new IOException();
        }

        @Override
        public Appendable append(char c) throws IOException {
            throw new IOException();
        }
    };

    public void testNoSpecialNullBehavior() {
        JoinerTest.checkNoOutput(J, ITERABLE_);
        JoinerTest.checkResult(J, ITERABLE_1, "1");
        JoinerTest.checkResult(J, ITERABLE_12, "1-2");
        JoinerTest.checkResult(J, ITERABLE_123, "1-2-3");
        try {
            J.join(ITERABLE_NULL);
            JoinerTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            J.join(ITERABLE_1_NULL_2);
            JoinerTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            J.join(ITERABLE_NULL.iterator());
            JoinerTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            J.join(ITERABLE_1_NULL_2.iterator());
            JoinerTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testOnCharOverride() {
        Joiner onChar = Joiner.on((char)'-');
        JoinerTest.checkNoOutput(onChar, ITERABLE_);
        JoinerTest.checkResult(onChar, ITERABLE_1, "1");
        JoinerTest.checkResult(onChar, ITERABLE_12, "1-2");
        JoinerTest.checkResult(onChar, ITERABLE_123, "1-2-3");
    }

    public void testSkipNulls() {
        Joiner skipNulls = J.skipNulls();
        JoinerTest.checkNoOutput(skipNulls, ITERABLE_);
        JoinerTest.checkNoOutput(skipNulls, ITERABLE_NULL);
        JoinerTest.checkNoOutput(skipNulls, ITERABLE_NULL_NULL);
        JoinerTest.checkNoOutput(skipNulls, ITERABLE_FOUR_NULLS);
        JoinerTest.checkResult(skipNulls, ITERABLE_1, "1");
        JoinerTest.checkResult(skipNulls, ITERABLE_12, "1-2");
        JoinerTest.checkResult(skipNulls, ITERABLE_123, "1-2-3");
        JoinerTest.checkResult(skipNulls, ITERABLE_NULL_1, "1");
        JoinerTest.checkResult(skipNulls, ITERABLE_1_NULL, "1");
        JoinerTest.checkResult(skipNulls, ITERABLE_1_NULL_2, "1-2");
    }

    public void testUseForNull() {
        Joiner zeroForNull = J.useForNull("0");
        JoinerTest.checkNoOutput(zeroForNull, ITERABLE_);
        JoinerTest.checkResult(zeroForNull, ITERABLE_1, "1");
        JoinerTest.checkResult(zeroForNull, ITERABLE_12, "1-2");
        JoinerTest.checkResult(zeroForNull, ITERABLE_123, "1-2-3");
        JoinerTest.checkResult(zeroForNull, ITERABLE_NULL, "0");
        JoinerTest.checkResult(zeroForNull, ITERABLE_NULL_NULL, "0-0");
        JoinerTest.checkResult(zeroForNull, ITERABLE_NULL_1, "0-1");
        JoinerTest.checkResult(zeroForNull, ITERABLE_1_NULL, "1-0");
        JoinerTest.checkResult(zeroForNull, ITERABLE_1_NULL_2, "1-0-2");
        JoinerTest.checkResult(zeroForNull, ITERABLE_FOUR_NULLS, "0-0-0-0");
    }

    private static void checkNoOutput(Joiner joiner, Iterable<Integer> set) {
        JoinerTest.assertEquals((String)"", (String)joiner.join(set));
        JoinerTest.assertEquals((String)"", (String)joiner.join(set.iterator()));
        Object[] array = Lists.newArrayList(set).toArray(new Integer[0]);
        JoinerTest.assertEquals((String)"", (String)joiner.join(array));
        StringBuilder sb1FromIterable = new StringBuilder();
        JoinerTest.assertSame((Object)sb1FromIterable, (Object)joiner.appendTo(sb1FromIterable, set));
        JoinerTest.assertEquals((int)0, (int)sb1FromIterable.length());
        StringBuilder sb1FromIterator = new StringBuilder();
        JoinerTest.assertSame((Object)sb1FromIterator, (Object)joiner.appendTo(sb1FromIterator, set));
        JoinerTest.assertEquals((int)0, (int)sb1FromIterator.length());
        StringBuilder sb2 = new StringBuilder();
        JoinerTest.assertSame((Object)sb2, (Object)joiner.appendTo(sb2, array));
        JoinerTest.assertEquals((int)0, (int)sb2.length());
        try {
            joiner.appendTo(NASTY_APPENDABLE, set);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        try {
            joiner.appendTo(NASTY_APPENDABLE, set.iterator());
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        try {
            joiner.appendTo(NASTY_APPENDABLE, array);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static void checkResult(Joiner joiner, Iterable<Integer> parts, String expected) {
        JoinerTest.assertEquals((String)expected, (String)joiner.join(parts));
        JoinerTest.assertEquals((String)expected, (String)joiner.join(parts.iterator()));
        StringBuilder sb1FromIterable = new StringBuilder().append('x');
        joiner.appendTo(sb1FromIterable, parts);
        JoinerTest.assertEquals((String)("x" + expected), (String)sb1FromIterable.toString());
        StringBuilder sb1FromIterator = new StringBuilder().append('x');
        joiner.appendTo(sb1FromIterator, parts.iterator());
        JoinerTest.assertEquals((String)("x" + expected), (String)sb1FromIterator.toString());
        Object[] partsArray = Lists.newArrayList(parts).toArray(new Integer[0]);
        JoinerTest.assertEquals((String)expected, (String)joiner.join(partsArray));
        StringBuilder sb2 = new StringBuilder().append('x');
        joiner.appendTo(sb2, partsArray);
        JoinerTest.assertEquals((String)("x" + expected), (String)sb2.toString());
        int num = partsArray.length - 2;
        if (num >= 0) {
            Object[] rest = new Integer[num];
            for (int i = 0; i < num; ++i) {
                rest[i] = partsArray[i + 2];
            }
            JoinerTest.assertEquals((String)expected, (String)joiner.join(partsArray[0], partsArray[1], rest));
            StringBuilder sb3 = new StringBuilder().append('x');
            joiner.appendTo(sb3, partsArray[0], partsArray[1], rest);
            JoinerTest.assertEquals((String)("x" + expected), (String)sb3.toString());
        }
    }

    public void test_useForNull_skipNulls() {
        Joiner j = Joiner.on((String)"x").useForNull("y");
        try {
            j = j.skipNulls();
            JoinerTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void test_skipNulls_useForNull() {
        Joiner j = Joiner.on((String)"x").skipNulls();
        try {
            j = j.useForNull("y");
            JoinerTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void test_useForNull_twice() {
        Joiner j = Joiner.on((String)"x").useForNull("y");
        try {
            j = j.useForNull("y");
            JoinerTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testMap() {
        Joiner.MapJoiner j = Joiner.on((String)";").withKeyValueSeparator(":");
        JoinerTest.assertEquals((String)"", (String)j.join((Map)ImmutableMap.of()));
        JoinerTest.assertEquals((String)":", (String)j.join((Map)ImmutableMap.of((Object)"", (Object)"")));
        LinkedHashMap mapWithNulls = Maps.newLinkedHashMap();
        mapWithNulls.put("a", null);
        mapWithNulls.put(null, "b");
        try {
            j.join((Map)mapWithNulls);
            JoinerTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        JoinerTest.assertEquals((String)"a:00;00:b", (String)j.useForNull("00").join((Map)mapWithNulls));
        StringBuilder sb = new StringBuilder();
        j.appendTo(sb, (Map)ImmutableMap.of((Object)1, (Object)2, (Object)3, (Object)4, (Object)5, (Object)6));
        JoinerTest.assertEquals((String)"1:2;3:4;5:6", (String)sb.toString());
    }

    public void testEntries() {
        Joiner.MapJoiner j = Joiner.on((String)";").withKeyValueSeparator(":");
        JoinerTest.assertEquals((String)"", (String)j.join((Iterable)ImmutableMultimap.of().entries()));
        JoinerTest.assertEquals((String)"", (String)j.join((Iterator)ImmutableMultimap.of().entries().iterator()));
        JoinerTest.assertEquals((String)":", (String)j.join((Iterable)ImmutableMultimap.of((Object)"", (Object)"").entries()));
        JoinerTest.assertEquals((String)":", (String)j.join((Iterator)ImmutableMultimap.of((Object)"", (Object)"").entries().iterator()));
        JoinerTest.assertEquals((String)"1:a;1:b", (String)j.join((Iterable)ImmutableMultimap.of((Object)"1", (Object)"a", (Object)"1", (Object)"b").entries()));
        JoinerTest.assertEquals((String)"1:a;1:b", (String)j.join((Iterator)ImmutableMultimap.of((Object)"1", (Object)"a", (Object)"1", (Object)"b").entries().iterator()));
        LinkedHashMap mapWithNulls = Maps.newLinkedHashMap();
        mapWithNulls.put("a", null);
        mapWithNulls.put(null, "b");
        Set entriesWithNulls = mapWithNulls.entrySet();
        try {
            j.join(entriesWithNulls);
            JoinerTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            j.join(entriesWithNulls.iterator());
            JoinerTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        JoinerTest.assertEquals((String)"a:00;00:b", (String)j.useForNull("00").join(entriesWithNulls));
        JoinerTest.assertEquals((String)"a:00;00:b", (String)j.useForNull("00").join(entriesWithNulls.iterator()));
        StringBuilder sb1 = new StringBuilder();
        j.appendTo(sb1, (Iterable)ImmutableMultimap.of((Object)1, (Object)2, (Object)3, (Object)4, (Object)5, (Object)6, (Object)1, (Object)3, (Object)5, (Object)10).entries());
        JoinerTest.assertEquals((String)"1:2;1:3;3:4;5:6;5:10", (String)sb1.toString());
        StringBuilder sb2 = new StringBuilder();
        j.appendTo(sb2, (Iterator)ImmutableMultimap.of((Object)1, (Object)2, (Object)3, (Object)4, (Object)5, (Object)6, (Object)1, (Object)3, (Object)5, (Object)10).entries().iterator());
        JoinerTest.assertEquals((String)"1:2;1:3;3:4;5:6;5:10", (String)sb2.toString());
    }

    public void test_skipNulls_onMap() {
        Joiner j = Joiner.on((String)",").skipNulls();
        try {
            j.withKeyValueSeparator("/");
            JoinerTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @GwtIncompatible
    public void testDontConvertCharSequenceToString() {
        JoinerTest.assertEquals((String)"foo,foo", (String)Joiner.on((String)",").join((Object)new DontStringMeBro(), (Object)new DontStringMeBro(), new Object[0]));
        JoinerTest.assertEquals((String)"foo,bar,foo", (String)Joiner.on((String)",").useForNull("bar").join((Object)new DontStringMeBro(), null, new Object[]{new DontStringMeBro()}));
    }

    @GwtIncompatible
    public void testNullPointers() {
        NullPointerTester tester = new NullPointerTester();
        tester.testAllPublicStaticMethods(Joiner.class);
        tester.testInstanceMethods((Object)Joiner.on((String)","), NullPointerTester.Visibility.PACKAGE);
        tester.testInstanceMethods((Object)Joiner.on((String)",").skipNulls(), NullPointerTester.Visibility.PACKAGE);
        tester.testInstanceMethods((Object)Joiner.on((String)",").useForNull("x"), NullPointerTester.Visibility.PACKAGE);
        tester.testInstanceMethods((Object)Joiner.on((String)",").withKeyValueSeparator("="), NullPointerTester.Visibility.PACKAGE);
    }

    private static class IterableIterator
    implements Iterable<Integer>,
    Iterator<Integer> {
        private static final ImmutableSet<Integer> INTEGERS = ImmutableSet.of((Object)1, (Object)2, (Object)3, (Object)4);
        private final Iterator<Integer> iterator = this.iterator();

        @Override
        public Iterator<Integer> iterator() {
            return INTEGERS.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Integer next() {
            return this.iterator.next();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    private static class DontStringMeBro
    implements CharSequence {
        private DontStringMeBro() {
        }

        @Override
        public int length() {
            return 3;
        }

        @Override
        public char charAt(int index) {
            return "foo".charAt(index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return "foo".subSequence(start, end);
        }

        @Override
        public String toString() {
            throw new AssertionFailedError("shouldn't be invoked");
        }
    }
}

