/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.cache;

import com.google.common.base.Ticker;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.TestingCacheLoaders;
import com.google.common.testing.FakeTicker;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;

public class CacheRefreshTest
extends TestCase {
    public void testAutoRefresh() {
        FakeTicker ticker = new FakeTicker();
        TestingCacheLoaders.IncrementingLoader loader = TestingCacheLoaders.incrementingLoader();
        LoadingCache cache = CacheBuilder.newBuilder().refreshAfterWrite(3L, TimeUnit.MILLISECONDS).expireAfterWrite(6L, TimeUnit.MILLISECONDS).lenientParsing().ticker((Ticker)ticker).build((CacheLoader)loader);
        int expectedLoads = 0;
        int expectedReloads = 0;
        for (int i = 0; i < 3; ++i) {
            CacheRefreshTest.assertEquals((Object)i, (Object)cache.getUnchecked((Object)i));
            CacheRefreshTest.assertEquals((int)(++expectedLoads), (int)loader.getLoadCount());
            CacheRefreshTest.assertEquals((int)expectedReloads, (int)loader.getReloadCount());
            ticker.advance(1L, TimeUnit.MILLISECONDS);
        }
        CacheRefreshTest.assertEquals((Object)0, (Object)cache.getUnchecked((Object)0));
        CacheRefreshTest.assertEquals((Object)1, (Object)cache.getUnchecked((Object)1));
        CacheRefreshTest.assertEquals((Object)2, (Object)cache.getUnchecked((Object)2));
        CacheRefreshTest.assertEquals((int)expectedLoads, (int)loader.getLoadCount());
        CacheRefreshTest.assertEquals((int)expectedReloads, (int)loader.getReloadCount());
        ticker.advance(1L, TimeUnit.MILLISECONDS);
        CacheRefreshTest.assertEquals((Object)1, (Object)cache.getUnchecked((Object)0));
        CacheRefreshTest.assertEquals((Object)1, (Object)cache.getUnchecked((Object)1));
        CacheRefreshTest.assertEquals((Object)2, (Object)cache.getUnchecked((Object)2));
        CacheRefreshTest.assertEquals((int)expectedLoads, (int)loader.getLoadCount());
        CacheRefreshTest.assertEquals((int)(++expectedReloads), (int)loader.getReloadCount());
        cache.asMap().put(1, -1);
        ticker.advance(1L, TimeUnit.MILLISECONDS);
        CacheRefreshTest.assertEquals((Object)1, (Object)cache.getUnchecked((Object)0));
        CacheRefreshTest.assertEquals((Object)-1, (Object)cache.getUnchecked((Object)1));
        CacheRefreshTest.assertEquals((Object)2, (Object)cache.getUnchecked((Object)2));
        CacheRefreshTest.assertEquals((int)expectedLoads, (int)loader.getLoadCount());
        CacheRefreshTest.assertEquals((int)expectedReloads, (int)loader.getReloadCount());
        ticker.advance(1L, TimeUnit.MILLISECONDS);
        CacheRefreshTest.assertEquals((Object)1, (Object)cache.getUnchecked((Object)0));
        CacheRefreshTest.assertEquals((Object)-1, (Object)cache.getUnchecked((Object)1));
        CacheRefreshTest.assertEquals((Object)3, (Object)cache.getUnchecked((Object)2));
        CacheRefreshTest.assertEquals((int)expectedLoads, (int)loader.getLoadCount());
        CacheRefreshTest.assertEquals((int)(++expectedReloads), (int)loader.getReloadCount());
        ticker.advance(1L, TimeUnit.MILLISECONDS);
        CacheRefreshTest.assertEquals((Object)1, (Object)cache.getUnchecked((Object)0));
        CacheRefreshTest.assertEquals((Object)-1, (Object)cache.getUnchecked((Object)1));
        CacheRefreshTest.assertEquals((Object)3, (Object)cache.getUnchecked((Object)2));
        CacheRefreshTest.assertEquals((int)expectedLoads, (int)loader.getLoadCount());
        CacheRefreshTest.assertEquals((int)expectedReloads, (int)loader.getReloadCount());
        ticker.advance(1L, TimeUnit.MILLISECONDS);
        CacheRefreshTest.assertEquals((Object)2, (Object)cache.getUnchecked((Object)0));
        ++expectedReloads;
        CacheRefreshTest.assertEquals((Object)0, (Object)cache.getUnchecked((Object)1));
        CacheRefreshTest.assertEquals((Object)3, (Object)cache.getUnchecked((Object)2));
        CacheRefreshTest.assertEquals((int)expectedLoads, (int)loader.getLoadCount());
        CacheRefreshTest.assertEquals((int)(++expectedReloads), (int)loader.getReloadCount());
    }
}

