/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.AbstractCollectIterator;
import com.google.common.testing.GcFinalization;
import java.lang.ref.WeakReference;
import java.util.NoSuchElementException;
import junit.framework.Assert;
import junit.framework.TestCase;

@GwtCompatible(emulated=true)
public class AbstractCollectIteratorTest
extends TestCase {
    public void testDefaultBehaviorOfNextAndHasNext() {
        AbstractCollectIterator<Integer> iter = new AbstractCollectIterator<Integer>(){
            private int rep;

            public Integer computeNext() {
                switch (this.rep++) {
                    case 0: {
                        return 0;
                    }
                    case 1: {
                        return 1;
                    }
                    case 2: {
                        return (Integer)this.endOfData();
                    }
                }
                Assert.fail((String)"Should not have been invoked again");
                return null;
            }
        };
        AbstractCollectIteratorTest.assertTrue((boolean)iter.hasNext());
        AbstractCollectIteratorTest.assertEquals((int)0, (int)((Integer)iter.next()));
        AbstractCollectIteratorTest.assertTrue((boolean)iter.hasNext());
        AbstractCollectIteratorTest.assertTrue((boolean)iter.hasNext());
        AbstractCollectIteratorTest.assertTrue((boolean)iter.hasNext());
        AbstractCollectIteratorTest.assertEquals((int)1, (int)((Integer)iter.next()));
        AbstractCollectIteratorTest.assertFalse((boolean)iter.hasNext());
        AbstractCollectIteratorTest.assertFalse((boolean)iter.hasNext());
        try {
            iter.next();
            AbstractCollectIteratorTest.fail((String)"no exception thrown");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testDefaultBehaviorOfPeek() {
        AbstractCollectIterator<Integer> iter = new AbstractCollectIterator<Integer>(){
            private int rep;

            public Integer computeNext() {
                switch (this.rep++) {
                    case 0: {
                        return 0;
                    }
                    case 1: {
                        return 1;
                    }
                    case 2: {
                        return (Integer)this.endOfData();
                    }
                }
                Assert.fail((String)"Should not have been invoked again");
                return null;
            }
        };
        AbstractCollectIteratorTest.assertEquals((int)0, (int)((Integer)iter.peek()));
        AbstractCollectIteratorTest.assertEquals((int)0, (int)((Integer)iter.peek()));
        AbstractCollectIteratorTest.assertTrue((boolean)iter.hasNext());
        AbstractCollectIteratorTest.assertEquals((int)0, (int)((Integer)iter.peek()));
        AbstractCollectIteratorTest.assertEquals((int)0, (int)((Integer)iter.next()));
        AbstractCollectIteratorTest.assertEquals((int)1, (int)((Integer)iter.peek()));
        AbstractCollectIteratorTest.assertEquals((int)1, (int)((Integer)iter.next()));
        try {
            iter.peek();
            AbstractCollectIteratorTest.fail((String)"peek() should throw NoSuchElementException at end");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        try {
            iter.peek();
            AbstractCollectIteratorTest.fail((String)"peek() should continue to throw NoSuchElementException at end");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        try {
            iter.next();
            AbstractCollectIteratorTest.fail((String)"next() should throw NoSuchElementException as usual");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        try {
            iter.peek();
            AbstractCollectIteratorTest.fail((String)"peek() should still throw NoSuchElementException after next()");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @GwtIncompatible
    public void testFreesNextReference() {
        AbstractCollectIterator<Object> itr = new AbstractCollectIterator<Object>(){

            public Object computeNext() {
                return new Object();
            }
        };
        WeakReference ref = new WeakReference(itr.next());
        GcFinalization.awaitClear(ref);
    }

    public void testDefaultBehaviorOfPeekForEmptyIteration() {
        AbstractCollectIterator<Integer> empty = new AbstractCollectIterator<Integer>(){
            private boolean alreadyCalledEndOfData;

            public Integer computeNext() {
                if (this.alreadyCalledEndOfData) {
                    Assert.fail((String)"Should not have been invoked again");
                }
                this.alreadyCalledEndOfData = true;
                return (Integer)this.endOfData();
            }
        };
        try {
            empty.peek();
            AbstractCollectIteratorTest.fail((String)"peek() should throw NoSuchElementException at end");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        try {
            empty.peek();
            AbstractCollectIteratorTest.fail((String)"peek() should continue to throw NoSuchElementException at end");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testSneakyThrow() throws Exception {
        AbstractCollectIterator<Integer> iter;
        block4: {
            iter = new AbstractCollectIterator<Integer>(){
                boolean haveBeenCalled;

                public Integer computeNext() {
                    if (this.haveBeenCalled) {
                        Assert.fail((String)"Should not have been called again");
                    } else {
                        this.haveBeenCalled = true;
                        AbstractCollectIteratorTest.sneakyThrow(new SomeCheckedException());
                    }
                    return null;
                }
            };
            try {
                iter.hasNext();
                AbstractCollectIteratorTest.fail((String)"No exception thrown");
            }
            catch (Exception e) {
                if (e instanceof SomeCheckedException) break block4;
                throw e;
            }
        }
        try {
            iter.hasNext();
            AbstractCollectIteratorTest.fail((String)"No exception thrown");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testException() {
        final SomeUncheckedException exception = new SomeUncheckedException();
        AbstractCollectIterator<Integer> iter = new AbstractCollectIterator<Integer>(){

            public Integer computeNext() {
                throw exception;
            }
        };
        try {
            iter.hasNext();
            AbstractCollectIteratorTest.fail((String)"No exception thrown");
        }
        catch (SomeUncheckedException e) {
            AbstractCollectIteratorTest.assertSame((Object)exception, (Object)e);
        }
    }

    public void testExceptionAfterEndOfData() {
        AbstractCollectIterator<Integer> iter = new AbstractCollectIterator<Integer>(){

            public Integer computeNext() {
                this.endOfData();
                throw new SomeUncheckedException();
            }
        };
        try {
            iter.hasNext();
            AbstractCollectIteratorTest.fail((String)"No exception thrown");
        }
        catch (SomeUncheckedException someUncheckedException) {
            // empty catch block
        }
    }

    public void testCantRemove() {
        AbstractCollectIterator<Integer> iter = new AbstractCollectIterator<Integer>(){
            boolean haveBeenCalled;

            public Integer computeNext() {
                if (this.haveBeenCalled) {
                    this.endOfData();
                }
                this.haveBeenCalled = true;
                return 0;
            }
        };
        AbstractCollectIteratorTest.assertEquals((int)0, (int)((Integer)iter.next()));
        try {
            iter.remove();
            AbstractCollectIteratorTest.fail((String)"No exception thrown");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testReentrantHasNext() {
        AbstractCollectIterator<Integer> iter = new AbstractCollectIterator<Integer>(){

            protected Integer computeNext() {
                this.hasNext();
                return null;
            }
        };
        try {
            iter.hasNext();
            AbstractCollectIteratorTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private static void sneakyThrow(Throwable t) {
        class SneakyThrower<T extends Throwable> {
            SneakyThrower() {
            }

            void throwIt(Throwable t) throws T {
                throw t;
            }
        }
        new SneakyThrower().throwIt(t);
    }

    private static class SomeUncheckedException
    extends RuntimeException {
        private SomeUncheckedException() {
        }
    }

    private static class SomeCheckedException
    extends Exception {
        private SomeCheckedException() {
        }
    }
}

