/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.ForwardingConcurrentMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import junit.framework.TestCase;

public class ForwardingConcurrentMapTest
extends TestCase {
    public void testPutIfAbsent() {
        TestMap map = new TestMap();
        map.put("foo", 1);
        ForwardingConcurrentMapTest.assertEquals((Object)1, (Object)map.putIfAbsent("foo", 2));
        ForwardingConcurrentMapTest.assertEquals((Object)1, (Object)map.get("foo"));
        ForwardingConcurrentMapTest.assertNull((Object)map.putIfAbsent("bar", 3));
        ForwardingConcurrentMapTest.assertEquals((Object)3, (Object)map.get("bar"));
    }

    public void testRemove() {
        TestMap map = new TestMap();
        map.put("foo", 1);
        ForwardingConcurrentMapTest.assertFalse((boolean)map.remove("foo", 2));
        ForwardingConcurrentMapTest.assertFalse((boolean)map.remove("bar", 1));
        ForwardingConcurrentMapTest.assertEquals((Object)1, (Object)map.get("foo"));
        ForwardingConcurrentMapTest.assertTrue((boolean)map.remove("foo", 1));
        ForwardingConcurrentMapTest.assertTrue((boolean)map.isEmpty());
    }

    public void testReplace() {
        TestMap map = new TestMap();
        map.put("foo", 1);
        ForwardingConcurrentMapTest.assertEquals((Object)1, (Object)map.replace("foo", 2));
        ForwardingConcurrentMapTest.assertNull((Object)map.replace("bar", 3));
        ForwardingConcurrentMapTest.assertEquals((Object)2, (Object)map.get("foo"));
        ForwardingConcurrentMapTest.assertFalse((boolean)map.containsKey("bar"));
    }

    public void testReplaceConditional() {
        TestMap map = new TestMap();
        map.put("foo", 1);
        ForwardingConcurrentMapTest.assertFalse((boolean)map.replace("foo", 2, 3));
        ForwardingConcurrentMapTest.assertFalse((boolean)map.replace("bar", 1, 2));
        ForwardingConcurrentMapTest.assertEquals((Object)1, (Object)map.get("foo"));
        ForwardingConcurrentMapTest.assertFalse((boolean)map.containsKey("bar"));
        ForwardingConcurrentMapTest.assertTrue((boolean)map.replace("foo", 1, 4));
        ForwardingConcurrentMapTest.assertEquals((Object)4, (Object)map.get("foo"));
    }

    private static class TestMap
    extends ForwardingConcurrentMap<String, Integer> {
        final ConcurrentMap<String, Integer> delegate = new ConcurrentHashMap<String, Integer>();

        private TestMap() {
        }

        protected ConcurrentMap<String, Integer> delegate() {
            return this.delegate;
        }
    }
}

