/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Objects;
import com.google.common.collect.BoundType;
import com.google.common.collect.GeneralRange;
import com.google.common.collect.Ordering;
import com.google.common.collect.Range;
import com.google.common.testing.NullPointerTester;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import junit.framework.TestCase;

@GwtCompatible(emulated=true)
public class GeneralRangeTest
extends TestCase {
    private static final Ordering<Integer> ORDERING = Ordering.natural().nullsFirst();
    private static final List<Integer> IN_ORDER_VALUES = Arrays.asList(null, 1, 2, 3, 4, 5);

    public void testCreateEmptyRangeFails() {
        for (BoundType lboundType : BoundType.values()) {
            for (BoundType uboundType : BoundType.values()) {
                try {
                    GeneralRange.range(ORDERING, (Object)4, (BoundType)lboundType, (Object)2, (BoundType)uboundType);
                    GeneralRangeTest.fail((String)"Expected IAE");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
    }

    public void testCreateEmptyRangeOpenOpenFails() {
        for (Integer i : IN_ORDER_VALUES) {
            try {
                GeneralRange.range(ORDERING, (Object)i, (BoundType)BoundType.OPEN, (Object)i, (BoundType)BoundType.OPEN);
                GeneralRangeTest.fail((String)"Expected IAE");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    public void testCreateEmptyRangeClosedOpenSucceeds() {
        for (Integer i : IN_ORDER_VALUES) {
            GeneralRange range = GeneralRange.range(ORDERING, (Object)i, (BoundType)BoundType.CLOSED, (Object)i, (BoundType)BoundType.OPEN);
            for (Integer j : IN_ORDER_VALUES) {
                GeneralRangeTest.assertFalse((boolean)range.contains((Object)j));
            }
        }
    }

    public void testCreateEmptyRangeOpenClosedSucceeds() {
        for (Integer i : IN_ORDER_VALUES) {
            GeneralRange range = GeneralRange.range(ORDERING, (Object)i, (BoundType)BoundType.OPEN, (Object)i, (BoundType)BoundType.CLOSED);
            for (Integer j : IN_ORDER_VALUES) {
                GeneralRangeTest.assertFalse((boolean)range.contains((Object)j));
            }
        }
    }

    public void testCreateSingletonRangeSucceeds() {
        for (Integer i : IN_ORDER_VALUES) {
            GeneralRange range = GeneralRange.range(ORDERING, (Object)i, (BoundType)BoundType.CLOSED, (Object)i, (BoundType)BoundType.CLOSED);
            for (Integer j : IN_ORDER_VALUES) {
                GeneralRangeTest.assertEquals((boolean)Objects.equal((Object)i, (Object)j), (boolean)range.contains((Object)j));
            }
        }
    }

    public void testSingletonRange() {
        GeneralRange range = GeneralRange.range(ORDERING, (Object)3, (BoundType)BoundType.CLOSED, (Object)3, (BoundType)BoundType.CLOSED);
        for (Integer i : IN_ORDER_VALUES) {
            GeneralRangeTest.assertEquals((ORDERING.compare((Object)i, (Object)3) == 0 ? 1 : 0) != 0, (boolean)range.contains((Object)i));
        }
    }

    public void testLowerRange() {
        for (BoundType lBoundType : BoundType.values()) {
            GeneralRange range = GeneralRange.downTo(ORDERING, (Object)3, (BoundType)lBoundType);
            for (Integer i : IN_ORDER_VALUES) {
                GeneralRangeTest.assertEquals((ORDERING.compare((Object)i, (Object)3) > 0 || ORDERING.compare((Object)i, (Object)3) == 0 && lBoundType == BoundType.CLOSED ? 1 : 0) != 0, (boolean)range.contains((Object)i));
                GeneralRangeTest.assertEquals((ORDERING.compare((Object)i, (Object)3) < 0 || ORDERING.compare((Object)i, (Object)3) == 0 && lBoundType == BoundType.OPEN ? 1 : 0) != 0, (boolean)range.tooLow((Object)i));
                GeneralRangeTest.assertFalse((boolean)range.tooHigh((Object)i));
            }
        }
    }

    public void testUpperRange() {
        for (BoundType lBoundType : BoundType.values()) {
            GeneralRange range = GeneralRange.upTo(ORDERING, (Object)3, (BoundType)lBoundType);
            for (Integer i : IN_ORDER_VALUES) {
                GeneralRangeTest.assertEquals((ORDERING.compare((Object)i, (Object)3) < 0 || ORDERING.compare((Object)i, (Object)3) == 0 && lBoundType == BoundType.CLOSED ? 1 : 0) != 0, (boolean)range.contains((Object)i));
                GeneralRangeTest.assertEquals((ORDERING.compare((Object)i, (Object)3) > 0 || ORDERING.compare((Object)i, (Object)3) == 0 && lBoundType == BoundType.OPEN ? 1 : 0) != 0, (boolean)range.tooHigh((Object)i));
                GeneralRangeTest.assertFalse((boolean)range.tooLow((Object)i));
            }
        }
    }

    public void testDoublyBoundedAgainstRange() {
        for (BoundType lboundType : BoundType.values()) {
            for (BoundType uboundType : BoundType.values()) {
                Range range = Range.range((Comparable)Integer.valueOf(2), (BoundType)lboundType, (Comparable)Integer.valueOf(4), (BoundType)uboundType);
                GeneralRange gRange = GeneralRange.range(ORDERING, (Object)2, (BoundType)lboundType, (Object)4, (BoundType)uboundType);
                for (Integer i : IN_ORDER_VALUES) {
                    GeneralRangeTest.assertEquals((i != null && range.contains((Comparable)i) ? 1 : 0) != 0, (boolean)gRange.contains((Object)i));
                }
            }
        }
    }

    public void testIntersectAgainstMatchingEndpointsRange() {
        GeneralRange range = GeneralRange.range(ORDERING, (Object)2, (BoundType)BoundType.CLOSED, (Object)4, (BoundType)BoundType.OPEN);
        GeneralRangeTest.assertEquals((Object)GeneralRange.range(ORDERING, (Object)2, (BoundType)BoundType.OPEN, (Object)4, (BoundType)BoundType.OPEN), (Object)range.intersect(GeneralRange.range(ORDERING, (Object)2, (BoundType)BoundType.OPEN, (Object)4, (BoundType)BoundType.CLOSED)));
    }

    public void testIntersectAgainstBiggerRange() {
        GeneralRange range = GeneralRange.range(ORDERING, (Object)2, (BoundType)BoundType.CLOSED, (Object)4, (BoundType)BoundType.OPEN);
        GeneralRangeTest.assertEquals((Object)GeneralRange.range(ORDERING, (Object)2, (BoundType)BoundType.CLOSED, (Object)4, (BoundType)BoundType.OPEN), (Object)range.intersect(GeneralRange.range(ORDERING, null, (BoundType)BoundType.OPEN, (Object)5, (BoundType)BoundType.CLOSED)));
        GeneralRangeTest.assertEquals((Object)GeneralRange.range(ORDERING, (Object)2, (BoundType)BoundType.OPEN, (Object)4, (BoundType)BoundType.OPEN), (Object)range.intersect(GeneralRange.range(ORDERING, (Object)2, (BoundType)BoundType.OPEN, (Object)5, (BoundType)BoundType.CLOSED)));
        GeneralRangeTest.assertEquals((Object)GeneralRange.range(ORDERING, (Object)2, (BoundType)BoundType.CLOSED, (Object)4, (BoundType)BoundType.OPEN), (Object)range.intersect(GeneralRange.range(ORDERING, (Object)1, (BoundType)BoundType.OPEN, (Object)4, (BoundType)BoundType.OPEN)));
    }

    public void testIntersectAgainstSmallerRange() {
        GeneralRange range = GeneralRange.range(ORDERING, (Object)2, (BoundType)BoundType.OPEN, (Object)4, (BoundType)BoundType.OPEN);
        GeneralRangeTest.assertEquals((Object)GeneralRange.range(ORDERING, (Object)3, (BoundType)BoundType.CLOSED, (Object)4, (BoundType)BoundType.OPEN), (Object)range.intersect(GeneralRange.range(ORDERING, (Object)3, (BoundType)BoundType.CLOSED, (Object)4, (BoundType)BoundType.CLOSED)));
    }

    public void testIntersectOverlappingRange() {
        GeneralRange range = GeneralRange.range(ORDERING, (Object)2, (BoundType)BoundType.OPEN, (Object)4, (BoundType)BoundType.CLOSED);
        GeneralRangeTest.assertEquals((Object)GeneralRange.range(ORDERING, (Object)3, (BoundType)BoundType.CLOSED, (Object)4, (BoundType)BoundType.CLOSED), (Object)range.intersect(GeneralRange.range(ORDERING, (Object)3, (BoundType)BoundType.CLOSED, (Object)5, (BoundType)BoundType.CLOSED)));
        GeneralRangeTest.assertEquals((Object)GeneralRange.range(ORDERING, (Object)2, (BoundType)BoundType.OPEN, (Object)3, (BoundType)BoundType.OPEN), (Object)range.intersect(GeneralRange.range(ORDERING, (Object)1, (BoundType)BoundType.OPEN, (Object)3, (BoundType)BoundType.OPEN)));
    }

    public void testIntersectNonOverlappingRange() {
        GeneralRange range = GeneralRange.range(ORDERING, (Object)2, (BoundType)BoundType.OPEN, (Object)4, (BoundType)BoundType.CLOSED);
        GeneralRangeTest.assertTrue((boolean)range.intersect(GeneralRange.range(ORDERING, (Object)5, (BoundType)BoundType.CLOSED, (Object)6, (BoundType)BoundType.CLOSED)).isEmpty());
        GeneralRangeTest.assertTrue((boolean)range.intersect(GeneralRange.range(ORDERING, (Object)1, (BoundType)BoundType.OPEN, (Object)2, (BoundType)BoundType.OPEN)).isEmpty());
    }

    public void testFromRangeAll() {
        GeneralRangeTest.assertEquals((Object)GeneralRange.all((Comparator)Ordering.natural()), (Object)GeneralRange.from((Range)Range.all()));
    }

    public void testFromRangeOneEnd() {
        for (BoundType endpointType : BoundType.values()) {
            GeneralRangeTest.assertEquals((Object)GeneralRange.upTo((Comparator)Ordering.natural(), (Object)3, (BoundType)endpointType), (Object)GeneralRange.from((Range)Range.upTo((Comparable)Integer.valueOf(3), (BoundType)endpointType)));
            GeneralRangeTest.assertEquals((Object)GeneralRange.downTo((Comparator)Ordering.natural(), (Object)3, (BoundType)endpointType), (Object)GeneralRange.from((Range)Range.downTo((Comparable)Integer.valueOf(3), (BoundType)endpointType)));
        }
    }

    public void testFromRangeTwoEnds() {
        for (BoundType lowerType : BoundType.values()) {
            for (BoundType upperType : BoundType.values()) {
                GeneralRangeTest.assertEquals((Object)GeneralRange.range((Comparator)Ordering.natural(), (Object)3, (BoundType)lowerType, (Object)4, (BoundType)upperType), (Object)GeneralRange.from((Range)Range.range((Comparable)Integer.valueOf(3), (BoundType)lowerType, (Comparable)Integer.valueOf(4), (BoundType)upperType)));
            }
        }
    }

    public void testReverse() {
        GeneralRangeTest.assertEquals((Object)GeneralRange.all((Comparator)ORDERING.reverse()), (Object)GeneralRange.all(ORDERING).reverse());
        GeneralRangeTest.assertEquals((Object)GeneralRange.downTo((Comparator)ORDERING.reverse(), (Object)3, (BoundType)BoundType.CLOSED), (Object)GeneralRange.upTo(ORDERING, (Object)3, (BoundType)BoundType.CLOSED).reverse());
        GeneralRangeTest.assertEquals((Object)GeneralRange.upTo((Comparator)ORDERING.reverse(), (Object)3, (BoundType)BoundType.OPEN), (Object)GeneralRange.downTo(ORDERING, (Object)3, (BoundType)BoundType.OPEN).reverse());
        GeneralRangeTest.assertEquals((Object)GeneralRange.range((Comparator)ORDERING.reverse(), (Object)5, (BoundType)BoundType.OPEN, (Object)3, (BoundType)BoundType.CLOSED), (Object)GeneralRange.range(ORDERING, (Object)3, (BoundType)BoundType.CLOSED, (Object)5, (BoundType)BoundType.OPEN).reverse());
    }

    @GwtIncompatible
    public void testNullPointers() {
        new NullPointerTester().testAllPublicStaticMethods(GeneralRange.class);
    }
}

