/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.MultimapTestSuiteBuilder;
import com.google.common.collect.testing.google.SetMultimapTestSuiteBuilder;
import com.google.common.collect.testing.google.TestSetMultimapGenerator;
import com.google.common.collect.testing.google.TestStringSetMultimapGenerator;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

@GwtCompatible(emulated=true)
public class HashMultimapTest
extends TestCase {
    @GwtIncompatible
    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)((MultimapTestSuiteBuilder)((MultimapTestSuiteBuilder)SetMultimapTestSuiteBuilder.using((TestSetMultimapGenerator)new TestStringSetMultimapGenerator(){

            protected SetMultimap<String, String> create(Map.Entry<String, String>[] entries) {
                HashMultimap multimap = HashMultimap.create();
                for (Map.Entry<String, String> entry : entries) {
                    multimap.put((Object)entry.getKey(), (Object)entry.getValue());
                }
                return multimap;
            }
        }).named("HashMultimap")).withFeatures(new Feature[]{MapFeature.ALLOWS_NULL_KEYS, MapFeature.ALLOWS_NULL_VALUES, MapFeature.ALLOWS_ANY_NULL_QUERIES, MapFeature.GENERAL_PURPOSE, MapFeature.FAILS_FAST_ON_CONCURRENT_MODIFICATION, CollectionFeature.SUPPORTS_ITERATOR_REMOVE, CollectionFeature.SERIALIZABLE, CollectionSize.ANY})).createTestSuite());
        suite.addTestSuite(HashMultimapTest.class);
        return suite;
    }

    public void testCreate() {
        HashMultimap multimap = HashMultimap.create();
        multimap.put((Object)"foo", (Object)1);
        multimap.put((Object)"bar", (Object)2);
        multimap.put((Object)"foo", (Object)3);
        HashMultimapTest.assertEquals((Object)ImmutableSet.of((Object)1, (Object)3), (Object)multimap.get((Object)"foo"));
        HashMultimapTest.assertEquals((int)2, (int)multimap.expectedValuesPerKey);
    }

    public void testCreateFromMultimap() {
        HashMultimap multimap = HashMultimap.create();
        multimap.put((Object)"foo", (Object)1);
        multimap.put((Object)"bar", (Object)2);
        multimap.put((Object)"foo", (Object)3);
        HashMultimap copy = HashMultimap.create((Multimap)multimap);
        HashMultimapTest.assertEquals((Object)multimap, (Object)copy);
        HashMultimapTest.assertEquals((int)2, (int)copy.expectedValuesPerKey);
    }

    public void testCreateFromSizes() {
        HashMultimap multimap = HashMultimap.create((int)20, (int)15);
        multimap.put((Object)"foo", (Object)1);
        multimap.put((Object)"bar", (Object)2);
        multimap.put((Object)"foo", (Object)3);
        HashMultimapTest.assertEquals((Object)ImmutableSet.of((Object)1, (Object)3), (Object)multimap.get((Object)"foo"));
        HashMultimapTest.assertEquals((int)15, (int)multimap.expectedValuesPerKey);
    }

    public void testCreateFromIllegalSizes() {
        try {
            HashMultimap.create((int)-20, (int)15);
            HashMultimapTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            HashMultimap.create((int)20, (int)-15);
            HashMultimapTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testEmptyMultimapsEqual() {
        HashMultimap setMultimap = HashMultimap.create();
        ArrayListMultimap listMultimap = ArrayListMultimap.create();
        HashMultimapTest.assertTrue((boolean)setMultimap.equals((Object)listMultimap));
        HashMultimapTest.assertTrue((boolean)listMultimap.equals((Object)setMultimap));
    }
}

