/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.caliper.Benchmark;
import com.google.caliper.Param;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;

public class ImmutableListCreationBenchmark {
    @Param(value={"10", "1000", "1000000"})
    int size;
    private static final Object OBJECT = new Object();

    @Benchmark
    int builderAdd(int reps) {
        int size = this.size;
        int dummy = 0;
        for (int rep = 0; rep < reps; ++rep) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < size; ++i) {
                builder.add(OBJECT);
            }
            dummy += builder.build().size();
        }
        return dummy;
    }

    @Benchmark
    int preSizedBuilderAdd(int reps) {
        int size = this.size;
        int dummy = 0;
        for (int rep = 0; rep < reps; ++rep) {
            ImmutableList.Builder builder = new ImmutableList.Builder(size);
            for (int i = 0; i < size; ++i) {
                builder.add(OBJECT);
            }
            dummy += builder.build().size();
        }
        return dummy;
    }

    @Benchmark
    int copyArrayList(int reps) {
        int size = this.size;
        int dummy = 0;
        for (int rep = 0; rep < reps; ++rep) {
            ArrayList builder = Lists.newArrayList();
            for (int i = 0; i < size; ++i) {
                builder.add(OBJECT);
            }
            dummy += ImmutableList.copyOf((Collection)builder).size();
        }
        return dummy;
    }

    @Benchmark
    int copyPreSizedArrayList(int reps) {
        int size = this.size;
        int tmp = 0;
        for (int rep = 0; rep < reps; ++rep) {
            ArrayList builder = Lists.newArrayListWithCapacity((int)size);
            for (int i = 0; i < size; ++i) {
                builder.add(OBJECT);
            }
            tmp += ImmutableList.copyOf((Collection)builder).size();
        }
        return tmp;
    }
}

