/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.ForwardingList;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.PeekingIterator;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.collect.UnmodifiableListIterator;
import com.google.common.collect.testing.AbstractIteratorTester;
import com.google.common.collect.testing.IteratorFeature;
import com.google.common.collect.testing.IteratorTester;
import com.google.common.collect.testing.ListTestSuiteBuilder;
import com.google.common.collect.testing.TestListGenerator;
import com.google.common.collect.testing.TestStringListGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.features.ListFeature;
import com.google.common.testing.NullPointerTester;
import com.google.common.truth.Truth;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.Vector;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

@GwtCompatible(emulated=true)
public class IteratorsTest
extends TestCase {
    @GwtIncompatible
    public static Test suite() {
        TestSuite suite = new TestSuite(IteratorsTest.class.getSimpleName());
        suite.addTest(IteratorsTest.testsForRemoveAllAndRetainAll());
        suite.addTestSuite(IteratorsTest.class);
        return suite;
    }

    public void testEmptyIterator() {
        UnmodifiableIterator iterator = Iterators.emptyIterator();
        IteratorsTest.assertFalse((boolean)iterator.hasNext());
        try {
            iterator.next();
            IteratorsTest.fail((String)"no exception thrown");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        try {
            iterator.remove();
            IteratorsTest.fail((String)"no exception thrown");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testEmptyListIterator() {
        UnmodifiableListIterator iterator = Iterators.emptyListIterator();
        IteratorsTest.assertFalse((boolean)iterator.hasNext());
        IteratorsTest.assertFalse((boolean)iterator.hasPrevious());
        IteratorsTest.assertEquals((int)0, (int)iterator.nextIndex());
        IteratorsTest.assertEquals((int)-1, (int)iterator.previousIndex());
        try {
            iterator.next();
            IteratorsTest.fail((String)"no exception thrown");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        try {
            iterator.previous();
            IteratorsTest.fail((String)"no exception thrown");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        try {
            iterator.remove();
            IteratorsTest.fail((String)"no exception thrown");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            iterator.set("a");
            IteratorsTest.fail((String)"no exception thrown");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            iterator.add("a");
            IteratorsTest.fail((String)"no exception thrown");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testEmptyModifiableIterator() {
        Iterator iterator = Iterators.emptyModifiableIterator();
        IteratorsTest.assertFalse((boolean)iterator.hasNext());
        try {
            iterator.next();
            IteratorsTest.fail((String)"Expected NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        try {
            iterator.remove();
            IteratorsTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testSize0() {
        UnmodifiableIterator iterator = Iterators.emptyIterator();
        IteratorsTest.assertEquals((int)0, (int)Iterators.size((Iterator)iterator));
    }

    public void testSize1() {
        Iterator<Integer> iterator = Collections.singleton(0).iterator();
        IteratorsTest.assertEquals((int)1, (int)Iterators.size(iterator));
    }

    public void testSize_partiallyConsumed() {
        Iterator<Integer> iterator = Arrays.asList(1, 2, 3, 4, 5).iterator();
        iterator.next();
        iterator.next();
        IteratorsTest.assertEquals((int)3, (int)Iterators.size(iterator));
    }

    public void test_contains_nonnull_yes() {
        Iterator<String> set = Arrays.asList("a", null, "b").iterator();
        IteratorsTest.assertTrue((boolean)Iterators.contains(set, (Object)"b"));
    }

    public void test_contains_nonnull_no() {
        Iterator<String> set = Arrays.asList("a", "b").iterator();
        IteratorsTest.assertFalse((boolean)Iterators.contains(set, (Object)"c"));
    }

    public void test_contains_null_yes() {
        Iterator<String> set = Arrays.asList("a", null, "b").iterator();
        IteratorsTest.assertTrue((boolean)Iterators.contains(set, null));
    }

    public void test_contains_null_no() {
        Iterator<String> set = Arrays.asList("a", "b").iterator();
        IteratorsTest.assertFalse((boolean)Iterators.contains(set, null));
    }

    public void testGetOnlyElement_noDefault_valid() {
        Iterator<String> iterator = Collections.singletonList("foo").iterator();
        IteratorsTest.assertEquals((String)"foo", (String)((String)Iterators.getOnlyElement(iterator)));
    }

    public void testGetOnlyElement_noDefault_empty() {
        UnmodifiableIterator iterator = Iterators.emptyIterator();
        try {
            Iterators.getOnlyElement((Iterator)iterator);
            IteratorsTest.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testGetOnlyElement_noDefault_moreThanOneLessThanFiveElements() {
        Iterator<String> iterator = Arrays.asList("one", "two").iterator();
        try {
            Iterators.getOnlyElement(iterator);
            IteratorsTest.fail();
        }
        catch (IllegalArgumentException expected) {
            Truth.assertThat((Throwable)expected).hasMessage("expected one element but was: <one, two>");
        }
    }

    public void testGetOnlyElement_noDefault_fiveElements() {
        Iterator<String> iterator = Arrays.asList("one", "two", "three", "four", "five").iterator();
        try {
            Iterators.getOnlyElement(iterator);
            IteratorsTest.fail();
        }
        catch (IllegalArgumentException expected) {
            Truth.assertThat((Throwable)expected).hasMessage("expected one element but was: <one, two, three, four, five>");
        }
    }

    public void testGetOnlyElement_noDefault_moreThanFiveElements() {
        Iterator<String> iterator = Arrays.asList("one", "two", "three", "four", "five", "six").iterator();
        try {
            Iterators.getOnlyElement(iterator);
            IteratorsTest.fail();
        }
        catch (IllegalArgumentException expected) {
            Truth.assertThat((Throwable)expected).hasMessage("expected one element but was: <one, two, three, four, five, ...>");
        }
    }

    public void testGetOnlyElement_withDefault_singleton() {
        Iterator<String> iterator = Collections.singletonList("foo").iterator();
        IteratorsTest.assertEquals((String)"foo", (String)((String)Iterators.getOnlyElement(iterator, (Object)"bar")));
    }

    public void testGetOnlyElement_withDefault_empty() {
        UnmodifiableIterator iterator = Iterators.emptyIterator();
        IteratorsTest.assertEquals((String)"bar", (String)((String)Iterators.getOnlyElement((Iterator)iterator, (Object)"bar")));
    }

    public void testGetOnlyElement_withDefault_empty_null() {
        UnmodifiableIterator iterator = Iterators.emptyIterator();
        IteratorsTest.assertNull((Object)Iterators.getOnlyElement((Iterator)iterator, null));
    }

    public void testGetOnlyElement_withDefault_two() {
        Iterator<String> iterator = Arrays.asList("foo", "bar").iterator();
        try {
            Iterators.getOnlyElement(iterator, (Object)"x");
            IteratorsTest.fail();
        }
        catch (IllegalArgumentException expected) {
            Truth.assertThat((Throwable)expected).hasMessage("expected one element but was: <foo, bar>");
        }
    }

    @GwtIncompatible
    public void testToArrayEmpty() {
        Iterator iterator = Collections.emptyList().iterator();
        Object[] array = (String[])Iterators.toArray(iterator, String.class);
        IteratorsTest.assertTrue((boolean)Arrays.equals(new String[0], array));
    }

    @GwtIncompatible
    public void testToArraySingleton() {
        Iterator<String> iterator = Collections.singletonList("a").iterator();
        Object[] array = (String[])Iterators.toArray(iterator, String.class);
        IteratorsTest.assertTrue((boolean)Arrays.equals(new String[]{"a"}, array));
    }

    @GwtIncompatible
    public void testToArray() {
        Object[] sourceArray = new String[]{"a", "b", "c"};
        Iterator<String> iterator = Arrays.asList(sourceArray).iterator();
        Object[] newArray = (String[])Iterators.toArray(iterator, String.class);
        IteratorsTest.assertTrue((boolean)Arrays.equals(sourceArray, newArray));
    }

    public void testFilterSimple() {
        Iterator unfiltered = Lists.newArrayList((Object[])new String[]{"foo", "bar"}).iterator();
        UnmodifiableIterator filtered = Iterators.filter(unfiltered, (Predicate)Predicates.equalTo((Object)"foo"));
        List<String> expected = Collections.singletonList("foo");
        ArrayList actual = Lists.newArrayList((Iterator)filtered);
        IteratorsTest.assertEquals(expected, (Object)actual);
    }

    public void testFilterNoMatch() {
        Iterator unfiltered = Lists.newArrayList((Object[])new String[]{"foo", "bar"}).iterator();
        UnmodifiableIterator filtered = Iterators.filter(unfiltered, (Predicate)Predicates.alwaysFalse());
        List expected = Collections.emptyList();
        ArrayList actual = Lists.newArrayList((Iterator)filtered);
        IteratorsTest.assertEquals(expected, (Object)actual);
    }

    public void testFilterMatchAll() {
        Iterator unfiltered = Lists.newArrayList((Object[])new String[]{"foo", "bar"}).iterator();
        UnmodifiableIterator filtered = Iterators.filter(unfiltered, (Predicate)Predicates.alwaysTrue());
        ArrayList expected = Lists.newArrayList((Object[])new String[]{"foo", "bar"});
        ArrayList actual = Lists.newArrayList((Iterator)filtered);
        IteratorsTest.assertEquals((Object)expected, (Object)actual);
    }

    public void testFilterNothing() {
        Iterator unfiltered = Collections.emptyList().iterator();
        UnmodifiableIterator filtered = Iterators.filter(unfiltered, (Predicate)new Predicate<String>(){

            public boolean apply(String s) {
                throw new AssertionFailedError("Should never be evaluated");
            }
        });
        List expected = Collections.emptyList();
        ArrayList actual = Lists.newArrayList((Iterator)filtered);
        IteratorsTest.assertEquals(expected, (Object)actual);
    }

    @GwtIncompatible
    public void testFilterUsingIteratorTester() {
        final List<Integer> list = Arrays.asList(1, 2, 3, 4, 5);
        Predicate<Integer> isEven = new Predicate<Integer>(){

            public boolean apply(Integer integer) {
                return integer % 2 == 0;
            }
        };
        new IteratorTester<Integer>(5, (Iterable)IteratorFeature.UNMODIFIABLE, Arrays.asList(2, 4), AbstractIteratorTester.KnownOrder.KNOWN_ORDER, (Predicate)isEven){
            final /* synthetic */ Predicate val$isEven;
            {
                this.val$isEven = predicate;
                super(x0, x1, x2, x3);
            }

            protected Iterator<Integer> newTargetIterator() {
                return Iterators.filter(list.iterator(), (Predicate)this.val$isEven);
            }
        }.test();
    }

    public void testAny() {
        ArrayList list = Lists.newArrayList();
        Predicate predicate = Predicates.equalTo((Object)"pants");
        IteratorsTest.assertFalse((boolean)Iterators.any(list.iterator(), (Predicate)predicate));
        list.add("cool");
        IteratorsTest.assertFalse((boolean)Iterators.any(list.iterator(), (Predicate)predicate));
        list.add("pants");
        IteratorsTest.assertTrue((boolean)Iterators.any(list.iterator(), (Predicate)predicate));
    }

    public void testAll() {
        ArrayList list = Lists.newArrayList();
        Predicate predicate = Predicates.equalTo((Object)"cool");
        IteratorsTest.assertTrue((boolean)Iterators.all(list.iterator(), (Predicate)predicate));
        list.add("cool");
        IteratorsTest.assertTrue((boolean)Iterators.all(list.iterator(), (Predicate)predicate));
        list.add("pants");
        IteratorsTest.assertFalse((boolean)Iterators.all(list.iterator(), (Predicate)predicate));
    }

    public void testFind_firstElement() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"cool", "pants"});
        Iterator iterator = list.iterator();
        IteratorsTest.assertEquals((String)"cool", (String)((String)Iterators.find(iterator, (Predicate)Predicates.equalTo((Object)"cool"))));
        IteratorsTest.assertEquals((String)"pants", (String)((String)iterator.next()));
    }

    public void testFind_lastElement() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"cool", "pants"});
        Iterator iterator = list.iterator();
        IteratorsTest.assertEquals((String)"pants", (String)((String)Iterators.find(iterator, (Predicate)Predicates.equalTo((Object)"pants"))));
        IteratorsTest.assertFalse((boolean)iterator.hasNext());
    }

    public void testFind_notPresent() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"cool", "pants"});
        Iterator iterator = list.iterator();
        try {
            Iterators.find(iterator, (Predicate)Predicates.alwaysFalse());
            IteratorsTest.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        IteratorsTest.assertFalse((boolean)iterator.hasNext());
    }

    public void testFind_matchAlways() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"cool", "pants"});
        Iterator iterator = list.iterator();
        IteratorsTest.assertEquals((String)"cool", (String)((String)Iterators.find(iterator, (Predicate)Predicates.alwaysTrue())));
    }

    public void testFind_withDefault_first() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"cool", "pants"});
        Iterator iterator = list.iterator();
        IteratorsTest.assertEquals((String)"cool", (String)((String)Iterators.find(iterator, (Predicate)Predicates.equalTo((Object)"cool"), (Object)"woot")));
        IteratorsTest.assertEquals((String)"pants", (String)((String)iterator.next()));
    }

    public void testFind_withDefault_last() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"cool", "pants"});
        Iterator iterator = list.iterator();
        IteratorsTest.assertEquals((String)"pants", (String)((String)Iterators.find(iterator, (Predicate)Predicates.equalTo((Object)"pants"), (Object)"woot")));
        IteratorsTest.assertFalse((boolean)iterator.hasNext());
    }

    public void testFind_withDefault_notPresent() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"cool", "pants"});
        Iterator iterator = list.iterator();
        IteratorsTest.assertEquals((String)"woot", (String)((String)Iterators.find(iterator, (Predicate)Predicates.alwaysFalse(), (Object)"woot")));
        IteratorsTest.assertFalse((boolean)iterator.hasNext());
    }

    public void testFind_withDefault_notPresent_nullReturn() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"cool", "pants"});
        Iterator iterator = list.iterator();
        IteratorsTest.assertNull((Object)Iterators.find(iterator, (Predicate)Predicates.alwaysFalse(), null));
        IteratorsTest.assertFalse((boolean)iterator.hasNext());
    }

    public void testFind_withDefault_matchAlways() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"cool", "pants"});
        Iterator iterator = list.iterator();
        IteratorsTest.assertEquals((String)"cool", (String)((String)Iterators.find(iterator, (Predicate)Predicates.alwaysTrue(), (Object)"woot")));
        IteratorsTest.assertEquals((String)"pants", (String)((String)iterator.next()));
    }

    public void testTryFind_firstElement() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"cool", "pants"});
        Iterator iterator = list.iterator();
        Truth.assertThat((Optional)Iterators.tryFind(iterator, (Predicate)Predicates.equalTo((Object)"cool"))).hasValue((Object)"cool");
    }

    public void testTryFind_lastElement() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"cool", "pants"});
        Iterator iterator = list.iterator();
        Truth.assertThat((Optional)Iterators.tryFind(iterator, (Predicate)Predicates.equalTo((Object)"pants"))).hasValue((Object)"pants");
    }

    public void testTryFind_alwaysTrue() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"cool", "pants"});
        Iterator iterator = list.iterator();
        Truth.assertThat((Optional)Iterators.tryFind(iterator, (Predicate)Predicates.alwaysTrue())).hasValue((Object)"cool");
    }

    public void testTryFind_alwaysFalse_orDefault() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"cool", "pants"});
        Iterator iterator = list.iterator();
        IteratorsTest.assertEquals((String)"woot", (String)((String)Iterators.tryFind(iterator, (Predicate)Predicates.alwaysFalse()).or((Object)"woot")));
        IteratorsTest.assertFalse((boolean)iterator.hasNext());
    }

    public void testTryFind_alwaysFalse_isPresent() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"cool", "pants"});
        Iterator iterator = list.iterator();
        Truth.assertThat((Optional)Iterators.tryFind(iterator, (Predicate)Predicates.alwaysFalse())).isAbsent();
        IteratorsTest.assertFalse((boolean)iterator.hasNext());
    }

    public void testTransform() {
        Iterator<String> input = Arrays.asList("1", "2", "3").iterator();
        Iterator result = Iterators.transform(input, (Function)new Function<String, Integer>(){

            public Integer apply(String from) {
                return Integer.valueOf(from);
            }
        });
        ArrayList actual = Lists.newArrayList((Iterator)result);
        List<Integer> expected = Arrays.asList(1, 2, 3);
        IteratorsTest.assertEquals(expected, (Object)actual);
    }

    public void testTransformRemove() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"1", "2", "3"});
        Iterator input = list.iterator();
        Iterator iterator = Iterators.transform(input, (Function)new Function<String, Integer>(){

            public Integer apply(String from) {
                return Integer.valueOf(from);
            }
        });
        IteratorsTest.assertEquals((Object)1, iterator.next());
        IteratorsTest.assertEquals((Object)2, iterator.next());
        iterator.remove();
        IteratorsTest.assertEquals(Arrays.asList("1", "3"), (Object)list);
    }

    public void testPoorlyBehavedTransform() {
        Iterator<String> input = Arrays.asList("1", null, "3").iterator();
        Iterator result = Iterators.transform(input, (Function)new Function<String, Integer>(){

            public Integer apply(String from) {
                return Integer.valueOf(from);
            }
        });
        result.next();
        try {
            result.next();
            IteratorsTest.fail((String)"Expected NFE");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void testNullFriendlyTransform() {
        Iterator<Integer> input = Arrays.asList(1, 2, null, 3).iterator();
        Iterator result = Iterators.transform(input, (Function)new Function<Integer, String>(){

            public String apply(Integer from) {
                return String.valueOf(from);
            }
        });
        ArrayList actual = Lists.newArrayList((Iterator)result);
        List<String> expected = Arrays.asList("1", "2", "null", "3");
        IteratorsTest.assertEquals(expected, (Object)actual);
    }

    public void testCycleOfEmpty() {
        Iterator cycle = Iterators.cycle((Object[])new String[0]);
        IteratorsTest.assertFalse((boolean)cycle.hasNext());
    }

    public void testCycleOfOne() {
        Iterator cycle = Iterators.cycle((Object[])new String[]{"a"});
        for (int i = 0; i < 3; ++i) {
            IteratorsTest.assertTrue((boolean)cycle.hasNext());
            IteratorsTest.assertEquals((String)"a", (String)((String)cycle.next()));
        }
    }

    public void testCycleOfOneWithRemove() {
        ArrayList iterable = Lists.newArrayList((Object[])new String[]{"a"});
        Iterator cycle = Iterators.cycle((Iterable)iterable);
        IteratorsTest.assertTrue((boolean)cycle.hasNext());
        IteratorsTest.assertEquals((String)"a", (String)((String)cycle.next()));
        cycle.remove();
        IteratorsTest.assertEquals(Collections.emptyList(), (Object)iterable);
        IteratorsTest.assertFalse((boolean)cycle.hasNext());
    }

    public void testCycleOfTwo() {
        Iterator cycle = Iterators.cycle((Object[])new String[]{"a", "b"});
        for (int i = 0; i < 3; ++i) {
            IteratorsTest.assertTrue((boolean)cycle.hasNext());
            IteratorsTest.assertEquals((String)"a", (String)((String)cycle.next()));
            IteratorsTest.assertTrue((boolean)cycle.hasNext());
            IteratorsTest.assertEquals((String)"b", (String)((String)cycle.next()));
        }
    }

    public void testCycleOfTwoWithRemove() {
        ArrayList iterable = Lists.newArrayList((Object[])new String[]{"a", "b"});
        Iterator cycle = Iterators.cycle((Iterable)iterable);
        IteratorsTest.assertTrue((boolean)cycle.hasNext());
        IteratorsTest.assertEquals((String)"a", (String)((String)cycle.next()));
        IteratorsTest.assertTrue((boolean)cycle.hasNext());
        IteratorsTest.assertEquals((String)"b", (String)((String)cycle.next()));
        IteratorsTest.assertTrue((boolean)cycle.hasNext());
        IteratorsTest.assertEquals((String)"a", (String)((String)cycle.next()));
        cycle.remove();
        IteratorsTest.assertEquals(Collections.singletonList("b"), (Object)iterable);
        IteratorsTest.assertTrue((boolean)cycle.hasNext());
        IteratorsTest.assertEquals((String)"b", (String)((String)cycle.next()));
        IteratorsTest.assertTrue((boolean)cycle.hasNext());
        IteratorsTest.assertEquals((String)"b", (String)((String)cycle.next()));
        cycle.remove();
        IteratorsTest.assertEquals(Collections.emptyList(), (Object)iterable);
        IteratorsTest.assertFalse((boolean)cycle.hasNext());
    }

    public void testCycleRemoveWithoutNext() {
        Iterator cycle = Iterators.cycle((Object[])new String[]{"a", "b"});
        IteratorsTest.assertTrue((boolean)cycle.hasNext());
        try {
            cycle.remove();
            IteratorsTest.fail((String)"no exception thrown");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testCycleRemoveSameElementTwice() {
        Iterator cycle = Iterators.cycle((Object[])new String[]{"a", "b"});
        cycle.next();
        cycle.remove();
        try {
            cycle.remove();
            IteratorsTest.fail((String)"no exception thrown");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testCycleWhenRemoveIsNotSupported() {
        List<String> iterable = Arrays.asList("a", "b");
        Iterator cycle = Iterators.cycle(iterable);
        cycle.next();
        try {
            cycle.remove();
            IteratorsTest.fail((String)"no exception thrown");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testCycleRemoveAfterHasNext() {
        ArrayList iterable = Lists.newArrayList((Object[])new String[]{"a"});
        Iterator cycle = Iterators.cycle((Iterable)iterable);
        IteratorsTest.assertTrue((boolean)cycle.hasNext());
        IteratorsTest.assertEquals((String)"a", (String)((String)cycle.next()));
        IteratorsTest.assertTrue((boolean)cycle.hasNext());
        cycle.remove();
        IteratorsTest.assertEquals(Collections.emptyList(), (Object)iterable);
        IteratorsTest.assertFalse((boolean)cycle.hasNext());
    }

    public void testCycleRemoveAfterHasNextExtraPicky() {
        PickyIterable<Object> iterable = new PickyIterable<Object>("a");
        Iterator cycle = Iterators.cycle(iterable);
        IteratorsTest.assertTrue((boolean)cycle.hasNext());
        IteratorsTest.assertEquals((String)"a", (String)((String)cycle.next()));
        IteratorsTest.assertTrue((boolean)cycle.hasNext());
        cycle.remove();
        IteratorsTest.assertTrue((boolean)iterable.elements.isEmpty());
        IteratorsTest.assertFalse((boolean)cycle.hasNext());
    }

    public void testCycleNoSuchElementException() {
        ArrayList iterable = Lists.newArrayList((Object[])new String[]{"a"});
        Iterator cycle = Iterators.cycle((Iterable)iterable);
        IteratorsTest.assertTrue((boolean)cycle.hasNext());
        IteratorsTest.assertEquals((String)"a", (String)((String)cycle.next()));
        cycle.remove();
        IteratorsTest.assertFalse((boolean)cycle.hasNext());
        try {
            cycle.next();
            IteratorsTest.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @GwtIncompatible
    public void testCycleUsingIteratorTester() {
        new IteratorTester<Integer>(5, (Iterable)IteratorFeature.UNMODIFIABLE, Arrays.asList(1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2), AbstractIteratorTester.KnownOrder.KNOWN_ORDER){

            protected Iterator<Integer> newTargetIterator() {
                return Iterators.cycle(Arrays.asList(1, 2));
            }
        }.test();
    }

    @GwtIncompatible
    public void testConcatNoIteratorsYieldsEmpty() {
        new EmptyIteratorTester(){

            protected Iterator<Integer> newTargetIterator() {
                return Iterators.concat((Iterator[])new Iterator[0]);
            }
        }.test();
    }

    @GwtIncompatible
    public void testConcatOneEmptyIteratorYieldsEmpty() {
        new EmptyIteratorTester(){

            protected Iterator<Integer> newTargetIterator() {
                return Iterators.concat((Iterator[])new Iterator[]{IteratorsTest.iterateOver(new Integer[0])});
            }
        }.test();
    }

    @GwtIncompatible
    public void testConcatMultipleEmptyIteratorsYieldsEmpty() {
        new EmptyIteratorTester(){

            protected Iterator<Integer> newTargetIterator() {
                return Iterators.concat((Iterator)IteratorsTest.iterateOver(new Integer[0]), (Iterator)IteratorsTest.iterateOver(new Integer[0]));
            }
        }.test();
    }

    @GwtIncompatible
    public void testConcatSingletonYieldsSingleton() {
        new SingletonIteratorTester(){

            protected Iterator<Integer> newTargetIterator() {
                return Iterators.concat((Iterator[])new Iterator[]{IteratorsTest.iterateOver(new Integer[]{1})});
            }
        }.test();
    }

    @GwtIncompatible
    public void testConcatEmptyAndSingletonAndEmptyYieldsSingleton() {
        new SingletonIteratorTester(){

            protected Iterator<Integer> newTargetIterator() {
                return Iterators.concat((Iterator)IteratorsTest.iterateOver(new Integer[0]), (Iterator)IteratorsTest.iterateOver(new Integer[]{1}), (Iterator)IteratorsTest.iterateOver(new Integer[0]));
            }
        }.test();
    }

    @GwtIncompatible
    public void testConcatSingletonAndSingletonYieldsDoubleton() {
        new DoubletonIteratorTester(){

            protected Iterator<Integer> newTargetIterator() {
                return Iterators.concat((Iterator)IteratorsTest.iterateOver(new Integer[]{1}), (Iterator)IteratorsTest.iterateOver(new Integer[]{2}));
            }
        }.test();
    }

    @GwtIncompatible
    public void testConcatSingletonAndSingletonWithEmptiesYieldsDoubleton() {
        new DoubletonIteratorTester(){

            protected Iterator<Integer> newTargetIterator() {
                return Iterators.concat((Iterator)IteratorsTest.iterateOver(new Integer[]{1}), (Iterator)IteratorsTest.iterateOver(new Integer[0]), (Iterator)IteratorsTest.iterateOver(new Integer[0]), (Iterator)IteratorsTest.iterateOver(new Integer[]{2}));
            }
        }.test();
    }

    @GwtIncompatible
    public void testConcatUnmodifiable() {
        new IteratorTester<Integer>(5, (Iterable)IteratorFeature.UNMODIFIABLE, Arrays.asList(1, 2), AbstractIteratorTester.KnownOrder.KNOWN_ORDER){

            protected Iterator<Integer> newTargetIterator() {
                return Iterators.concat(Arrays.asList(1).iterator(), Arrays.asList(new Integer[0]).iterator(), Arrays.asList(2).iterator());
            }
        }.test();
    }

    public void testConcatContainingNull() {
        Iterator<Iterator> input = Arrays.asList(IteratorsTest.iterateOver(1, 2), null, IteratorsTest.iterateOver(3)).iterator();
        Iterator result = Iterators.concat(input);
        IteratorsTest.assertEquals((int)1, (int)((Integer)result.next()));
        IteratorsTest.assertEquals((int)2, (int)((Integer)result.next()));
        try {
            result.hasNext();
            IteratorsTest.fail((String)"no exception thrown");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            result.next();
            IteratorsTest.fail((String)"no exception thrown");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConcatVarArgsContainingNull() {
        try {
            Iterators.concat((Iterator[])new Iterator[]{IteratorsTest.iterateOver(1, 2), null, IteratorsTest.iterateOver(3), IteratorsTest.iterateOver(4), IteratorsTest.iterateOver(5)});
            IteratorsTest.fail((String)"no exception thrown");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConcatNested_appendToEnd() {
        int nestingDepth = 128;
        Iterator iterator = IteratorsTest.iterateOver(new Integer[0]);
        for (int i = 0; i < 128; ++i) {
            iterator = Iterators.concat(iterator, IteratorsTest.iterateOver(1));
        }
        IteratorsTest.assertEquals((int)128, (int)Iterators.size(iterator));
    }

    public void testConcatNested_appendToBeginning() {
        int nestingDepth = 128;
        Iterator iterator = IteratorsTest.iterateOver(new Integer[0]);
        for (int i = 0; i < 128; ++i) {
            iterator = Iterators.concat(IteratorsTest.iterateOver(1), iterator);
        }
        IteratorsTest.assertEquals((int)128, (int)Iterators.size(iterator));
    }

    public void testAddAllWithEmptyIterator() {
        ArrayList alreadyThere = Lists.newArrayList((Object[])new String[]{"already", "there"});
        boolean changed = Iterators.addAll((Collection)alreadyThere, (Iterator)Iterators.emptyIterator());
        Truth.assertThat((Iterable)alreadyThere).containsExactly(new Object[]{"already", "there"}).inOrder();
        IteratorsTest.assertFalse((boolean)changed);
    }

    public void testAddAllToList() {
        ArrayList alreadyThere = Lists.newArrayList((Object[])new String[]{"already", "there"});
        ArrayList freshlyAdded = Lists.newArrayList((Object[])new String[]{"freshly", "added"});
        boolean changed = Iterators.addAll((Collection)alreadyThere, freshlyAdded.iterator());
        Truth.assertThat((Iterable)alreadyThere).containsExactly(new Object[]{"already", "there", "freshly", "added"});
        IteratorsTest.assertTrue((boolean)changed);
    }

    public void testAddAllToSet() {
        LinkedHashSet alreadyThere = Sets.newLinkedHashSet(Arrays.asList("already", "there"));
        ArrayList oneMore = Lists.newArrayList((Object[])new String[]{"there"});
        boolean changed = Iterators.addAll((Collection)alreadyThere, oneMore.iterator());
        Truth.assertThat((Iterable)alreadyThere).containsExactly(new Object[]{"already", "there"}).inOrder();
        IteratorsTest.assertFalse((boolean)changed);
    }

    @GwtIncompatible
    public void testNullPointerExceptions() {
        NullPointerTester tester = new NullPointerTester();
        tester.testAllPublicStaticMethods(Iterators.class);
    }

    private static Iterator<Integer> iterateOver(Integer ... values) {
        return Lists.newArrayList((Object[])values).iterator();
    }

    public void testElementsEqual() {
        Collection<Object> a = Lists.newArrayList();
        Collection<Object> b = Collections.emptySet();
        IteratorsTest.assertTrue((boolean)Iterators.elementsEqual(a.iterator(), b.iterator()));
        a = Arrays.asList(4, 8, 15, 16, 23, 42);
        b = Arrays.asList(4, 8, 15, 16, 23, 42);
        IteratorsTest.assertTrue((boolean)Iterators.elementsEqual(a.iterator(), b.iterator()));
        a = Arrays.asList(4, 8, null, 16, 23, 42);
        b = Arrays.asList(4, 8, null, 16, 23, 42);
        IteratorsTest.assertTrue((boolean)Iterators.elementsEqual(a.iterator(), b.iterator()));
        a = ImmutableList.of((Object)4, (Object)8, (Object)15, (Object)16, (Object)23, (Object)42);
        b = Arrays.asList(4, 8, 15, 16, 23, 42);
        IteratorsTest.assertTrue((boolean)Iterators.elementsEqual(a.iterator(), b.iterator()));
        a = Arrays.asList(4, 8, 15, 12, 23, 42);
        b = Arrays.asList(4, 8, 15, 16, 23, 42);
        IteratorsTest.assertFalse((boolean)Iterators.elementsEqual(a.iterator(), b.iterator()));
        a = Arrays.asList(4, 8, 15, null, 23, 42);
        b = Arrays.asList(4, 8, 15, 16, 23, 42);
        IteratorsTest.assertFalse((boolean)Iterators.elementsEqual(a.iterator(), b.iterator()));
        IteratorsTest.assertFalse((boolean)Iterators.elementsEqual(b.iterator(), a.iterator()));
        a = Arrays.asList(4, 8, 15, 16, 23);
        b = Arrays.asList(4, 8, 15, 16, 23, 42);
        IteratorsTest.assertFalse((boolean)Iterators.elementsEqual(a.iterator(), b.iterator()));
        IteratorsTest.assertFalse((boolean)Iterators.elementsEqual(b.iterator(), a.iterator()));
        a = Collections.emptySet();
        b = Arrays.asList(4, 8, 15, 16, 23, 42);
        IteratorsTest.assertFalse((boolean)Iterators.elementsEqual(a.iterator(), b.iterator()));
        IteratorsTest.assertFalse((boolean)Iterators.elementsEqual(b.iterator(), a.iterator()));
    }

    public void testPartition_badSize() {
        UnmodifiableIterator source = Iterators.singletonIterator((Object)1);
        try {
            Iterators.partition((Iterator)source, (int)0);
            IteratorsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testPartition_empty() {
        UnmodifiableIterator source = Iterators.emptyIterator();
        UnmodifiableIterator partitions = Iterators.partition((Iterator)source, (int)1);
        IteratorsTest.assertFalse((boolean)partitions.hasNext());
    }

    public void testPartition_singleton1() {
        UnmodifiableIterator source = Iterators.singletonIterator((Object)1);
        UnmodifiableIterator partitions = Iterators.partition((Iterator)source, (int)1);
        IteratorsTest.assertTrue((boolean)partitions.hasNext());
        IteratorsTest.assertTrue((boolean)partitions.hasNext());
        IteratorsTest.assertEquals((Object)ImmutableList.of((Object)1), partitions.next());
        IteratorsTest.assertFalse((boolean)partitions.hasNext());
    }

    public void testPartition_singleton2() {
        UnmodifiableIterator source = Iterators.singletonIterator((Object)1);
        UnmodifiableIterator partitions = Iterators.partition((Iterator)source, (int)2);
        IteratorsTest.assertTrue((boolean)partitions.hasNext());
        IteratorsTest.assertTrue((boolean)partitions.hasNext());
        IteratorsTest.assertEquals((Object)ImmutableList.of((Object)1), partitions.next());
        IteratorsTest.assertFalse((boolean)partitions.hasNext());
    }

    @GwtIncompatible
    public void testPartition_general() {
        new IteratorTester<List<Integer>>(5, (Iterable)IteratorFeature.UNMODIFIABLE, (Iterable)ImmutableList.of(Arrays.asList(1, 2, 3), Arrays.asList(4, 5, 6), Arrays.asList(7)), AbstractIteratorTester.KnownOrder.KNOWN_ORDER){

            protected Iterator<List<Integer>> newTargetIterator() {
                UnmodifiableIterator source = Iterators.forArray((Object[])new Integer[]{1, 2, 3, 4, 5, 6, 7});
                return Iterators.partition((Iterator)source, (int)3);
            }
        }.test();
    }

    public void testPartition_view() {
        List<Integer> list = Arrays.asList(1, 2);
        UnmodifiableIterator partitions = Iterators.partition(list.iterator(), (int)1);
        list.set(0, 3);
        List first = (List)partitions.next();
        list.set(0, 4);
        IteratorsTest.assertEquals((Object)ImmutableList.of((Object)3), (Object)first);
    }

    @GwtIncompatible
    public void testPartitionRandomAccess() {
        Iterator<Integer> source = Arrays.asList(1, 2, 3).iterator();
        UnmodifiableIterator partitions = Iterators.partition(source, (int)2);
        IteratorsTest.assertTrue((boolean)(partitions.next() instanceof RandomAccess));
        IteratorsTest.assertTrue((boolean)(partitions.next() instanceof RandomAccess));
    }

    public void testPaddedPartition_badSize() {
        UnmodifiableIterator source = Iterators.singletonIterator((Object)1);
        try {
            Iterators.paddedPartition((Iterator)source, (int)0);
            IteratorsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testPaddedPartition_empty() {
        UnmodifiableIterator source = Iterators.emptyIterator();
        UnmodifiableIterator partitions = Iterators.paddedPartition((Iterator)source, (int)1);
        IteratorsTest.assertFalse((boolean)partitions.hasNext());
    }

    public void testPaddedPartition_singleton1() {
        UnmodifiableIterator source = Iterators.singletonIterator((Object)1);
        UnmodifiableIterator partitions = Iterators.paddedPartition((Iterator)source, (int)1);
        IteratorsTest.assertTrue((boolean)partitions.hasNext());
        IteratorsTest.assertTrue((boolean)partitions.hasNext());
        IteratorsTest.assertEquals((Object)ImmutableList.of((Object)1), partitions.next());
        IteratorsTest.assertFalse((boolean)partitions.hasNext());
    }

    public void testPaddedPartition_singleton2() {
        UnmodifiableIterator source = Iterators.singletonIterator((Object)1);
        UnmodifiableIterator partitions = Iterators.paddedPartition((Iterator)source, (int)2);
        IteratorsTest.assertTrue((boolean)partitions.hasNext());
        IteratorsTest.assertTrue((boolean)partitions.hasNext());
        IteratorsTest.assertEquals(Arrays.asList(1, null), partitions.next());
        IteratorsTest.assertFalse((boolean)partitions.hasNext());
    }

    @GwtIncompatible
    public void testPaddedPartition_general() {
        new IteratorTester<List<Integer>>(5, (Iterable)IteratorFeature.UNMODIFIABLE, (Iterable)ImmutableList.of(Arrays.asList(1, 2, 3), Arrays.asList(4, 5, 6), Arrays.asList(7, null, null)), AbstractIteratorTester.KnownOrder.KNOWN_ORDER){

            protected Iterator<List<Integer>> newTargetIterator() {
                UnmodifiableIterator source = Iterators.forArray((Object[])new Integer[]{1, 2, 3, 4, 5, 6, 7});
                return Iterators.paddedPartition((Iterator)source, (int)3);
            }
        }.test();
    }

    public void testPaddedPartition_view() {
        List<Integer> list = Arrays.asList(1, 2);
        UnmodifiableIterator partitions = Iterators.paddedPartition(list.iterator(), (int)1);
        list.set(0, 3);
        List first = (List)partitions.next();
        list.set(0, 4);
        IteratorsTest.assertEquals((Object)ImmutableList.of((Object)3), (Object)first);
    }

    public void testPaddedPartitionRandomAccess() {
        Iterator<Integer> source = Arrays.asList(1, 2, 3).iterator();
        UnmodifiableIterator partitions = Iterators.paddedPartition(source, (int)2);
        IteratorsTest.assertTrue((boolean)(partitions.next() instanceof RandomAccess));
        IteratorsTest.assertTrue((boolean)(partitions.next() instanceof RandomAccess));
    }

    public void testForArrayEmpty() {
        Object[] array = new String[]{};
        UnmodifiableIterator iterator = Iterators.forArray((Object[])array);
        IteratorsTest.assertFalse((boolean)iterator.hasNext());
        try {
            iterator.next();
            IteratorsTest.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testForArrayTypical() {
        Object[] array = new String[]{"foo", "bar"};
        UnmodifiableIterator iterator = Iterators.forArray((Object[])array);
        IteratorsTest.assertTrue((boolean)iterator.hasNext());
        IteratorsTest.assertEquals((String)"foo", (String)((String)iterator.next()));
        IteratorsTest.assertTrue((boolean)iterator.hasNext());
        try {
            iterator.remove();
            IteratorsTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        IteratorsTest.assertEquals((String)"bar", (String)((String)iterator.next()));
        IteratorsTest.assertFalse((boolean)iterator.hasNext());
        try {
            iterator.next();
            IteratorsTest.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testForArrayOffset() {
        Object[] array = new String[]{"foo", "bar", "cat", "dog"};
        UnmodifiableListIterator iterator = Iterators.forArray((Object[])array, (int)1, (int)2, (int)0);
        IteratorsTest.assertTrue((boolean)iterator.hasNext());
        IteratorsTest.assertEquals((String)"bar", (String)((String)iterator.next()));
        IteratorsTest.assertTrue((boolean)iterator.hasNext());
        IteratorsTest.assertEquals((String)"cat", (String)((String)iterator.next()));
        IteratorsTest.assertFalse((boolean)iterator.hasNext());
        try {
            Iterators.forArray((Object[])array, (int)2, (int)3, (int)0);
            IteratorsTest.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testForArrayLength0() {
        Object[] array = new String[]{"foo", "bar"};
        IteratorsTest.assertFalse((boolean)Iterators.forArray((Object[])array, (int)0, (int)0, (int)0).hasNext());
        IteratorsTest.assertFalse((boolean)Iterators.forArray((Object[])array, (int)1, (int)0, (int)0).hasNext());
        IteratorsTest.assertFalse((boolean)Iterators.forArray((Object[])array, (int)2, (int)0, (int)0).hasNext());
        try {
            Iterators.forArray((Object[])array, (int)-1, (int)0, (int)0);
            IteratorsTest.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            Iterators.forArray((Object[])array, (int)3, (int)0, (int)0);
            IteratorsTest.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @GwtIncompatible
    public void testForArrayUsingTester() {
        new IteratorTester<Integer>(6, (Iterable)IteratorFeature.UNMODIFIABLE, Arrays.asList(1, 2, 3), AbstractIteratorTester.KnownOrder.KNOWN_ORDER){

            protected Iterator<Integer> newTargetIterator() {
                return Iterators.forArray((Object[])new Integer[]{1, 2, 3});
            }
        }.test();
    }

    @GwtIncompatible
    public void testForArrayWithOffsetUsingTester() {
        new IteratorTester<Integer>(6, (Iterable)IteratorFeature.UNMODIFIABLE, Arrays.asList(1, 2, 3), AbstractIteratorTester.KnownOrder.KNOWN_ORDER){

            protected Iterator<Integer> newTargetIterator() {
                return Iterators.forArray((Object[])new Integer[]{0, 1, 2, 3, 4}, (int)1, (int)3, (int)0);
            }
        }.test();
    }

    public void testForEnumerationEmpty() {
        Enumeration<Integer> enumer = IteratorsTest.enumerate(new Integer[0]);
        UnmodifiableIterator iter = Iterators.forEnumeration(enumer);
        IteratorsTest.assertFalse((boolean)iter.hasNext());
        try {
            iter.next();
            IteratorsTest.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testForEnumerationSingleton() {
        Enumeration<Integer> enumer = IteratorsTest.enumerate(1);
        UnmodifiableIterator iter = Iterators.forEnumeration(enumer);
        IteratorsTest.assertTrue((boolean)iter.hasNext());
        IteratorsTest.assertTrue((boolean)iter.hasNext());
        IteratorsTest.assertEquals((int)1, (int)((Integer)iter.next()));
        try {
            iter.remove();
            IteratorsTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        IteratorsTest.assertFalse((boolean)iter.hasNext());
        try {
            iter.next();
            IteratorsTest.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testForEnumerationTypical() {
        Enumeration<Integer> enumer = IteratorsTest.enumerate(1, 2, 3);
        UnmodifiableIterator iter = Iterators.forEnumeration(enumer);
        IteratorsTest.assertTrue((boolean)iter.hasNext());
        IteratorsTest.assertEquals((int)1, (int)((Integer)iter.next()));
        IteratorsTest.assertTrue((boolean)iter.hasNext());
        IteratorsTest.assertEquals((int)2, (int)((Integer)iter.next()));
        IteratorsTest.assertTrue((boolean)iter.hasNext());
        IteratorsTest.assertEquals((int)3, (int)((Integer)iter.next()));
        IteratorsTest.assertFalse((boolean)iter.hasNext());
    }

    public void testAsEnumerationEmpty() {
        UnmodifiableIterator iter = Iterators.emptyIterator();
        Enumeration enumer = Iterators.asEnumeration((Iterator)iter);
        IteratorsTest.assertFalse((boolean)enumer.hasMoreElements());
        try {
            enumer.nextElement();
            IteratorsTest.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testAsEnumerationSingleton() {
        UnmodifiableIterator iter = ImmutableList.of((Object)1).iterator();
        Enumeration enumer = Iterators.asEnumeration((Iterator)iter);
        IteratorsTest.assertTrue((boolean)enumer.hasMoreElements());
        IteratorsTest.assertTrue((boolean)enumer.hasMoreElements());
        IteratorsTest.assertEquals((int)1, (int)((Integer)enumer.nextElement()));
        IteratorsTest.assertFalse((boolean)enumer.hasMoreElements());
        try {
            enumer.nextElement();
            IteratorsTest.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testAsEnumerationTypical() {
        UnmodifiableIterator iter = ImmutableList.of((Object)1, (Object)2, (Object)3).iterator();
        Enumeration enumer = Iterators.asEnumeration((Iterator)iter);
        IteratorsTest.assertTrue((boolean)enumer.hasMoreElements());
        IteratorsTest.assertEquals((int)1, (int)((Integer)enumer.nextElement()));
        IteratorsTest.assertTrue((boolean)enumer.hasMoreElements());
        IteratorsTest.assertEquals((int)2, (int)((Integer)enumer.nextElement()));
        IteratorsTest.assertTrue((boolean)enumer.hasMoreElements());
        IteratorsTest.assertEquals((int)3, (int)((Integer)enumer.nextElement()));
        IteratorsTest.assertFalse((boolean)enumer.hasMoreElements());
    }

    private static Enumeration<Integer> enumerate(Integer ... ints) {
        Vector<Integer> vector = new Vector<Integer>();
        vector.addAll(Arrays.asList(ints));
        return vector.elements();
    }

    public void testToString() {
        Iterator iterator = Lists.newArrayList((Object[])new String[]{"yam", "bam", "jam", "ham"}).iterator();
        IteratorsTest.assertEquals((String)"[yam, bam, jam, ham]", (String)Iterators.toString(iterator));
    }

    public void testToStringWithNull() {
        Iterator iterator = Lists.newArrayList((Object[])new String[]{"hello", null, "world"}).iterator();
        IteratorsTest.assertEquals((String)"[hello, null, world]", (String)Iterators.toString(iterator));
    }

    public void testToStringEmptyIterator() {
        Iterator iterator = Collections.emptyList().iterator();
        IteratorsTest.assertEquals((String)"[]", (String)Iterators.toString(iterator));
    }

    public void testLimit() {
        ArrayList list = Lists.newArrayList();
        try {
            Iterators.limit(list.iterator(), (int)-1);
            IteratorsTest.fail((String)"expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        IteratorsTest.assertFalse((boolean)Iterators.limit(list.iterator(), (int)0).hasNext());
        IteratorsTest.assertFalse((boolean)Iterators.limit(list.iterator(), (int)1).hasNext());
        list.add("cool");
        IteratorsTest.assertFalse((boolean)Iterators.limit(list.iterator(), (int)0).hasNext());
        IteratorsTest.assertEquals((Object)list, (Object)Lists.newArrayList((Iterator)Iterators.limit(list.iterator(), (int)1)));
        IteratorsTest.assertEquals((Object)list, (Object)Lists.newArrayList((Iterator)Iterators.limit(list.iterator(), (int)2)));
        list.add("pants");
        IteratorsTest.assertFalse((boolean)Iterators.limit(list.iterator(), (int)0).hasNext());
        IteratorsTest.assertEquals((Object)ImmutableList.of((Object)"cool"), (Object)Lists.newArrayList((Iterator)Iterators.limit(list.iterator(), (int)1)));
        IteratorsTest.assertEquals((Object)list, (Object)Lists.newArrayList((Iterator)Iterators.limit(list.iterator(), (int)2)));
        IteratorsTest.assertEquals((Object)list, (Object)Lists.newArrayList((Iterator)Iterators.limit(list.iterator(), (int)3)));
    }

    public void testLimitRemove() {
        ArrayList list = Lists.newArrayList();
        list.add("cool");
        list.add("pants");
        Iterator iterator = Iterators.limit(list.iterator(), (int)1);
        iterator.next();
        iterator.remove();
        IteratorsTest.assertFalse((boolean)iterator.hasNext());
        IteratorsTest.assertEquals((int)1, (int)list.size());
        IteratorsTest.assertEquals((String)"pants", (String)((String)list.get(0)));
    }

    @GwtIncompatible
    public void testLimitUsingIteratorTester() {
        final ArrayList list = Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4, 5});
        new IteratorTester<Integer>(5, (Iterable)IteratorFeature.MODIFIABLE, (Iterable)Lists.newArrayList((Object[])new Integer[]{1, 2, 3}), AbstractIteratorTester.KnownOrder.KNOWN_ORDER){

            protected Iterator<Integer> newTargetIterator() {
                return Iterators.limit(Lists.newArrayList((Iterable)list).iterator(), (int)3);
            }
        }.test();
    }

    public void testGetNext_withDefault_singleton() {
        Iterator<String> iterator = Collections.singletonList("foo").iterator();
        IteratorsTest.assertEquals((String)"foo", (String)((String)Iterators.getNext(iterator, (Object)"bar")));
    }

    public void testGetNext_withDefault_empty() {
        UnmodifiableIterator iterator = Iterators.emptyIterator();
        IteratorsTest.assertEquals((String)"bar", (String)((String)Iterators.getNext((Iterator)iterator, (Object)"bar")));
    }

    public void testGetNext_withDefault_empty_null() {
        UnmodifiableIterator iterator = Iterators.emptyIterator();
        IteratorsTest.assertNull((Object)Iterators.getNext((Iterator)iterator, null));
    }

    public void testGetNext_withDefault_two() {
        Iterator<String> iterator = Arrays.asList("foo", "bar").iterator();
        IteratorsTest.assertEquals((String)"foo", (String)((String)Iterators.getNext(iterator, (Object)"x")));
    }

    public void testGetLast_basic() {
        ArrayList list = Lists.newArrayList();
        list.add("a");
        list.add("b");
        IteratorsTest.assertEquals((String)"b", (String)((String)Iterators.getLast(list.iterator())));
    }

    public void testGetLast_exception() {
        ArrayList list = Lists.newArrayList();
        try {
            Iterators.getLast(list.iterator());
            IteratorsTest.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testGetLast_withDefault_singleton() {
        Iterator<String> iterator = Collections.singletonList("foo").iterator();
        IteratorsTest.assertEquals((String)"foo", (String)((String)Iterators.getLast(iterator, (Object)"bar")));
    }

    public void testGetLast_withDefault_empty() {
        UnmodifiableIterator iterator = Iterators.emptyIterator();
        IteratorsTest.assertEquals((String)"bar", (String)((String)Iterators.getLast((Iterator)iterator, (Object)"bar")));
    }

    public void testGetLast_withDefault_empty_null() {
        UnmodifiableIterator iterator = Iterators.emptyIterator();
        IteratorsTest.assertNull((Object)Iterators.getLast((Iterator)iterator, null));
    }

    public void testGetLast_withDefault_two() {
        Iterator<String> iterator = Arrays.asList("foo", "bar").iterator();
        IteratorsTest.assertEquals((String)"bar", (String)((String)Iterators.getLast(iterator, (Object)"x")));
    }

    public void testGet_basic() {
        ArrayList list = Lists.newArrayList();
        list.add("a");
        list.add("b");
        Iterator iterator = list.iterator();
        IteratorsTest.assertEquals((String)"b", (String)((String)Iterators.get(iterator, (int)1)));
        IteratorsTest.assertFalse((boolean)iterator.hasNext());
    }

    public void testGet_atSize() {
        ArrayList list = Lists.newArrayList();
        list.add("a");
        list.add("b");
        Iterator iterator = list.iterator();
        try {
            Iterators.get(iterator, (int)2);
            IteratorsTest.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        IteratorsTest.assertFalse((boolean)iterator.hasNext());
    }

    public void testGet_pastEnd() {
        ArrayList list = Lists.newArrayList();
        list.add("a");
        list.add("b");
        Iterator iterator = list.iterator();
        try {
            Iterators.get(iterator, (int)5);
            IteratorsTest.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        IteratorsTest.assertFalse((boolean)iterator.hasNext());
    }

    public void testGet_empty() {
        ArrayList list = Lists.newArrayList();
        Iterator iterator = list.iterator();
        try {
            Iterators.get(iterator, (int)0);
            IteratorsTest.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        IteratorsTest.assertFalse((boolean)iterator.hasNext());
    }

    public void testGet_negativeIndex() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"a", "b", "c"});
        Iterator iterator = list.iterator();
        try {
            Iterators.get(iterator, (int)-1);
            IteratorsTest.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testGet_withDefault_basic() {
        ArrayList list = Lists.newArrayList();
        list.add("a");
        list.add("b");
        Iterator iterator = list.iterator();
        IteratorsTest.assertEquals((String)"a", (String)((String)Iterators.get(iterator, (int)0, (Object)"c")));
        IteratorsTest.assertTrue((boolean)iterator.hasNext());
    }

    public void testGet_withDefault_atSize() {
        ArrayList list = Lists.newArrayList();
        list.add("a");
        list.add("b");
        Iterator iterator = list.iterator();
        IteratorsTest.assertEquals((String)"c", (String)((String)Iterators.get(iterator, (int)2, (Object)"c")));
        IteratorsTest.assertFalse((boolean)iterator.hasNext());
    }

    public void testGet_withDefault_pastEnd() {
        ArrayList list = Lists.newArrayList();
        list.add("a");
        list.add("b");
        Iterator iterator = list.iterator();
        IteratorsTest.assertEquals((String)"c", (String)((String)Iterators.get(iterator, (int)3, (Object)"c")));
        IteratorsTest.assertFalse((boolean)iterator.hasNext());
    }

    public void testGet_withDefault_negativeIndex() {
        ArrayList list = Lists.newArrayList();
        list.add("a");
        list.add("b");
        Iterator iterator = list.iterator();
        try {
            Iterators.get(iterator, (int)-1, (Object)"c");
            IteratorsTest.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        IteratorsTest.assertTrue((boolean)iterator.hasNext());
    }

    public void testAdvance_basic() {
        ArrayList list = Lists.newArrayList();
        list.add("a");
        list.add("b");
        Iterator iterator = list.iterator();
        Iterators.advance(iterator, (int)1);
        IteratorsTest.assertEquals((String)"b", (String)((String)iterator.next()));
    }

    public void testAdvance_pastEnd() {
        ArrayList list = Lists.newArrayList();
        list.add("a");
        list.add("b");
        Iterator iterator = list.iterator();
        Iterators.advance(iterator, (int)5);
        IteratorsTest.assertFalse((boolean)iterator.hasNext());
    }

    public void testAdvance_illegalArgument() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"a", "b", "c"});
        Iterator iterator = list.iterator();
        try {
            Iterators.advance(iterator, (int)-1);
            IteratorsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testFrequency() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"a", null, "b", null, "a", null});
        IteratorsTest.assertEquals((int)2, (int)Iterators.frequency(list.iterator(), (Object)"a"));
        IteratorsTest.assertEquals((int)1, (int)Iterators.frequency(list.iterator(), (Object)"b"));
        IteratorsTest.assertEquals((int)0, (int)Iterators.frequency(list.iterator(), (Object)"c"));
        IteratorsTest.assertEquals((int)0, (int)Iterators.frequency(list.iterator(), (Object)4.2));
        IteratorsTest.assertEquals((int)3, (int)Iterators.frequency(list.iterator(), null));
    }

    @GwtIncompatible
    public void testSingletonIterator() {
        new IteratorTester<Integer>(3, (Iterable)IteratorFeature.UNMODIFIABLE, Collections.singleton(1), AbstractIteratorTester.KnownOrder.KNOWN_ORDER){

            protected Iterator<Integer> newTargetIterator() {
                return Iterators.singletonIterator((Object)1);
            }
        }.test();
    }

    public void testRemoveAll() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"a", "b", "c", "d", "e"});
        IteratorsTest.assertTrue((boolean)Iterators.removeAll(list.iterator(), (Collection)Lists.newArrayList((Object[])new String[]{"b", "d", "f"})));
        IteratorsTest.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"a", "c", "e"}), (Object)list);
        IteratorsTest.assertFalse((boolean)Iterators.removeAll(list.iterator(), (Collection)Lists.newArrayList((Object[])new String[]{"x", "y", "z"})));
        IteratorsTest.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"a", "c", "e"}), (Object)list);
    }

    public void testRemoveIf() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"a", "b", "c", "d", "e"});
        IteratorsTest.assertTrue((boolean)Iterators.removeIf(list.iterator(), (Predicate)new Predicate<String>(){

            public boolean apply(String s) {
                return s.equals("b") || s.equals("d") || s.equals("f");
            }
        }));
        IteratorsTest.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"a", "c", "e"}), (Object)list);
        IteratorsTest.assertFalse((boolean)Iterators.removeIf(list.iterator(), (Predicate)new Predicate<String>(){

            public boolean apply(String s) {
                return s.equals("x") || s.equals("y") || s.equals("z");
            }
        }));
        IteratorsTest.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"a", "c", "e"}), (Object)list);
    }

    public void testRetainAll() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"a", "b", "c", "d", "e"});
        IteratorsTest.assertTrue((boolean)Iterators.retainAll(list.iterator(), (Collection)Lists.newArrayList((Object[])new String[]{"b", "d", "f"})));
        IteratorsTest.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"b", "d"}), (Object)list);
        IteratorsTest.assertFalse((boolean)Iterators.retainAll(list.iterator(), (Collection)Lists.newArrayList((Object[])new String[]{"b", "e", "d"})));
        IteratorsTest.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"b", "d"}), (Object)list);
    }

    @GwtIncompatible
    private static Test testsForRemoveAllAndRetainAll() {
        return ((ListTestSuiteBuilder)((ListTestSuiteBuilder)ListTestSuiteBuilder.using((TestListGenerator)new TestStringListGenerator(){

            public List<String> create(String[] elements) {
                final ArrayList delegate = Lists.newArrayList((Object[])elements);
                return new ForwardingList<String>(){

                    protected List<String> delegate() {
                        return delegate;
                    }

                    public boolean removeAll(Collection<?> c) {
                        return Iterators.removeAll((Iterator)this.iterator(), c);
                    }

                    public boolean retainAll(Collection<?> c) {
                        return Iterators.retainAll((Iterator)this.iterator(), c);
                    }
                };
            }
        }).named("ArrayList with Iterators.removeAll and retainAll")).withFeatures(new Feature[]{ListFeature.GENERAL_PURPOSE, CollectionFeature.ALLOWS_NULL_VALUES, CollectionSize.ANY})).createTestSuite();
    }

    public void testConsumingIterator() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"a", "b"});
        Iterator consumingIterator = Iterators.consumingIterator(list.iterator());
        IteratorsTest.assertEquals((String)"Iterators.consumingIterator(...)", (String)consumingIterator.toString());
        Truth.assertThat((Iterable)list).containsExactly(new Object[]{"a", "b"}).inOrder();
        IteratorsTest.assertTrue((boolean)consumingIterator.hasNext());
        Truth.assertThat((Iterable)list).containsExactly(new Object[]{"a", "b"}).inOrder();
        IteratorsTest.assertEquals((String)"a", (String)((String)consumingIterator.next()));
        Truth.assertThat((Iterable)list).contains((Object)"b");
        IteratorsTest.assertTrue((boolean)consumingIterator.hasNext());
        IteratorsTest.assertEquals((String)"b", (String)((String)consumingIterator.next()));
        Truth.assertThat((Iterable)list).isEmpty();
        IteratorsTest.assertFalse((boolean)consumingIterator.hasNext());
    }

    @GwtIncompatible
    public void testConsumingIterator_duelingIterators() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"a", "b"});
        Iterator i1 = Iterators.consumingIterator(list.iterator());
        Iterator i2 = Iterators.consumingIterator(list.iterator());
        i1.next();
        try {
            i2.next();
            IteratorsTest.fail((String)"Concurrent modification should throw an exception.");
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    public void testIndexOf_consumedData() {
        Iterator iterator = Lists.newArrayList((Object[])new String[]{"manny", "mo", "jack"}).iterator();
        IteratorsTest.assertEquals((int)1, (int)Iterators.indexOf(iterator, (Predicate)Predicates.equalTo((Object)"mo")));
        IteratorsTest.assertEquals((String)"jack", (String)((String)iterator.next()));
        IteratorsTest.assertFalse((boolean)iterator.hasNext());
    }

    public void testIndexOf_consumedDataWithDuplicates() {
        Iterator iterator = Lists.newArrayList((Object[])new String[]{"manny", "mo", "mo", "jack"}).iterator();
        IteratorsTest.assertEquals((int)1, (int)Iterators.indexOf(iterator, (Predicate)Predicates.equalTo((Object)"mo")));
        IteratorsTest.assertEquals((String)"mo", (String)((String)iterator.next()));
        IteratorsTest.assertEquals((String)"jack", (String)((String)iterator.next()));
        IteratorsTest.assertFalse((boolean)iterator.hasNext());
    }

    public void testIndexOf_consumedDataNoMatch() {
        Iterator iterator = Lists.newArrayList((Object[])new String[]{"manny", "mo", "mo", "jack"}).iterator();
        IteratorsTest.assertEquals((int)-1, (int)Iterators.indexOf(iterator, (Predicate)Predicates.equalTo((Object)"bob")));
        IteratorsTest.assertFalse((boolean)iterator.hasNext());
    }

    public void testUnmodifiableIteratorShortCircuit() {
        Iterator mod = Lists.newArrayList((Object[])new String[]{"a", "b", "c"}).iterator();
        UnmodifiableIterator unmod = Iterators.unmodifiableIterator(mod);
        IteratorsTest.assertNotSame(mod, (Object)unmod);
        IteratorsTest.assertSame((Object)unmod, (Object)Iterators.unmodifiableIterator((UnmodifiableIterator)unmod));
        IteratorsTest.assertSame((Object)unmod, (Object)Iterators.unmodifiableIterator((Iterator)unmod));
    }

    public void testPeekingIteratorShortCircuit() {
        Iterator nonpeek = Lists.newArrayList((Object[])new String[]{"a", "b", "c"}).iterator();
        PeekingIterator peek = Iterators.peekingIterator(nonpeek);
        IteratorsTest.assertNotSame((Object)peek, nonpeek);
        IteratorsTest.assertSame((Object)peek, (Object)Iterators.peekingIterator((PeekingIterator)peek));
        IteratorsTest.assertSame((Object)peek, (Object)Iterators.peekingIterator((Iterator)peek));
    }

    @GwtIncompatible
    private static abstract class DoubletonIteratorTester
    extends IteratorTester<Integer> {
        protected DoubletonIteratorTester() {
            super(5, (Iterable)IteratorFeature.MODIFIABLE, (Iterable)Lists.newArrayList((Object[])new Integer[]{1, 2}), AbstractIteratorTester.KnownOrder.KNOWN_ORDER);
        }
    }

    @GwtIncompatible
    private static abstract class SingletonIteratorTester
    extends IteratorTester<Integer> {
        protected SingletonIteratorTester() {
            super(3, (Iterable)IteratorFeature.MODIFIABLE, Collections.singleton(1), AbstractIteratorTester.KnownOrder.KNOWN_ORDER);
        }
    }

    @GwtIncompatible
    private static abstract class EmptyIteratorTester
    extends IteratorTester<Integer> {
        protected EmptyIteratorTester() {
            super(3, (Iterable)IteratorFeature.MODIFIABLE, Collections.emptySet(), AbstractIteratorTester.KnownOrder.KNOWN_ORDER);
        }
    }

    private static final class PickyIterable<E>
    implements Iterable<E> {
        final List<E> elements;
        int modCount = 0;

        PickyIterable(E ... elements) {
            this.elements = new ArrayList<E>(Arrays.asList(elements));
        }

        @Override
        public Iterator<E> iterator() {
            return new PickyIterator();
        }

        final class PickyIterator
        implements Iterator<E> {
            int expectedModCount;
            int index;
            boolean canRemove;

            PickyIterator() {
                this.expectedModCount = PickyIterable.this.modCount;
                this.index = 0;
            }

            @Override
            public boolean hasNext() {
                this.checkConcurrentModification();
                return this.index < PickyIterable.this.elements.size();
            }

            @Override
            public E next() {
                this.checkConcurrentModification();
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.canRemove = true;
                return PickyIterable.this.elements.get(this.index++);
            }

            @Override
            public void remove() {
                this.checkConcurrentModification();
                CollectPreconditions.checkRemove((boolean)this.canRemove);
                PickyIterable.this.elements.remove(--this.index);
                this.expectedModCount = ++PickyIterable.this.modCount;
                this.canRemove = false;
            }

            void checkConcurrentModification() {
                if (this.expectedModCount != PickyIterable.this.modCount) {
                    throw new ConcurrentModificationException();
                }
            }
        }
    }
}

