/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Equivalence;
import com.google.common.base.Ticker;
import com.google.common.collect.GenericMapMaker;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.collect.MapMakerInternalMap;
import com.google.common.collect.Maps;
import com.google.common.testing.NullPointerTester;
import com.google.common.truth.Truth;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import junit.framework.TestCase;

public class MapMakerInternalMapTest
extends TestCase {
    static final int SMALL_MAX_SIZE = 315;

    private static <K, V> MapMakerInternalMap<K, V> makeMap(GenericMapMaker<K, V> maker) {
        return new MapMakerInternalMap((MapMaker)maker);
    }

    private static <K, V> MapMakerInternalMap<K, V> makeMap(MapMaker maker) {
        return new MapMakerInternalMap(maker);
    }

    private static MapMaker createMapMaker() {
        MapMaker maker = new MapMaker();
        maker.useCustomMap = true;
        return maker;
    }

    public void testDefaults() {
        MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(MapMakerInternalMapTest.createMapMaker());
        MapMakerInternalMapTest.assertSame((Object)MapMakerInternalMap.Strength.STRONG, (Object)map.keyStrength);
        MapMakerInternalMapTest.assertSame((Object)MapMakerInternalMap.Strength.STRONG, (Object)map.valueStrength);
        MapMakerInternalMapTest.assertSame((Object)map.keyStrength.defaultEquivalence(), (Object)map.keyEquivalence);
        MapMakerInternalMapTest.assertSame((Object)map.valueStrength.defaultEquivalence(), (Object)map.valueEquivalence);
        MapMakerInternalMapTest.assertEquals((long)0L, (long)map.expireAfterAccessNanos);
        MapMakerInternalMapTest.assertEquals((long)0L, (long)map.expireAfterWriteNanos);
        MapMakerInternalMapTest.assertEquals((int)-1, (int)map.maximumSize);
        MapMakerInternalMapTest.assertSame((Object)MapMakerInternalMap.EntryFactory.STRONG, (Object)map.entryFactory);
        MapMakerInternalMapTest.assertSame((Object)GenericMapMaker.NullListener.INSTANCE, (Object)map.removalListener);
        MapMakerInternalMapTest.assertSame((Object)MapMakerInternalMap.DISCARDING_QUEUE, (Object)map.removalNotificationQueue);
        MapMakerInternalMapTest.assertSame((Object)Ticker.systemTicker(), (Object)map.ticker);
        MapMakerInternalMapTest.assertEquals((int)4, (int)map.concurrencyLevel);
        Truth.assertThat((Object[])map.segments).hasLength(4);
        MapMakerInternalMapTest.assertEquals((int)(16 / map.segments.length), (int)map.segments[0].table.length());
        MapMakerInternalMapTest.assertFalse((boolean)map.evictsBySize());
        MapMakerInternalMapTest.assertFalse((boolean)map.expires());
        MapMakerInternalMapTest.assertFalse((boolean)map.expiresAfterWrite());
        MapMakerInternalMapTest.assertFalse((boolean)map.expiresAfterAccess());
    }

    public void testSetKeyEquivalence() {
        Equivalence<Object> testEquivalence = new Equivalence<Object>(){

            protected boolean doEquivalent(Object a, Object b) {
                return false;
            }

            protected int doHash(Object t) {
                return 0;
            }
        };
        MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(MapMakerInternalMapTest.createMapMaker().keyEquivalence((Equivalence)testEquivalence));
        MapMakerInternalMapTest.assertSame((Object)testEquivalence, (Object)map.keyEquivalence);
        MapMakerInternalMapTest.assertSame((Object)map.valueStrength.defaultEquivalence(), (Object)map.valueEquivalence);
    }

    public void testSetConcurrencyLevel() {
        MapMakerInternalMapTest.checkConcurrencyLevel(1, 1);
        MapMakerInternalMapTest.checkConcurrencyLevel(2, 2);
        MapMakerInternalMapTest.checkConcurrencyLevel(3, 4);
        MapMakerInternalMapTest.checkConcurrencyLevel(4, 4);
        MapMakerInternalMapTest.checkConcurrencyLevel(5, 8);
        MapMakerInternalMapTest.checkConcurrencyLevel(6, 8);
        MapMakerInternalMapTest.checkConcurrencyLevel(7, 8);
        MapMakerInternalMapTest.checkConcurrencyLevel(8, 8);
    }

    private static void checkConcurrencyLevel(int concurrencyLevel, int segmentCount) {
        MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(MapMakerInternalMapTest.createMapMaker().concurrencyLevel(concurrencyLevel));
        Truth.assertThat((Object[])map.segments).hasLength(segmentCount);
    }

    public void testSetInitialCapacity() {
        MapMakerInternalMapTest.checkInitialCapacity(1, 0, 1);
        MapMakerInternalMapTest.checkInitialCapacity(1, 1, 1);
        MapMakerInternalMapTest.checkInitialCapacity(1, 2, 2);
        MapMakerInternalMapTest.checkInitialCapacity(1, 3, 4);
        MapMakerInternalMapTest.checkInitialCapacity(1, 4, 4);
        MapMakerInternalMapTest.checkInitialCapacity(1, 5, 8);
        MapMakerInternalMapTest.checkInitialCapacity(1, 6, 8);
        MapMakerInternalMapTest.checkInitialCapacity(1, 7, 8);
        MapMakerInternalMapTest.checkInitialCapacity(1, 8, 8);
        MapMakerInternalMapTest.checkInitialCapacity(2, 0, 1);
        MapMakerInternalMapTest.checkInitialCapacity(2, 1, 1);
        MapMakerInternalMapTest.checkInitialCapacity(2, 2, 1);
        MapMakerInternalMapTest.checkInitialCapacity(2, 3, 2);
        MapMakerInternalMapTest.checkInitialCapacity(2, 4, 2);
        MapMakerInternalMapTest.checkInitialCapacity(2, 5, 4);
        MapMakerInternalMapTest.checkInitialCapacity(2, 6, 4);
        MapMakerInternalMapTest.checkInitialCapacity(2, 7, 4);
        MapMakerInternalMapTest.checkInitialCapacity(2, 8, 4);
        MapMakerInternalMapTest.checkInitialCapacity(4, 0, 1);
        MapMakerInternalMapTest.checkInitialCapacity(4, 1, 1);
        MapMakerInternalMapTest.checkInitialCapacity(4, 2, 1);
        MapMakerInternalMapTest.checkInitialCapacity(4, 3, 1);
        MapMakerInternalMapTest.checkInitialCapacity(4, 4, 1);
        MapMakerInternalMapTest.checkInitialCapacity(4, 5, 2);
        MapMakerInternalMapTest.checkInitialCapacity(4, 6, 2);
        MapMakerInternalMapTest.checkInitialCapacity(4, 7, 2);
        MapMakerInternalMapTest.checkInitialCapacity(4, 8, 2);
    }

    private static void checkInitialCapacity(int concurrencyLevel, int initialCapacity, int segmentSize) {
        MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(MapMakerInternalMapTest.createMapMaker().concurrencyLevel(concurrencyLevel).initialCapacity(initialCapacity));
        for (int i = 0; i < map.segments.length; ++i) {
            MapMakerInternalMapTest.assertEquals((int)segmentSize, (int)map.segments[i].table.length());
        }
    }

    public void testSetMaximumSize() {
        for (int maxSize = 1; maxSize < 8; ++maxSize) {
            MapMakerInternalMapTest.checkMaximumSize(1, 8, maxSize);
            MapMakerInternalMapTest.checkMaximumSize(2, 8, maxSize);
            MapMakerInternalMapTest.checkMaximumSize(4, 8, maxSize);
            MapMakerInternalMapTest.checkMaximumSize(8, 8, maxSize);
        }
        MapMakerInternalMapTest.checkMaximumSize(1, 8, Integer.MAX_VALUE);
        MapMakerInternalMapTest.checkMaximumSize(2, 8, Integer.MAX_VALUE);
        MapMakerInternalMapTest.checkMaximumSize(4, 8, Integer.MAX_VALUE);
        MapMakerInternalMapTest.checkMaximumSize(8, 8, Integer.MAX_VALUE);
        for (int capacity = 0; capacity < 8; ++capacity) {
            MapMakerInternalMapTest.checkMaximumSize(1, capacity, 4);
            MapMakerInternalMapTest.checkMaximumSize(2, capacity, 4);
            MapMakerInternalMapTest.checkMaximumSize(4, capacity, 4);
            MapMakerInternalMapTest.checkMaximumSize(8, capacity, 4);
        }
    }

    private static void checkMaximumSize(int concurrencyLevel, int initialCapacity, int maxSize) {
        MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(MapMakerInternalMapTest.createMapMaker().concurrencyLevel(concurrencyLevel).initialCapacity(initialCapacity).maximumSize(maxSize));
        int totalCapacity = 0;
        for (int i = 0; i < map.segments.length; ++i) {
            totalCapacity += map.segments[i].maxSegmentSize;
        }
        MapMakerInternalMapTest.assertTrue((String)("totalCapcity=" + totalCapacity + ", maxSize=" + maxSize), (totalCapacity <= maxSize ? 1 : 0) != 0);
    }

    public void testSetWeakKeys() {
        MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(MapMakerInternalMapTest.createMapMaker().weakKeys());
        MapMakerInternalMapTest.checkStrength(map, MapMakerInternalMap.Strength.WEAK, MapMakerInternalMap.Strength.STRONG);
        MapMakerInternalMapTest.assertSame((Object)MapMakerInternalMap.EntryFactory.WEAK, (Object)map.entryFactory);
    }

    public void testSetWeakValues() {
        MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(MapMakerInternalMapTest.createMapMaker().weakValues());
        MapMakerInternalMapTest.checkStrength(map, MapMakerInternalMap.Strength.STRONG, MapMakerInternalMap.Strength.WEAK);
        MapMakerInternalMapTest.assertSame((Object)MapMakerInternalMap.EntryFactory.STRONG, (Object)map.entryFactory);
    }

    public void testSetSoftValues() {
        MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(MapMakerInternalMapTest.createMapMaker().softValues());
        MapMakerInternalMapTest.checkStrength(map, MapMakerInternalMap.Strength.STRONG, MapMakerInternalMap.Strength.SOFT);
        MapMakerInternalMapTest.assertSame((Object)MapMakerInternalMap.EntryFactory.STRONG, (Object)map.entryFactory);
    }

    private static void checkStrength(MapMakerInternalMap<Object, Object> map, MapMakerInternalMap.Strength keyStrength, MapMakerInternalMap.Strength valueStrength) {
        MapMakerInternalMapTest.assertSame((Object)keyStrength, (Object)map.keyStrength);
        MapMakerInternalMapTest.assertSame((Object)valueStrength, (Object)map.valueStrength);
        MapMakerInternalMapTest.assertSame((Object)keyStrength.defaultEquivalence(), (Object)map.keyEquivalence);
        MapMakerInternalMapTest.assertSame((Object)valueStrength.defaultEquivalence(), (Object)map.valueEquivalence);
    }

    public void testSetExpireAfterWrite() {
        long duration = 42L;
        TimeUnit unit = TimeUnit.SECONDS;
        MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(MapMakerInternalMapTest.createMapMaker().expireAfterWrite(duration, unit));
        MapMakerInternalMapTest.assertEquals((long)unit.toNanos(duration), (long)map.expireAfterWriteNanos);
    }

    public void testSetExpireAfterAccess() {
        long duration = 42L;
        TimeUnit unit = TimeUnit.SECONDS;
        MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(MapMakerInternalMapTest.createMapMaker().expireAfterAccess(duration, unit));
        MapMakerInternalMapTest.assertEquals((long)unit.toNanos(duration), (long)map.expireAfterAccessNanos);
    }

    public void testSetRemovalListener() {
        MapMaker.RemovalListener<Object, Object> testListener = new MapMaker.RemovalListener<Object, Object>(){

            public void onRemoval(MapMaker.RemovalNotification<Object, Object> notification) {
            }
        };
        MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(MapMakerInternalMapTest.createMapMaker().removalListener((MapMaker.RemovalListener)testListener));
        MapMakerInternalMapTest.assertSame((Object)testListener, (Object)map.removalListener);
    }

    public void testRemovalListener_explicit() {
        QueuingRemovalListener listener = new QueuingRemovalListener();
        MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(MapMakerInternalMapTest.createMapMaker().removalListener(listener));
        MapMakerInternalMapTest.assertTrue((boolean)listener.isEmpty());
        Object one = new Object();
        Object two = new Object();
        Object three = new Object();
        Object four = new Object();
        Object five = new Object();
        Object six = new Object();
        map.put(one, two);
        map.remove(one);
        MapMakerInternalMapTest.assertNotified(listener, one, two, MapMaker.RemovalCause.EXPLICIT);
        map.put(two, three);
        map.remove(two, three);
        MapMakerInternalMapTest.assertNotified(listener, two, three, MapMaker.RemovalCause.EXPLICIT);
        map.put(three, four);
        Iterator i = map.entrySet().iterator();
        i.next();
        i.remove();
        MapMakerInternalMapTest.assertNotified(listener, three, four, MapMaker.RemovalCause.EXPLICIT);
        map.put(four, five);
        i = map.keySet().iterator();
        i.next();
        i.remove();
        MapMakerInternalMapTest.assertNotified(listener, four, five, MapMaker.RemovalCause.EXPLICIT);
        map.put(five, six);
        i = map.values().iterator();
        i.next();
        i.remove();
        MapMakerInternalMapTest.assertNotified(listener, five, six, MapMaker.RemovalCause.EXPLICIT);
        MapMakerInternalMapTest.assertTrue((boolean)listener.isEmpty());
    }

    public void testRemovalListener_replaced() {
        QueuingRemovalListener listener = new QueuingRemovalListener();
        MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(MapMakerInternalMapTest.createMapMaker().removalListener(listener));
        MapMakerInternalMapTest.assertTrue((boolean)listener.isEmpty());
        Object one = new Object();
        Object two = new Object();
        Object three = new Object();
        Object four = new Object();
        Object five = new Object();
        Object six = new Object();
        map.put(one, two);
        map.put(one, three);
        MapMakerInternalMapTest.assertNotified(listener, one, two, MapMaker.RemovalCause.REPLACED);
        ImmutableMap newMap = ImmutableMap.of((Object)one, (Object)four);
        map.putAll((Map)newMap);
        MapMakerInternalMapTest.assertNotified(listener, one, three, MapMaker.RemovalCause.REPLACED);
        map.replace(one, five);
        MapMakerInternalMapTest.assertNotified(listener, one, four, MapMaker.RemovalCause.REPLACED);
        map.replace(one, five, six);
        MapMakerInternalMapTest.assertNotified(listener, one, five, MapMaker.RemovalCause.REPLACED);
    }

    public void testRemovalListener_collected() {
        QueuingRemovalListener listener = new QueuingRemovalListener();
        MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(MapMakerInternalMapTest.createMapMaker().concurrencyLevel(1).softValues().removalListener(listener));
        MapMakerInternalMap.Segment segment = map.segments[0];
        MapMakerInternalMapTest.assertTrue((boolean)listener.isEmpty());
        Object one = new Object();
        Object two = new Object();
        Object three = new Object();
        map.put(one, two);
        map.put(two, three);
        MapMakerInternalMapTest.assertTrue((boolean)listener.isEmpty());
        int hash = map.hash(one);
        MapMakerInternalMap.ReferenceEntry entry = segment.getEntry(one, hash);
        map.reclaimValue(entry.getValueReference());
        MapMakerInternalMapTest.assertNotified(listener, one, two, MapMaker.RemovalCause.COLLECTED);
        MapMakerInternalMapTest.assertTrue((boolean)listener.isEmpty());
    }

    public void testRemovalListener_size() {
        QueuingRemovalListener listener = new QueuingRemovalListener();
        MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(MapMakerInternalMapTest.createMapMaker().concurrencyLevel(1).maximumSize(2).removalListener(listener));
        MapMakerInternalMapTest.assertTrue((boolean)listener.isEmpty());
        Object one = new Object();
        Object two = new Object();
        Object three = new Object();
        Object four = new Object();
        map.put(one, two);
        map.put(two, three);
        MapMakerInternalMapTest.assertTrue((boolean)listener.isEmpty());
        map.put(three, four);
        MapMakerInternalMapTest.assertNotified(listener, one, two, MapMaker.RemovalCause.SIZE);
        MapMakerInternalMapTest.assertTrue((boolean)listener.isEmpty());
    }

    static <K, V> void assertNotified(QueuingRemovalListener<K, V> listener, K key, V value, MapMaker.RemovalCause cause) {
        MapMaker.RemovalNotification notification = (MapMaker.RemovalNotification)listener.remove();
        MapMakerInternalMapTest.assertSame(key, (Object)notification.getKey());
        MapMakerInternalMapTest.assertSame(value, (Object)notification.getValue());
        MapMakerInternalMapTest.assertSame((Object)cause, (Object)notification.getCause());
    }

    public void testNewEntry() {
        for (MapMaker maker : MapMakerInternalMapTest.allEntryTypeMakers()) {
            MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(maker);
            Object keyOne = new Object();
            Object valueOne = new Object();
            int hashOne = map.hash(keyOne);
            MapMakerInternalMap.ReferenceEntry entryOne = map.newEntry(keyOne, hashOne, null);
            MapMakerInternalMap.ValueReference valueRefOne = map.newValueReference(entryOne, valueOne);
            MapMakerInternalMapTest.assertSame((Object)valueOne, (Object)valueRefOne.get());
            entryOne.setValueReference(valueRefOne);
            MapMakerInternalMapTest.assertSame((Object)keyOne, (Object)entryOne.getKey());
            MapMakerInternalMapTest.assertEquals((int)hashOne, (int)entryOne.getHash());
            MapMakerInternalMapTest.assertNull((Object)entryOne.getNext());
            MapMakerInternalMapTest.assertSame((Object)valueRefOne, (Object)entryOne.getValueReference());
            Object keyTwo = new Object();
            Object valueTwo = new Object();
            int hashTwo = map.hash(keyTwo);
            MapMakerInternalMap.ReferenceEntry entryTwo = map.newEntry(keyTwo, hashTwo, entryOne);
            MapMakerInternalMap.ValueReference valueRefTwo = map.newValueReference(entryTwo, valueTwo);
            MapMakerInternalMapTest.assertSame((Object)valueTwo, (Object)valueRefTwo.get());
            entryTwo.setValueReference(valueRefTwo);
            MapMakerInternalMapTest.assertSame((Object)keyTwo, (Object)entryTwo.getKey());
            MapMakerInternalMapTest.assertEquals((int)hashTwo, (int)entryTwo.getHash());
            MapMakerInternalMapTest.assertSame((Object)entryOne, (Object)entryTwo.getNext());
            MapMakerInternalMapTest.assertSame((Object)valueRefTwo, (Object)entryTwo.getValueReference());
        }
    }

    public void testCopyEntry() {
        for (MapMaker maker : MapMakerInternalMapTest.allEntryTypeMakers()) {
            MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(maker);
            Object keyOne = new Object();
            Object valueOne = new Object();
            int hashOne = map.hash(keyOne);
            MapMakerInternalMap.ReferenceEntry entryOne = map.newEntry(keyOne, hashOne, null);
            entryOne.setValueReference(map.newValueReference(entryOne, valueOne));
            Object keyTwo = new Object();
            Object valueTwo = new Object();
            int hashTwo = map.hash(keyTwo);
            MapMakerInternalMap.ReferenceEntry entryTwo = map.newEntry(keyTwo, hashTwo, entryOne);
            entryTwo.setValueReference(map.newValueReference(entryTwo, valueTwo));
            if (map.evictsBySize()) {
                MapMakerInternalMap.connectEvictables((MapMakerInternalMap.ReferenceEntry)entryOne, (MapMakerInternalMap.ReferenceEntry)entryTwo);
            }
            if (map.expires()) {
                MapMakerInternalMap.connectExpirables((MapMakerInternalMap.ReferenceEntry)entryOne, (MapMakerInternalMap.ReferenceEntry)entryTwo);
            }
            MapMakerInternalMapTest.assertConnected(map, entryOne, entryTwo);
            MapMakerInternalMap.ReferenceEntry copyOne = map.copyEntry(entryOne, null);
            MapMakerInternalMapTest.assertSame((Object)keyOne, (Object)entryOne.getKey());
            MapMakerInternalMapTest.assertEquals((int)hashOne, (int)entryOne.getHash());
            MapMakerInternalMapTest.assertNull((Object)entryOne.getNext());
            MapMakerInternalMapTest.assertSame((Object)valueOne, (Object)copyOne.getValueReference().get());
            MapMakerInternalMapTest.assertConnected(map, copyOne, entryTwo);
            MapMakerInternalMap.ReferenceEntry copyTwo = map.copyEntry(entryTwo, copyOne);
            MapMakerInternalMapTest.assertSame((Object)keyTwo, (Object)copyTwo.getKey());
            MapMakerInternalMapTest.assertEquals((int)hashTwo, (int)copyTwo.getHash());
            MapMakerInternalMapTest.assertSame((Object)copyOne, (Object)copyTwo.getNext());
            MapMakerInternalMapTest.assertSame((Object)valueTwo, (Object)copyTwo.getValueReference().get());
            MapMakerInternalMapTest.assertConnected(map, copyOne, copyTwo);
        }
    }

    private static <K, V> void assertConnected(MapMakerInternalMap<K, V> map, MapMakerInternalMap.ReferenceEntry<K, V> one, MapMakerInternalMap.ReferenceEntry<K, V> two) {
        if (map.evictsBySize()) {
            MapMakerInternalMapTest.assertSame(two, (Object)one.getNextEvictable());
        }
        if (map.expires()) {
            MapMakerInternalMapTest.assertSame(two, (Object)one.getNextExpirable());
        }
    }

    public void testSegmentGetAndContains() {
        MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(MapMakerInternalMapTest.createMapMaker().concurrencyLevel(1).expireAfterAccess(99999L, TimeUnit.SECONDS));
        MapMakerInternalMap.Segment segment = map.segments[0];
        Object key = new Object();
        int hash = map.hash(key);
        Object value = new Object();
        AtomicReferenceArray table = segment.table;
        int index = hash & table.length() - 1;
        MapMakerInternalMap.ReferenceEntry entry = map.newEntry(key, hash, null);
        MapMakerInternalMap.ValueReference valueRef = map.newValueReference(entry, value);
        entry.setValueReference(valueRef);
        MapMakerInternalMapTest.assertNull((Object)segment.get(key, hash));
        table.set(index, entry);
        MapMakerInternalMapTest.assertNull((Object)segment.get(key, hash));
        MapMakerInternalMapTest.assertFalse((boolean)segment.containsKey(key, hash));
        MapMakerInternalMapTest.assertFalse((boolean)segment.containsValue(value));
        ++segment.count;
        MapMakerInternalMapTest.assertSame((Object)value, (Object)segment.get(key, hash));
        MapMakerInternalMapTest.assertTrue((boolean)segment.containsKey(key, hash));
        MapMakerInternalMapTest.assertTrue((boolean)segment.containsValue(value));
        MapMakerInternalMapTest.assertNull((Object)segment.get(new Object(), hash));
        DummyEntry nullEntry = DummyEntry.create(null, hash, entry);
        Object nullValue = new Object();
        MapMakerInternalMap.ValueReference nullValueRef = map.newValueReference(nullEntry, nullValue);
        nullEntry.setValueReference(nullValueRef);
        table.set(index, nullEntry);
        MapMakerInternalMapTest.assertSame((Object)value, (Object)segment.get(key, hash));
        MapMakerInternalMapTest.assertTrue((boolean)segment.containsKey(key, hash));
        MapMakerInternalMapTest.assertTrue((boolean)segment.containsValue(value));
        MapMakerInternalMapTest.assertFalse((boolean)segment.containsValue(nullValue));
        DummyEntry dummy = DummyEntry.create(new Object(), hash, entry);
        Object dummyValue = new Object();
        MapMakerInternalMap.ValueReference dummyValueRef = map.newValueReference(dummy, dummyValue);
        dummy.setValueReference(dummyValueRef);
        table.set(index, dummy);
        MapMakerInternalMapTest.assertSame((Object)value, (Object)segment.get(key, hash));
        MapMakerInternalMapTest.assertTrue((boolean)segment.containsKey(key, hash));
        MapMakerInternalMapTest.assertTrue((boolean)segment.containsValue(value));
        MapMakerInternalMapTest.assertTrue((boolean)segment.containsValue(dummyValue));
        dummy = DummyEntry.create(key, hash, entry);
        dummyValue = new Object();
        dummyValueRef = map.newValueReference(dummy, dummyValue);
        dummy.setValueReference(dummyValueRef);
        table.set(index, dummy);
        MapMakerInternalMapTest.assertSame((Object)dummyValue, (Object)segment.get(key, hash));
        MapMakerInternalMapTest.assertTrue((boolean)segment.containsKey(key, hash));
        MapMakerInternalMapTest.assertTrue((boolean)segment.containsValue(value));
        MapMakerInternalMapTest.assertTrue((boolean)segment.containsValue(dummyValue));
        dummy.setExpirationTime(0L);
        MapMakerInternalMapTest.assertNull((Object)segment.get(key, hash));
        MapMakerInternalMapTest.assertFalse((boolean)segment.containsKey(key, hash));
        MapMakerInternalMapTest.assertTrue((boolean)segment.containsValue(value));
        MapMakerInternalMapTest.assertFalse((boolean)segment.containsValue(dummyValue));
    }

    public void testSegmentReplaceValue() {
        MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(MapMakerInternalMapTest.createMapMaker().concurrencyLevel(1).expireAfterAccess(99999L, TimeUnit.SECONDS));
        MapMakerInternalMap.Segment segment = map.segments[0];
        Object key = new Object();
        int hash = map.hash(key);
        Object oldValue = new Object();
        Object newValue = new Object();
        AtomicReferenceArray table = segment.table;
        int index = hash & table.length() - 1;
        DummyEntry<Object, Object> entry = DummyEntry.create(key, hash, null);
        DummyValueReference<Object, Object> oldValueRef = DummyValueReference.create(oldValue, entry);
        entry.setValueReference(oldValueRef);
        MapMakerInternalMapTest.assertFalse((boolean)segment.replace(key, hash, oldValue, newValue));
        MapMakerInternalMapTest.assertEquals((int)0, (int)segment.count);
        table.set(index, entry);
        ++segment.count;
        MapMakerInternalMapTest.assertEquals((int)1, (int)segment.count);
        MapMakerInternalMapTest.assertSame((Object)oldValue, (Object)segment.get(key, hash));
        MapMakerInternalMapTest.assertTrue((boolean)segment.replace(key, hash, oldValue, newValue));
        MapMakerInternalMapTest.assertEquals((int)1, (int)segment.count);
        MapMakerInternalMapTest.assertSame((Object)newValue, (Object)segment.get(key, hash));
        MapMakerInternalMapTest.assertFalse((boolean)segment.replace(key, hash, oldValue, newValue));
        MapMakerInternalMapTest.assertEquals((int)1, (int)segment.count);
        MapMakerInternalMapTest.assertSame((Object)newValue, (Object)segment.get(key, hash));
        entry.setValueReference(oldValueRef);
        MapMakerInternalMapTest.assertSame((Object)oldValue, (Object)segment.get(key, hash));
        oldValueRef.clear(null);
        MapMakerInternalMapTest.assertFalse((boolean)segment.replace(key, hash, oldValue, newValue));
        MapMakerInternalMapTest.assertEquals((int)0, (int)segment.count);
        MapMakerInternalMapTest.assertNull((Object)segment.get(key, hash));
    }

    public void testSegmentReplace() {
        MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(MapMakerInternalMapTest.createMapMaker().concurrencyLevel(1).expireAfterAccess(99999L, TimeUnit.SECONDS));
        MapMakerInternalMap.Segment segment = map.segments[0];
        Object key = new Object();
        int hash = map.hash(key);
        Object oldValue = new Object();
        Object newValue = new Object();
        AtomicReferenceArray table = segment.table;
        int index = hash & table.length() - 1;
        DummyEntry<Object, Object> entry = DummyEntry.create(key, hash, null);
        DummyValueReference<Object, Object> oldValueRef = DummyValueReference.create(oldValue, entry);
        entry.setValueReference(oldValueRef);
        MapMakerInternalMapTest.assertNull((Object)segment.replace(key, hash, newValue));
        MapMakerInternalMapTest.assertEquals((int)0, (int)segment.count);
        table.set(index, entry);
        ++segment.count;
        MapMakerInternalMapTest.assertEquals((int)1, (int)segment.count);
        MapMakerInternalMapTest.assertSame((Object)oldValue, (Object)segment.get(key, hash));
        MapMakerInternalMapTest.assertSame((Object)oldValue, (Object)segment.replace(key, hash, newValue));
        MapMakerInternalMapTest.assertEquals((int)1, (int)segment.count);
        MapMakerInternalMapTest.assertSame((Object)newValue, (Object)segment.get(key, hash));
        entry.setValueReference(oldValueRef);
        MapMakerInternalMapTest.assertSame((Object)oldValue, (Object)segment.get(key, hash));
        oldValueRef.clear(null);
        MapMakerInternalMapTest.assertNull((Object)segment.replace(key, hash, newValue));
        MapMakerInternalMapTest.assertEquals((int)0, (int)segment.count);
        MapMakerInternalMapTest.assertNull((Object)segment.get(key, hash));
    }

    public void testSegmentPut() {
        MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(MapMakerInternalMapTest.createMapMaker().concurrencyLevel(1).expireAfterAccess(99999L, TimeUnit.SECONDS));
        MapMakerInternalMap.Segment segment = map.segments[0];
        Object key = new Object();
        int hash = map.hash(key);
        Object oldValue = new Object();
        Object newValue = new Object();
        MapMakerInternalMapTest.assertEquals((int)0, (int)segment.count);
        MapMakerInternalMapTest.assertNull((Object)segment.put(key, hash, oldValue, false));
        MapMakerInternalMapTest.assertEquals((int)1, (int)segment.count);
        MapMakerInternalMapTest.assertSame((Object)oldValue, (Object)segment.put(key, hash, newValue, false));
        MapMakerInternalMapTest.assertEquals((int)1, (int)segment.count);
        MapMakerInternalMapTest.assertSame((Object)newValue, (Object)segment.get(key, hash));
        MapMakerInternalMap.ReferenceEntry entry = segment.getEntry(key, hash);
        DummyValueReference oldValueRef = DummyValueReference.create(oldValue, entry);
        entry.setValueReference(oldValueRef);
        MapMakerInternalMapTest.assertSame((Object)oldValue, (Object)segment.get(key, hash));
        oldValueRef.clear(null);
        MapMakerInternalMapTest.assertNull((Object)segment.put(key, hash, newValue, false));
        MapMakerInternalMapTest.assertEquals((int)1, (int)segment.count);
        MapMakerInternalMapTest.assertSame((Object)newValue, (Object)segment.get(key, hash));
    }

    public void testSegmentPutIfAbsent() {
        MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(MapMakerInternalMapTest.createMapMaker().concurrencyLevel(1).expireAfterAccess(99999L, TimeUnit.SECONDS));
        MapMakerInternalMap.Segment segment = map.segments[0];
        Object key = new Object();
        int hash = map.hash(key);
        Object oldValue = new Object();
        Object newValue = new Object();
        MapMakerInternalMapTest.assertEquals((int)0, (int)segment.count);
        MapMakerInternalMapTest.assertNull((Object)segment.put(key, hash, oldValue, true));
        MapMakerInternalMapTest.assertEquals((int)1, (int)segment.count);
        MapMakerInternalMapTest.assertSame((Object)oldValue, (Object)segment.put(key, hash, newValue, true));
        MapMakerInternalMapTest.assertEquals((int)1, (int)segment.count);
        MapMakerInternalMapTest.assertSame((Object)oldValue, (Object)segment.get(key, hash));
        MapMakerInternalMap.ReferenceEntry entry = segment.getEntry(key, hash);
        DummyValueReference oldValueRef = DummyValueReference.create(oldValue, entry);
        entry.setValueReference(oldValueRef);
        MapMakerInternalMapTest.assertSame((Object)oldValue, (Object)segment.get(key, hash));
        oldValueRef.clear(null);
        MapMakerInternalMapTest.assertNull((Object)segment.put(key, hash, newValue, true));
        MapMakerInternalMapTest.assertEquals((int)1, (int)segment.count);
        MapMakerInternalMapTest.assertSame((Object)newValue, (Object)segment.get(key, hash));
    }

    public void testSegmentPut_expand() {
        MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(MapMakerInternalMapTest.createMapMaker().concurrencyLevel(1).initialCapacity(1));
        MapMakerInternalMap.Segment segment = map.segments[0];
        MapMakerInternalMapTest.assertEquals((int)1, (int)segment.table.length());
        int count = 1024;
        for (int i = 0; i < count; ++i) {
            Object key = new Object();
            Object value = new Object();
            int hash = map.hash(key);
            MapMakerInternalMapTest.assertNull((Object)segment.put(key, hash, value, false));
            MapMakerInternalMapTest.assertTrue((segment.table.length() > i ? 1 : 0) != 0);
        }
    }

    public void testSegmentPut_evict() {
        int maxSize = 10;
        MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(MapMakerInternalMapTest.createMapMaker().concurrencyLevel(1).maximumSize(maxSize));
        int originalCount = 1024;
        LinkedHashMap originalMap = Maps.newLinkedHashMap();
        for (int i = 0; i < originalCount; ++i) {
            Object key = new Object();
            Object value = new Object();
            map.put(key, value);
            originalMap.put(key, value);
            if (i >= maxSize) {
                Iterator it = originalMap.keySet().iterator();
                it.next();
                it.remove();
            }
            MapMakerInternalMapTest.assertEquals((Object)originalMap, map);
        }
    }

    public void testSegmentRemove() {
        MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(MapMakerInternalMapTest.createMapMaker().concurrencyLevel(1));
        MapMakerInternalMap.Segment segment = map.segments[0];
        Object key = new Object();
        int hash = map.hash(key);
        Object oldValue = new Object();
        AtomicReferenceArray table = segment.table;
        int index = hash & table.length() - 1;
        DummyEntry<Object, Object> entry = DummyEntry.create(key, hash, null);
        DummyValueReference<Object, Object> oldValueRef = DummyValueReference.create(oldValue, entry);
        entry.setValueReference(oldValueRef);
        MapMakerInternalMapTest.assertEquals((int)0, (int)segment.count);
        MapMakerInternalMapTest.assertNull((Object)segment.remove(key, hash));
        MapMakerInternalMapTest.assertEquals((int)0, (int)segment.count);
        table.set(index, entry);
        ++segment.count;
        MapMakerInternalMapTest.assertEquals((int)1, (int)segment.count);
        MapMakerInternalMapTest.assertSame((Object)oldValue, (Object)segment.get(key, hash));
        MapMakerInternalMapTest.assertSame((Object)oldValue, (Object)segment.remove(key, hash));
        MapMakerInternalMapTest.assertEquals((int)0, (int)segment.count);
        MapMakerInternalMapTest.assertNull((Object)segment.get(key, hash));
        table.set(index, entry);
        ++segment.count;
        MapMakerInternalMapTest.assertEquals((int)1, (int)segment.count);
        MapMakerInternalMapTest.assertSame((Object)oldValue, (Object)segment.get(key, hash));
        oldValueRef.clear(null);
        MapMakerInternalMapTest.assertNull((Object)segment.remove(key, hash));
        MapMakerInternalMapTest.assertEquals((int)0, (int)segment.count);
        MapMakerInternalMapTest.assertNull((Object)segment.get(key, hash));
    }

    public void testSegmentRemoveValue() {
        MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(MapMakerInternalMapTest.createMapMaker().concurrencyLevel(1));
        MapMakerInternalMap.Segment segment = map.segments[0];
        Object key = new Object();
        int hash = map.hash(key);
        Object oldValue = new Object();
        Object newValue = new Object();
        AtomicReferenceArray table = segment.table;
        int index = hash & table.length() - 1;
        DummyEntry<Object, Object> entry = DummyEntry.create(key, hash, null);
        DummyValueReference<Object, Object> oldValueRef = DummyValueReference.create(oldValue, entry);
        entry.setValueReference(oldValueRef);
        MapMakerInternalMapTest.assertEquals((int)0, (int)segment.count);
        MapMakerInternalMapTest.assertNull((Object)segment.remove(key, hash));
        MapMakerInternalMapTest.assertEquals((int)0, (int)segment.count);
        table.set(index, entry);
        ++segment.count;
        MapMakerInternalMapTest.assertEquals((int)1, (int)segment.count);
        MapMakerInternalMapTest.assertSame((Object)oldValue, (Object)segment.get(key, hash));
        MapMakerInternalMapTest.assertTrue((boolean)segment.remove(key, hash, oldValue));
        MapMakerInternalMapTest.assertEquals((int)0, (int)segment.count);
        MapMakerInternalMapTest.assertNull((Object)segment.get(key, hash));
        table.set(index, entry);
        ++segment.count;
        MapMakerInternalMapTest.assertEquals((int)1, (int)segment.count);
        MapMakerInternalMapTest.assertSame((Object)oldValue, (Object)segment.get(key, hash));
        MapMakerInternalMapTest.assertFalse((boolean)segment.remove(key, hash, newValue));
        MapMakerInternalMapTest.assertEquals((int)1, (int)segment.count);
        MapMakerInternalMapTest.assertSame((Object)oldValue, (Object)segment.get(key, hash));
        MapMakerInternalMapTest.assertSame((Object)oldValue, (Object)segment.get(key, hash));
        oldValueRef.clear(null);
        MapMakerInternalMapTest.assertFalse((boolean)segment.remove(key, hash, oldValue));
        MapMakerInternalMapTest.assertEquals((int)0, (int)segment.count);
        MapMakerInternalMapTest.assertNull((Object)segment.get(key, hash));
    }

    public void testExpand() {
        MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(MapMakerInternalMapTest.createMapMaker().concurrencyLevel(1).initialCapacity(1));
        MapMakerInternalMap.Segment segment = map.segments[0];
        MapMakerInternalMapTest.assertEquals((int)1, (int)segment.table.length());
        int originalCount = 1024;
        MapMakerInternalMap.ReferenceEntry entry = null;
        for (int i = 0; i < originalCount; ++i) {
            Object key = new Object();
            Object value = new Object();
            int hash = map.hash(key);
            entry = map.newEntry(key, hash, entry);
            MapMakerInternalMap.ValueReference valueRef = map.newValueReference(entry, value);
            entry.setValueReference(valueRef);
        }
        segment.table.set(0, entry);
        segment.count = originalCount;
        ImmutableMap originalMap = ImmutableMap.copyOf(map);
        MapMakerInternalMapTest.assertEquals((int)originalCount, (int)originalMap.size());
        MapMakerInternalMapTest.assertEquals((Object)originalMap, map);
        for (int i = 1; i <= originalCount * 2; i *= 2) {
            if (i > 1) {
                segment.expand();
            }
            MapMakerInternalMapTest.assertEquals((int)i, (int)segment.table.length());
            MapMakerInternalMapTest.assertEquals((int)originalCount, (int)MapMakerInternalMapTest.countLiveEntries(map));
            MapMakerInternalMapTest.assertEquals((int)originalCount, (int)segment.count);
            MapMakerInternalMapTest.assertEquals((Object)originalMap, map);
        }
    }

    public void testReclaimKey() {
        CountingRemovalListener listener = new CountingRemovalListener();
        MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(MapMakerInternalMapTest.createMapMaker().concurrencyLevel(1).initialCapacity(1).maximumSize(315).expireAfterWrite(99999L, TimeUnit.SECONDS).removalListener(listener));
        MapMakerInternalMap.Segment segment = map.segments[0];
        AtomicReferenceArray table = segment.table;
        MapMakerInternalMapTest.assertEquals((int)1, (int)table.length());
        Object keyOne = new Object();
        Object valueOne = new Object();
        int hashOne = map.hash(keyOne);
        DummyEntry<Object, Object> entryOne = MapMakerInternalMapTest.createDummyEntry(keyOne, hashOne, valueOne, null);
        Object keyTwo = new Object();
        Object valueTwo = new Object();
        int hashTwo = map.hash(keyTwo);
        DummyEntry<Object, Object> entryTwo = MapMakerInternalMapTest.createDummyEntry(keyTwo, hashTwo, valueTwo, entryOne);
        Object keyThree = new Object();
        Object valueThree = new Object();
        int hashThree = map.hash(keyThree);
        DummyEntry<Object, Object> entryThree = MapMakerInternalMapTest.createDummyEntry(keyThree, hashThree, valueThree, entryTwo);
        MapMakerInternalMapTest.assertEquals((int)0, (int)listener.getCount());
        MapMakerInternalMapTest.assertFalse((boolean)segment.reclaimKey(entryOne, hashOne));
        MapMakerInternalMapTest.assertEquals((int)0, (int)listener.getCount());
        table.set(0, entryOne);
        MapMakerInternalMapTest.assertFalse((boolean)segment.reclaimKey(entryTwo, hashTwo));
        MapMakerInternalMapTest.assertEquals((int)0, (int)listener.getCount());
        table.set(0, entryTwo);
        MapMakerInternalMapTest.assertFalse((boolean)segment.reclaimKey(entryThree, hashThree));
        MapMakerInternalMapTest.assertEquals((int)0, (int)listener.getCount());
        table.set(0, entryOne);
        segment.count = 1;
        MapMakerInternalMapTest.assertTrue((boolean)segment.reclaimKey(entryOne, hashOne));
        MapMakerInternalMapTest.assertEquals((int)1, (int)listener.getCount());
        MapMakerInternalMapTest.assertSame((Object)keyOne, listener.getLastEvictedKey());
        MapMakerInternalMapTest.assertSame((Object)valueOne, listener.getLastEvictedValue());
        MapMakerInternalMapTest.assertTrue((boolean)map.removalNotificationQueue.isEmpty());
        MapMakerInternalMapTest.assertFalse((boolean)segment.evictionQueue.contains(entryOne));
        MapMakerInternalMapTest.assertFalse((boolean)segment.expirationQueue.contains(entryOne));
        MapMakerInternalMapTest.assertEquals((int)0, (int)segment.count);
        MapMakerInternalMapTest.assertNull(table.get(0));
    }

    public void testRemoveFromChain() {
        MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(MapMakerInternalMapTest.createMapMaker().concurrencyLevel(1));
        MapMakerInternalMap.Segment segment = map.segments[0];
        Object keyOne = new Object();
        Object valueOne = new Object();
        int hashOne = map.hash(keyOne);
        DummyEntry<Object, Object> entryOne = MapMakerInternalMapTest.createDummyEntry(keyOne, hashOne, valueOne, null);
        Object keyTwo = new Object();
        Object valueTwo = new Object();
        int hashTwo = map.hash(keyTwo);
        DummyEntry<Object, Object> entryTwo = MapMakerInternalMapTest.createDummyEntry(keyTwo, hashTwo, valueTwo, entryOne);
        Object keyThree = new Object();
        Object valueThree = new Object();
        int hashThree = map.hash(keyThree);
        DummyEntry<Object, Object> entryThree = MapMakerInternalMapTest.createDummyEntry(keyThree, hashThree, valueThree, entryTwo);
        MapMakerInternalMapTest.assertNull((Object)segment.removeFromChain(entryOne, entryOne));
        MapMakerInternalMapTest.assertSame(entryOne, (Object)segment.removeFromChain(entryTwo, entryTwo));
        MapMakerInternalMap.ReferenceEntry newFirst = segment.removeFromChain(entryThree, entryTwo);
        MapMakerInternalMapTest.assertSame((Object)keyThree, (Object)newFirst.getKey());
        MapMakerInternalMapTest.assertSame((Object)valueThree, (Object)newFirst.getValueReference().get());
        MapMakerInternalMapTest.assertEquals((int)hashThree, (int)newFirst.getHash());
        MapMakerInternalMapTest.assertSame(entryOne, (Object)newFirst.getNext());
        newFirst = segment.removeFromChain(entryThree, entryOne);
        MapMakerInternalMapTest.assertSame((Object)keyTwo, (Object)newFirst.getKey());
        MapMakerInternalMapTest.assertSame((Object)valueTwo, (Object)newFirst.getValueReference().get());
        MapMakerInternalMapTest.assertEquals((int)hashTwo, (int)newFirst.getHash());
        newFirst = newFirst.getNext();
        MapMakerInternalMapTest.assertSame((Object)keyThree, (Object)newFirst.getKey());
        MapMakerInternalMapTest.assertSame((Object)valueThree, (Object)newFirst.getValueReference().get());
        MapMakerInternalMapTest.assertEquals((int)hashThree, (int)newFirst.getHash());
        MapMakerInternalMapTest.assertNull((Object)newFirst.getNext());
    }

    public void testExpand_cleanup() {
        MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(MapMakerInternalMapTest.createMapMaker().concurrencyLevel(1).initialCapacity(1));
        MapMakerInternalMap.Segment segment = map.segments[0];
        MapMakerInternalMapTest.assertEquals((int)1, (int)segment.table.length());
        int originalCount = 1024;
        DummyEntry entry = null;
        for (int i = 0; i < originalCount; ++i) {
            Object key = new Object();
            Object value = i % 3 == 0 ? null : new Object();
            int hash = map.hash(key);
            if (i % 3 == 1) {
                key = null;
            }
            entry = DummyEntry.create(key, hash, entry);
            DummyValueReference<Object, Object> valueRef = DummyValueReference.create(value, entry);
            entry.setValueReference(valueRef);
        }
        segment.table.set(0, entry);
        segment.count = originalCount;
        int liveCount = originalCount / 3;
        MapMakerInternalMapTest.assertEquals((int)1, (int)segment.table.length());
        MapMakerInternalMapTest.assertEquals((int)liveCount, (int)MapMakerInternalMapTest.countLiveEntries(map));
        ImmutableMap originalMap = ImmutableMap.copyOf(map);
        MapMakerInternalMapTest.assertEquals((int)liveCount, (int)originalMap.size());
        for (int i = 1; i <= originalCount * 2; i *= 2) {
            if (i > 1) {
                segment.expand();
            }
            MapMakerInternalMapTest.assertEquals((int)i, (int)segment.table.length());
            MapMakerInternalMapTest.assertEquals((int)liveCount, (int)MapMakerInternalMapTest.countLiveEntries(map));
            MapMakerInternalMapTest.assertTrue((segment.count >= liveCount ? 1 : 0) != 0);
            MapMakerInternalMapTest.assertTrue((segment.count <= originalCount ? 1 : 0) != 0);
            MapMakerInternalMapTest.assertEquals((Object)originalMap, (Object)ImmutableMap.copyOf(map));
        }
    }

    private static <K, V> int countLiveEntries(MapMakerInternalMap<K, V> map) {
        int result = 0;
        for (MapMakerInternalMap.Segment segment : map.segments) {
            AtomicReferenceArray table = segment.table;
            for (int i = 0; i < table.length(); ++i) {
                for (MapMakerInternalMap.ReferenceEntry e = (MapMakerInternalMap.ReferenceEntry)table.get(i); e != null; e = e.getNext()) {
                    if (!map.isLive(e)) continue;
                    ++result;
                }
            }
        }
        return result;
    }

    public void testClear() {
        MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(MapMakerInternalMapTest.createMapMaker().concurrencyLevel(1).initialCapacity(1).maximumSize(315).expireAfterWrite(99999L, TimeUnit.SECONDS));
        MapMakerInternalMap.Segment segment = map.segments[0];
        AtomicReferenceArray table = segment.table;
        MapMakerInternalMapTest.assertEquals((int)1, (int)table.length());
        Object key = new Object();
        Object value = new Object();
        int hash = map.hash(key);
        DummyEntry<Object, Object> entry = MapMakerInternalMapTest.createDummyEntry(key, hash, value, null);
        segment.recordWrite(entry);
        segment.table.set(0, entry);
        segment.readCount.incrementAndGet();
        segment.count = 1;
        MapMakerInternalMapTest.assertSame(entry, table.get(0));
        MapMakerInternalMapTest.assertSame(entry, segment.evictionQueue.peek());
        MapMakerInternalMapTest.assertSame(entry, segment.expirationQueue.peek());
        segment.clear();
        MapMakerInternalMapTest.assertNull(table.get(0));
        MapMakerInternalMapTest.assertTrue((boolean)segment.evictionQueue.isEmpty());
        MapMakerInternalMapTest.assertTrue((boolean)segment.expirationQueue.isEmpty());
        MapMakerInternalMapTest.assertEquals((int)0, (int)segment.readCount.get());
        MapMakerInternalMapTest.assertEquals((int)0, (int)segment.count);
    }

    public void testRemoveEntry() {
        MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(MapMakerInternalMapTest.createMapMaker().concurrencyLevel(1).initialCapacity(1).maximumSize(315).expireAfterWrite(99999L, TimeUnit.SECONDS).removalListener(new CountingRemovalListener()));
        MapMakerInternalMap.Segment segment = map.segments[0];
        AtomicReferenceArray table = segment.table;
        MapMakerInternalMapTest.assertEquals((int)1, (int)table.length());
        Object key = new Object();
        Object value = new Object();
        int hash = map.hash(key);
        DummyEntry<Object, Object> entry = MapMakerInternalMapTest.createDummyEntry(key, hash, value, null);
        MapMakerInternalMapTest.assertFalse((boolean)segment.removeEntry(entry, hash, MapMaker.RemovalCause.COLLECTED));
        segment.recordWrite(entry);
        table.set(0, entry);
        segment.count = 1;
        MapMakerInternalMapTest.assertTrue((boolean)segment.removeEntry(entry, hash, MapMaker.RemovalCause.COLLECTED));
        MapMakerInternalMapTest.assertNotificationEnqueued(map, key, value);
        MapMakerInternalMapTest.assertTrue((boolean)map.removalNotificationQueue.isEmpty());
        MapMakerInternalMapTest.assertFalse((boolean)segment.evictionQueue.contains(entry));
        MapMakerInternalMapTest.assertFalse((boolean)segment.expirationQueue.contains(entry));
        MapMakerInternalMapTest.assertEquals((int)0, (int)segment.count);
        MapMakerInternalMapTest.assertNull(table.get(0));
    }

    public void testReclaimValue() {
        CountingRemovalListener listener = new CountingRemovalListener();
        MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(MapMakerInternalMapTest.createMapMaker().concurrencyLevel(1).initialCapacity(1).maximumSize(315).expireAfterWrite(99999L, TimeUnit.SECONDS).removalListener(listener));
        MapMakerInternalMap.Segment segment = map.segments[0];
        AtomicReferenceArray table = segment.table;
        MapMakerInternalMapTest.assertEquals((int)1, (int)table.length());
        Object key = new Object();
        Object value = new Object();
        int hash = map.hash(key);
        DummyEntry<Object, Object> entry = DummyEntry.create(key, hash, null);
        DummyValueReference<Object, Object> valueRef = DummyValueReference.create(value, entry);
        entry.setValueReference(valueRef);
        MapMakerInternalMapTest.assertFalse((boolean)segment.reclaimValue(key, hash, valueRef));
        segment.recordWrite(entry);
        table.set(0, entry);
        segment.count = 1;
        MapMakerInternalMapTest.assertTrue((boolean)segment.reclaimValue(key, hash, valueRef));
        MapMakerInternalMapTest.assertEquals((int)1, (int)listener.getCount());
        MapMakerInternalMapTest.assertSame((Object)key, listener.getLastEvictedKey());
        MapMakerInternalMapTest.assertSame((Object)value, listener.getLastEvictedValue());
        MapMakerInternalMapTest.assertTrue((boolean)map.removalNotificationQueue.isEmpty());
        MapMakerInternalMapTest.assertFalse((boolean)segment.evictionQueue.contains(entry));
        MapMakerInternalMapTest.assertFalse((boolean)segment.expirationQueue.contains(entry));
        MapMakerInternalMapTest.assertEquals((int)0, (int)segment.count);
        MapMakerInternalMapTest.assertNull(table.get(0));
        table.set(0, entry);
        DummyValueReference<Object, Object> otherValueRef = DummyValueReference.create(value, entry);
        entry.setValueReference(otherValueRef);
        MapMakerInternalMapTest.assertFalse((boolean)segment.reclaimValue(key, hash, valueRef));
        MapMakerInternalMapTest.assertEquals((int)1, (int)listener.getCount());
        MapMakerInternalMapTest.assertTrue((boolean)segment.reclaimValue(key, hash, otherValueRef));
        MapMakerInternalMapTest.assertEquals((int)2, (int)listener.getCount());
        MapMakerInternalMapTest.assertSame((Object)key, listener.getLastEvictedKey());
        MapMakerInternalMapTest.assertSame((Object)value, listener.getLastEvictedValue());
    }

    public void testClearValue() {
        MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(MapMakerInternalMapTest.createMapMaker().concurrencyLevel(1).initialCapacity(1).maximumSize(315).expireAfterWrite(99999L, TimeUnit.SECONDS).removalListener(new CountingRemovalListener()));
        MapMakerInternalMap.Segment segment = map.segments[0];
        AtomicReferenceArray table = segment.table;
        MapMakerInternalMapTest.assertEquals((int)1, (int)table.length());
        Object key = new Object();
        Object value = new Object();
        int hash = map.hash(key);
        DummyEntry<Object, Object> entry = DummyEntry.create(key, hash, null);
        DummyValueReference<Object, Object> valueRef = DummyValueReference.create(value, entry);
        entry.setValueReference(valueRef);
        MapMakerInternalMapTest.assertFalse((boolean)segment.clearValue(key, hash, valueRef));
        segment.recordWrite(entry);
        table.set(0, entry);
        MapMakerInternalMapTest.assertTrue((boolean)segment.clearValue(key, hash, valueRef));
        MapMakerInternalMapTest.assertTrue((boolean)map.removalNotificationQueue.isEmpty());
        MapMakerInternalMapTest.assertFalse((boolean)segment.evictionQueue.contains(entry));
        MapMakerInternalMapTest.assertFalse((boolean)segment.expirationQueue.contains(entry));
        MapMakerInternalMapTest.assertEquals((int)0, (int)segment.count);
        MapMakerInternalMapTest.assertNull(table.get(0));
        table.set(0, entry);
        DummyValueReference<Object, Object> otherValueRef = DummyValueReference.create(value, entry);
        entry.setValueReference(otherValueRef);
        MapMakerInternalMapTest.assertFalse((boolean)segment.clearValue(key, hash, valueRef));
        entry.setValueReference(valueRef);
        MapMakerInternalMapTest.assertTrue((boolean)segment.clearValue(key, hash, valueRef));
    }

    private static <K, V> void assertNotificationEnqueued(MapMakerInternalMap<K, V> map, K key, V value) {
        MapMaker.RemovalNotification notification = (MapMaker.RemovalNotification)map.removalNotificationQueue.poll();
        MapMakerInternalMapTest.assertSame(key, (Object)notification.getKey());
        MapMakerInternalMapTest.assertSame(value, (Object)notification.getValue());
    }

    public void testDrainRecencyQueueOnWrite() {
        for (MapMaker maker : MapMakerInternalMapTest.allEvictingMakers()) {
            MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(maker.concurrencyLevel(1));
            MapMakerInternalMap.Segment segment = map.segments[0];
            if (segment.recencyQueue == MapMakerInternalMap.DISCARDING_QUEUE) continue;
            Object keyOne = new Object();
            Object valueOne = new Object();
            Object keyTwo = new Object();
            Object valueTwo = new Object();
            map.put(keyOne, valueOne);
            MapMakerInternalMapTest.assertTrue((boolean)segment.recencyQueue.isEmpty());
            for (int i = 0; i < 31; ++i) {
                map.get(keyOne);
            }
            MapMakerInternalMapTest.assertFalse((boolean)segment.recencyQueue.isEmpty());
            map.put(keyTwo, valueTwo);
            MapMakerInternalMapTest.assertTrue((boolean)segment.recencyQueue.isEmpty());
        }
    }

    public void testDrainRecencyQueueOnRead() {
        for (MapMaker maker : MapMakerInternalMapTest.allEvictingMakers()) {
            int i;
            MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(maker.concurrencyLevel(1));
            MapMakerInternalMap.Segment segment = map.segments[0];
            if (segment.recencyQueue == MapMakerInternalMap.DISCARDING_QUEUE) continue;
            Object keyOne = new Object();
            Object valueOne = new Object();
            map.put(keyOne, valueOne);
            MapMakerInternalMapTest.assertTrue((boolean)segment.recencyQueue.isEmpty());
            for (i = 0; i < 31; ++i) {
                map.get(keyOne);
            }
            MapMakerInternalMapTest.assertFalse((boolean)segment.recencyQueue.isEmpty());
            for (i = 0; i < 126; ++i) {
                map.get(keyOne);
                MapMakerInternalMapTest.assertTrue((segment.recencyQueue.size() <= 63 ? 1 : 0) != 0);
            }
            for (i = 0; i < 126; ++i) {
                map.put(new Object(), new Object());
            }
            MapMakerInternalMapTest.assertTrue((boolean)segment.recencyQueue.isEmpty());
            for (i = 0; i < 31; ++i) {
                map.get(keyOne);
            }
            MapMakerInternalMapTest.assertFalse((boolean)segment.recencyQueue.isEmpty());
            for (Object key : map.keySet()) {
                map.get(key);
                MapMakerInternalMapTest.assertTrue((segment.recencyQueue.size() <= 63 ? 1 : 0) != 0);
            }
        }
    }

    public void testRecordRead() {
        for (MapMaker maker : MapMakerInternalMapTest.allEvictingMakers()) {
            MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(maker.concurrencyLevel(1));
            MapMakerInternalMap.Segment segment = map.segments[0];
            LinkedList writeOrder = Lists.newLinkedList();
            LinkedList readOrder = Lists.newLinkedList();
            for (int i = 0; i < 126; ++i) {
                Object key = new Object();
                int hash = map.hash(key);
                Object value = new Object();
                DummyEntry<Object, Object> entry = MapMakerInternalMapTest.createDummyEntry(key, hash, value, null);
                segment.recordWrite(entry);
                writeOrder.add(entry);
                readOrder.add(entry);
            }
            MapMakerInternalMapTest.checkEvictionQueues(map, segment, readOrder, writeOrder);
            MapMakerInternalMapTest.checkExpirationTimes(map);
            Random random = new Random();
            ArrayList reads = Lists.newArrayList();
            Iterator i = readOrder.iterator();
            while (i.hasNext()) {
                MapMakerInternalMap.ReferenceEntry entry = (MapMakerInternalMap.ReferenceEntry)i.next();
                if (!random.nextBoolean()) continue;
                segment.recordRead(entry);
                reads.add(entry);
                i.remove();
            }
            MapMakerInternalMapTest.checkAndDrainRecencyQueue(map, segment, reads);
            readOrder.addAll(reads);
            MapMakerInternalMapTest.checkEvictionQueues(map, segment, readOrder, writeOrder);
            MapMakerInternalMapTest.checkExpirationTimes(map);
        }
    }

    public void testRecordReadOnGet() {
        for (MapMaker maker : MapMakerInternalMapTest.allEvictingMakers()) {
            MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(maker.concurrencyLevel(1));
            MapMakerInternalMap.Segment segment = map.segments[0];
            LinkedList writeOrder = Lists.newLinkedList();
            LinkedList readOrder = Lists.newLinkedList();
            for (int i = 0; i < 126; ++i) {
                Object key = new Object();
                int hash = map.hash(key);
                Object value = new Object();
                map.put(key, value);
                MapMakerInternalMap.ReferenceEntry entry = segment.getEntry(key, hash);
                writeOrder.add(entry);
                readOrder.add(entry);
            }
            MapMakerInternalMapTest.checkEvictionQueues(map, segment, readOrder, writeOrder);
            MapMakerInternalMapTest.checkExpirationTimes(map);
            MapMakerInternalMapTest.assertTrue((boolean)segment.recencyQueue.isEmpty());
            Random random = new Random();
            ArrayList reads = Lists.newArrayList();
            Iterator i = readOrder.iterator();
            while (i.hasNext()) {
                MapMakerInternalMap.ReferenceEntry entry = (MapMakerInternalMap.ReferenceEntry)i.next();
                if (!random.nextBoolean()) continue;
                map.get(entry.getKey());
                reads.add(entry);
                i.remove();
                MapMakerInternalMapTest.assertTrue((segment.recencyQueue.size() <= 63 ? 1 : 0) != 0);
            }
            int undrainedIndex = reads.size() - segment.recencyQueue.size();
            MapMakerInternalMapTest.checkAndDrainRecencyQueue(map, segment, reads.subList(undrainedIndex, reads.size()));
            readOrder.addAll(reads);
            MapMakerInternalMapTest.checkEvictionQueues(map, segment, readOrder, writeOrder);
            MapMakerInternalMapTest.checkExpirationTimes(map);
        }
    }

    public void testRecordWrite() {
        for (MapMaker maker : MapMakerInternalMapTest.allEvictingMakers()) {
            MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(maker.concurrencyLevel(1));
            MapMakerInternalMap.Segment segment = map.segments[0];
            LinkedList writeOrder = Lists.newLinkedList();
            for (int i = 0; i < 126; ++i) {
                Object key = new Object();
                int hash = map.hash(key);
                Object value = new Object();
                DummyEntry<Object, Object> entry = MapMakerInternalMapTest.createDummyEntry(key, hash, value, null);
                segment.recordWrite(entry);
                writeOrder.add(entry);
            }
            MapMakerInternalMapTest.checkEvictionQueues(map, segment, writeOrder, writeOrder);
            MapMakerInternalMapTest.checkExpirationTimes(map);
            Random random = new Random();
            ArrayList writes = Lists.newArrayList();
            Iterator i = writeOrder.iterator();
            while (i.hasNext()) {
                MapMakerInternalMap.ReferenceEntry entry = (MapMakerInternalMap.ReferenceEntry)i.next();
                if (!random.nextBoolean()) continue;
                segment.recordWrite(entry);
                writes.add(entry);
                i.remove();
            }
            writeOrder.addAll(writes);
            MapMakerInternalMapTest.checkEvictionQueues(map, segment, writeOrder, writeOrder);
            MapMakerInternalMapTest.checkExpirationTimes(map);
        }
    }

    static <K, V> void checkAndDrainRecencyQueue(MapMakerInternalMap<K, V> map, MapMakerInternalMap.Segment<K, V> segment, List<MapMakerInternalMap.ReferenceEntry<K, V>> reads) {
        if (map.evictsBySize() || map.expiresAfterAccess()) {
            MapMakerInternalMapTest.assertSameEntries(reads, ImmutableList.copyOf((Collection)segment.recencyQueue));
        }
        segment.drainRecencyQueue();
    }

    static <K, V> void checkEvictionQueues(MapMakerInternalMap<K, V> map, MapMakerInternalMap.Segment<K, V> segment, List<MapMakerInternalMap.ReferenceEntry<K, V>> readOrder, List<MapMakerInternalMap.ReferenceEntry<K, V>> writeOrder) {
        if (map.evictsBySize()) {
            MapMakerInternalMapTest.assertSameEntries(readOrder, ImmutableList.copyOf((Collection)segment.evictionQueue));
        }
        if (map.expiresAfterAccess()) {
            MapMakerInternalMapTest.assertSameEntries(readOrder, ImmutableList.copyOf((Collection)segment.expirationQueue));
        }
        if (map.expiresAfterWrite()) {
            MapMakerInternalMapTest.assertSameEntries(writeOrder, ImmutableList.copyOf((Collection)segment.expirationQueue));
        }
    }

    private static <K, V> void assertSameEntries(List<MapMakerInternalMap.ReferenceEntry<K, V>> expectedEntries, List<MapMakerInternalMap.ReferenceEntry<K, V>> actualEntries) {
        int size = expectedEntries.size();
        MapMakerInternalMapTest.assertEquals((int)size, (int)actualEntries.size());
        for (int i = 0; i < size; ++i) {
            MapMakerInternalMap.ReferenceEntry<K, V> expectedEntry = expectedEntries.get(0);
            MapMakerInternalMap.ReferenceEntry<K, V> actualEntry = actualEntries.get(0);
            MapMakerInternalMapTest.assertSame((Object)expectedEntry.getKey(), (Object)actualEntry.getKey());
            MapMakerInternalMapTest.assertSame((Object)expectedEntry.getValueReference().get(), (Object)actualEntry.getValueReference().get());
        }
    }

    static <K, V> void checkExpirationTimes(MapMakerInternalMap<K, V> map) {
        if (!map.expires()) {
            return;
        }
        for (MapMakerInternalMap.Segment segment : map.segments) {
            long expirationTime;
            long lastExpirationTime = 0L;
            for (MapMakerInternalMap.ReferenceEntry e : segment.recencyQueue) {
                expirationTime = e.getExpirationTime();
                MapMakerInternalMapTest.assertTrue((expirationTime >= lastExpirationTime ? 1 : 0) != 0);
                lastExpirationTime = expirationTime;
            }
            lastExpirationTime = 0L;
            for (MapMakerInternalMap.ReferenceEntry e : segment.expirationQueue) {
                expirationTime = e.getExpirationTime();
                MapMakerInternalMapTest.assertTrue((expirationTime >= lastExpirationTime ? 1 : 0) != 0);
                lastExpirationTime = expirationTime;
            }
        }
    }

    public void testEvictEntries() {
        int i;
        int maxSize = 10;
        MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(MapMakerInternalMapTest.createMapMaker().concurrencyLevel(1).maximumSize(maxSize));
        MapMakerInternalMap.Segment segment = map.segments[0];
        int originalCount = 1024;
        MapMakerInternalMap.ReferenceEntry entry = null;
        LinkedHashMap originalMap = Maps.newLinkedHashMap();
        for (i = 0; i < originalCount; ++i) {
            Object key = new Object();
            Object value = new Object();
            AtomicReferenceArray table = segment.table;
            int hash = map.hash(key);
            int index = hash & table.length() - 1;
            MapMakerInternalMap.ReferenceEntry first = (MapMakerInternalMap.ReferenceEntry)table.get(index);
            entry = map.newEntry(key, hash, first);
            MapMakerInternalMap.ValueReference valueRef = map.newValueReference(entry, value);
            entry.setValueReference(valueRef);
            segment.recordWrite(entry);
            table.set(index, entry);
            originalMap.put(key, value);
        }
        segment.count = originalCount;
        MapMakerInternalMapTest.assertEquals((int)originalCount, (int)originalMap.size());
        MapMakerInternalMapTest.assertEquals((Object)originalMap, map);
        for (i = maxSize - 1; i < originalCount; ++i) {
            MapMakerInternalMapTest.assertTrue((boolean)segment.evictEntries());
            Iterator it = originalMap.keySet().iterator();
            it.next();
            it.remove();
            MapMakerInternalMapTest.assertEquals((Object)originalMap, map);
        }
        MapMakerInternalMapTest.assertFalse((boolean)segment.evictEntries());
    }

    public void testDrainKeyReferenceQueueOnWrite() {
        for (MapMaker maker : MapMakerInternalMapTest.allKeyValueStrengthMakers()) {
            MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(maker.concurrencyLevel(1));
            if (!map.usesKeyReferences()) continue;
            MapMakerInternalMap.Segment segment = map.segments[0];
            Object keyOne = new Object();
            int hashOne = map.hash(keyOne);
            Object valueOne = new Object();
            Object keyTwo = new Object();
            Object valueTwo = new Object();
            map.put(keyOne, valueOne);
            MapMakerInternalMap.ReferenceEntry entry = segment.getEntry(keyOne, hashOne);
            Reference reference = (Reference)entry;
            reference.enqueue();
            map.put(keyTwo, valueTwo);
            MapMakerInternalMapTest.assertFalse((boolean)map.containsKey(keyOne));
            MapMakerInternalMapTest.assertFalse((boolean)map.containsValue(valueOne));
            MapMakerInternalMapTest.assertNull((Object)map.get(keyOne));
            MapMakerInternalMapTest.assertEquals((int)1, (int)map.size());
            MapMakerInternalMapTest.assertNull(segment.keyReferenceQueue.poll());
        }
    }

    public void testDrainValueReferenceQueueOnWrite() {
        for (MapMaker maker : MapMakerInternalMapTest.allKeyValueStrengthMakers()) {
            MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(maker.concurrencyLevel(1));
            if (!map.usesValueReferences()) continue;
            MapMakerInternalMap.Segment segment = map.segments[0];
            Object keyOne = new Object();
            int hashOne = map.hash(keyOne);
            Object valueOne = new Object();
            Object keyTwo = new Object();
            Object valueTwo = new Object();
            map.put(keyOne, valueOne);
            MapMakerInternalMap.ReferenceEntry entry = segment.getEntry(keyOne, hashOne);
            MapMakerInternalMap.ValueReference valueReference = entry.getValueReference();
            Reference reference = (Reference)valueReference;
            reference.enqueue();
            map.put(keyTwo, valueTwo);
            MapMakerInternalMapTest.assertFalse((boolean)map.containsKey(keyOne));
            MapMakerInternalMapTest.assertFalse((boolean)map.containsValue(valueOne));
            MapMakerInternalMapTest.assertNull((Object)map.get(keyOne));
            MapMakerInternalMapTest.assertEquals((int)1, (int)map.size());
            MapMakerInternalMapTest.assertNull(segment.valueReferenceQueue.poll());
        }
    }

    public void testDrainKeyReferenceQueueOnRead() {
        for (MapMaker maker : MapMakerInternalMapTest.allKeyValueStrengthMakers()) {
            MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(maker.concurrencyLevel(1));
            if (!map.usesKeyReferences()) continue;
            MapMakerInternalMap.Segment segment = map.segments[0];
            Object keyOne = new Object();
            int hashOne = map.hash(keyOne);
            Object valueOne = new Object();
            Object keyTwo = new Object();
            map.put(keyOne, valueOne);
            MapMakerInternalMap.ReferenceEntry entry = segment.getEntry(keyOne, hashOne);
            Reference reference = (Reference)entry;
            reference.enqueue();
            for (int i = 0; i < 315; ++i) {
                map.get(keyTwo);
            }
            MapMakerInternalMapTest.assertFalse((boolean)map.containsKey(keyOne));
            MapMakerInternalMapTest.assertFalse((boolean)map.containsValue(valueOne));
            MapMakerInternalMapTest.assertNull((Object)map.get(keyOne));
            MapMakerInternalMapTest.assertEquals((int)0, (int)map.size());
            MapMakerInternalMapTest.assertNull(segment.keyReferenceQueue.poll());
        }
    }

    public void testDrainValueReferenceQueueOnRead() {
        for (MapMaker maker : MapMakerInternalMapTest.allKeyValueStrengthMakers()) {
            MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(maker.concurrencyLevel(1));
            if (!map.usesValueReferences()) continue;
            MapMakerInternalMap.Segment segment = map.segments[0];
            Object keyOne = new Object();
            int hashOne = map.hash(keyOne);
            Object valueOne = new Object();
            Object keyTwo = new Object();
            map.put(keyOne, valueOne);
            MapMakerInternalMap.ReferenceEntry entry = segment.getEntry(keyOne, hashOne);
            MapMakerInternalMap.ValueReference valueReference = entry.getValueReference();
            Reference reference = (Reference)valueReference;
            reference.enqueue();
            for (int i = 0; i < 315; ++i) {
                map.get(keyTwo);
            }
            MapMakerInternalMapTest.assertFalse((boolean)map.containsKey(keyOne));
            MapMakerInternalMapTest.assertFalse((boolean)map.containsValue(valueOne));
            MapMakerInternalMapTest.assertNull((Object)map.get(keyOne));
            MapMakerInternalMapTest.assertEquals((int)0, (int)map.size());
            MapMakerInternalMapTest.assertNull(segment.valueReferenceQueue.poll());
        }
    }

    private static Iterable<MapMaker> allEntryTypeMakers() {
        ArrayList result = Lists.newArrayList(MapMakerInternalMapTest.allKeyValueStrengthMakers());
        for (MapMaker maker : MapMakerInternalMapTest.allKeyValueStrengthMakers()) {
            result.add(maker.maximumSize(315));
        }
        for (MapMaker maker : MapMakerInternalMapTest.allKeyValueStrengthMakers()) {
            result.add(maker.expireAfterAccess(99999L, TimeUnit.SECONDS));
        }
        for (MapMaker maker : MapMakerInternalMapTest.allKeyValueStrengthMakers()) {
            result.add(maker.expireAfterWrite(99999L, TimeUnit.SECONDS));
        }
        for (MapMaker maker : MapMakerInternalMapTest.allKeyValueStrengthMakers()) {
            result.add(maker.maximumSize(315).expireAfterAccess(99999L, TimeUnit.SECONDS));
        }
        for (MapMaker maker : MapMakerInternalMapTest.allKeyValueStrengthMakers()) {
            result.add(maker.maximumSize(315).expireAfterWrite(99999L, TimeUnit.SECONDS));
        }
        return result;
    }

    static Iterable<MapMaker> allEvictingMakers() {
        return ImmutableList.of((Object)MapMakerInternalMapTest.createMapMaker().maximumSize(315), (Object)MapMakerInternalMapTest.createMapMaker().expireAfterAccess(99999L, TimeUnit.SECONDS), (Object)MapMakerInternalMapTest.createMapMaker().expireAfterWrite(99999L, TimeUnit.SECONDS), (Object)MapMakerInternalMapTest.createMapMaker().maximumSize(315).expireAfterAccess(315L, TimeUnit.SECONDS), (Object)MapMakerInternalMapTest.createMapMaker().maximumSize(315).expireAfterWrite(315L, TimeUnit.SECONDS));
    }

    private static Iterable<MapMaker> allKeyValueStrengthMakers() {
        return ImmutableList.of((Object)MapMakerInternalMapTest.createMapMaker(), (Object)MapMakerInternalMapTest.createMapMaker().weakValues(), (Object)MapMakerInternalMapTest.createMapMaker().softValues(), (Object)MapMakerInternalMapTest.createMapMaker().weakKeys(), (Object)MapMakerInternalMapTest.createMapMaker().weakKeys().weakValues(), (Object)MapMakerInternalMapTest.createMapMaker().weakKeys().softValues());
    }

    private static <K, V> DummyEntry<K, V> createDummyEntry(K key, int hash, V value, MapMakerInternalMap.ReferenceEntry<K, V> next) {
        DummyEntry<K, V> entry = DummyEntry.create(key, hash, next);
        DummyValueReference<K, V> valueRef = DummyValueReference.create(value, entry);
        entry.setValueReference(valueRef);
        return entry;
    }

    public void testNullParameters() throws Exception {
        NullPointerTester tester = new NullPointerTester();
        tester.testAllPublicInstanceMethods(MapMakerInternalMapTest.makeMap(MapMakerInternalMapTest.createMapMaker()));
    }

    static class DummyValueReference<K, V>
    implements MapMakerInternalMap.ValueReference<K, V> {
        final MapMakerInternalMap.ReferenceEntry<K, V> entry;
        private V value;
        boolean computing = false;

        public DummyValueReference(V value, MapMakerInternalMap.ReferenceEntry<K, V> entry) {
            this.value = value;
            this.entry = entry;
        }

        public static <K, V> DummyValueReference<K, V> create(V value, MapMakerInternalMap.ReferenceEntry<K, V> entry) {
            return new DummyValueReference<K, V>(value, entry);
        }

        public V get() {
            return this.value;
        }

        public MapMakerInternalMap.ReferenceEntry<K, V> getEntry() {
            return this.entry;
        }

        public MapMakerInternalMap.ValueReference<K, V> copyFor(ReferenceQueue<V> queue, V value, MapMakerInternalMap.ReferenceEntry<K, V> entry) {
            return new DummyValueReference<K, V>(value, entry);
        }

        public void setComputing(boolean computing) {
            this.computing = computing;
        }

        public boolean isComputingReference() {
            return this.computing;
        }

        public V waitForValue() {
            return this.get();
        }

        public void clear(MapMakerInternalMap.ValueReference<K, V> newValue) {
            this.value = null;
        }
    }

    static class DummyEntry<K, V>
    implements MapMakerInternalMap.ReferenceEntry<K, V> {
        private K key;
        private final int hash;
        private final MapMakerInternalMap.ReferenceEntry<K, V> next;
        private MapMakerInternalMap.ValueReference<K, V> valueReference = MapMakerInternalMap.unset();
        private long expirationTime = Long.MAX_VALUE;
        private MapMakerInternalMap.ReferenceEntry<K, V> nextExpirable = MapMakerInternalMap.nullEntry();
        private MapMakerInternalMap.ReferenceEntry<K, V> previousExpirable = MapMakerInternalMap.nullEntry();
        private MapMakerInternalMap.ReferenceEntry<K, V> nextEvictable = MapMakerInternalMap.nullEntry();
        private MapMakerInternalMap.ReferenceEntry<K, V> previousEvictable = MapMakerInternalMap.nullEntry();

        public DummyEntry(K key, int hash, MapMakerInternalMap.ReferenceEntry<K, V> next) {
            this.key = key;
            this.hash = hash;
            this.next = next;
        }

        public static <K, V> DummyEntry<K, V> create(K key, int hash, MapMakerInternalMap.ReferenceEntry<K, V> next) {
            return new DummyEntry<K, V>(key, hash, next);
        }

        public void clearKey() {
            this.key = null;
        }

        public MapMakerInternalMap.ValueReference<K, V> getValueReference() {
            return this.valueReference;
        }

        public void setValueReference(MapMakerInternalMap.ValueReference<K, V> valueReference) {
            this.valueReference = valueReference;
        }

        public MapMakerInternalMap.ReferenceEntry<K, V> getNext() {
            return this.next;
        }

        public int getHash() {
            return this.hash;
        }

        public K getKey() {
            return this.key;
        }

        public long getExpirationTime() {
            return this.expirationTime;
        }

        public void setExpirationTime(long time) {
            this.expirationTime = time;
        }

        public MapMakerInternalMap.ReferenceEntry<K, V> getNextExpirable() {
            return this.nextExpirable;
        }

        public void setNextExpirable(MapMakerInternalMap.ReferenceEntry<K, V> next) {
            this.nextExpirable = next;
        }

        public MapMakerInternalMap.ReferenceEntry<K, V> getPreviousExpirable() {
            return this.previousExpirable;
        }

        public void setPreviousExpirable(MapMakerInternalMap.ReferenceEntry<K, V> previous) {
            this.previousExpirable = previous;
        }

        public MapMakerInternalMap.ReferenceEntry<K, V> getNextEvictable() {
            return this.nextEvictable;
        }

        public void setNextEvictable(MapMakerInternalMap.ReferenceEntry<K, V> next) {
            this.nextEvictable = next;
        }

        public MapMakerInternalMap.ReferenceEntry<K, V> getPreviousEvictable() {
            return this.previousEvictable;
        }

        public void setPreviousEvictable(MapMakerInternalMap.ReferenceEntry<K, V> previous) {
            this.previousEvictable = previous;
        }
    }

    static class QueuingRemovalListener<K, V>
    extends ConcurrentLinkedQueue<MapMaker.RemovalNotification<K, V>>
    implements MapMaker.RemovalListener<K, V> {
        QueuingRemovalListener() {
        }

        public void onRemoval(MapMaker.RemovalNotification<K, V> notification) {
            this.add(notification);
        }
    }

    private static class CountingRemovalListener<K, V>
    implements MapMaker.RemovalListener<K, V> {
        private final AtomicInteger count = new AtomicInteger();
        private K lastKey;
        private V lastValue;

        private CountingRemovalListener() {
        }

        public void onRemoval(MapMaker.RemovalNotification<K, V> notification) {
            this.count.incrementAndGet();
            this.lastKey = notification.getKey();
            this.lastValue = notification.getValue();
        }

        public int getCount() {
            return this.count.get();
        }

        public K getLastEvictedKey() {
            return this.lastKey;
        }

        public V getLastEvictedValue() {
            return this.lastValue;
        }
    }
}

