/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.caliper.BeforeExperiment;
import com.google.caliper.Benchmark;
import com.google.caliper.Param;
import com.google.caliper.api.SkipThisScenarioException;
import com.google.common.collect.ImmutableSet;
import java.util.Random;

public class MultipleSetContainsBenchmark {
    @Param(value={"0.0", "0.1", "0.7", "1.0"})
    double emptySetProportion;
    @Param(value={"0.0", "0.1", "0.7", "1.0"})
    double singletonSetProportion;
    @Param(value={"0.2", "0.8"})
    double hitRate;
    static final Object PRESENT = new Object();
    static final Object ABSENT = new Object();
    private final ImmutableSet<Object>[] sets = new ImmutableSet[4096];
    private final Object[] queries = new Object[4096];

    @BeforeExperiment
    void setUp() {
        if (this.emptySetProportion + this.singletonSetProportion > 1.01) {
            throw new SkipThisScenarioException();
        }
        Random rng = new Random();
        for (int i = 0; i < 4096; ++i) {
            double setSize = rng.nextDouble();
            this.sets[i] = setSize < this.emptySetProportion ? ImmutableSet.of() : (setSize < this.emptySetProportion + this.singletonSetProportion ? ImmutableSet.of((Object)PRESENT) : ImmutableSet.of((Object)PRESENT, (Object)new Object()));
            this.queries[i] = rng.nextDouble() < this.hitRate ? PRESENT : ABSENT;
        }
    }

    @Benchmark
    public boolean contains(int reps) {
        ImmutableSet<Object>[] sets = this.sets;
        Object[] queries = this.queries;
        boolean result = false;
        for (int i = 0; i < reps; ++i) {
            int j = i & 0xFFF;
            result ^= sets[j].contains(queries[j]);
        }
        return result;
    }
}

