/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import java.util.Collections;
import junit.framework.TestCase;

@GwtCompatible
public class MultisetsImmutableEntryTest
extends TestCase {
    private static final String NE = null;

    private static <E> Multiset.Entry<E> entry(E element, int count) {
        return Multisets.immutableEntry(element, (int)count);
    }

    private static <E> Multiset.Entry<E> control(E element, int count) {
        return (Multiset.Entry)HashMultiset.create(Collections.nCopies(count, element)).entrySet().iterator().next();
    }

    public void testToString() {
        MultisetsImmutableEntryTest.assertEquals((String)"foo", (String)MultisetsImmutableEntryTest.entry("foo", 1).toString());
        MultisetsImmutableEntryTest.assertEquals((String)"bar x 2", (String)MultisetsImmutableEntryTest.entry("bar", 2).toString());
    }

    public void testToStringNull() {
        MultisetsImmutableEntryTest.assertEquals((String)"null", (String)MultisetsImmutableEntryTest.entry(NE, 1).toString());
        MultisetsImmutableEntryTest.assertEquals((String)"null x 2", (String)MultisetsImmutableEntryTest.entry(NE, 2).toString());
    }

    public void testEquals() {
        MultisetsImmutableEntryTest.assertEquals(MultisetsImmutableEntryTest.control("foo", 1), MultisetsImmutableEntryTest.entry("foo", 1));
        MultisetsImmutableEntryTest.assertEquals(MultisetsImmutableEntryTest.control("bar", 2), MultisetsImmutableEntryTest.entry("bar", 2));
        MultisetsImmutableEntryTest.assertFalse((boolean)MultisetsImmutableEntryTest.control("foo", 1).equals(MultisetsImmutableEntryTest.entry("foo", 2)));
        MultisetsImmutableEntryTest.assertFalse((boolean)MultisetsImmutableEntryTest.entry("foo", 1).equals(MultisetsImmutableEntryTest.control("bar", 1)));
        MultisetsImmutableEntryTest.assertFalse((boolean)MultisetsImmutableEntryTest.entry("foo", 1).equals(new Object()));
        MultisetsImmutableEntryTest.assertFalse((boolean)MultisetsImmutableEntryTest.entry("foo", 1).equals(null));
    }

    public void testEqualsNull() {
        MultisetsImmutableEntryTest.assertEquals(MultisetsImmutableEntryTest.control(NE, 1), MultisetsImmutableEntryTest.entry(NE, 1));
        MultisetsImmutableEntryTest.assertFalse((boolean)MultisetsImmutableEntryTest.control(NE, 1).equals(MultisetsImmutableEntryTest.entry(NE, 2)));
        MultisetsImmutableEntryTest.assertFalse((boolean)MultisetsImmutableEntryTest.entry(NE, 1).equals(MultisetsImmutableEntryTest.control("bar", 1)));
        MultisetsImmutableEntryTest.assertFalse((boolean)MultisetsImmutableEntryTest.entry(NE, 1).equals(new Object()));
        MultisetsImmutableEntryTest.assertFalse((boolean)MultisetsImmutableEntryTest.entry(NE, 1).equals(null));
    }

    public void testHashCode() {
        MultisetsImmutableEntryTest.assertEquals((int)MultisetsImmutableEntryTest.control("foo", 1).hashCode(), (int)MultisetsImmutableEntryTest.entry("foo", 1).hashCode());
        MultisetsImmutableEntryTest.assertEquals((int)MultisetsImmutableEntryTest.control("bar", 2).hashCode(), (int)MultisetsImmutableEntryTest.entry("bar", 2).hashCode());
    }

    public void testHashCodeNull() {
        MultisetsImmutableEntryTest.assertEquals((int)MultisetsImmutableEntryTest.control(NE, 1).hashCode(), (int)MultisetsImmutableEntryTest.entry(NE, 1).hashCode());
    }

    public void testNegativeCount() {
        try {
            MultisetsImmutableEntryTest.entry("foo", -1);
            MultisetsImmutableEntryTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

