/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.escape;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.ImmutableMap;
import com.google.common.escape.ArrayBasedEscaperMap;
import java.util.Map;
import junit.framework.TestCase;

@GwtCompatible
public class ArrayBasedEscaperMapTest
extends TestCase {
    public void testNullMap() {
        try {
            ArrayBasedEscaperMap.create(null);
            ArrayBasedEscaperMapTest.fail((String)"expected exception did not occur");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testEmptyMap() {
        ImmutableMap map = ImmutableMap.of();
        ArrayBasedEscaperMap fem = ArrayBasedEscaperMap.create((Map)map);
        ArrayBasedEscaperMapTest.assertEquals((int)0, (int)fem.getReplacementArray().length);
    }

    public void testMapLength() {
        ImmutableMap map = ImmutableMap.of((Object)Character.valueOf('a'), (Object)"first", (Object)Character.valueOf('z'), (Object)"last");
        ArrayBasedEscaperMap fem = ArrayBasedEscaperMap.create((Map)map);
        ArrayBasedEscaperMapTest.assertEquals((int)123, (int)fem.getReplacementArray().length);
    }

    public void testMapping() {
        ImmutableMap map = ImmutableMap.of((Object)Character.valueOf('\u0000'), (Object)"zero", (Object)Character.valueOf('a'), (Object)"first", (Object)Character.valueOf('b'), (Object)"second", (Object)Character.valueOf('z'), (Object)"last", (Object)Character.valueOf('\uffff'), (Object)"biggest");
        ArrayBasedEscaperMap fem = ArrayBasedEscaperMap.create((Map)map);
        char[][] replacementArray = fem.getReplacementArray();
        ArrayBasedEscaperMapTest.assertEquals((int)65536, (int)replacementArray.length);
        ArrayBasedEscaperMapTest.assertNotNull((Object)replacementArray[replacementArray.length - 1]);
        for (int n = 0; n < replacementArray.length; ++n) {
            char c = (char)n;
            if (replacementArray[n] != null) {
                ArrayBasedEscaperMapTest.assertEquals((String)((String)map.get(Character.valueOf(c))), (String)new String(replacementArray[n]));
                continue;
            }
            ArrayBasedEscaperMapTest.assertFalse((boolean)map.containsKey(Character.valueOf(c)));
        }
    }
}

