/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.eventbus;

import com.google.common.collect.Lists;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;

public class ReentrantEventsTest
extends TestCase {
    static final String FIRST = "one";
    static final Double SECOND = 2.0;
    final EventBus bus = new EventBus();

    public void testNoReentrantEvents() {
        ReentrantEventsHater hater = new ReentrantEventsHater();
        this.bus.register((Object)hater);
        this.bus.post((Object)FIRST);
        ReentrantEventsTest.assertEquals((String)"ReentrantEventHater expected 2 events", (Object)Lists.newArrayList((Object[])new Object[]{FIRST, SECOND}), hater.eventsReceived);
    }

    public void testEventOrderingIsPredictable() {
        EventProcessor processor = new EventProcessor();
        this.bus.register((Object)processor);
        EventRecorder recorder = new EventRecorder();
        this.bus.register((Object)recorder);
        this.bus.post((Object)FIRST);
        ReentrantEventsTest.assertEquals((String)"EventRecorder expected events in order", (Object)Lists.newArrayList((Object[])new Object[]{FIRST, SECOND}), recorder.eventsReceived);
    }

    public class EventRecorder {
        List<Object> eventsReceived = Lists.newArrayList();

        @Subscribe
        public void listenForEverything(Object event) {
            this.eventsReceived.add(event);
        }
    }

    public class EventProcessor {
        @Subscribe
        public void listenForStrings(String event) {
            ReentrantEventsTest.this.bus.post((Object)SECOND);
        }
    }

    public class ReentrantEventsHater {
        boolean ready = true;
        List<Object> eventsReceived = Lists.newArrayList();

        @Subscribe
        public void listenForStrings(String event) {
            this.eventsReceived.add(event);
            this.ready = false;
            try {
                ReentrantEventsTest.this.bus.post((Object)SECOND);
            }
            finally {
                this.ready = true;
            }
        }

        @Subscribe
        public void listenForDoubles(Double event) {
            Assert.assertTrue((String)"I received an event when I wasn't ready!", (boolean)this.ready);
            this.eventsReceived.add(event);
        }
    }
}

