/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.collect.ImmutableSet;
import com.google.common.graph.AbstractGraphTest;
import com.google.common.graph.DirectedGraph;
import com.google.common.graph.Graphs;
import com.google.common.truth.Truth;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractDirectedGraphTest
extends AbstractGraphTest {
    DirectedGraph<Integer, String> directedGraph;

    public abstract DirectedGraph<Integer, String> createGraph();

    @Override
    public void init() {
        this.directedGraph = this.createGraph();
        this.graph = this.directedGraph;
    }

    @After
    public void validateSourceAndTarget() {
        for (Integer node : this.directedGraph.nodes()) {
            Integer oppositeNode;
            for (String inEdge : this.directedGraph.inEdges((Object)node)) {
                oppositeNode = (Integer)Graphs.oppositeNode(this.directedGraph, (Object)inEdge, (Object)node);
                Truth.assertThat((Integer)((Integer)this.directedGraph.source((Object)inEdge))).isEqualTo((Object)oppositeNode);
                Truth.assertThat((Integer)((Integer)this.directedGraph.target((Object)inEdge))).isEqualTo((Object)node);
            }
            for (String outEdge : this.directedGraph.outEdges((Object)node)) {
                oppositeNode = (Integer)Graphs.oppositeNode(this.directedGraph, (Object)outEdge, (Object)node);
                Truth.assertThat((Integer)((Integer)this.directedGraph.source((Object)outEdge))).isEqualTo((Object)node);
                Truth.assertThat((Integer)((Integer)this.directedGraph.target((Object)outEdge))).isEqualTo((Object)oppositeNode);
            }
            for (Integer adjacentNode : this.directedGraph.adjacentNodes((Object)node)) {
                Set edges = this.directedGraph.edgesConnecting((Object)node, (Object)adjacentNode);
                Set antiParallelEdges = this.directedGraph.edgesConnecting((Object)adjacentNode, (Object)node);
                Assert.assertTrue((node.equals(adjacentNode) || Collections.disjoint(edges, antiParallelEdges) ? 1 : 0) != 0);
            }
        }
    }

    @Override
    @Test
    public void incidentNodes_oneEdge() {
        this.addEdge("1-2", N1, N2);
        Truth.assertThat((Iterable)this.graph.incidentNodes((Object)"1-2")).containsExactly(new Object[]{N1, N2}).inOrder();
    }

    @Test
    public void edgesConnecting_oneEdge() {
        this.addEdge("1-2", N1, N2);
        Truth.assertThat((Iterable)this.directedGraph.edgesConnecting((Object)N1, (Object)N2)).containsExactly(new Object[]{"1-2"});
        Truth.assertThat((Iterable)this.directedGraph.edgesConnecting((Object)N2, (Object)N1)).isEmpty();
    }

    @Test
    public void inEdges_oneEdge() {
        this.addEdge("1-2", N1, N2);
        Truth.assertThat((Iterable)this.directedGraph.inEdges((Object)N2)).containsExactly(new Object[]{"1-2"});
        Truth.assertThat((Iterable)this.directedGraph.inEdges((Object)N1)).isEmpty();
    }

    @Test
    public void outEdges_oneEdge() {
        this.addEdge("1-2", N1, N2);
        Truth.assertThat((Iterable)this.directedGraph.outEdges((Object)N1)).containsExactly(new Object[]{"1-2"});
        Truth.assertThat((Iterable)this.directedGraph.outEdges((Object)N2)).isEmpty();
    }

    @Test
    public void predecessors_oneEdge() {
        this.addEdge("1-2", N1, N2);
        Truth.assertThat((Iterable)this.directedGraph.predecessors((Object)N2)).containsExactly(new Object[]{N1});
        Truth.assertThat((Iterable)this.directedGraph.predecessors((Object)N1)).isEmpty();
    }

    @Test
    public void successors_oneEdge() {
        this.addEdge("1-2", N1, N2);
        Truth.assertThat((Iterable)this.directedGraph.successors((Object)N1)).containsExactly(new Object[]{N2});
        Truth.assertThat((Iterable)this.directedGraph.successors((Object)N2)).isEmpty();
    }

    @Test
    public void inDegree_oneEdge() {
        this.addEdge("1-2", N1, N2);
        Assert.assertEquals((long)1L, (long)this.directedGraph.inDegree((Object)N2));
        Assert.assertEquals((long)0L, (long)this.directedGraph.inDegree((Object)N1));
    }

    @Test
    public void outDegree_oneEdge() {
        this.addEdge("1-2", N1, N2);
        Assert.assertEquals((long)1L, (long)this.directedGraph.outDegree((Object)N1));
        Assert.assertEquals((long)0L, (long)this.directedGraph.outDegree((Object)N2));
    }

    @Test
    public void source_oneEdge() {
        this.addEdge("1-2", N1, N2);
        Assert.assertEquals((Object)N1, (Object)this.directedGraph.source((Object)"1-2"));
    }

    @Test
    public void source_edgeNotInGraph() {
        try {
            this.directedGraph.source((Object)"edgeNotInGraph");
            Assert.fail((String)"Should not be allowed to pass an edge that is not an element of the graph.");
        }
        catch (IllegalArgumentException e) {
            AbstractDirectedGraphTest.assertEdgeNotInGraphErrorMessage(e);
        }
    }

    @Test
    public void target_oneEdge() {
        this.addEdge("1-2", N1, N2);
        Assert.assertEquals((Object)N2, (Object)this.directedGraph.target((Object)"1-2"));
    }

    @Test
    public void target_edgeNotInGraph() {
        try {
            this.directedGraph.target((Object)"edgeNotInGraph");
            Assert.fail((String)"Should not be allowed to pass an edge that is not an element of the graph.");
        }
        catch (IllegalArgumentException e) {
            AbstractDirectedGraphTest.assertEdgeNotInGraphErrorMessage(e);
        }
    }

    @Test
    public void addEdge_existingNodes() {
        this.addNode(N1);
        this.addNode(N2);
        Assert.assertTrue((boolean)this.addEdge("1-2", N1, N2));
        Truth.assertThat((Iterable)this.directedGraph.edges()).contains((Object)"1-2");
        Truth.assertThat((Iterable)this.directedGraph.edgesConnecting((Object)N1, (Object)N2)).containsExactly(new Object[]{"1-2"});
        Truth.assertThat((Iterable)this.directedGraph.edgesConnecting((Object)N2, (Object)N1)).isEmpty();
    }

    @Test
    public void addEdge_existingEdgeBetweenSameNodes() {
        this.addEdge("1-2", N1, N2);
        ImmutableSet edges = ImmutableSet.copyOf((Collection)this.directedGraph.edges());
        Assert.assertFalse((boolean)this.addEdge("1-2", N1, N2));
        Truth.assertThat((Iterable)this.directedGraph.edges()).containsExactlyElementsIn((Iterable)edges);
    }

    @Test
    public void addEdge_existingEdgeBetweenDifferentNodes() {
        this.addEdge("1-2", N1, N2);
        try {
            this.addEdge("1-2", N4, N5);
            Assert.fail((String)"Reusing an existing edge to connect different nodes succeeded");
        }
        catch (IllegalArgumentException e) {
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"it can't be reused to connect");
        }
        try {
            this.addEdge("1-2", N2, N1);
            Assert.fail((String)"Reusing an existing edge to connect different nodes succeeded");
        }
        catch (IllegalArgumentException e) {
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"it can't be reused to connect");
        }
    }

    @Test
    public void addEdge_parallelEdge() {
        this.addEdge("1-2", N1, N2);
        try {
            this.addEdge("edgeNotInGraph", N1, N2);
            Assert.fail((String)"Should not be allowed to add a parallel edge.");
        }
        catch (IllegalArgumentException e) {
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"connected by a different edge");
        }
    }

    @Test
    public void removeEdge_existingEdge() {
        this.addEdge("1-2", N1, N2);
        Assert.assertTrue((boolean)this.directedGraph.removeEdge((Object)"1-2"));
        Truth.assertThat((Iterable)this.directedGraph.edges()).doesNotContain((Object)"1-2");
        Truth.assertThat((Iterable)this.directedGraph.edgesConnecting((Object)N1, (Object)N2)).isEmpty();
    }

    @Test
    public void toString_emptyGraph() {
        Truth.assertThat((String)this.graph.toString()).isEqualTo((Object)String.format("config: %s, nodes: %s, edges: {}", this.graph.config(), this.graph.nodes()));
    }

    @Test
    public void toString_noEdges() {
        this.addNode(N1);
        Truth.assertThat((String)this.graph.toString()).isEqualTo((Object)String.format("config: %s, nodes: %s, edges: {}", this.graph.config(), this.graph.nodes()));
    }

    @Test
    public void toString_singleEdge() {
        this.addEdge("1-2", N1, N2);
        Truth.assertThat((String)this.graph.toString()).isEqualTo((Object)String.format("config: %s, nodes: %s, edges: {%s=<%s -> %s>}", this.graph.config(), this.graph.nodes(), "1-2", N1, N2));
    }

    @Test
    public void toString_multipleNodesAndEdges() {
        this.addEdge("1-2", N1, N2);
        this.addEdge("1-3", N1, N3);
        Truth.assertThat((String)this.graph.toString()).isEqualTo((Object)String.format("config: %s, nodes: %s, edges: {%s=<%s -> %s>, %s=<%s -> %s>}", this.graph.config(), this.graph.nodes(), "1-2", N1, N2, "1-3", N1, N3));
    }
}

