/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.collect.ImmutableSet;
import com.google.common.graph.Graph;
import com.google.common.graph.Graphs;
import com.google.common.graph.Hypergraph;
import com.google.common.testing.EqualsTester;
import com.google.common.truth.Truth;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Collection;
import java.util.Iterator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractGraphTest {
    Graph<Integer, String> graph;
    static final Integer N1 = 1;
    static final Integer N2 = 2;
    static final Integer N3 = 3;
    static final Integer N4 = 4;
    static final Integer N5 = 5;
    static final Integer NODE_NOT_IN_GRAPH = 1000;
    static final String E11 = "1-1";
    static final String E11_A = "1-1a";
    static final String E12 = "1-2";
    static final String E12_A = "1-2a";
    static final String E21 = "2-1";
    static final String E13 = "1-3";
    static final String E14 = "1-4";
    static final String E23 = "2-3";
    static final String E41 = "4-1";
    static final String E15 = "1-5";
    static final String EDGE_NOT_IN_GRAPH = "edgeNotInGraph";
    static final String ERROR_ELEMENT_NOT_IN_GRAPH = "not an element of this graph";
    static final String NODE_STRING = "Node";
    static final String EDGE_STRING = "Edge";
    static final String ERROR_PARALLEL_EDGE = "connected by a different edge";
    static final String ERROR_REUSE_EDGE = "it can't be reused to connect";
    static final String ERROR_MODIFIABLE_SET = "Set returned is unexpectedly modifiable";
    static final String ERROR_SELF_LOOP = "self-loops are not allowed";
    static final String ERROR_NODE_NOT_IN_GRAPH = "Should not be allowed to pass a node that is not an element of the graph.";
    static final String ERROR_EDGE_NOT_IN_GRAPH = "Should not be allowed to pass an edge that is not an element of the graph.";
    static final String ERROR_ADDED_SELF_LOOP = "Should not be allowed to add a self-loop edge.";
    static final String ERROR_ADDED_PARALLEL_EDGE = "Should not be allowed to add a parallel edge.";
    static final String ERROR_ADDED_EXISTING_EDGE = "Reusing an existing edge to connect different nodes succeeded";

    public abstract Graph<Integer, String> createGraph();

    @CanIgnoreReturnValue
    boolean addNode(Integer n) {
        return this.graph.addNode((Object)n);
    }

    @CanIgnoreReturnValue
    boolean addEdge(String e, Integer n1, Integer n2) {
        this.graph.addNode((Object)n1);
        this.graph.addNode((Object)n2);
        return this.graph.addEdge((Object)e, (Object)n1, (Object)n2);
    }

    @Before
    public void init() {
        this.graph = this.createGraph();
    }

    @After
    public void validateGraphState() {
        new EqualsTester().addEqualityGroup(new Object[]{this.graph}).testEquals();
        for (String edge : this.graph.edges()) {
            if (!(this.graph instanceof Hypergraph)) {
                Iterator incidentNodesIterator = this.graph.incidentNodes((Object)edge).iterator();
                Integer node1 = (Integer)incidentNodesIterator.next();
                Integer node2 = incidentNodesIterator.hasNext() ? (Integer)incidentNodesIterator.next() : node1;
                Assert.assertFalse((boolean)incidentNodesIterator.hasNext());
                Truth.assertThat((Iterable)this.graph.edgesConnecting((Object)node1, (Object)node2)).contains((Object)edge);
                Truth.assertThat((Iterable)this.graph.successors((Object)node1)).contains((Object)node2);
                Truth.assertThat((Iterable)this.graph.adjacentNodes((Object)node1)).contains((Object)node2);
                Truth.assertThat((Iterable)this.graph.outEdges((Object)node1)).contains((Object)edge);
                Truth.assertThat((Iterable)this.graph.incidentEdges((Object)node1)).contains((Object)edge);
                Truth.assertThat((Iterable)this.graph.predecessors((Object)node2)).contains((Object)node1);
                Truth.assertThat((Iterable)this.graph.adjacentNodes((Object)node2)).contains((Object)node1);
                Truth.assertThat((Iterable)this.graph.inEdges((Object)node2)).contains((Object)edge);
                Truth.assertThat((Iterable)this.graph.incidentEdges((Object)node2)).contains((Object)edge);
            }
            for (Integer incidentNode : this.graph.incidentNodes((Object)edge)) {
                Truth.assertThat((Iterable)this.graph.nodes()).contains((Object)incidentNode);
                for (String adjacentEdge : this.graph.incidentEdges((Object)incidentNode)) {
                    Assert.assertTrue((edge.equals(adjacentEdge) || this.graph.adjacentEdges((Object)edge).contains(adjacentEdge) ? 1 : 0) != 0);
                }
            }
        }
        for (Integer node : this.graph.nodes()) {
            for (String incidentEdge : this.graph.incidentEdges((Object)node)) {
                Assert.assertTrue((this.graph.inEdges((Object)node).contains(incidentEdge) || this.graph.outEdges((Object)node).contains(incidentEdge) ? 1 : 0) != 0);
                Truth.assertThat((Iterable)this.graph.edges()).contains((Object)incidentEdge);
                Truth.assertThat((Iterable)this.graph.incidentNodes((Object)incidentEdge)).contains((Object)node);
            }
            for (String inEdge : this.graph.inEdges((Object)node)) {
                Truth.assertThat((Iterable)this.graph.incidentEdges((Object)node)).contains((Object)inEdge);
                if (this.graph instanceof Hypergraph) continue;
                Truth.assertThat((Iterable)this.graph.outEdges(Graphs.oppositeNode(this.graph, (Object)inEdge, (Object)node))).contains((Object)inEdge);
            }
            for (String outEdge : this.graph.outEdges((Object)node)) {
                Truth.assertThat((Iterable)this.graph.incidentEdges((Object)node)).contains((Object)outEdge);
                if (this.graph instanceof Hypergraph) continue;
                Truth.assertThat((Iterable)this.graph.inEdges(Graphs.oppositeNode(this.graph, (Object)outEdge, (Object)node))).contains((Object)outEdge);
            }
            for (Integer adjacentNode : this.graph.adjacentNodes((Object)node)) {
                Assert.assertTrue((this.graph.predecessors((Object)node).contains(adjacentNode) || this.graph.successors((Object)node).contains(adjacentNode) ? 1 : 0) != 0);
                Assert.assertTrue((!this.graph.edgesConnecting((Object)node, (Object)adjacentNode).isEmpty() || !this.graph.edgesConnecting((Object)adjacentNode, (Object)node).isEmpty() ? 1 : 0) != 0);
                Truth.assertThat((Iterable)this.graph.incidentEdges((Object)node)).isNotEmpty();
                Truth.assertThat((Iterable)this.graph.incidentEdges((Object)node)).hasSize(this.graph.degree((Object)node));
            }
            for (Integer predecessor : this.graph.predecessors((Object)node)) {
                Truth.assertThat((Iterable)this.graph.successors((Object)predecessor)).contains((Object)node);
                Truth.assertThat((Iterable)this.graph.edgesConnecting((Object)predecessor, (Object)node)).isNotEmpty();
                Truth.assertThat((Iterable)this.graph.inEdges((Object)node)).isNotEmpty();
                Truth.assertThat((Iterable)this.graph.inEdges((Object)node)).hasSize(this.graph.inDegree((Object)node));
            }
            for (Integer successor : this.graph.successors((Object)node)) {
                Truth.assertThat((Iterable)this.graph.predecessors((Object)successor)).contains((Object)node);
                Truth.assertThat((Iterable)this.graph.edgesConnecting((Object)node, (Object)successor)).isNotEmpty();
                Truth.assertThat((Iterable)this.graph.outEdges((Object)node)).isNotEmpty();
                Truth.assertThat((Iterable)this.graph.outEdges((Object)node)).hasSize(this.graph.outDegree((Object)node));
            }
        }
    }

    @Test
    public abstract void nodes_checkReturnedSetMutability();

    @Test
    public abstract void edges_checkReturnedSetMutability();

    @Test
    public abstract void incidentEdges_checkReturnedSetMutability();

    @Test
    public abstract void incidentNodes_checkReturnedSetMutability();

    @Test
    public abstract void adjacentNodes_checkReturnedSetMutability();

    @Test
    public abstract void adjacentEdges_checkReturnedSetMutability();

    @Test
    public abstract void edgesConnecting_checkReturnedSetMutability();

    @Test
    public abstract void inEdges_checkReturnedSetMutability();

    @Test
    public abstract void outEdges_checkReturnedSetMutability();

    @Test
    public abstract void predecessors_checkReturnedSetMutability();

    @Test
    public abstract void successors_checkReturnedSetMutability();

    @Test
    public void nodes_oneNode() {
        this.addNode(N1);
        Truth.assertThat((Iterable)this.graph.nodes()).containsExactly(new Object[]{N1});
    }

    @Test
    public void nodes_noNodes() {
        Truth.assertThat((Iterable)this.graph.nodes()).isEmpty();
    }

    @Test
    public void edges_oneEdge() {
        this.addEdge(E12, N1, N2);
        Truth.assertThat((Iterable)this.graph.edges()).containsExactly(new Object[]{E12});
    }

    @Test
    public void edges_noEdges() {
        Truth.assertThat((Iterable)this.graph.edges()).isEmpty();
        this.addNode(N1);
        this.addNode(N2);
        Truth.assertThat((Iterable)this.graph.edges()).isEmpty();
    }

    @Test
    public void incidentEdges_oneEdge() {
        this.addEdge(E12, N1, N2);
        Truth.assertThat((Iterable)this.graph.incidentEdges((Object)N2)).containsExactly(new Object[]{E12});
        Truth.assertThat((Iterable)this.graph.incidentEdges((Object)N1)).containsExactly(new Object[]{E12});
    }

    @Test
    public void incidentEdges_isolatedNode() {
        this.addNode(N1);
        Truth.assertThat((Iterable)this.graph.incidentEdges((Object)N1)).isEmpty();
    }

    @Test
    public void incidentEdges_nodeNotInGraph() {
        try {
            this.graph.incidentEdges((Object)NODE_NOT_IN_GRAPH);
            Assert.fail((String)ERROR_NODE_NOT_IN_GRAPH);
        }
        catch (IllegalArgumentException e) {
            AbstractGraphTest.assertNodeNotInGraphErrorMessage(e);
        }
    }

    @Test
    public void incidentNodes_oneEdge() {
        this.addEdge(E12, N1, N2);
        Truth.assertThat((Iterable)this.graph.incidentNodes((Object)E12)).containsExactly(new Object[]{N1, N2});
    }

    @Test
    public void incidentNodes_edgeNotInGraph() {
        try {
            this.graph.incidentNodes((Object)EDGE_NOT_IN_GRAPH);
            Assert.fail((String)ERROR_EDGE_NOT_IN_GRAPH);
        }
        catch (IllegalArgumentException e) {
            AbstractGraphTest.assertEdgeNotInGraphErrorMessage(e);
        }
    }

    @Test
    public void adjacentNodes_oneEdge() {
        this.addEdge(E12, N1, N2);
        Truth.assertThat((Iterable)this.graph.adjacentNodes((Object)N1)).containsExactly(new Object[]{N2});
        Truth.assertThat((Iterable)this.graph.adjacentNodes((Object)N2)).containsExactly(new Object[]{N1});
    }

    @Test
    public void adjacentNodes_noAdjacentNodes() {
        this.addNode(N1);
        Truth.assertThat((Iterable)this.graph.adjacentNodes((Object)N1)).isEmpty();
    }

    @Test
    public void adjacentNodes_nodeNotInGraph() {
        try {
            this.graph.adjacentNodes((Object)NODE_NOT_IN_GRAPH);
            Assert.fail((String)ERROR_NODE_NOT_IN_GRAPH);
        }
        catch (IllegalArgumentException e) {
            AbstractGraphTest.assertNodeNotInGraphErrorMessage(e);
        }
    }

    @Test
    public void adjacentEdges_addEdges() {
        this.addEdge(E12, N1, N2);
        this.addEdge(E13, N1, N3);
        this.addEdge(E23, N2, N3);
        Truth.assertThat((Iterable)this.graph.adjacentEdges((Object)E12)).containsExactly(new Object[]{E13, E23});
    }

    @Test
    public void adjacentEdges_noAdjacentEdges() {
        this.addEdge(E12, N1, N2);
        Truth.assertThat((Iterable)this.graph.adjacentEdges((Object)E12)).isEmpty();
    }

    @Test
    public void adjacentEdges_nodeNotInGraph() {
        try {
            this.graph.adjacentEdges((Object)EDGE_NOT_IN_GRAPH);
            Assert.fail((String)ERROR_EDGE_NOT_IN_GRAPH);
        }
        catch (IllegalArgumentException e) {
            AbstractGraphTest.assertEdgeNotInGraphErrorMessage(e);
        }
    }

    @Test
    public void edgesConnecting_disconnectedNodes() {
        this.addNode(N1);
        this.addNode(N2);
        Truth.assertThat((Iterable)this.graph.edgesConnecting((Object)N1, (Object)N2)).isEmpty();
    }

    @Test
    public void edgesConnecting_nodesNotInGraph() {
        this.addNode(N1);
        this.addNode(N2);
        try {
            this.graph.edgesConnecting((Object)N1, (Object)NODE_NOT_IN_GRAPH);
            Assert.fail((String)ERROR_NODE_NOT_IN_GRAPH);
        }
        catch (IllegalArgumentException e) {
            AbstractGraphTest.assertNodeNotInGraphErrorMessage(e);
        }
        try {
            this.graph.edgesConnecting((Object)NODE_NOT_IN_GRAPH, (Object)N2);
            Assert.fail((String)ERROR_NODE_NOT_IN_GRAPH);
        }
        catch (IllegalArgumentException e) {
            AbstractGraphTest.assertNodeNotInGraphErrorMessage(e);
        }
        try {
            this.graph.edgesConnecting((Object)NODE_NOT_IN_GRAPH, (Object)NODE_NOT_IN_GRAPH);
            Assert.fail((String)ERROR_NODE_NOT_IN_GRAPH);
        }
        catch (IllegalArgumentException e) {
            AbstractGraphTest.assertNodeNotInGraphErrorMessage(e);
        }
    }

    @Test
    public void inEdges_noInEdges() {
        this.addNode(N1);
        Truth.assertThat((Iterable)this.graph.inEdges((Object)N1)).isEmpty();
    }

    @Test
    public void inEdges_nodeNotInGraph() {
        try {
            this.graph.inEdges((Object)NODE_NOT_IN_GRAPH);
            Assert.fail((String)ERROR_NODE_NOT_IN_GRAPH);
        }
        catch (IllegalArgumentException e) {
            AbstractGraphTest.assertNodeNotInGraphErrorMessage(e);
        }
    }

    @Test
    public void outEdges_noOutEdges() {
        this.addNode(N1);
        Truth.assertThat((Iterable)this.graph.outEdges((Object)N1)).isEmpty();
    }

    @Test
    public void outEdges_nodeNotInGraph() {
        try {
            this.graph.outEdges((Object)NODE_NOT_IN_GRAPH);
            Assert.fail((String)ERROR_NODE_NOT_IN_GRAPH);
        }
        catch (IllegalArgumentException e) {
            AbstractGraphTest.assertNodeNotInGraphErrorMessage(e);
        }
    }

    @Test
    public void predecessors_noPredecessors() {
        this.addNode(N1);
        Truth.assertThat((Iterable)this.graph.predecessors((Object)N1)).isEmpty();
    }

    @Test
    public void predecessors_nodeNotInGraph() {
        try {
            this.graph.predecessors((Object)NODE_NOT_IN_GRAPH);
            Assert.fail((String)ERROR_NODE_NOT_IN_GRAPH);
        }
        catch (IllegalArgumentException e) {
            AbstractGraphTest.assertNodeNotInGraphErrorMessage(e);
        }
    }

    @Test
    public void successors_noSuccessors() {
        this.addNode(N1);
        Truth.assertThat((Iterable)this.graph.successors((Object)N1)).isEmpty();
    }

    @Test
    public void successors_nodeNotInGraph() {
        try {
            this.graph.successors((Object)NODE_NOT_IN_GRAPH);
            Assert.fail((String)ERROR_NODE_NOT_IN_GRAPH);
        }
        catch (IllegalArgumentException e) {
            AbstractGraphTest.assertNodeNotInGraphErrorMessage(e);
        }
    }

    @Test
    public void degree_oneEdge() {
        this.addEdge(E12, N1, N2);
        Assert.assertEquals((long)1L, (long)this.graph.degree((Object)N1));
        Assert.assertEquals((long)1L, (long)this.graph.degree((Object)N2));
    }

    @Test
    public void degree_isolatedNode() {
        this.addNode(N1);
        Assert.assertEquals((long)0L, (long)this.graph.degree((Object)N1));
    }

    @Test
    public void degree_nodeNotInGraph() {
        try {
            this.graph.degree((Object)NODE_NOT_IN_GRAPH);
            Assert.fail((String)ERROR_NODE_NOT_IN_GRAPH);
        }
        catch (IllegalArgumentException e) {
            AbstractGraphTest.assertNodeNotInGraphErrorMessage(e);
        }
    }

    @Test
    public void inDegree_isolatedNode() {
        this.addNode(N1);
        Assert.assertEquals((long)0L, (long)this.graph.inDegree((Object)N1));
    }

    @Test
    public void inDegree_nodeNotInGraph() {
        try {
            this.graph.inDegree((Object)NODE_NOT_IN_GRAPH);
            Assert.fail((String)ERROR_NODE_NOT_IN_GRAPH);
        }
        catch (IllegalArgumentException e) {
            AbstractGraphTest.assertNodeNotInGraphErrorMessage(e);
        }
    }

    @Test
    public void outDegree_isolatedNode() {
        this.addNode(N1);
        Assert.assertEquals((long)0L, (long)this.graph.outDegree((Object)N1));
    }

    @Test
    public void outDegree_nodeNotInGraph() {
        try {
            this.graph.outDegree((Object)NODE_NOT_IN_GRAPH);
            Assert.fail((String)ERROR_NODE_NOT_IN_GRAPH);
        }
        catch (IllegalArgumentException e) {
            AbstractGraphTest.assertNodeNotInGraphErrorMessage(e);
        }
    }

    @Test
    public void addNode_newNode() {
        Assert.assertTrue((boolean)this.addNode(N1));
        Truth.assertThat((Iterable)this.graph.nodes()).contains((Object)N1);
    }

    @Test
    public void addNode_existingNode() {
        this.addNode(N1);
        ImmutableSet nodes = ImmutableSet.copyOf((Collection)this.graph.nodes());
        Assert.assertFalse((boolean)this.addNode(N1));
        Truth.assertThat((Iterable)this.graph.nodes()).containsExactlyElementsIn((Iterable)nodes);
    }

    @Test
    public void removeNode_existingNode() {
        this.addEdge(E12, N1, N2);
        this.addEdge(E41, N4, N1);
        Assert.assertTrue((boolean)this.graph.removeNode((Object)N1));
        Truth.assertThat((Iterable)this.graph.nodes()).containsExactly(new Object[]{N2, N4});
        Truth.assertThat((Iterable)this.graph.edges()).doesNotContain((Object)E12);
        Truth.assertThat((Iterable)this.graph.edges()).doesNotContain((Object)E41);
    }

    @Test
    public void removeNode_invalidArgument() {
        ImmutableSet nodes = ImmutableSet.copyOf((Collection)this.graph.nodes());
        Assert.assertFalse((boolean)this.graph.removeNode((Object)NODE_NOT_IN_GRAPH));
        Truth.assertThat((Iterable)this.graph.nodes()).containsExactlyElementsIn((Iterable)nodes);
    }

    @Test
    public void removeEdge_oneOfMany() {
        this.addEdge(E12, N1, N2);
        this.addEdge(E13, N1, N3);
        this.addEdge(E14, N1, N4);
        Truth.assertThat((Iterable)this.graph.edges()).containsExactly(new Object[]{E12, E13, E14});
        Assert.assertTrue((boolean)this.graph.removeEdge((Object)E13));
        Truth.assertThat((Iterable)this.graph.edges()).containsExactly(new Object[]{E12, E14});
    }

    @Test
    public void removeEdge_invalidArgument() {
        ImmutableSet edges = ImmutableSet.copyOf((Collection)this.graph.edges());
        Assert.assertFalse((boolean)this.graph.removeEdge((Object)EDGE_NOT_IN_GRAPH));
        Truth.assertThat((Iterable)this.graph.edges()).containsExactlyElementsIn((Iterable)edges);
    }

    static void assertNodeNotInGraphErrorMessage(Throwable throwable) {
        Truth.assertThat((String)throwable.getMessage()).startsWith(NODE_STRING);
        Truth.assertThat((String)throwable.getMessage()).contains((CharSequence)ERROR_ELEMENT_NOT_IN_GRAPH);
    }

    static void assertEdgeNotInGraphErrorMessage(Throwable throwable) {
        Truth.assertThat((String)throwable.getMessage()).startsWith(EDGE_STRING);
        Truth.assertThat((String)throwable.getMessage()).contains((CharSequence)ERROR_ELEMENT_NOT_IN_GRAPH);
    }
}

