/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.graph.AbstractUndirectedGraphTest;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public abstract class AbstractImmutableUndirectedGraphTest
extends AbstractUndirectedGraphTest {
    @Rule
    public final ExpectedException expectedException = ExpectedException.none();

    @Override
    @Test
    public final void nodes_checkReturnedSetMutability() {
        this.expectedException.expect(UnsupportedOperationException.class);
        this.graph.nodes().add(N2);
    }

    @Override
    @Test
    public final void edges_checkReturnedSetMutability() {
        this.expectedException.expect(UnsupportedOperationException.class);
        this.graph.edges().add("1-2");
    }

    @Override
    @Test
    public final void incidentEdges_checkReturnedSetMutability() {
        this.addNode(N1);
        this.expectedException.expect(UnsupportedOperationException.class);
        this.graph.incidentEdges((Object)N1).add("1-2");
    }

    @Override
    @Test
    public final void incidentNodes_checkReturnedSetMutability() {
        this.addEdge("1-2", N1, N2);
        this.expectedException.expect(UnsupportedOperationException.class);
        this.graph.incidentNodes((Object)"1-2").add(N2);
    }

    @Override
    @Test
    public final void adjacentNodes_checkReturnedSetMutability() {
        this.addNode(N1);
        this.expectedException.expect(UnsupportedOperationException.class);
        this.graph.adjacentNodes((Object)N1).add(N2);
    }

    @Override
    @Test
    public final void adjacentEdges_checkReturnedSetMutability() {
        this.addEdge("1-2", N1, N2);
        this.expectedException.expect(UnsupportedOperationException.class);
        this.graph.adjacentEdges((Object)"1-2").add("2-3");
    }

    @Override
    @Test
    public final void edgesConnecting_checkReturnedSetMutability() {
        this.addEdge("1-2", N1, N2);
        this.expectedException.expect(UnsupportedOperationException.class);
        this.graph.edgesConnecting((Object)N1, (Object)N2).add("2-3");
    }

    @Override
    @Test
    public final void inEdges_checkReturnedSetMutability() {
        this.addEdge("1-2", N1, N2);
        this.expectedException.expect(UnsupportedOperationException.class);
        this.graph.inEdges((Object)N2).add("2-3");
    }

    @Override
    @Test
    public final void outEdges_checkReturnedSetMutability() {
        this.addEdge("1-2", N1, N2);
        this.expectedException.expect(UnsupportedOperationException.class);
        this.graph.outEdges((Object)N1).add("2-3");
    }

    @Override
    @Test
    public final void predecessors_checkReturnedSetMutability() {
        this.addEdge("1-2", N1, N2);
        this.expectedException.expect(UnsupportedOperationException.class);
        this.graph.predecessors((Object)N2).add(N1);
    }

    @Override
    @Test
    public final void successors_checkReturnedSetMutability() {
        this.addEdge("1-2", N1, N2);
        this.expectedException.expect(UnsupportedOperationException.class);
        this.graph.successors((Object)N1).add(N2);
    }

    @Override
    @Test
    public void removeNode_existingNode() {
        this.expectedException.expect(UnsupportedOperationException.class);
        super.removeNode_existingNode();
    }

    @Override
    @Test
    public void removeNode_invalidArgument() {
        this.expectedException.expect(UnsupportedOperationException.class);
        super.removeNode_invalidArgument();
    }

    @Override
    @Test
    public void removeEdge_existingEdge() {
        this.expectedException.expect(UnsupportedOperationException.class);
        super.removeEdge_existingEdge();
    }

    @Override
    @Test
    public void removeEdge_oneOfMany() {
        this.expectedException.expect(UnsupportedOperationException.class);
        super.removeEdge_oneOfMany();
    }

    @Override
    @Test
    public void removeEdge_invalidArgument() {
        this.expectedException.expect(UnsupportedOperationException.class);
        super.removeEdge_invalidArgument();
    }

    @Test
    public void addNode_immutable() {
        this.expectedException.expect(UnsupportedOperationException.class);
        this.graph.addNode((Object)N3);
    }

    @Test
    public void addEdge_immutable() {
        this.expectedException.expect(UnsupportedOperationException.class);
        this.graph.addEdge((Object)"1-3", (Object)N1, (Object)N3);
    }
}

