/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.collect.ImmutableSet;
import com.google.common.graph.AbstractGraphTest;
import com.google.common.graph.UndirectedGraph;
import com.google.common.testing.EqualsTester;
import com.google.common.truth.Truth;
import java.util.Collection;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractUndirectedGraphTest
extends AbstractGraphTest {
    UndirectedGraph<Integer, String> undirectedGraph;

    public abstract UndirectedGraph<Integer, String> createGraph();

    @Override
    public void init() {
        this.undirectedGraph = this.createGraph();
        this.graph = this.undirectedGraph;
    }

    @After
    public void validateUndirectedEdges() {
        for (Integer node : this.undirectedGraph.nodes()) {
            new EqualsTester().addEqualityGroup(new Object[]{this.undirectedGraph.inEdges((Object)node), this.undirectedGraph.outEdges((Object)node), this.undirectedGraph.incidentEdges((Object)node)}).testEquals();
            new EqualsTester().addEqualityGroup(new Object[]{this.undirectedGraph.predecessors((Object)node), this.undirectedGraph.successors((Object)node), this.undirectedGraph.adjacentNodes((Object)node)}).testEquals();
            for (Integer adjacentNode : this.undirectedGraph.adjacentNodes((Object)node)) {
                Truth.assertThat((Iterable)this.undirectedGraph.edgesConnecting((Object)node, (Object)adjacentNode)).containsExactlyElementsIn((Iterable)this.undirectedGraph.edgesConnecting((Object)adjacentNode, (Object)node));
            }
        }
    }

    @Test
    public void edgesConnecting_oneEdge() {
        this.addEdge("1-2", N1, N2);
        Truth.assertThat((Iterable)this.undirectedGraph.edgesConnecting((Object)N1, (Object)N2)).containsExactly(new Object[]{"1-2"});
        Truth.assertThat((Iterable)this.undirectedGraph.edgesConnecting((Object)N2, (Object)N1)).containsExactly(new Object[]{"1-2"});
    }

    @Test
    public void inEdges_oneEdge() {
        this.addEdge("1-2", N1, N2);
        Truth.assertThat((Iterable)this.undirectedGraph.inEdges((Object)N2)).containsExactly(new Object[]{"1-2"});
        Truth.assertThat((Iterable)this.undirectedGraph.inEdges((Object)N1)).containsExactly(new Object[]{"1-2"});
    }

    @Test
    public void outEdges_oneEdge() {
        this.addEdge("1-2", N1, N2);
        Truth.assertThat((Iterable)this.undirectedGraph.outEdges((Object)N2)).containsExactly(new Object[]{"1-2"});
        Truth.assertThat((Iterable)this.undirectedGraph.outEdges((Object)N1)).containsExactly(new Object[]{"1-2"});
    }

    @Test
    public void predecessors_oneEdge() {
        this.addEdge("1-2", N1, N2);
        Truth.assertThat((Iterable)this.undirectedGraph.predecessors((Object)N2)).containsExactly(new Object[]{N1});
        Truth.assertThat((Iterable)this.undirectedGraph.predecessors((Object)N1)).containsExactly(new Object[]{N2});
    }

    @Test
    public void successors_oneEdge() {
        this.addEdge("1-2", N1, N2);
        Truth.assertThat((Iterable)this.undirectedGraph.successors((Object)N1)).containsExactly(new Object[]{N2});
        Truth.assertThat((Iterable)this.undirectedGraph.successors((Object)N2)).containsExactly(new Object[]{N1});
    }

    @Test
    public void inDegree_oneEdge() {
        this.addEdge("1-2", N1, N2);
        Assert.assertEquals((long)1L, (long)this.undirectedGraph.inDegree((Object)N2));
        Assert.assertEquals((long)1L, (long)this.undirectedGraph.inDegree((Object)N1));
    }

    @Test
    public void outDegree_oneEdge() {
        this.addEdge("1-2", N1, N2);
        Assert.assertEquals((long)1L, (long)this.undirectedGraph.outDegree((Object)N1));
        Assert.assertEquals((long)1L, (long)this.undirectedGraph.outDegree((Object)N2));
    }

    @Test
    public void addEdge_existingNodes() {
        this.addNode(N1);
        this.addNode(N2);
        Assert.assertTrue((boolean)this.addEdge("1-2", N1, N2));
        Truth.assertThat((Iterable)this.undirectedGraph.edges()).contains((Object)"1-2");
        Truth.assertThat((Iterable)this.undirectedGraph.edgesConnecting((Object)N1, (Object)N2)).containsExactly(new Object[]{"1-2"});
        Truth.assertThat((Iterable)this.undirectedGraph.edgesConnecting((Object)N2, (Object)N1)).containsExactly(new Object[]{"1-2"});
    }

    @Test
    public void addEdge_existingEdgeBetweenSameNodes() {
        this.addEdge("1-2", N1, N2);
        ImmutableSet edges = ImmutableSet.copyOf((Collection)this.undirectedGraph.edges());
        Assert.assertFalse((boolean)this.addEdge("1-2", N1, N2));
        Truth.assertThat((Iterable)this.undirectedGraph.edges()).containsExactlyElementsIn((Iterable)edges);
        Assert.assertFalse((boolean)this.addEdge("1-2", N2, N1));
        Truth.assertThat((Iterable)this.undirectedGraph.edges()).containsExactlyElementsIn((Iterable)edges);
    }

    @Test
    public void addEdge_existingEdgeBetweenDifferentNodes() {
        this.addEdge("1-2", N1, N2);
        try {
            this.addEdge("1-2", N4, N5);
            Assert.fail((String)"Reusing an existing edge to connect different nodes succeeded");
        }
        catch (IllegalArgumentException e) {
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"it can't be reused to connect");
        }
    }

    @Test
    public void addEdge_parallelEdge() {
        this.addEdge("1-2", N1, N2);
        try {
            this.addEdge("edgeNotInGraph", N1, N2);
            Assert.fail((String)"Should not be allowed to add a parallel edge.");
        }
        catch (IllegalArgumentException e) {
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"connected by a different edge");
        }
        try {
            this.addEdge("edgeNotInGraph", N2, N1);
            Assert.fail((String)"Should not be allowed to add a parallel edge.");
        }
        catch (IllegalArgumentException e) {
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"connected by a different edge");
        }
    }

    @Test
    public void removeEdge_existingEdge() {
        this.addEdge("1-2", N1, N2);
        Assert.assertTrue((boolean)this.undirectedGraph.removeEdge((Object)"1-2"));
        Truth.assertThat((Iterable)this.undirectedGraph.edges()).doesNotContain((Object)"1-2");
        Truth.assertThat((Iterable)this.undirectedGraph.edgesConnecting((Object)N1, (Object)N2)).isEmpty();
        Truth.assertThat((Iterable)this.undirectedGraph.edgesConnecting((Object)N2, (Object)N1)).isEmpty();
    }

    @Test
    public void toString_emptyGraph() {
        Truth.assertThat((String)this.graph.toString()).isEqualTo((Object)String.format("config: %s, nodes: %s, edges: {}", this.graph.config(), this.graph.nodes()));
    }

    @Test
    public void toString_noEdges() {
        this.addNode(N1);
        Truth.assertThat((String)this.graph.toString()).isEqualTo((Object)String.format("config: %s, nodes: %s, edges: {}", this.graph.config(), this.graph.nodes()));
    }

    @Test
    public void toString_singleEdge() {
        this.addEdge("1-2", N1, N2);
        Truth.assertThat((String)this.graph.toString()).isEqualTo((Object)String.format("config: %s, nodes: %s, edges: {%s=[%s, %s]}", this.graph.config(), this.graph.nodes(), "1-2", N1, N2));
    }

    @Test
    public void toString_multipleNodesAndEdges() {
        this.addEdge("1-2", N1, N2);
        this.addEdge("1-3", N1, N3);
        Truth.assertThat((String)this.graph.toString()).isEqualTo((Object)String.format("config: %s, nodes: %s, edges: {%s=[%s, %s], %s=[%s, %s]}", this.graph.config(), this.graph.nodes(), "1-2", N1, N2, "1-3", N1, N3));
    }
}

