/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.graph.GraphConfig;
import com.google.common.graph.Graphs;
import com.google.common.testing.EqualsTester;
import com.google.common.truth.Truth;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public final class GraphConfigTest {
    @Test
    public void testEquals() throws Exception {
        GraphConfig configA1 = Graphs.config().expectedNodeCount(5);
        GraphConfig configA2 = Graphs.config().expectedNodeCount(5);
        GraphConfig configB = Graphs.config().expectedNodeCount(10);
        new EqualsTester().addEqualityGroup(new Object[]{configA1, configA2}).addEqualityGroup(new Object[]{configB}).testEquals();
    }

    @Test
    public void toString_selfLoops() {
        Truth.assertThat((String)Graphs.config().toString()).isEqualTo((Object)"self-loops allowed");
    }

    @Test
    public void toString_noSelfLoops() {
        Truth.assertThat((String)Graphs.config().noSelfLoops().toString()).isEqualTo((Object)"self-loops disallowed");
    }

    @Test
    public void toString_selfLoops_multigraph() {
        Truth.assertThat((String)Graphs.config().multigraph().toString()).isEqualTo((Object)"multigraph,self-loops allowed");
    }

    @Test
    public void toString_noSelfLoops_multigraph() {
        Truth.assertThat((String)Graphs.config().noSelfLoops().multigraph().toString()).isEqualTo((Object)"multigraph,self-loops disallowed");
    }

    @Test
    public void compatibleWith_default() {
        Truth.assertThat((Boolean)Graphs.config().compatibleWith(Graphs.config())).isTrue();
    }

    @Test
    public void compatibleWith_multigraph_compatible() {
        Truth.assertThat((Boolean)Graphs.config().multigraph().compatibleWith(Graphs.config().multigraph())).isTrue();
        Truth.assertThat((Boolean)Graphs.config().multigraph().compatibleWith(Graphs.config())).isTrue();
    }

    @Test
    public void compatibleWith_multigraph_incompatible() {
        Truth.assertThat((Boolean)Graphs.config().compatibleWith(Graphs.config().multigraph())).isFalse();
    }

    @Test
    public void compatibleWith_selfLoops_compatible() {
        Truth.assertThat((Boolean)Graphs.config().noSelfLoops().compatibleWith(Graphs.config().noSelfLoops())).isTrue();
        Truth.assertThat((Boolean)Graphs.config().compatibleWith(Graphs.config().noSelfLoops())).isTrue();
    }

    @Test
    public void compatibleWith_selfLoops_incompatible() {
        Truth.assertThat((Boolean)Graphs.config().noSelfLoops().compatibleWith(Graphs.config())).isFalse();
    }
}

