/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.graph.AndroidIncompatible;
import com.google.common.graph.DirectedGraph;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphConfig;
import com.google.common.graph.Graphs;
import com.google.common.testing.EqualsTester;
import java.util.Arrays;
import java.util.Collection;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@AndroidIncompatible
public final class GraphEqualsTest {
    private static final Integer N1 = 1;
    private static final Integer N2 = 2;
    private static final Integer N3 = 3;
    private static final String E11 = "1-1";
    private static final String E12 = "1-2";
    private static final String E12_A = "1-2a";
    private static final String E13 = "1-3";
    private final GraphType graphType;
    private final Graph<Integer, String> graph;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({GraphType.UNDIRECTED}, {GraphType.DIRECTED});
    }

    public GraphEqualsTest(GraphType graphType) {
        this.graphType = graphType;
        this.graph = this.createGraph();
    }

    private Graph<Integer, String> createGraph() {
        return this.createGraph(Graphs.config());
    }

    private Graph<Integer, String> createGraph(GraphConfig config) {
        switch (this.graphType) {
            case UNDIRECTED: {
                return Graphs.createUndirected((GraphConfig)config);
            }
            case DIRECTED: {
                return Graphs.createDirected((GraphConfig)config);
            }
        }
        throw new IllegalStateException("Unexpected graph type: " + (Object)((Object)this.graphType));
    }

    @Test
    public void equals_nodeSetsDiffer() {
        this.graph.addNode((Object)N1);
        Graph<Integer, String> g2 = this.createGraph();
        g2.addNode((Object)N2);
        new EqualsTester().addEqualityGroup(new Object[]{this.graph}).addEqualityGroup(new Object[]{g2}).testEquals();
    }

    @Test
    public void equals_edgeSetsDiffer() {
        this.graph.addEdge((Object)E12, (Object)N1, (Object)N2);
        Graph<Integer, String> g2 = this.createGraph();
        g2.addEdge((Object)E13, (Object)N1, (Object)N2);
        new EqualsTester().addEqualityGroup(new Object[]{this.graph}).addEqualityGroup(new Object[]{g2}).testEquals();
    }

    @Test
    public void equals_directedVsUndirected() {
        DirectedGraph g2;
        this.graph.addEdge((Object)E12, (Object)N1, (Object)N2);
        switch (this.graphType) {
            case UNDIRECTED: {
                g2 = Graphs.createDirected();
                break;
            }
            case DIRECTED: {
                g2 = Graphs.createUndirected();
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected graph type: " + (Object)((Object)this.graphType));
            }
        }
        g2.addEdge((Object)E12, (Object)N1, (Object)N2);
        new EqualsTester().addEqualityGroup(new Object[]{this.graph}).addEqualityGroup(new Object[]{g2}).testEquals();
    }

    @Test
    public void equals_selfLoop_directedVsUndirected() {
        DirectedGraph g2;
        this.graph.addEdge((Object)E11, (Object)N1, (Object)N1);
        switch (this.graphType) {
            case UNDIRECTED: {
                g2 = Graphs.createDirected();
                break;
            }
            case DIRECTED: {
                g2 = Graphs.createUndirected();
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected graph type: " + (Object)((Object)this.graphType));
            }
        }
        g2.addEdge((Object)E11, (Object)N1, (Object)N1);
        new EqualsTester().addEqualityGroup(new Object[]{this.graph, g2}).testEquals();
    }

    @Test
    public void equals_connectionsDiffer() {
        this.graph.addEdge((Object)E12, (Object)N1, (Object)N2);
        this.graph.addEdge((Object)E13, (Object)N1, (Object)N3);
        Graph<Integer, String> g2 = this.createGraph();
        g2.addEdge((Object)E13, (Object)N1, (Object)N2);
        g2.addEdge((Object)E12, (Object)N1, (Object)N3);
        new EqualsTester().addEqualityGroup(new Object[]{this.graph}).addEqualityGroup(new Object[]{g2}).testEquals();
    }

    @Test
    public void equals_configsDiffer() {
        this.graph.addEdge((Object)E12, (Object)N1, (Object)N2);
        Graph<Integer, String> g2 = this.createGraph(Graphs.MULTIGRAPH.noSelfLoops());
        g2.addEdge((Object)E12, (Object)N1, (Object)N2);
        new EqualsTester().addEqualityGroup(new Object[]{this.graph, g2}).testEquals();
    }

    @Test
    public void equals_edgeAddOrdersDiffer() {
        Graph<Integer, String> g1 = this.createGraph(Graphs.MULTIGRAPH);
        Graph<Integer, String> g2 = this.createGraph(Graphs.MULTIGRAPH);
        g1.addEdge((Object)E12, (Object)N1, (Object)N2);
        g1.addEdge((Object)E12_A, (Object)N1, (Object)N2);
        g2.addEdge((Object)E12_A, (Object)N1, (Object)N2);
        g2.addEdge((Object)E12, (Object)N1, (Object)N2);
        new EqualsTester().addEqualityGroup(new Object[]{g1, g2}).testEquals();
    }

    @Test
    public void equals_edgeDirectionsDiffer() {
        this.graph.addEdge((Object)E12, (Object)N1, (Object)N2);
        Graph<Integer, String> g2 = this.createGraph();
        g2.addEdge((Object)E12, (Object)N2, (Object)N1);
        switch (this.graphType) {
            case UNDIRECTED: {
                new EqualsTester().addEqualityGroup(new Object[]{this.graph, g2}).testEquals();
                break;
            }
            case DIRECTED: {
                new EqualsTester().addEqualityGroup(new Object[]{this.graph}).addEqualityGroup(new Object[]{g2}).testEquals();
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected graph type: " + (Object)((Object)this.graphType));
            }
        }
    }

    static enum GraphType {
        UNDIRECTED,
        DIRECTED,
        HYPER;

    }
}

