/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.collect.ImmutableSet;
import com.google.common.graph.DirectedGraph;
import com.google.common.graph.GraphConfig;
import com.google.common.graph.GraphProperties;
import com.google.common.graph.Graphs;
import com.google.common.truth.Truth;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class GraphPropertiesTest {
    private static final Integer N1 = 1;
    private static final Integer N2 = 2;
    private static final Integer N3 = 3;
    private static final String E11 = "1-1";
    private static final String E12 = "1-2";
    private static final String E12_A = "1-2a";
    private static final String E13 = "1-3";
    private static final String E21 = "2-1";
    private static final String E23 = "2-3";
    private static final String E31 = "3-1";

    @Test
    public void isCyclic_emptyGraph() {
        DirectedGraph directedGraph = Graphs.createDirected();
        Truth.assertThat((Boolean)GraphProperties.isCyclic((DirectedGraph)directedGraph)).isFalse();
    }

    @Test
    public void isCyclic_isolatedNodes() {
        DirectedGraph directedGraph = Graphs.createDirected();
        directedGraph.addNode((Object)N1);
        Truth.assertThat((Boolean)GraphProperties.isCyclic((DirectedGraph)directedGraph)).isFalse();
        directedGraph.addNode((Object)N2);
        Truth.assertThat((Boolean)GraphProperties.isCyclic((DirectedGraph)directedGraph)).isFalse();
    }

    @Test
    public void isCyclic_oneEdge() {
        DirectedGraph directedGraph = Graphs.createDirected();
        directedGraph.addEdge((Object)E12, (Object)N1, (Object)N2);
        Truth.assertThat((Boolean)GraphProperties.isCyclic((DirectedGraph)directedGraph)).isFalse();
    }

    @Test
    public void isCyclic_selfLoopEdge() {
        DirectedGraph directedGraph = Graphs.createDirected();
        directedGraph.addEdge((Object)E11, (Object)N1, (Object)N1);
        Truth.assertThat((Boolean)GraphProperties.isCyclic((DirectedGraph)directedGraph)).isTrue();
    }

    @Test
    public void isCyclic_twoParallelEdges() {
        DirectedGraph directedGraph = Graphs.createDirected((GraphConfig)Graphs.config().multigraph());
        directedGraph.addEdge((Object)E12, (Object)N1, (Object)N2);
        directedGraph.addEdge((Object)E12_A, (Object)N1, (Object)N2);
        Truth.assertThat((Boolean)GraphProperties.isCyclic((DirectedGraph)directedGraph)).isFalse();
    }

    @Test
    public void isCyclic_twoAcyclicEdges() {
        DirectedGraph directedGraph = Graphs.createDirected();
        directedGraph.addEdge((Object)E12, (Object)N1, (Object)N2);
        directedGraph.addEdge((Object)E13, (Object)N1, (Object)N3);
        Truth.assertThat((Boolean)GraphProperties.isCyclic((DirectedGraph)directedGraph)).isFalse();
    }

    @Test
    public void isCyclic_twoCyclicEdges() {
        DirectedGraph directedGraph = Graphs.createDirected();
        directedGraph.addEdge((Object)E12, (Object)N1, (Object)N2);
        directedGraph.addEdge((Object)E21, (Object)N2, (Object)N1);
        Truth.assertThat((Boolean)GraphProperties.isCyclic((DirectedGraph)directedGraph)).isTrue();
    }

    @Test
    public void isCyclic_threeAcyclicEdges() {
        DirectedGraph directedGraph = Graphs.createDirected();
        directedGraph.addEdge((Object)E12, (Object)N1, (Object)N2);
        directedGraph.addEdge((Object)E23, (Object)N2, (Object)N3);
        directedGraph.addEdge((Object)E13, (Object)N1, (Object)N3);
        Truth.assertThat((Boolean)GraphProperties.isCyclic((DirectedGraph)directedGraph)).isFalse();
    }

    @Test
    public void isCyclic_threeCyclicEdges() {
        DirectedGraph directedGraph = Graphs.createDirected();
        directedGraph.addEdge((Object)E12, (Object)N1, (Object)N2);
        directedGraph.addEdge((Object)E23, (Object)N2, (Object)N3);
        directedGraph.addEdge((Object)E31, (Object)N3, (Object)N1);
        Truth.assertThat((Boolean)GraphProperties.isCyclic((DirectedGraph)directedGraph)).isTrue();
    }

    @Test
    public void isCyclic_disconnectedCyclicGraph() {
        DirectedGraph directedGraph = Graphs.createDirected();
        directedGraph.addEdge((Object)E12, (Object)N1, (Object)N2);
        directedGraph.addEdge((Object)E21, (Object)N2, (Object)N1);
        directedGraph.addNode((Object)N3);
        Truth.assertThat((Boolean)GraphProperties.isCyclic((DirectedGraph)directedGraph)).isTrue();
    }

    @Test
    public void isCyclic_cyclicMultigraph() {
        DirectedGraph directedGraph = Graphs.createDirected((GraphConfig)Graphs.config().multigraph());
        directedGraph.addEdge((Object)E12, (Object)N1, (Object)N2);
        directedGraph.addEdge((Object)E12_A, (Object)N1, (Object)N2);
        directedGraph.addEdge((Object)E23, (Object)N2, (Object)N3);
        directedGraph.addEdge((Object)E31, (Object)N3, (Object)N1);
        Truth.assertThat((Boolean)GraphProperties.isCyclic((DirectedGraph)directedGraph)).isTrue();
    }

    @Test
    public void isCyclic_multipleCycles() {
        DirectedGraph directedGraph = Graphs.createDirected((GraphConfig)Graphs.config().multigraph());
        directedGraph.addEdge((Object)E12, (Object)N1, (Object)N2);
        directedGraph.addEdge((Object)E21, (Object)N2, (Object)N1);
        directedGraph.addEdge((Object)E23, (Object)N2, (Object)N3);
        directedGraph.addEdge((Object)E31, (Object)N3, (Object)N1);
        Truth.assertThat((Boolean)GraphProperties.isCyclic((DirectedGraph)directedGraph)).isTrue();
    }

    @Test
    public void roots_emptyGraph() {
        DirectedGraph directedGraph = Graphs.createDirected();
        Truth.assertThat((Iterable)GraphProperties.roots((DirectedGraph)directedGraph)).isEmpty();
    }

    @Test
    public void roots_trivialGraph() {
        DirectedGraph directedGraph = Graphs.createDirected();
        directedGraph.addNode((Object)N1);
        Truth.assertThat((Iterable)GraphProperties.roots((DirectedGraph)directedGraph)).isEqualTo((Object)ImmutableSet.of((Object)N1));
    }

    @Test
    public void roots_nodeWithSelfLoop() {
        DirectedGraph directedGraph = Graphs.createDirected();
        directedGraph.addNode((Object)N1);
        directedGraph.addEdge((Object)E11, (Object)N1, (Object)N1);
        Truth.assertThat((Iterable)GraphProperties.roots((DirectedGraph)directedGraph)).isEmpty();
    }

    @Test
    public void roots_nodeWithChildren() {
        DirectedGraph directedGraph = Graphs.createDirected();
        directedGraph.addEdge((Object)E12, (Object)N1, (Object)N2);
        directedGraph.addEdge((Object)E13, (Object)N1, (Object)N3);
        Truth.assertThat((Iterable)GraphProperties.roots((DirectedGraph)directedGraph)).isEqualTo((Object)ImmutableSet.of((Object)N1));
    }

    @Test
    public void roots_cycle() {
        DirectedGraph directedGraph = Graphs.createDirected();
        directedGraph.addEdge((Object)E12, (Object)N1, (Object)N2);
        directedGraph.addEdge((Object)E21, (Object)N2, (Object)N1);
        Truth.assertThat((Iterable)GraphProperties.roots((DirectedGraph)directedGraph)).isEmpty();
    }

    @Test
    public void roots_multipleRoots() {
        DirectedGraph directedGraph = Graphs.createDirected();
        directedGraph.addNode((Object)N1);
        directedGraph.addNode((Object)N2);
        Truth.assertThat((Iterable)GraphProperties.roots((DirectedGraph)directedGraph)).isEqualTo((Object)ImmutableSet.of((Object)N1, (Object)N2));
    }
}

