/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.graph.AbstractImmutableDirectedGraphTest;
import com.google.common.graph.DirectedGraph;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphConfig;
import com.google.common.graph.Graphs;
import com.google.common.graph.ImmutableDirectedGraph;
import com.google.common.truth.Truth;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ImmutableSimpleDirectedGraphTest
extends AbstractImmutableDirectedGraphTest {
    protected ImmutableDirectedGraph.Builder<Integer, String> builder;

    @Override
    @CanIgnoreReturnValue
    final boolean addNode(Integer n) {
        DirectedGraph oldGraph = Graphs.copyOf((DirectedGraph)this.directedGraph);
        this.directedGraph = this.builder.addNode((Object)n).build();
        this.graph = this.directedGraph;
        return !this.graph.equals((Object)oldGraph);
    }

    @Override
    @CanIgnoreReturnValue
    final boolean addEdge(String e, Integer n1, Integer n2) {
        DirectedGraph oldGraph = Graphs.copyOf((DirectedGraph)this.directedGraph);
        this.directedGraph = this.builder.addEdge((Object)e, (Object)n1, (Object)n2).build();
        this.graph = this.directedGraph;
        return !this.graph.equals((Object)oldGraph);
    }

    public ImmutableDirectedGraph<Integer, String> createGraph() {
        this.builder = ImmutableDirectedGraph.builder((GraphConfig)Graphs.config().noSelfLoops());
        return this.builder.build();
    }

    @Test
    public void addEdge_selfLoop() {
        try {
            this.addEdge("1-1", N1, N1);
            Assert.fail((String)"Should not be allowed to add a self-loop edge.");
        }
        catch (IllegalArgumentException e) {
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"self-loops are not allowed");
        }
    }

    @Test
    public void addEdge_nodesNotInGraph() {
        this.addNode(N1);
        Assert.assertTrue((boolean)this.addEdge("1-5", N1, N5));
        Assert.assertTrue((boolean)this.addEdge("4-1", N4, N1));
        Assert.assertTrue((boolean)this.addEdge("2-3", N2, N3));
        Truth.assertThat((Iterable)this.directedGraph.nodes()).containsExactly(new Object[]{N1, N5, N4, N2, N3}).inOrder();
        Truth.assertThat((Iterable)this.directedGraph.edges()).containsExactly(new Object[]{"1-5", "4-1", "2-3"}).inOrder();
        Truth.assertThat((Iterable)this.directedGraph.edgesConnecting((Object)N1, (Object)N5)).containsExactly(new Object[]{"1-5"});
        Truth.assertThat((Iterable)this.directedGraph.edgesConnecting((Object)N4, (Object)N1)).containsExactly(new Object[]{"4-1"});
        Truth.assertThat((Iterable)this.directedGraph.edgesConnecting((Object)N2, (Object)N3)).containsExactly(new Object[]{"2-3"});
        Truth.assertThat((Iterable)this.directedGraph.edgesConnecting((Object)N3, (Object)N2)).isEmpty();
    }

    @Test
    public void copyOf() {
        DirectedGraph graph = Graphs.createDirected((GraphConfig)this.directedGraph.config());
        this.populateInputGraph((DirectedGraph<Integer, String>)graph);
        Truth.assertThat((Object)ImmutableDirectedGraph.copyOf((DirectedGraph)graph)).isEqualTo((Object)graph);
    }

    @Test
    public void addGraph() {
        DirectedGraph graph = Graphs.createDirected((GraphConfig)this.directedGraph.config());
        this.populateInputGraph((DirectedGraph<Integer, String>)graph);
        Truth.assertThat((Object)this.builder.addGraph((Graph)graph).build()).isEqualTo((Object)graph);
    }

    @Test
    public void addGraph_overlap() {
        DirectedGraph graph = Graphs.createDirected((GraphConfig)this.directedGraph.config());
        this.populateInputGraph((DirectedGraph<Integer, String>)graph);
        this.builder.addEdge((Object)"1-2", (Object)N1, (Object)N2);
        this.builder.addGraph((Graph)graph);
        Truth.assertThat((Object)this.builder.build()).isEqualTo((Object)graph);
    }

    @Test
    public void addGraph_inconsistentEdges() {
        DirectedGraph graph = Graphs.createDirected((GraphConfig)this.directedGraph.config());
        this.populateInputGraph((DirectedGraph<Integer, String>)graph);
        this.builder.addEdge((Object)"2-1", (Object)N3, (Object)N1);
        try {
            this.builder.addGraph((Graph)graph);
            Assert.fail((String)"Should have rejected a graph whose edge definitions were inconsistent with existingbuilder state");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected void populateInputGraph(DirectedGraph<Integer, String> graph) {
        graph.addEdge((Object)"1-2", (Object)N1, (Object)N2);
        graph.addEdge((Object)"2-1", (Object)N2, (Object)N1);
        graph.addEdge((Object)"2-3", (Object)N2, (Object)N3);
        graph.addNode((Object)N5);
    }
}

