/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.graph.AbstractImmutableUndirectedGraphTest;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphConfig;
import com.google.common.graph.Graphs;
import com.google.common.graph.ImmutableUndirectedGraph;
import com.google.common.graph.UndirectedGraph;
import com.google.common.truth.Truth;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ImmutableSimpleUndirectedGraphTest
extends AbstractImmutableUndirectedGraphTest {
    protected ImmutableUndirectedGraph.Builder<Integer, String> builder;

    @Override
    @CanIgnoreReturnValue
    final boolean addNode(Integer n) {
        UndirectedGraph oldGraph = Graphs.copyOf((UndirectedGraph)this.undirectedGraph);
        this.undirectedGraph = this.builder.addNode((Object)n).build();
        this.graph = this.undirectedGraph;
        return !this.graph.equals((Object)oldGraph);
    }

    @Override
    @CanIgnoreReturnValue
    final boolean addEdge(String e, Integer n1, Integer n2) {
        UndirectedGraph oldGraph = Graphs.copyOf((UndirectedGraph)this.undirectedGraph);
        this.undirectedGraph = this.builder.addEdge((Object)e, (Object)n1, (Object)n2).build();
        this.graph = this.undirectedGraph;
        return !this.graph.equals((Object)oldGraph);
    }

    public ImmutableUndirectedGraph<Integer, String> createGraph() {
        this.builder = ImmutableUndirectedGraph.builder((GraphConfig)Graphs.config().noSelfLoops());
        return this.builder.build();
    }

    @Test
    public void addEdge_selfLoop() {
        try {
            this.addEdge("1-1", N1, N1);
            Assert.fail((String)"Should not be allowed to add a self-loop edge.");
        }
        catch (IllegalArgumentException e) {
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"self-loops are not allowed");
        }
    }

    @Test
    public void addEdge_nodesNotInGraph() {
        this.addNode(N1);
        Assert.assertTrue((boolean)this.addEdge("1-5", N1, N5));
        Assert.assertTrue((boolean)this.addEdge("4-1", N4, N1));
        Assert.assertTrue((boolean)this.addEdge("2-3", N2, N3));
        Truth.assertThat((Iterable)this.undirectedGraph.nodes()).containsExactly(new Object[]{N1, N5, N4, N2, N3}).inOrder();
        Truth.assertThat((Iterable)this.undirectedGraph.edges()).containsExactly(new Object[]{"1-5", "4-1", "2-3"}).inOrder();
        Truth.assertThat((Iterable)this.undirectedGraph.edgesConnecting((Object)N1, (Object)N5)).containsExactly(new Object[]{"1-5"});
        Truth.assertThat((Iterable)this.undirectedGraph.edgesConnecting((Object)N4, (Object)N1)).containsExactly(new Object[]{"4-1"});
        Truth.assertThat((Iterable)this.undirectedGraph.edgesConnecting((Object)N2, (Object)N3)).containsExactly(new Object[]{"2-3"});
        Truth.assertThat((Iterable)this.undirectedGraph.edgesConnecting((Object)N3, (Object)N2)).containsExactly(new Object[]{"2-3"});
    }

    @Test
    public void copyOf_nullArgument() {
        try {
            ImmutableUndirectedGraph.copyOf(null);
            Assert.fail((String)"Should have rejected a null graph");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void copyOf() {
        UndirectedGraph graph = Graphs.createUndirected((GraphConfig)this.undirectedGraph.config());
        this.populateInputGraph((UndirectedGraph<Integer, String>)graph);
        Truth.assertThat((Object)ImmutableUndirectedGraph.copyOf((UndirectedGraph)graph)).isEqualTo((Object)graph);
    }

    @Test
    public void addGraph() {
        UndirectedGraph graph = Graphs.createUndirected((GraphConfig)this.undirectedGraph.config());
        this.populateInputGraph((UndirectedGraph<Integer, String>)graph);
        Truth.assertThat((Object)this.builder.addGraph((Graph)graph).build()).isEqualTo((Object)graph);
    }

    @Test
    public void addGraph_overlap() {
        UndirectedGraph graph = Graphs.createUndirected((GraphConfig)this.undirectedGraph.config());
        this.populateInputGraph((UndirectedGraph<Integer, String>)graph);
        this.builder.addEdge((Object)"1-2", (Object)N1, (Object)N2);
        this.builder.addGraph((Graph)graph);
        Truth.assertThat((Object)this.builder.build()).isEqualTo((Object)graph);
    }

    @Test
    public void addGraph_inconsistentEdges() {
        UndirectedGraph graph = Graphs.createUndirected((GraphConfig)this.undirectedGraph.config());
        this.populateInputGraph((UndirectedGraph<Integer, String>)graph);
        this.builder.addEdge((Object)"1-2", (Object)N5, (Object)N1);
        try {
            this.builder.addGraph((Graph)graph);
            Assert.fail((String)"Should have rejected a graph whose edge definitions were inconsistent with existingbuilder state");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected void populateInputGraph(UndirectedGraph<Integer, String> graph) {
        graph.addEdge((Object)"1-2", (Object)N1, (Object)N2);
        graph.addEdge((Object)"2-3", (Object)N2, (Object)N3);
        graph.addNode((Object)N5);
    }
}

