/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.graph.ImmutableSimpleUndirectedGraphTest;
import com.google.common.graph.ImmutableUndirectedGraph;
import com.google.common.graph.UndirectedGraph;
import com.google.common.truth.Truth;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ImmutableUndirectedGraphTest
extends ImmutableSimpleUndirectedGraphTest {
    @Override
    public ImmutableUndirectedGraph<Integer, String> createGraph() {
        this.builder = ImmutableUndirectedGraph.builder();
        return this.builder.build();
    }

    @Test
    public void edges_selfLoop() {
        this.addEdge("1-1", N1, N1);
        Truth.assertThat((Iterable)this.graph.edges()).containsExactly(new Object[]{"1-1"});
    }

    @Test
    public void incidentEdges_selfLoop() {
        this.addEdge("1-1", N1, N1);
        Truth.assertThat((Iterable)this.graph.incidentEdges((Object)N1)).containsExactly(new Object[]{"1-1"});
    }

    @Test
    public void incidentNodes_selfLoop() {
        this.addEdge("1-1", N1, N1);
        Truth.assertThat((Iterable)this.graph.incidentNodes((Object)"1-1")).containsExactly(new Object[]{N1});
    }

    @Test
    public void adjacentNodes_selfLoop() {
        this.addEdge("1-1", N1, N1);
        this.addEdge("1-2", N1, N2);
        Truth.assertThat((Iterable)this.graph.adjacentNodes((Object)N1)).containsExactly(new Object[]{N1, N2});
    }

    @Test
    public void adjacentEdges_selfLoop() {
        this.addEdge("1-1", N1, N1);
        Truth.assertThat((Iterable)this.graph.adjacentEdges((Object)"1-1")).isEmpty();
        this.addEdge("1-2", N1, N2);
        Truth.assertThat((Iterable)this.graph.adjacentEdges((Object)"1-1")).containsExactly(new Object[]{"1-2"});
    }

    @Test
    public void edgesConnecting_selfLoop() {
        this.addEdge("1-1", N1, N1);
        Truth.assertThat((Iterable)this.undirectedGraph.edgesConnecting((Object)N1, (Object)N1)).containsExactly(new Object[]{"1-1"});
        this.addEdge("1-2", N1, N2);
        Truth.assertThat((Iterable)this.undirectedGraph.edgesConnecting((Object)N1, (Object)N2)).containsExactly(new Object[]{"1-2"});
        Truth.assertThat((Iterable)this.undirectedGraph.edgesConnecting((Object)N2, (Object)N1)).containsExactly(new Object[]{"1-2"});
    }

    @Test
    public void inEdges_selfLoop() {
        this.addEdge("1-1", N1, N1);
        Truth.assertThat((Iterable)this.undirectedGraph.inEdges((Object)N1)).containsExactly(new Object[]{"1-1"});
        this.addEdge("1-2", N1, N2);
        Truth.assertThat((Iterable)this.undirectedGraph.inEdges((Object)N1)).containsExactly(new Object[]{"1-1", "1-2"});
    }

    @Test
    public void outEdges_selfLoop() {
        this.addEdge("1-1", N1, N1);
        Truth.assertThat((Iterable)this.undirectedGraph.outEdges((Object)N1)).containsExactly(new Object[]{"1-1"});
        this.addEdge("1-2", N2, N1);
        Truth.assertThat((Iterable)this.undirectedGraph.outEdges((Object)N1)).containsExactly(new Object[]{"1-1", "1-2"});
    }

    @Test
    public void predecessors_selfLoop() {
        this.addEdge("1-1", N1, N1);
        Truth.assertThat((Iterable)this.undirectedGraph.predecessors((Object)N1)).containsExactly(new Object[]{N1});
        this.addEdge("1-2", N1, N2);
        Truth.assertThat((Iterable)this.undirectedGraph.predecessors((Object)N1)).containsExactly(new Object[]{N1, N2});
    }

    @Test
    public void successors_selfLoop() {
        this.addEdge("1-1", N1, N1);
        Truth.assertThat((Iterable)this.undirectedGraph.successors((Object)N1)).containsExactly(new Object[]{N1});
        this.addEdge("1-2", N2, N1);
        Truth.assertThat((Iterable)this.undirectedGraph.successors((Object)N1)).containsExactly(new Object[]{N1, N2});
    }

    @Test
    public void degree_selfLoop() {
        this.addEdge("1-1", N1, N1);
        Assert.assertEquals((long)1L, (long)this.graph.degree((Object)N1));
        this.addEdge("1-2", N1, N2);
        Assert.assertEquals((long)2L, (long)this.graph.degree((Object)N1));
    }

    @Test
    public void inDegree_selfLoop() {
        this.addEdge("1-1", N1, N1);
        Assert.assertEquals((long)1L, (long)this.undirectedGraph.inDegree((Object)N1));
        this.addEdge("1-2", N1, N2);
        Assert.assertEquals((long)2L, (long)this.undirectedGraph.inDegree((Object)N1));
    }

    @Test
    public void outDegree_selfLoop() {
        this.addEdge("1-1", N1, N1);
        Assert.assertEquals((long)1L, (long)this.undirectedGraph.outDegree((Object)N1));
        this.addEdge("1-2", N2, N1);
        Assert.assertEquals((long)2L, (long)this.undirectedGraph.outDegree((Object)N1));
    }

    @Override
    @Test
    public void addEdge_selfLoop() {
        Assert.assertTrue((boolean)this.addEdge("1-1", N1, N1));
        Truth.assertThat((Iterable)this.graph.edges()).contains((Object)"1-1");
        Truth.assertThat((Iterable)this.graph.edgesConnecting((Object)N1, (Object)N1)).containsExactly(new Object[]{"1-1"});
    }

    @Test
    public void addEdge_existingEdgeBetweenDifferentNodes_selfLoops() {
        this.addEdge("1-1", N1, N1);
        try {
            this.addEdge("1-1", N1, N2);
            Assert.fail((String)"Reusing an existing self-loop edge to connect different nodes succeeded");
        }
        catch (IllegalArgumentException e) {
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"it can't be reused to connect");
        }
        try {
            this.addEdge("1-1", N2, N2);
            Assert.fail((String)"Reusing an existing self-loop edge to make a different self-loop edge succeeded");
        }
        catch (IllegalArgumentException e) {
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"it can't be reused to connect");
        }
        this.addEdge("1-2", N1, N2);
        try {
            this.addEdge("1-2", N1, N1);
            Assert.fail((String)"Reusing an existing edge to add a self-loop edge between different nodes succeeded");
        }
        catch (IllegalArgumentException e) {
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"it can't be reused to connect");
        }
    }

    @Test
    public void addEdge_parallelSelfLoopEdge() {
        this.addEdge("1-1", N1, N1);
        try {
            this.addEdge("edgeNotInGraph", N1, N1);
            Assert.fail((String)"Adding a parallel self-loop edge succeeded");
        }
        catch (IllegalArgumentException e) {
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"connected by a different edge");
        }
    }

    @Test
    public void toString_selfLoop() {
        this.addEdge("1-1", N1, N1);
        Truth.assertThat((String)this.graph.toString()).isEqualTo((Object)String.format("config: %s, nodes: %s, edges: {%s=[%s]}", this.graph.config(), this.graph.nodes(), "1-1", N1));
    }

    @Override
    protected void populateInputGraph(UndirectedGraph<Integer, String> graph) {
        super.populateInputGraph(graph);
        graph.addEdge((Object)"1-1", (Object)N1, (Object)N1);
    }
}

