/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.graph.GraphConfig;
import com.google.common.graph.Graphs;
import com.google.common.graph.ImmutableUndirectedGraph;
import com.google.common.graph.ImmutableUndirectedGraphTest;
import com.google.common.graph.UndirectedGraph;
import com.google.common.truth.Truth;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ImmutableUndirectedMultigraphTest
extends ImmutableUndirectedGraphTest {
    @Override
    public ImmutableUndirectedGraph<Integer, String> createGraph() {
        this.builder = ImmutableUndirectedGraph.builder((GraphConfig)Graphs.MULTIGRAPH);
        return this.builder.build();
    }

    @Test
    public void edgesConnecting_parallelEdges() {
        Assert.assertTrue((boolean)this.addEdge("1-2", N1, N2));
        Assert.assertTrue((boolean)this.addEdge("1-2a", N1, N2));
        Assert.assertTrue((boolean)this.addEdge("2-1", N2, N1));
        Truth.assertThat((Iterable)this.undirectedGraph.edgesConnecting((Object)N1, (Object)N2)).containsExactly(new Object[]{"1-2", "1-2a", "2-1"});
        Truth.assertThat((Iterable)this.undirectedGraph.edgesConnecting((Object)N2, (Object)N1)).containsExactly(new Object[]{"1-2", "1-2a", "2-1"});
    }

    @Test
    public void edgesConnecting_parallelSelfLoopEdges() {
        Assert.assertTrue((boolean)this.addEdge("1-1", N1, N1));
        Assert.assertTrue((boolean)this.addEdge("1-1a", N1, N1));
        Truth.assertThat((Iterable)this.undirectedGraph.edgesConnecting((Object)N1, (Object)N1)).containsExactly(new Object[]{"1-1", "1-1a"});
    }

    @Override
    @Test
    public void addEdge_parallelEdge() {
        Assert.assertTrue((boolean)this.addEdge("1-2", N1, N2));
        Assert.assertTrue((boolean)this.addEdge("1-2a", N1, N2));
        Assert.assertTrue((boolean)this.addEdge("2-1", N2, N1));
        Truth.assertThat((Iterable)this.undirectedGraph.edges()).containsExactly(new Object[]{"1-2", "1-2a", "2-1"}).inOrder();
    }

    @Override
    @Test
    public void addEdge_parallelSelfLoopEdge() {
        Assert.assertTrue((boolean)this.addEdge("1-1", N1, N1));
        Assert.assertTrue((boolean)this.addEdge("1-1a", N1, N1));
        Truth.assertThat((Iterable)this.undirectedGraph.edges()).containsExactly(new Object[]{"1-1", "1-1a"}).inOrder();
    }

    @Test
    public void toString_parallelEdges() {
        this.addEdge("1-2", N1, N2);
        this.addEdge("1-2a", N1, N2);
        this.addEdge("1-1", N1, N1);
        this.addEdge("1-1a", N1, N1);
        Truth.assertThat((String)this.graph.toString()).isEqualTo((Object)String.format("config: %s, nodes: %s, edges: {%s=[%s, %s], %s=[%s, %s], %s=[%s], %s=[%s]}", this.graph.config(), this.graph.nodes(), "1-2", N1, N2, "1-2a", N1, N2, "1-1", N1, "1-1a", N1));
    }

    @Override
    protected void populateInputGraph(UndirectedGraph<Integer, String> graph) {
        super.populateInputGraph(graph);
        graph.addEdge((Object)"1-1a", (Object)N1, (Object)N1);
        graph.addEdge((Object)"1-2a", (Object)N1, (Object)N2);
    }
}

